/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.BDACopyDataPage;
import oracle.dbtools.raptor.hadoop.ui.BDACopyGeneralPage;
import oracle.dbtools.raptor.hadoop.ui.BDACopyOptionalParmsPage;
import oracle.dbtools.raptor.hadoop.ui.BDACopyWizObjectShuttlePanel;
import oracle.dbtools.raptor.hadoop.ui.BDACopyWizSummaryPage;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class BDACopyWizMain {
    static final String STATE_A = "StateA";
    static final String TRANSITION_A = "A";
    static final String STATE_B = "StateB";
    static final String TRANSITION_B = "B";
    static final String STATE_C = "StateC";
    static final String TRANSITION_C = "C";
    static final String STATE_D = "StateD";
    static final String TRANSITION_D = "D";
    static final String TRANSITION_FIN = "Fin";
    static final String STATE_FIN = "StateFin";
    public static final String WIZARD_TYPE_TOOL = "1";
    static final String KEY_FILENAME = "FILENAME";
    static final String KEY_CONN = "CONNECTION";
    static final String KEY_CNAME = "CONNECTION_NAME";
    static final String KEY_TARGETFORMAT = "TARGETFORMAT";
    static final String KEY_DATA_LIST = "DATA_LIST";
    static final String KEY_ACTION_OBJECT_LIST = "ACTION_OBJECT_LIST";
    static final String KEY_WIZARD_TYPE = "WIZARD_TYPE";
    public static final String BDA_COPY_NAME = "raptor.bdacopyWizard";
    public static final int BDA_COPY_ACTION = Ide.findOrCreateCmdID((String)"raptor.bdacopyWizard");
    private static BDACopyWizMain INSTANCE;

    private static FSM getFSMforDBTool() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(ExportWizArb.getString((String)"STEP1"), BDACopyGeneralPage.class, "f1_help_id_for_start");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_A, (Object)STATE_A);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step2 = new Step(ExportWizArb.getString((String)"STEP3"), BDACopyWizObjectShuttlePanel.class, "f1_help_id_for_stepA");
        fSMBuilder.newState((Object)STATE_A, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_C, (Object)STATE_C);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step3 = new Step(ExportWizArb.getString((String)"STEP4"), BDACopyDataPage.class, "f1_help_id_for_stepC");
        fSMBuilder.newState((Object)STATE_C, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_D, (Object)STATE_D);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step4 = new Step(HadoopWizArb.getString("STEP_OPT_PARMS"), BDACopyOptionalParmsPage.class, "f1_help_id_for_opt_parms");
        fSMBuilder.newState((Object)STATE_D, step4, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step5 = new Step(HadoopWizArb.getString("STEP_SUMMARY"), BDACopyWizSummaryPage.class, "f1_help_id_for_step5");
        fSMBuilder.newFinalState((Object)STATE_FIN, step5);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public void launchForDBTool() {
        FSM fSM = BDACopyWizMain.getFSMforDBTool();
        this.launchWizard(fSM, WIZARD_TYPE_TOOL, new ExtractListModel());
    }

    public void launchWizard(FSM fSM, String string, ExtractListModel extractListModel) {
        Namespace namespace = new Namespace();
        HadoopProperties hadoopProperties = new HadoopProperties();
        namespace.put("HADOOP_PROPERTIES", (Object)hadoopProperties);
        namespace.put("EXTRACT_LIST_MODEL", (Object)extractListModel);
        namespace.put("IMPORT_PROPERTIES", (Object)hadoopProperties.getIProps());
        hadoopProperties.put(HadoopKeys.EXTRACT_LIST_MODEL, extractListModel);
        extractListModel.isDDLEnabled(false);
        extractListModel.isDataEnabled(true);
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD, ExtractDataFormat.CSV);
        extractListModel.setDataFormat(extractDataFormat);
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setTable(true);
        dDLTypes.setView(true);
        dDLTypes.setMatView(true);
        dDLTypes.setConstraint(false);
        dDLTypes.setDbLink(false);
        dDLTypes.setDirectory(false);
        dDLTypes.setFunction(false);
        dDLTypes.setIndex(false);
        dDLTypes.setMatView(false);
        dDLTypes.setMatViewLog(false);
        dDLTypes.setPackBody(false);
        dDLTypes.setPackSpec(false);
        dDLTypes.setProcedure(false);
        dDLTypes.setQueue(false);
        dDLTypes.setQueueTable(false);
        dDLTypes.setRefConstraint(false);
        dDLTypes.setSequence(false);
        dDLTypes.setShowTable(true);
        dDLTypes.setShowView(true);
        dDLTypes.setShowMatView(true);
        dDLTypes.setShowConstraint(false);
        dDLTypes.setShowDbLink(false);
        dDLTypes.setShowDirectory(false);
        dDLTypes.setShowFunction(false);
        dDLTypes.setShowIndex(false);
        dDLTypes.setShowMatView(false);
        dDLTypes.setShowMatViewLog(false);
        dDLTypes.setShowPackBody(false);
        dDLTypes.setShowPackSpec(false);
        dDLTypes.setShowProcedure(false);
        dDLTypes.setShowQueue(false);
        dDLTypes.setShowQueueTable(false);
        dDLTypes.setShowRefConstraint(false);
        dDLTypes.setShowSequence(false);
        extractListModel.setDDLTypes(dDLTypes);
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        fSMWizard.setWizardTitle(HadoopWizArb.getString("BDA_MAIN_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ExportWizArb.getImage((String)"WIZ_IMAGE"));
        fSMWizard.setLogoImage(ExportWizArb.getImage((String)"WIZ_LOGO"));
        fSMWizard.setRoadmapVisible(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        wizardDialog.setPreferredSize(new Dimension(900, 600));
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)BDA_COPY_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static BDACopyWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BDACopyWizMain();
        }
        return INSTANCE;
    }

    static boolean acquireLock(String string) {
        return LockedConnection.acquireLock(string);
    }

    static void freeLock() {
        LockedConnection.freeLock();
    }

    private static class LockedConnection {
        private static String _connName;
        private static boolean _locked;

        private LockedConnection() {
        }

        static synchronized boolean acquireLock(String string) {
            boolean bl = false;
            LockedConnection.freeLock();
            bl = _locked = Connections.getInstance().lock(string, true);
            if (bl) {
                _connName = string;
            }
            return bl;
        }

        static synchronized void freeLock() {
            if (_connName != null && _locked) {
                Connections.getInstance().unlock(_connName);
                _locked = false;
                _connName = null;
            }
        }

        static {
            _locked = false;
        }
    }

    public static class BDACopyController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == BDA_COPY_ACTION) {
                BDACopyWizMain.getInstance().launchForDBTool();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == BDA_COPY_ACTION) {
                if (Connections.getInstance().getConnNames().length <= 0) {
                    ideAction.setEnabled(false);
                } else {
                    ideAction.setEnabled(true);
                }
                return true;
            }
            return false;
        }
    }
}

