/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptable {
    private static final int Id_message = 1;
    private static final int Id_name = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 3;
    private static final int Id_toString = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Object messageValue;
    private Object nameValue;
    private boolean prototypeFlag;

    NativeError() {
        this.setMaxId(2);
        this.messageValue = NOT_FOUND;
        this.nameValue = NOT_FOUND;
    }

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeError obj = new NativeError();
        obj.prototypeFlag = true;
        obj.messageValue = "";
        obj.nameValue = "Error";
        obj.addAsPrototype(4, cx, scope, sealed);
    }

    protected int getIdDefaultAttributes(int id) {
        if (id == 1 || id == 2) {
            return 0;
        }
        return super.getIdDefaultAttributes(id);
    }

    protected boolean hasIdValue(int id) {
        if (id == 1) {
            return this.messageValue != NOT_FOUND;
        }
        if (id == 2) {
            return this.nameValue != NOT_FOUND;
        }
        return super.hasIdValue(id);
    }

    protected Object getIdValue(int id) {
        if (id == 1) {
            return this.messageValue;
        }
        if (id == 2) {
            return this.nameValue;
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        if (id == 1) {
            this.messageValue = value;
            return;
        }
        if (id == 2) {
            this.nameValue = value;
            return;
        }
        super.setIdValue(id, value);
    }

    protected void deleteIdValue(int id) {
        if (id == 1) {
            this.messageValue = NOT_FOUND;
            return;
        }
        if (id == 2) {
            this.nameValue = NOT_FOUND;
            return;
        }
        super.deleteIdValue(id);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            if (methodId == 3) {
                return 1;
            }
            if (methodId == 4) {
                return 0;
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (methodId == 3) {
                return NativeError.jsConstructor(cx, args, f, thisObj == null);
            }
            if (methodId == 4) {
                return NativeError.js_toString(thisObj);
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static Object jsConstructor(Context cx, Object[] args, Function funObj, boolean inNewExpr) {
        NativeError result = new NativeError();
        if (args.length >= 1) {
            result.messageValue = ScriptRuntime.toString(args[0]);
        }
        result.setPrototype(NativeError.getClassPrototype(funObj, "Error"));
        return result;
    }

    private static String js_toString(Scriptable thisObj) {
        Object name = ScriptRuntime.getStrIdElem(thisObj, "name");
        Object message = ScriptRuntime.getStrIdElem(thisObj, "message");
        return ScriptRuntime.toString(name) + ": " + ScriptRuntime.toString(message);
    }

    public String getClassName() {
        return "Error";
    }

    public String toString() {
        return NativeError.js_toString(this);
    }

    String getName() {
        Object val = this.nameValue;
        return ScriptRuntime.toString(val != NOT_FOUND ? val : Undefined.instance);
    }

    String getMessage() {
        Object val = this.messageValue;
        return ScriptRuntime.toString(val != NOT_FOUND ? val : Undefined.instance);
    }

    protected String getIdName(int id) {
        if (id == 1) {
            return "message";
        }
        if (id == 2) {
            return "name";
        }
        if (this.prototypeFlag) {
            if (id == 3) {
                return "constructor";
            }
            if (id == 4) {
                return "toString";
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 4) {
            X = "name";
            id = 2;
        } else if (s_length == 7) {
            X = "message";
            id = 1;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id != 0 || !this.prototypeFlag) {
            return id;
        }
        id = 0;
        X = null;
        s_length = s.length();
        if (s_length == 8) {
            X = "toString";
            id = 4;
        } else if (s_length == 11) {
            X = "constructor";
            id = 3;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

