/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class BNPropListExpandOptimizer
implements SparqlQueryOptimizer {
    private int newBlankNodes = 0;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        if (((SimpleNode)node).id == 47) {
            this.expandTriplesBlock((ASTTriplesBlock)node);
        }
        int n = ((SimpleNode)node).jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            this.optimizeQuery(node.jjtGetChild(i));
        }
        return node;
    }

    private void expandTriplesBlock(ASTTriplesBlock aSTTriplesBlock) throws RDFException {
        List<ASTTriplesBlock> list;
        SimpleNode simpleNode;
        SimpleNode simpleNode2 = (SimpleNode)aSTTriplesBlock.jjtGetChild(0);
        if (simpleNode2.id == 75 || simpleNode2.id == 74) {
            this.expandShortcutSubject(aSTTriplesBlock);
        }
        if (aSTTriplesBlock.jjtGetNumChildren() > 1) {
            simpleNode = (SimpleNode)aSTTriplesBlock.jjtGetChild(1);
            if ((simpleNode.id == 63 || simpleNode.id == 60) && (list = this.expandPropertyListNotEmptyPath(simpleNode)).size() > 0) {
                this.addTriples(aSTTriplesBlock, list);
            }
        }
        if (aSTTriplesBlock.jjtGetNumChildren() > 2) {
            simpleNode = (SimpleNode)aSTTriplesBlock.jjtGetChild(2);
            if (simpleNode.id == 75 || simpleNode.id == 74) {
                this.expandShortcutObject(aSTTriplesBlock);
            } else if ((simpleNode.id == 62 || simpleNode.id == 61) && (list = this.expandObjectListPath(simpleNode)).size() > 0) {
                this.addTriples(aSTTriplesBlock, list);
            }
        }
    }

    private void expandShortcutSubject(ASTTriplesBlock aSTTriplesBlock) throws RDFException {
        int n;
        int n2;
        ASTTriplesBlock aSTTriplesBlock2 = this.expandBNPLP((SimpleNode)aSTTriplesBlock.jjtGetChild(0));
        int n3 = aSTTriplesBlock.jjtGetNumChildren();
        ASTTriplesBlock aSTTriplesBlock3 = null;
        if (n3 > 1) {
            aSTTriplesBlock3 = new ASTTriplesBlock(aSTTriplesBlock.parser, 47);
            aSTTriplesBlock3.jjtSetInitCapacity(n3);
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.type = 10;
            aSTTripleAtom.name = ((ASTTripleAtom)aSTTriplesBlock2.jjtGetChild((int)0)).name;
            aSTTriplesBlock3.jjtAddChild(aSTTripleAtom, 0);
            aSTTriplesBlock3.jjtGetChild(0).jjtSetParent(aSTTriplesBlock3);
            for (n2 = 1; n2 < n3; ++n2) {
                aSTTriplesBlock3.jjtAddChild(aSTTriplesBlock.jjtGetChild(n2), n2);
                aSTTriplesBlock3.jjtGetChild(n2).jjtSetParent(aSTTriplesBlock3);
            }
        }
        for (n = n3 - 1; n >= 0; --n) {
            aSTTriplesBlock.jjtRemoveChild(n);
        }
        n2 = aSTTriplesBlock2.jjtGetNumChildren();
        for (n = 0; n < n2; ++n) {
            aSTTriplesBlock.jjtAddChild(aSTTriplesBlock2.jjtGetChild(n), n);
            aSTTriplesBlock.jjtGetChild(n).jjtSetParent(aSTTriplesBlock);
        }
        if (n3 > 1) {
            aSTTriplesBlock.jjtAddChild(aSTTriplesBlock3, n);
            aSTTriplesBlock.jjtGetChild(n).jjtSetParent(aSTTriplesBlock);
        }
    }

    private void expandShortcutObject(ASTTriplesBlock aSTTriplesBlock) throws RDFException {
        ASTTriplesBlock aSTTriplesBlock2 = this.expandBNPLP((SimpleNode)aSTTriplesBlock.jjtGetChild(2));
        int n = aSTTriplesBlock2.jjtGetNumChildren();
        if (aSTTriplesBlock.jjtGetNumChildren() > 3) {
            aSTTriplesBlock2.jjtAddChild(aSTTriplesBlock.jjtGetChild(3), n);
            aSTTriplesBlock2.jjtGetChild(n).jjtSetParent(aSTTriplesBlock2);
        }
        for (int i = aSTTriplesBlock.jjtGetNumChildren() - 1; i >= 2; --i) {
            aSTTriplesBlock.jjtRemoveChild(i);
        }
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 10;
        aSTTripleAtom.name = ((ASTTripleAtom)aSTTriplesBlock2.jjtGetChild((int)0)).name;
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom, 2);
        aSTTriplesBlock.jjtGetChild(2).jjtSetParent(aSTTriplesBlock);
        aSTTriplesBlock.jjtAddChild(aSTTriplesBlock2, 3);
        aSTTriplesBlock.jjtGetChild(3).jjtSetParent(aSTTriplesBlock);
    }

    private List<ASTTriplesBlock> expandPropertyListNotEmptyPath(SimpleNode simpleNode) throws RDFException {
        ArrayList<ASTTriplesBlock> arrayList = new ArrayList<ASTTriplesBlock>();
        int n = simpleNode.jjtGetNumChildren() / 2;
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = 2 * i + 1;
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n2);
            if (simpleNode2.id == 75 || simpleNode2.id == 74) {
                object = this.expandBNPLP(simpleNode2);
                arrayList.add((ASTTriplesBlock)object);
                ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
                aSTTripleAtom.type = 10;
                aSTTripleAtom.name = ((ASTTripleAtom)((SimpleNode)object).jjtGetChild((int)0)).name;
                simpleNode.jjtAddChild(aSTTripleAtom, n2);
                simpleNode.jjtGetChild(n2).jjtSetParent(simpleNode);
                continue;
            }
            if (simpleNode2.id != 62 && simpleNode2.id != 61 || (object = this.expandObjectListPath(simpleNode2)).size() <= 0) continue;
            arrayList.addAll((Collection<ASTTriplesBlock>)object);
        }
        return arrayList;
    }

    private List<ASTTriplesBlock> expandObjectListPath(SimpleNode simpleNode) throws RDFException {
        ArrayList<ASTTriplesBlock> arrayList = new ArrayList<ASTTriplesBlock>();
        int n = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2.id != 75 && simpleNode2.id != 74) continue;
            ASTTriplesBlock aSTTriplesBlock = this.expandBNPLP(simpleNode2);
            arrayList.add(aSTTriplesBlock);
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.type = 10;
            aSTTripleAtom.name = ((ASTTripleAtom)aSTTriplesBlock.jjtGetChild((int)0)).name;
            simpleNode.jjtAddChild(aSTTripleAtom, i);
            simpleNode.jjtGetChild(i).jjtSetParent(simpleNode);
        }
        return arrayList;
    }

    private void addTriples(ASTTriplesBlock aSTTriplesBlock, List<ASTTriplesBlock> list) {
        int n = aSTTriplesBlock.jjtGetNumChildren() - 1;
        SimpleNode simpleNode = (SimpleNode)aSTTriplesBlock.jjtGetChild(n);
        if (simpleNode.id == 47) {
            this.addLastChild(list.get(list.size() - 1), simpleNode);
            aSTTriplesBlock.jjtRemoveChild(n);
        }
        this.addLastChild(aSTTriplesBlock, list.get(0));
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (i >= n2 - 1) continue;
            this.addLastChild(list.get(i), list.get(i + 1));
        }
    }

    private void addLastChild(SimpleNode simpleNode, SimpleNode simpleNode2) {
        simpleNode.jjtAddChild(simpleNode2, simpleNode.jjtGetNumChildren());
        simpleNode2.jjtSetParent(simpleNode);
    }

    private ASTTriplesBlock expandBNPLP(SimpleNode simpleNode) throws RDFException {
        if (BNPropListExpandOptimizer.hasAncestorType(simpleNode, 52)) {
            throw new RDFException("Use of blank nodes inside SERVICE is not allowed");
        }
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 10;
        ++this.newBlankNodes;
        aSTTripleAtom.name = "_:bn" + UUID.randomUUID().toString();
        ASTTriplesBlock aSTTriplesBlock = new ASTTriplesBlock(simpleNode.parser, 47);
        int n = simpleNode.jjtGetNumChildren();
        aSTTriplesBlock.jjtSetInitCapacity(n + 1);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom, 0);
        aSTTriplesBlock.jjtGetChild(0).jjtSetParent(aSTTriplesBlock);
        for (int i = 0; i < n; ++i) {
            aSTTriplesBlock.jjtAddChild(simpleNode.jjtGetChild(i), i + 1);
            aSTTriplesBlock.jjtGetChild(i + 1).jjtSetParent(aSTTriplesBlock);
        }
        return aSTTriplesBlock;
    }

    public static boolean hasAncestorType(Node node, int n) {
        for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
            if (((SimpleNode)node2).id != n) continue;
            return true;
        }
        return false;
    }
}

