/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.UnDefVarFilterOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public final class QueryUtils {
    protected static final int DEFAULT_MASK_THRESHOLD = 4;
    private static final Pattern HINT0PATTERN = Pattern.compile("(^|\\G|\\s+)HINT0\\s*=\\s*\\{\\s*([^\\}]*)\\s*\\}(\\s+|$)", 2);
    private static final Pattern TIMESTAMP = Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{0,9})?");

    protected static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    protected static void log(String string, String string2) {
        System.out.print("\n");
        System.out.print(string);
        System.out.print(string2);
    }

    protected static String extractParenValue(String string, int n, String string2) {
        String string3 = null;
        String string4 = "Error extracting value for " + string2;
        int n2 = string.indexOf("(", n);
        if (n2 >= 0) {
            int n3 = string.indexOf(")", n2);
            if (n3 > n2 + 1) {
                string3 = string.substring(n2 + 1, n3).trim();
            } else {
                QueryUtils.log(string4);
            }
        } else {
            QueryUtils.log(string4);
        }
        return string3;
    }

    protected static String wrapSQLforNumeric(String string) {
        String string2 = "";
        string2 = "to_number(" + string + ")";
        return string2;
    }

    protected static String buildVidHash(String string) {
        return "round(sys_op_combined_hash(" + string + ")/2)";
    }

    protected static String buildSubQForCLOB(String string, String string2, String string3, String string4) {
        String string5 = "(CASE WHEN " + string3 + " LIKE 'ORALL%' " + "THEN (SELECT /*+ INDEX(V " + "C_PK_VID" + ") */ V." + "LONG_VALUE" + " FROM " + string4 + " V" + " WHERE V." + "VALUE_ID" + "=" + string2 + ") " + "ELSE NULL END)";
        return string5;
    }

    protected static String buildInLineRDFT(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string5 = "REPLACE(" + string + ",chr(0))";
        stringBuffer.append("CASE WHEN " + string2 + " IS NULL\n");
        stringBuffer.append("THEN NULL\n");
        stringBuffer.append("WHEN " + string2 + " IN " + "('UR','URI')" + "\n");
        stringBuffer.append("THEN '<' || " + string + " || '>'\n");
        stringBuffer.append("WHEN " + string2 + " IN " + "('BL','BLN')" + "\n");
        stringBuffer.append("THEN " + string + "\n");
        stringBuffer.append("ELSE\n");
        stringBuffer.append("'\"' || " + string5 + " || '\"' || ");
        stringBuffer.append("NVL2(" + string3 + ",'@' || " + string3 + ",'') || ");
        stringBuffer.append("NVL2(" + string4 + ",'^^<' || " + string4 + " || '>', '')");
        stringBuffer.append("END");
        return stringBuffer.toString();
    }

    protected static void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (String string2 : set) {
            map2.put(string2.toUpperCase(), "V" + n);
            String string3 = QueryUtils.buildVTYPCaseForVar("V" + n);
            ArrayList<String> arrayList = new ArrayList<String>(8);
            arrayList.add("V" + n + "." + "VALUE_NAME");
            arrayList.add("V" + n + "." + "VALUE_ID");
            arrayList.add("V" + n + "." + "VNAME_PREFIX");
            arrayList.add("V" + n + "." + "VNAME_SUFFIX");
            arrayList.add(string3);
            arrayList.add("V" + n + "." + "LONG_VALUE");
            arrayList.add("V" + n + "." + "LITERAL_TYPE");
            arrayList.add("V" + n + "." + "LANGUAGE_TYPE");
            map.put(string2.toUpperCase(), arrayList);
            stringBuffer.append(", " + string + " V" + n);
            if (set2.contains(string2)) {
                stringBuffer2.append(" AND (R." + string2 + "$RDFVID" + " = V" + n + "." + "VALUE_ID" + ")");
            } else {
                stringBuffer2.append(" AND (R." + string2 + "$RDFVID" + " = V" + n + "." + "VALUE_ID" + "(+))");
            }
            ++n;
        }
        stringArray[0] = stringBuffer.toString();
        stringArray2[0] = stringBuffer2.toString();
    }

    protected static String buildVTYPCaseForVar(String string) {
        String string2 = " (CASE WHEN " + string + "." + "VALUE_TYPE" + " IS NULL THEN NULL" + " WHEN " + string + "." + "VALUE_TYPE" + " IN ('UR','" + "URI" + "') THEN '" + "URI" + "'\n" + " WHEN " + string + "." + "VALUE_TYPE" + " IN ('BN', '" + "BLN" + "') THEN '" + "BLN" + "'\n" + " ELSE '" + "LIT" + "'\n" + "END) ";
        return string2;
    }

    protected static ASTTripleAtom maskVar(String string) {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 0;
        aSTTripleAtom.name = string + "$";
        return aSTTripleAtom;
    }

    protected static boolean isMasked(ASTTripleAtom aSTTripleAtom) {
        boolean bl = false;
        if (aSTTripleAtom != null && aSTTripleAtom.type == 0 && aSTTripleAtom.name.endsWith("$")) {
            bl = true;
        }
        return bl;
    }

    protected static String unMaskVar(String string) {
        return string.substring(0, string.length() - 1);
    }

    protected static String buildAliasExpr(SQLGenContext sQLGenContext, String string, String string2) {
        if (!sQLGenContext.disableAliasOpt && string.endsWith(string2) && string.matches("^\\w+\\." + string2.replace("$", "\\$") + "$")) {
            return string;
        }
        return string + " AS " + string2;
    }

    protected static String buildFuncCall(String string, int[] nArray, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(nArray[i]));
            bl = true;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static boolean containsAny(Set<String> set, Set<String> set2) {
        if (set != null && !set.isEmpty()) {
            for (String string : set2) {
                if (!set.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> getCommonVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected static Set<String> getUnion(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    protected static Set<String> getDistinctVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected static boolean isSafeTabName(String string) {
        if (string.contains("(") || string.contains(")") || string.contains(";") || string.contains("'") || string.contains("\"") || string.contains(",")) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("SELECT");
        hashSet.add("FROM");
        hashSet.add("WHERE");
        hashSet.add("UNION");
        hashSet.add("JOIN");
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!hashSet.contains(string2)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSafeTimestamp(String string) {
        return TIMESTAMP.matcher(string).matches();
    }

    protected static String extractBracketedOption(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2 + "=[");
        if (n >= 0) {
            string3 = QueryUtils.extractUntil(string, n + string2.length() + 2, ']');
        }
        return string3;
    }

    protected static String extractPlainOption(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2 + "=");
        if (n >= 0) {
            n = n + string2.length() + 1;
            int n2 = string.indexOf(" ", n);
            int n3 = string.indexOf("\t", n);
            int n4 = string.indexOf("\n", n);
            if (n2 > n3 && n3 != -1) {
                n2 = n3;
            }
            if (n2 > n4 && n4 != -1) {
                n2 = n4;
            }
            if (n2 == -1) {
                n2 = string.length();
            }
            string3 = string.substring(n, n2);
        }
        return string3;
    }

    protected static String extractUntil(String string, int n, char c) {
        String string2 = "";
        int n2 = n;
        if (n2 <= string.length()) {
            char c2 = ' ';
            boolean bl = false;
            while (!bl && n2 <= string.length()) {
                c2 = string.charAt(n2);
                if (c2 == c) {
                    bl = true;
                } else {
                    string2 = string2 + String.valueOf(c2);
                }
                ++n2;
            }
        }
        return string2;
    }

    protected static void appendToList(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (stringBuffer.length() == string3.length() && stringBuffer.toString().equalsIgnoreCase(string3)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string2 + string);
        }
    }

    protected static String appendToList(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string.equalsIgnoreCase(string4) ? string + string2 : string + string3 + string2;
        return string5;
    }

    protected static boolean selectNeeded(boolean bl, boolean bl2, boolean bl3, int[] nArray, int[] nArray2, int[] nArray3) {
        boolean bl4 = false;
        if (nArray2[0] < nArray.length && nArray3[0] == nArray[nArray2[0]] || bl2) {
            bl4 = true;
        }
        if ((!bl3 || bl) && bl4 && nArray2[0] < nArray.length && nArray3[0] == nArray[nArray2[0]]) {
            nArray2[0] = nArray2[0] + 1;
        }
        if (!bl3 || bl) {
            nArray3[0] = nArray3[0] + 1;
        }
        return bl4;
    }

    protected static String buildMaskedInListClause(String[] stringArray, Set<String> set, Set<String> set2, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String string, String string2, String string3, String string4, boolean bl, String string5, SQLGenContext sQLGenContext) throws RDFException {
        int n;
        CharSequence charSequence;
        String[] stringArray6 = new String[stringArray.length];
        String[] stringArray7 = new String[stringArray.length];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            charSequence = stringArray[i];
            string7 = stringArray2[i];
            string9 = stringArray3[i];
            if (!set.contains(charSequence)) {
                string7 = "NVL(" + stringArray2[i] + "," + stringArray4[i] + ")";
                arrayList.add(i);
                arrayList3.add(stringArray4[i]);
            }
            if (!set2.contains(charSequence)) {
                string9 = "NVL(" + stringArray3[i] + "," + stringArray5[i] + ")";
                arrayList2.add(i);
                arrayList4.add(stringArray5[i]);
            }
            stringArray6[i] = string7;
            stringArray7[i] = string9;
        }
        String[] stringArray8 = new String[stringArray.length];
        charSequence = new StringBuffer("");
        String string10 = "";
        String string11 = "";
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            String string12 = stringArray[n];
            string10 = stringArray2[n];
            string11 = stringArray3[n];
            if (!set.contains(string12)) {
                string10 = !stringArray4[n].startsWith("'") ? "COALESCE(" + QueryUtils.wrapSQLforNumeric(stringArray2[n]) + "," + QueryUtils.wrapSQLforNumeric(stringArray3[n]) + "," + stringArray4[n] + ")" : "COALESCE(" + stringArray2[n] + "," + stringArray3[n] + "," + stringArray4[n] + ")";
            }
            if (!set2.contains(string12)) {
                string11 = !stringArray5[n].startsWith("'") ? "COALESCE(" + QueryUtils.wrapSQLforNumeric(stringArray3[n]) + "," + QueryUtils.wrapSQLforNumeric(stringArray2[n]) + "," + stringArray5[n] + ")" : "COALESCE(" + stringArray3[n] + "," + stringArray2[n] + "," + stringArray5[n] + ")";
                ++n2;
            }
            stringArray8[n] = string10 + " = " + string11;
        }
        n = 0;
        for (int i = 0; i < stringArray8.length; ++i) {
            if (n != 0) {
                ((StringBuffer)charSequence).append(" AND\n");
            }
            ((StringBuffer)charSequence).append(stringArray8[i]);
            n = 1;
        }
        if (!bl && n2 == stringArray.length) {
            String string13 = QueryUtils.buildAllColCoalesce(stringArray3, stringArray5);
            if (n != 0) {
                ((StringBuffer)charSequence).append(" AND\n");
            }
            ((StringBuffer)charSequence).append(string13 + " IS NOT NULL");
        }
        if (arrayList.size() > 32 || arrayList2.size() > 32) {
            throw new RDFException("Limit of 32 potentially unbound variables exceeded in negation pattern");
        }
        int n3 = arrayList.size() + arrayList2.size();
        Set<Integer> set3 = Collections.emptySet();
        string6 = QueryUtils.genColListForIn(stringArray6, set3, stringArray4, stringArray2, false, "1");
        string8 = bl ? QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, true, "0");
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, ((StringBuffer)charSequence).toString(), n3));
        if (sQLGenContext.forceMaskForNE || sQLGenContext.disableNotExists || n3 <= sQLGenContext.neMaskThreshold && !sQLGenContext.disableMaskForNE) {
            List<Set<Integer>> list = QueryUtils.genMaskingSets(arrayList);
            for (Set<Integer> object2 : list) {
                string6 = QueryUtils.genColListForIn(stringArray6, set3, stringArray4, stringArray2, false, "1");
                string8 = bl ? QueryUtils.genColListForIn(stringArray7, object2, stringArray4, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, object2, stringArray4, stringArray3, true, "0");
                stringBuffer.append(string4 + "\n");
                stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, "", n3));
            }
            List<Set<Integer>> list2 = QueryUtils.genMaskingSets(arrayList2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Set set4 = (Set)iterator.next();
                string6 = QueryUtils.genColListForIn(stringArray6, set4, stringArray5, stringArray2, false, "1");
                string8 = bl ? QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, true, "0");
                stringBuffer.append(string4 + "\n");
                stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, "", n3));
            }
        }
        return stringBuffer.toString();
    }

    protected static String buildExistsCond(String string, String string2, String string3, String string4, String string5, SQLGenContext sQLGenContext, String string6, String string7, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (sQLGenContext.disableNotExists) {
            stringBuffer.append("(" + string + ")\n");
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("(SELECT " + string6 + "" + string3 + "\n");
            stringBuffer.append("FROM (" + string4 + ") " + string5 + ")");
        } else {
            stringBuffer.append("(" + string2 + "\n");
            stringBuffer.append("(SELECT " + string6 + " " + string3 + "\n");
            stringBuffer.append("FROM (" + string4 + ") " + string5 + "\n");
            if (sQLGenContext.forceMaskForNE || n <= sQLGenContext.neMaskThreshold && !sQLGenContext.disableMaskForNE) {
                stringBuffer.append("WHERE (" + string + ") IN ((" + string3 + "))))\n");
            } else {
                stringBuffer.append("WHERE " + string7 + "))\n");
            }
        }
        return stringBuffer.toString();
    }

    protected static String genColListForIn(String[] stringArray, Set<Integer> set, String[] stringArray2, String[] stringArray3, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            if (set.contains(i)) {
                QueryUtils.appendToList(stringBuffer, stringArray2[i], ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, stringArray[i], ", ", "");
        }
        if (bl) {
            String string2 = "";
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (stringArray.length > 1) {
                stringBuffer2.append("COALESCE(");
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray2[i].startsWith("'") ? stringArray3[i] : QueryUtils.buildSafeToChar(stringArray3[i]);
                    QueryUtils.appendToList(stringBuffer2, string2, ",", "COALESCE(");
                }
                stringBuffer2.append(")");
            } else {
                stringBuffer2.append(stringArray3[0]);
            }
            QueryUtils.appendToList(stringBuffer, " NVL2(" + stringBuffer2.toString() + ",1," + string + ")", ", ", "");
        } else if (string != null) {
            QueryUtils.appendToList(stringBuffer, string, ", ", "");
        }
        return stringBuffer.toString();
    }

    protected static String buildAllColCoalesce(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray.length > 1) {
            String string = "";
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray2[i].startsWith("'") ? stringArray[i] : QueryUtils.buildSafeToChar(stringArray[i]);
                QueryUtils.appendToList(stringBuffer, string, ",", "COALESCE(");
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(stringArray[0]);
        }
        return stringBuffer.toString();
    }

    protected static String buildSafeToChar(String string) {
        return "TO_CHAR(" + string + "," + "'TM9'" + "," + "'NLS_Numeric_Characters=''.,'''" + ")";
    }

    protected static int computeNonVnTermLen(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string != null && string.length() > 0) {
            n = string.length() + 1;
        }
        if (string2 != null && string2.length() > 0) {
            n2 = string2.length() + 4;
        }
        return n + n2 + 2;
    }

    protected static int computeConstTermLen(String string, String string2, String string3) {
        return string.length() + QueryUtils.computeNonVnTermLen(string2, string3);
    }

    protected static String computeClobTermLen(String string, String string2, String string3) {
        return "(NVL(DBMS_LOB.GETLENGTH(TO_CLOB(" + string + ")),0)" + "+NVL(LENGTH(" + string2 + ")+2,0)" + "+NVL(LENGTH(" + string3 + ")+4,0)" + "+2)";
    }

    protected static String shortenConstVNforTerm(String string, String string2, String string3) {
        int n = 4000 - QueryUtils.computeNonVnTermLen(string2, string3);
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static String shortenVNforTerm(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (string3 == null) {
            string3 = "NULL";
        }
        return "TO_CHAR(SUBSTR(" + string + "," + "1," + "(" + 4000 + "-(NVL(length(" + string3 + ")+4,0)" + "+NVL(length(" + string2 + ")+1,0)+2))))";
    }

    protected static String shortenClobForTerm(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (string3 == null) {
            string3 = "NULL";
        }
        return "TO_CHAR(DBMS_LOB.SUBSTR(TO_CLOB(" + string + ")," + "(" + 4000 + "-(NVL(length(" + string3 + ")+4,0)" + "+NVL(length(" + string2 + ")+1,0)+2))," + "1))";
    }

    protected static String escapeSingleQuotes(String string) {
        return string.replace("'", "''");
    }

    public static String splitClobInChunks(String string, int n, boolean bl) {
        String string2 = "(";
        int n2 = 0;
        while (n2 + n < string.length()) {
            String string3 = string.substring(n2, n2 + n);
            if (bl) {
                string3 = QueryUtils.escapeSingleQuotes(string3);
            }
            string2 = string2 + "to_clob('" + string3 + "') ||";
            n2 += n;
        }
        string2 = string2 + "to_clob('" + QueryUtils.escapeSingleQuotes(string.substring(n2)) + "'))";
        return string2;
    }

    protected static List<Set<Integer>> genMaskingSets(List<Integer> list) {
        int n = Double.valueOf(Math.pow(2.0, list.size())).intValue();
        ArrayList<Set<Integer>> arrayList = new ArrayList<Set<Integer>>(n - 1);
        for (int i = 1; i < n; ++i) {
            char[] cArray = String.format("%1$" + list.size() + "s", Integer.toBinaryString(i)).replace(' ', '0').toCharArray();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] != '1') continue;
                hashSet.add(list.get(j));
            }
            arrayList.add(hashSet);
        }
        return arrayList;
    }

    protected static String genVNameSubstr(String string, String string2, String string3, String string4) {
        return "NVL2(" + string2 + "," + "to_char(" + QueryUtils.shortenClobForTerm(string2, string3, string4) + ")," + string + ")";
    }

    protected static String extractHint0Contents(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            return null;
        }
        Matcher matcher = HINT0PATTERN.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            if (matcher.groupCount() != 3) {
                QueryUtils.log("ERROR: HINT0 pattern needs to be fixed. Unable to search for HINT0 hints");
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(matcher.group(2));
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected static String buildInList(String string, long[] lArray) {
        String string2 = "";
        if (lArray != null && lArray.length > 0) {
            string2 = " " + string + " IN (";
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + lArray[i];
            }
            string2 = string2 + ") ";
        }
        return string2;
    }

    public static void processUnDefVars(Filter filter, Set<String> set, Map<String, String> map) throws RDFException {
        if (filter != null) {
            UnDefVarFilterOptimizer unDefVarFilterOptimizer = new UnDefVarFilterOptimizer(set, map);
            try {
                filter.applyFilterOptimizer(unDefVarFilterOptimizer);
            }
            catch (FilterException filterException) {
                throw new RDFException(filterException.getMessage());
            }
        }
    }

    protected static String buildUnpivot(Set<String> set, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "$RDFTERM";
        if (bl) {
            string2 = "$RDFVID";
        }
        stringBuffer.append("SELECT TERM").append(string2).append("\nFROM (SELECT DISTINCT ");
        int n = 0;
        for (String string3 : set) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3).append(string2).append(" AS TERM").append(n);
            ++n;
        }
        stringBuffer.append(" FROM(").append(string).append("))");
        stringBuffer.append("\nUNPIVOT INCLUDE NULLS\n");
        stringBuffer.append("((TERM").append(string2).append(")\n FOR (c) IN (");
        for (n = 0; n < set.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("(TERM").append(n).append(")");
        }
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    protected static String buildOptTerm(String[] stringArray) {
        String string = "";
        string = Integer.parseInt(stringArray[7]) == 28 ? stringArray[9] : "sem_apis.compose_rdf_term(" + stringArray[0] + "," + stringArray[1] + "," + stringArray[4] + "," + stringArray[5] + ")";
        return string;
    }

    protected static String buildOptNumber(String[] stringArray) {
        String string = "";
        string = Integer.parseInt(stringArray[7]) == 3 || Integer.parseInt(stringArray[7]) == 29 ? stringArray[9] : "sem_apis.getV$NumericVal(" + stringArray[1] + "," + stringArray[2] + "," + stringArray[3] + "," + stringArray[4] + "," + stringArray[5] + ")";
        return string;
    }
}

