/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.SelectivityEstimator;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.NUMBER;

public class RDFModelStatistics {
    private static final String STATS_CALL = "{ call ? := sem_apis.get_model_stats( ?, ?, ?, ? ) }";
    private static final String VALUE_ID_CALL = "SELECT /*+ INDEX(v RDF_VAL_NAMETYLITLNG_IDX) */        CASE WHEN CANON_ID is NULL THEN VALUE_ID        ELSE CANON_ID END FROM   MDSYS.RDF_VALUE$ WHERE  VALUE_TYPE='UR' and        VNAME_PREFIX=?  and        VNAME_SUFFIX=?";
    private static final String VALUE_ID_COL = "VALUE_ID";
    private static final String PRED_STATS_TAB = "PRED";
    private static final String TERM_STATS_TAB = "TERM";
    private static final String PRED_INSTANCES_COL = "INSTANCES";
    private static final String PRED_SUBJ_FANOUT_COL = "START_NODE_FANOUT";
    private static final String PRED_OBJ_FANOUT_COL = "END_NODE_FANOUT";
    private static final String TERM_SUBJ_INSTANCES_COL = "START_NODE_INSTANCES";
    private static final String TERM_OBJ_INSTANCES_COL = "END_NODE_INSTANCES";
    private static final String EMPTY_QUERY = "SELECT 1 FROM DUAL WHERE NULL != NULL";
    private static final Set<Long> EMPTY_SET = new HashSet<Long>();
    private static Map<String, OracleCallableStatement> preparedCalls = new HashMap<String, OracleCallableStatement>();
    private static boolean warned = false;

    private RDFModelStatistics() {
    }

    public static OracleResultSet getStats(String string, Set<SelectivityEstimator.Model> set, Collection<Long> collection) throws SQLException {
        return RDFModelStatistics.getStats(string, set, collection, null);
    }

    public static OracleResultSet getStats(String string, Set<SelectivityEstimator.Model> set, Collection<Long> collection, String string2) throws SQLException {
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Models collection must not be empty");
        }
        Connection connection = HintEngine.getSessionContext().getConnection();
        OracleCallableStatement oracleCallableStatement = RDFModelStatistics.prepareCall(STATS_CALL, connection);
        NUMBER[] nUMBERArray = new NUMBER[collection.size()];
        int n = 0;
        for (Long l : collection) {
            nUMBERArray[n] = new NUMBER((Object)l);
            ++n;
        }
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"SYS.ODCINUMBERLIST", (Connection)connection);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)nUMBERArray);
        oracleCallableStatement.registerOutParameter(1, -10);
        oracleCallableStatement.setString(2, set.iterator().next().getName().toUpperCase());
        oracleCallableStatement.setString(3, string);
        oracleCallableStatement.setARRAY(4, aRRAY);
        oracleCallableStatement.setString(5, string2);
        oracleCallableStatement.execute();
        return (OracleResultSet)oracleCallableStatement.getCursor(1);
    }

    private static OracleCallableStatement prepareCall(String string, Connection connection) throws SQLException {
        OracleCallableStatement oracleCallableStatement;
        if (!preparedCalls.containsKey(string)) {
            if (connection == null) {
                if (!warned) {
                    System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "no connection to database, selectivity estimator will use default values for generating hints");
                    warned = true;
                }
                return null;
            }
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string, 1003, 1007);
            preparedCalls.put(string, oracleCallableStatement);
        } else {
            oracleCallableStatement = preparedCalls.get(string);
        }
        return oracleCallableStatement;
    }

    private static void logDuration(String string, long l) {
        System.out.printf("[%5s] %7s: %s\n", "stats", "debug", String.format("%2$6.2f s | %1$s", string, (double)(System.currentTimeMillis() - l) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, PredStats> getPredResults(Set<SelectivityEstimator.Model> set, Set<Long> set2) throws SQLException {
        HashMap<Long, PredStats> hashMap;
        boolean bl = HintEngine.getSessionContext().isLogStats();
        long l = 0L;
        OracleResultSet oracleResultSet = null;
        try {
            oracleResultSet = RDFModelStatistics.getStats(PRED_STATS_TAB, set, set2);
            int n = oracleResultSet.findColumn(VALUE_ID_COL);
            int n2 = oracleResultSet.findColumn(PRED_INSTANCES_COL);
            int n3 = oracleResultSet.findColumn(PRED_SUBJ_FANOUT_COL);
            int n4 = oracleResultSet.findColumn(PRED_OBJ_FANOUT_COL);
            hashMap = new HashMap<Long, PredStats>();
            if (bl) {
                l = System.currentTimeMillis();
            }
            while (oracleResultSet.next()) {
                PredStats predStats = new PredStats(oracleResultSet.getNUMBER(n2).bigDecimalValue(), oracleResultSet.getNUMBER(n3).bigDecimalValue(), oracleResultSet.getNUMBER(n4).bigDecimalValue());
                hashMap.put(oracleResultSet.getNUMBER(n).longValue(), predStats);
            }
            if (bl) {
                RDFModelStatistics.logDuration("Pred stats read and stored for " + set2.size() + " IDs", l);
            }
        }
        finally {
            if (oracleResultSet != null) {
                try {
                    oracleResultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, TermStats> getTermResults(Set<SelectivityEstimator.Model> set, Set<Long> set2) throws SQLException {
        HashMap<Long, TermStats> hashMap;
        boolean bl = HintEngine.getSessionContext().isLogStats();
        long l = 0L;
        OracleResultSet oracleResultSet = null;
        try {
            oracleResultSet = RDFModelStatistics.getStats(TERM_STATS_TAB, set, set2);
            int n = oracleResultSet.findColumn(VALUE_ID_COL);
            int n2 = oracleResultSet.findColumn(TERM_SUBJ_INSTANCES_COL);
            int n3 = oracleResultSet.findColumn(TERM_OBJ_INSTANCES_COL);
            hashMap = new HashMap<Long, TermStats>();
            if (bl) {
                l = System.currentTimeMillis();
            }
            while (oracleResultSet.next()) {
                TermStats termStats = new TermStats(oracleResultSet.getNUMBER(n2).bigDecimalValue(), oracleResultSet.getNUMBER(n3).bigDecimalValue());
                hashMap.put(oracleResultSet.getNUMBER(n).longValue(), termStats);
            }
            if (bl) {
                RDFModelStatistics.logDuration("Term stats read and stored for " + set2.size() + " IDs", l);
            }
        }
        finally {
            if (oracleResultSet != null) {
                try {
                    oracleResultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal getCount(String string, Set<SelectivityEstimator.Model> set) throws SQLException {
        OracleResultSet oracleResultSet = null;
        try {
            oracleResultSet = RDFModelStatistics.getStats(string, set, EMPTY_SET, "COUNT");
            if (oracleResultSet.next()) {
                BigDecimal bigDecimal = oracleResultSet.getBigDecimal(1);
                return bigDecimal;
            }
        }
        finally {
            if (oracleResultSet != null) {
                try {
                    oracleResultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return BigDecimal.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal getSum(String string, String string2, Set<SelectivityEstimator.Model> set) throws SQLException {
        OracleResultSet oracleResultSet = null;
        boolean bl = false;
        long l = 0L;
        try {
            if (string2.equals(PRED_INSTANCES_COL)) {
                oracleResultSet = RDFModelStatistics.getStats(string, set, EMPTY_SET, "SUM");
                if (oracleResultSet.next()) {
                    BigDecimal bigDecimal = oracleResultSet.getBigDecimal(1);
                    return bigDecimal;
                }
                BigDecimal bigDecimal = null;
                return bigDecimal;
            }
            oracleResultSet = RDFModelStatistics.getStats(string, set, EMPTY_SET);
            int n = oracleResultSet.findColumn(string2);
            while (oracleResultSet.next()) {
                bl = true;
                l += oracleResultSet.getNUMBER(n).longValue();
            }
        }
        finally {
            if (oracleResultSet != null) {
                try {
                    oracleResultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        if (bl) {
            return new BigDecimal(l);
        }
        return null;
    }

    public static Map<Long, PredStats> getPredStats(Set<SelectivityEstimator.Model> set, Set<Long> set2) {
        try {
            if (!set2.isEmpty()) {
                return RDFModelStatistics.getPredResults(set, set2);
            }
        }
        catch (Exception exception) {
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "unable to access statistics: " + exception.getMessage());
            exception.printStackTrace();
        }
        return new HashMap<Long, PredStats>();
    }

    public static Map<Long, TermStats> getTermStats(Set<SelectivityEstimator.Model> set, Set<Long> set2) {
        try {
            if (!set2.isEmpty()) {
                return RDFModelStatistics.getTermResults(set, set2);
            }
        }
        catch (Exception exception) {
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "unable to access statistics: " + exception.getMessage());
            exception.printStackTrace();
        }
        return new HashMap<Long, TermStats>();
    }

    private static BigDecimal getSumWrapper(String string, String string2, Set<SelectivityEstimator.Model> set) {
        try {
            return RDFModelStatistics.getSum(string, string2, set);
        }
        catch (Exception exception) {
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "unable to access statistics: " + exception.getMessage());
            return null;
        }
    }

    private static BigDecimal getCountWrapper(String string, Set<SelectivityEstimator.Model> set) {
        try {
            return RDFModelStatistics.getCount(string, set);
        }
        catch (Exception exception) {
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "unable to access statistics: " + exception.getMessage());
            return null;
        }
    }

    public static BigDecimal getPredicateInstances(Set<SelectivityEstimator.Model> set) {
        return RDFModelStatistics.getSumWrapper(PRED_STATS_TAB, PRED_INSTANCES_COL, set);
    }

    public static BigDecimal getPredicateCount(Set<SelectivityEstimator.Model> set) {
        return RDFModelStatistics.getCountWrapper(PRED_STATS_TAB, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getCanonicalID(String string, String string2) {
        Connection connection = HintEngine.getSessionContext().getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(VALUE_ID_CALL, 1003, 1007);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (Exception exception) {
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", String.format("unable to retrieve canonical ID for '%s%s': %s", string, string2, exception.getMessage()));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static class TermStats {
        private final BigDecimal subjectInstances;
        private final BigDecimal objectInstances;

        public TermStats(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            this.subjectInstances = bigDecimal;
            this.objectInstances = bigDecimal2;
        }

        public BigDecimal getSubjectInstances() {
            return this.subjectInstances;
        }

        public BigDecimal getObjectInstances() {
            return this.objectInstances;
        }
    }

    public static class PredStats {
        private final BigDecimal instances;
        private final BigDecimal subjectFanout;
        private final BigDecimal objectFanout;

        public PredStats(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
            this.instances = bigDecimal;
            this.subjectFanout = bigDecimal2;
            this.objectFanout = bigDecimal3;
        }

        public BigDecimal getInstances() {
            return this.instances;
        }

        public BigDecimal getSubjectFanout() {
            return this.subjectFanout;
        }

        public BigDecimal getObjectFanout() {
            return this.objectFanout;
        }
    }
}

