/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SelectivityEstimator;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class SimpleFilterEstimator
implements SelectivityEstimator {
    private static final BigDecimal VERY_RARE = BigDecimal.ONE.divide(new BigDecimal(1000000000000L));
    private static final BigDecimal RARE = BigDecimal.ONE.divide(new BigDecimal(1000000000L));
    private static final BigDecimal AVERAGE = BigDecimal.ONE.divide(new BigDecimal(1000000L));
    private static final BigDecimal COMMON = BigDecimal.ONE.divide(new BigDecimal(100L));
    private static final BigDecimal VERY_COMMON = BigDecimal.ONE.divide(BigDecimal.TEN);
    private static final BigDecimal BD_TWO = new BigDecimal(2);
    private SelectivityEstimator estimator;

    public SimpleFilterEstimator(SelectivityEstimator selectivityEstimator) {
        this.estimator = selectivityEstimator;
        if (selectivityEstimator == null) {
            throw new IllegalArgumentException("Underlying estimator can not be null");
        }
    }

    @Override
    public Set<SelectivityEstimator.Stats> getTripleStats(Set<SelectivityEstimator.Model> set, SPARQLBGP sPARQLBGP, Set<TriplesBlock> set2) throws SQLException {
        Set<SelectivityEstimator.Stats> set3 = this.estimator.getTripleStats(set, sPARQLBGP, set2);
        return this.filterStats(sPARQLBGP, set3);
    }

    @Override
    public long getTotalNumTuples(Set<SelectivityEstimator.Model> set) throws SQLException {
        return this.estimator.getTotalNumTuples(set);
    }

    private Set<SelectivityEstimator.Stats> filterStats(SPARQLBGP sPARQLBGP, Set<SelectivityEstimator.Stats> set) {
        HashSet<SelectivityEstimator.Stats> hashSet = new HashSet<SelectivityEstimator.Stats>();
        for (SelectivityEstimator.Stats stats : set) {
            hashSet.add(this.filterStat(sPARQLBGP, stats));
        }
        return hashSet;
    }

    private SelectivityEstimator.Stats filterStat(SPARQLBGP sPARQLBGP, SelectivityEstimator.Stats stats) {
        BigDecimal bigDecimal = stats.getSelectivity();
        LinkedList<Filter> linkedList = new LinkedList<Filter>(sPARQLBGP.getFilters());
        if (linkedList.isEmpty()) {
            return stats;
        }
        Set<String> set = stats.getVars();
        if (set.isEmpty()) {
            return stats;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (SimpleFilterEstimator.intersectIgnoreCase(set, filter.getVars())) continue;
            iterator.remove();
        }
        if (linkedList.isEmpty()) {
            return stats;
        }
        for (Filter filter : linkedList) {
            SimpleNode simpleNode = filter.getFilterTree();
        }
        return stats;
    }

    private static boolean intersectIgnoreCase(Set<String> set, Set<String> set2) {
        for (String string : set) {
            for (String string2 : set2) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

