/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.PPAltNode;
import oracle.spatial.rdf.server.PPIRINode;
import oracle.spatial.rdf.server.PPModNode;
import oracle.spatial.rdf.server.PPNegatedNode;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.PPSQLTransVisitor;
import oracle.spatial.rdf.server.PPSeqNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class SimplePPSQLTransVisitor
implements PPSQLTransVisitor {
    public static final int DEFAULT_PP_DEPTH = 10;
    private ASTTripleAtom activeGraph = null;
    private SQLGenContext ctx;
    private Map<Hint.QueryOption, String> queryOptions;
    private String linkTab = "";
    private int ppMaxDepth = 10;
    private String joinType = null;
    private boolean disableSJ = false;
    private boolean disableSJdist = false;
    private boolean useRW = false;
    private String searchType = null;
    private boolean distinctRW = false;
    private int wCount = 0;
    private List<String> wList = null;
    private String linkObjCol = "CANON_END_NODE_ID";

    public SimplePPSQLTransVisitor(ASTTripleAtom aSTTripleAtom, SQLGenContext sQLGenContext, Map<Hint.QueryOption, String> map, String string) {
        this.activeGraph = aSTTripleAtom;
        this.ctx = sQLGenContext;
        this.queryOptions = map;
        this.linkTab = string;
        this.ppMaxDepth = 10;
        String string2 = map.get((Object)Hint.QueryOption.MAX_PP_DEPTH);
        if (string2 != null) {
            try {
                this.ppMaxDepth = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                QueryUtils.log("Error reading MAX_PP_DEPTH for\n" + string2 + "\n" + exception.getMessage());
            }
        }
        if (map.containsKey((Object)Hint.QueryOption.USE_PP_HASH)) {
            this.joinType = "USE_HASH";
        } else if (map.containsKey((Object)Hint.QueryOption.USE_PP_NL)) {
            this.joinType = "USE_NL";
        }
        if (map.containsKey((Object)Hint.QueryOption.DISABLE_PP_SJ)) {
            this.disableSJ = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.DISABLE_PP_SJ_DIST)) {
            this.disableSJdist = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.USE_PP_RW)) {
            this.useRW = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.RW_PP_DISTINCT)) {
            this.distinctRW = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.USE_PP_BFS)) {
            this.searchType = "BREADTH";
        } else if (map.containsKey((Object)Hint.QueryOption.USE_PP_DFS)) {
            this.searchType = "DEPTH";
        }
        this.wCount = 0;
        this.wList = new ArrayList<String>();
        if (sQLGenContext.useExactValue) {
            this.linkObjCol = "END_NODE_ID";
        }
    }

    @Override
    public String visit(PPModNode pPModNode, String[] stringArray) throws RDFException {
        if (pPModNode.getNumChildren() != 1) {
            throw new RDFException("Unexpected number of children under PPModNode");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Object var4_4 = null;
        Object var5_5 = null;
        switch (pPModNode.getModifier()) {
            case 0: {
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append(this.buildZeroLengthQuery(pPModNode));
                stringBuffer.append("\nUNION ALL\n");
                stringBuffer.append("(");
                stringBuffer.append(this.buildNHopQuery(pPModNode, stringArray[0], 0, 1, true));
                stringBuffer.append(")) T0");
                break;
            }
            case 1: {
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append(this.buildZeroLengthQuery(pPModNode));
                stringBuffer.append("\nUNION ALL\n");
                stringBuffer.append("(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + "\n");
                stringBuffer.append("FROM (");
                stringBuffer.append(this.buildBasicUnbound(pPModNode, stringArray[0]));
                stringBuffer.append(")\n");
                stringBuffer.append(")) T0");
                break;
            }
            case 2: {
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection()));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append("(");
                stringBuffer.append(this.buildBasicUnbound(pPModNode, stringArray[0]));
                stringBuffer.append(")");
                stringBuffer.append(") T0");
                stringBuffer.append(") T0");
                break;
            }
            case 3: {
                int n = pPModNode.getMinOcc();
                int n2 = pPModNode.getMaxOcc();
                if (pPModNode.isExactRange()) {
                    stringBuffer.append(this.buildNHopQuery(pPModNode, stringArray[0], pPModNode.getDirection(), n, true));
                    break;
                }
                if (n2 >= 0) {
                    stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection()));
                    stringBuffer.append("\n");
                    StringBuffer stringBuffer2 = new StringBuffer("FROM (");
                    int n3 = n >= 0 ? n : 0;
                    String string = "";
                    for (int i = n3; i <= n2; ++i) {
                        string = this.buildNHopQuery(pPModNode, stringArray[0], 0, i, true);
                        QueryUtils.appendToList(stringBuffer2, "(" + string + ")", "\nUNION ALL\n", "FROM (");
                    }
                    stringBuffer2.append(") T0\n");
                    stringBuffer.append(stringBuffer2);
                    break;
                }
                stringBuffer.append("WITH NHOP AS (");
                stringBuffer.append(this.buildNHopQuery(pPModNode, stringArray[0], 0, n, false));
                stringBuffer.append(")\n");
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection()));
                stringBuffer.append("\n");
                StringBuffer stringBuffer3 = new StringBuffer("FROM (");
                stringBuffer3.append("(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + " " + "FROM NHOP)");
                stringBuffer3.append("\nUNION ALL\n");
                String string = this.linkObjCol;
                String string2 = "START_NODE_ID";
                stringBuffer3.append("(SELECT NH.START_NODE_ID, UB." + this.linkObjCol + ", " + "NH." + "G_ID" + "\n" + "FROM\n");
                stringBuffer3.append("(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + " " + "FROM NHOP) NH,\n");
                stringBuffer3.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, "CONNECT_BY_ROOT T0." + string2, "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0." + string, this.linkObjCol) + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0.G_ID", "G_ID") + "\n" + "FROM (SELECT " + "START_NODE_ID" + ", " + this.linkObjCol + ", " + "G_ID" + "\n" + "FROM (" + stringArray[0] + ")\n" + "WHERE " + "START_NODE_ID" + "<>" + this.linkObjCol + ") T0\n" + "START WITH (" + string2 + " IN (SELECT " + string + "\n" + "FROM NHOP))\n" + "CONNECT BY NOCYCLE " + "PRIOR " + string + "=" + string2);
                if (this.activeGraph != null) {
                    stringBuffer3.append(" AND PRIOR G_ID=G_ID");
                }
                stringBuffer3.append(") UB\n");
                stringBuffer3.append("WHERE NH." + string + "=" + "UB." + string2);
                if (this.activeGraph != null) {
                    stringBuffer3.append(" AND NH.G_ID=UB.G_ID");
                }
                stringBuffer3.append(")");
                stringBuffer3.append(") T0");
                stringBuffer.append(stringBuffer3);
                StringBuffer stringBuffer4 = new StringBuffer("WHERE ");
                if (pPModNode.hasConstrainedStart()) {
                    this.applyIDConstraint(stringBuffer4, "T0", "START_NODE_ID", true, pPModNode.getStartNode());
                }
                if (pPModNode.hasConstrainedEnd()) {
                    this.applyIDConstraint(stringBuffer4, "T0", this.linkObjCol, true, pPModNode.getEndNode());
                }
                if (stringBuffer4.length() <= 6) break;
                stringBuffer.append("\n");
                stringBuffer.append(stringBuffer4);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String visit(PPSeqNode pPSeqNode, String[] stringArray) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "T0";
        String string2 = "T" + (pPSeqNode.getNumChildren() - 1);
        stringBuffer.append(this.buildPPSelect(string, string2, pPSeqNode.getDirection(), false, pPSeqNode.getNumChildren()));
        stringBuffer.append("\n");
        stringBuffer.append(this.buildPPFrom(stringArray));
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
        this.appendPathJoin(stringBuffer2, pPSeqNode.getNumChildren());
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public String visit(PPAltNode pPAltNode, String[] stringArray) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.buildPPSelect("T0", "T0", pPAltNode.getDirection()));
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer("FROM (");
        for (int i = 0; i < pPAltNode.getNumChildren(); ++i) {
            QueryUtils.appendToList(stringBuffer2, "(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + "\n" + "FROM (" + stringArray[i] + "))", "\nUNION ALL\n", "FROM (");
        }
        stringBuffer2.append(") T0\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public String visit(PPNegatedNode pPNegatedNode, String[] stringArray) throws RDFException {
        ArrayList<PPIRINode> arrayList = new ArrayList<PPIRINode>();
        ArrayList<PPIRINode> arrayList2 = new ArrayList<PPIRINode>();
        for (int i = 0; i < pPNegatedNode.getNumChildren(); ++i) {
            PPIRINode pPIRINode = (PPIRINode)pPNegatedNode.getChild(i);
            if (pPIRINode.getDirection() == 0) {
                arrayList.add(pPIRINode);
                continue;
            }
            arrayList2.add(pPIRINode);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        if (arrayList.size() > 0) {
            stringBuffer.append(this.buildBasicIRIQuery(arrayList, 0, false));
            this.appendStartEndConstraint(stringBuffer, "T0", pPNegatedNode);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (arrayList2.size() > 0) {
            stringBuffer2.append(this.buildBasicIRIQuery(arrayList2, 1, false));
            this.appendStartEndConstraint(stringBuffer2, "T0", pPNegatedNode);
            ++n;
        }
        StringBuffer stringBuffer3 = new StringBuffer("");
        stringBuffer3.append(this.buildPPSelect("T0", "T0", pPNegatedNode.getDirection()));
        stringBuffer3.append("\n");
        stringBuffer3.append("FROM (\n");
        if (stringBuffer.length() > 0) {
            stringBuffer3.append("(").append(stringBuffer).append(")");
        }
        if (n > 1) {
            stringBuffer3.append("\nUNION ALL\n");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer3.append("(").append(stringBuffer2).append(")");
        }
        stringBuffer3.append(") T0");
        return stringBuffer3.toString();
    }

    @Override
    public String visit(PPIRINode pPIRINode, String[] stringArray) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        ArrayList<PPIRINode> arrayList = new ArrayList<PPIRINode>(1);
        arrayList.add(pPIRINode);
        stringBuffer.append(this.buildBasicIRIQuery(arrayList, pPIRINode.getDirection(), true));
        this.appendStartEndConstraint(stringBuffer, "T0", pPIRINode);
        return stringBuffer.toString();
    }

    @Override
    public String getWITHClauses() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.wList.size() > 0) {
            stringBuffer.append("WITH\n");
            for (String string : this.wList) {
                QueryUtils.appendToList(stringBuffer, string, ",\n", "WITH\n");
            }
        }
        return stringBuffer.toString();
    }

    private boolean isGraphQuery() {
        return this.activeGraph != null;
    }

    private String buildPPSelect(String string, String string2, int n) throws RDFException {
        return this.buildPPSelect(string, string2, n, false);
    }

    private String buildPPSelect(String string, String string2, int n, boolean bl) throws RDFException {
        return this.buildPPSelect(string, string2, n, bl, 0);
    }

    private String buildPPSelect(String string, String string2, int n, boolean bl, int n2) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (n2 > 1 && this.joinType != null) {
            stringBuffer2.append("/*+ " + this.joinType + "(");
            for (int i = 0; i < n2; ++i) {
                stringBuffer2.append(" T" + i);
            }
            stringBuffer2.append(") */ ");
        }
        stringBuffer.append(stringBuffer2.toString());
        if (bl && !this.ctx.allowPPDup) {
            stringBuffer.append("DISTINCT ");
        }
        switch (n) {
            case 0: {
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string + "." + "START_NODE_ID", "START_NODE_ID"));
                stringBuffer.append(",\n");
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string2 + "." + this.linkObjCol, this.linkObjCol));
                break;
            }
            case 1: {
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string2 + "." + this.linkObjCol, "START_NODE_ID"));
                stringBuffer.append(",\n");
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string + "." + "START_NODE_ID", this.linkObjCol));
                break;
            }
            default: {
                throw new RDFException("Unexpected property path direction");
            }
        }
        stringBuffer.append(",\n");
        stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string + "." + "G_ID", "G_ID"));
        return stringBuffer.toString();
    }

    private String buildPPFrom(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("FROM ");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            }
            bl = true;
            stringBuffer.append("(").append(stringArray[i]).append(") T").append(i);
        }
        return stringBuffer.toString();
    }

    private void appendPathJoin(StringBuffer stringBuffer, int n) {
        for (int i = 1; i < n; ++i) {
            QueryUtils.appendToList(stringBuffer, "T" + (i - 1) + "." + this.linkObjCol + "=" + "T" + i + "." + "START_NODE_ID", " AND ", "WHERE ");
            if (this.activeGraph == null) continue;
            QueryUtils.appendToList(stringBuffer, "T" + (i - 1) + "." + "G_ID" + "=" + "T" + i + "." + "G_ID", " AND ", "WHERE ");
        }
    }

    private String buildBasicIRIQuery(List<PPIRINode> list, int n, boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.buildPPSelect("T0", "T0", n));
        stringBuffer.append("\n");
        stringBuffer.append(this.buildPPFrom(new String[]{this.linkTab}));
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
        if (list.size() == 1) {
            PPIRINode pPIRINode = list.get(0);
            this.applyIDConstraint(stringBuffer2, "T0", "P_VALUE_ID", bl, pPIRINode.getPredAtom());
        } else {
            String string = this.buildVIDinList(list);
            stringBuffer2.append("T0.P_VALUE_ID");
            if (bl) {
                stringBuffer2.append(" IN ");
            } else {
                stringBuffer2.append(" NOT IN ");
            }
            stringBuffer2.append(string);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    private void appendStartEndConstraint(StringBuffer stringBuffer, String string, PPNode pPNode) throws RDFException {
        String string2 = "";
        if (pPNode.hasConstrainedStart()) {
            string2 = pPNode.getDirection() == 0 ? "START_NODE_ID" : this.linkObjCol;
            this.applyIDConstraint(stringBuffer, string, string2, true, pPNode.getStartNode());
        }
        if (pPNode.hasConstrainedEnd()) {
            string2 = pPNode.getDirection() == 0 ? this.linkObjCol : "START_NODE_ID";
            this.applyIDConstraint(stringBuffer, string, string2, true, pPNode.getEndNode());
        }
    }

    private void applyIDConstraint(StringBuffer stringBuffer, String string, String string2, boolean bl, ASTTripleAtom aSTTripleAtom) throws RDFException {
        if (aSTTripleAtom.type == 7) {
            throw new RDFException("SYS_CONTEXT functions not allowed within property path expressions");
        }
        TriplesBlock.Element element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
        Long l = element.getCanonicalID();
        String string3 = "=";
        if (!bl) {
            string3 = "<>";
        }
        if (l != null) {
            QueryUtils.appendToList(stringBuffer, string + "." + string2 + string3 + l.toString(), " AND ", "WHERE ");
        } else if (!element.exists()) {
            QueryUtils.appendToList(stringBuffer, "(1" + string3 + "0)", " AND ", "WHERE ");
        }
    }

    private String buildVIDinList(List<PPIRINode> list) throws RDFException {
        ASTTripleAtom aSTTripleAtom = null;
        TriplesBlock.Element element = null;
        Long l = null;
        StringBuffer stringBuffer = new StringBuffer("(");
        for (PPIRINode pPIRINode : list) {
            aSTTripleAtom = pPIRINode.getPredAtom();
            if (aSTTripleAtom.type == 7) {
                throw new RDFException("SYS_CONTEXT functions not allowed within property path expressions");
            }
            element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
            l = element.getCanonicalID() != null ? element.getCanonicalID() : new Long(0L);
            QueryUtils.appendToList(stringBuffer, l.toString(), ", ", "(");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String buildNHopQuery(PPNode pPNode, String string, int n, int n2, boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n2 == 0) {
            stringBuffer.append(this.buildZeroLengthQuery(pPNode));
        } else {
            stringBuffer.append(this.buildPPSelect("T0", "T" + (n2 - 1), n, false, n2));
            stringBuffer.append("\n");
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = string;
            }
            stringBuffer.append(this.buildPPFrom(stringArray));
            StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
            if (n2 > 1) {
                this.appendPathJoin(stringBuffer2, n2);
            }
            String string2 = "";
            String string3 = "";
            if (bl && pPNode.hasConstrainedStart()) {
                string2 = "START_NODE_ID";
                string3 = "T0";
                if (pPNode.getDirection() == 1) {
                    string2 = this.linkObjCol;
                    string3 = "T" + (n2 - 1);
                }
                this.applyIDConstraint(stringBuffer2, string3, string2, true, pPNode.getStartNode());
            }
            if (bl && pPNode.hasConstrainedEnd()) {
                string2 = this.linkObjCol;
                string3 = "T" + (n2 - 1);
                if (pPNode.getDirection() == 1) {
                    string2 = "START_NODE_ID";
                    string3 = "T0";
                }
                this.applyIDConstraint(stringBuffer2, string3, string2, true, pPNode.getEndNode());
            }
            if (stringBuffer2.length() > 6) {
                stringBuffer.append("\n");
                stringBuffer.append(stringBuffer2);
            }
        }
        return stringBuffer.toString();
    }

    private String buildZeroLengthQuery(PPNode pPNode) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Long l = this.getStartNodeID(pPNode);
        Long l2 = this.getEndNodeID(pPNode);
        if (this.activeGraph == null) {
            if (l != null && l2 != null) {
                stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), this.linkObjCol) + ", " + "NULL AS " + "G_ID" + "\n" + "FROM dual\n" + "WHERE " + l.toString() + "=" + l2.toString());
                if (this.ctx.strictPPNodeSet) {
                    stringBuffer.append("\nAND ((").append(l.toString()).append(" IN (SELECT ").append("START_NODE_ID").append(" FROM ").append(this.linkTab).append(")) OR\n(").append(l.toString()).append(" IN (SELECT ").append(this.linkObjCol).append(" FROM ").append(this.linkTab).append(")))");
                }
                stringBuffer.append(")");
            } else if (l != null) {
                stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), this.linkObjCol) + ", " + "NULL AS " + "G_ID" + "\n" + "FROM dual");
                if (this.ctx.strictPPNodeSet) {
                    stringBuffer.append("\nWHERE (").append(l.toString()).append(" IN (SELECT ").append("START_NODE_ID").append(" FROM ").append(this.linkTab).append(")) OR\n(").append(l.toString()).append(" IN (SELECT ").append(this.linkObjCol).append(" FROM ").append(this.linkTab).append("))");
                }
                stringBuffer.append(")");
            } else if (l2 != null) {
                stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l2.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l2.toString(), this.linkObjCol) + ", " + "NULL AS " + "G_ID" + "\n" + "FROM dual");
                if (this.ctx.strictPPNodeSet) {
                    stringBuffer.append("\nWHERE (").append(l2.toString()).append(" IN (SELECT ").append("START_NODE_ID").append(" FROM ").append(this.linkTab).append(")) OR\n(").append(l2.toString()).append(" IN (SELECT ").append(this.linkObjCol).append(" FROM ").append(this.linkTab).append("))");
                }
                stringBuffer.append(")");
            } else {
                stringBuffer.append("(SELECT VID AS START_NODE_ID, VID AS " + this.linkObjCol + ", " + "NULL AS " + "G_ID" + "\n" + "FROM (" + "SELECT VID\n" + "FROM (" + "(SELECT " + "START_NODE_ID" + " AS VID " + "FROM (" + this.linkTab + ")) " + "UNION ALL " + "(SELECT " + this.linkObjCol + " AS VID " + "FROM (" + this.linkTab + "))" + ")))");
            }
        } else {
            String string = "";
            if (this.activeGraph.type == 1) {
                String string2 = this.ctx.URImap.get(this.activeGraph.name);
                string = " AND G_ID=" + string2;
            }
            if (l != null || l2 != null) {
                if (l != null && l2 != null) {
                    stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), this.linkObjCol) + "\n" + "FROM dual\n" + "WHERE " + l.toString() + "=" + l2.toString() + ")");
                } else if (l != null) {
                    stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), this.linkObjCol) + "\n" + "FROM dual)");
                } else if (l2 != null) {
                    stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l2.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l2.toString(), this.linkObjCol) + "\n" + "FROM dual)");
                }
                stringBuffer.insert(0, "(SELECT " + QueryUtils.buildAliasExpr(this.ctx, "T0.START_NODE_ID", "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0." + this.linkObjCol, this.linkObjCol) + ", " + QueryUtils.buildAliasExpr(this.ctx, "G.G_ID", "G_ID") + "\n" + "FROM (");
                stringBuffer.append(") T0,\n");
                stringBuffer.append(this.linkTab).append(" G\n");
                stringBuffer.append("WHERE (G.START_NODE_ID = T0.START_NODE_ID OR G." + this.linkObjCol + " = " + "T0." + "START_NODE_ID" + ")" + string + ")");
            } else {
                stringBuffer.append("(SELECT VID AS START_NODE_ID, VID AS " + this.linkObjCol + ", " + QueryUtils.buildAliasExpr(this.ctx, "G_ID", "G_ID") + "\n" + "FROM (" + "SELECT VID, " + "G_ID" + "\n" + "FROM (" + "(SELECT " + "START_NODE_ID" + " AS VID, " + QueryUtils.buildAliasExpr(this.ctx, "G_ID", "G_ID") + " " + "FROM (" + this.linkTab + ") " + "WHERE 1=1" + string + ") " + "UNION ALL " + "(SELECT " + this.linkObjCol + " AS VID , " + QueryUtils.buildAliasExpr(this.ctx, "G_ID", "G_ID") + " " + "FROM (" + this.linkTab + ") " + "WHERE 1=1" + string + ") " + ")))");
            }
        }
        return stringBuffer.toString();
    }

    private Long getStartNodeID(PPNode pPNode) {
        TriplesBlock.Element element = null;
        Long l = null;
        if (pPNode.hasConstrainedStart()) {
            element = TriplesBlock.getElementForNode(pPNode.getStartNode(), this.ctx);
            l = element.getCanonicalID();
        }
        return l;
    }

    private Long getEndNodeID(PPNode pPNode) {
        TriplesBlock.Element element = null;
        Long l = null;
        if (pPNode.hasConstrainedEnd()) {
            element = TriplesBlock.getElementForNode(pPNode.getEndNode(), this.ctx);
            l = element.getCanonicalID();
        }
        return l;
    }

    private String buildBasicUnbound(PPModNode pPModNode, String string) {
        String string2 = "";
        if (!this.disableSJ && this.ppMaxDepth > 0) {
            string2 = this.buildPlainJoinUnbound(pPModNode, string);
        } else {
            String string3 = ", G_ID";
            if (this.activeGraph == null) {
                string3 = ", NULL AS G_ID";
            }
            Long l = null;
            Long l2 = null;
            if (pPModNode.getDirection() == 0) {
                l = this.getStartNodeID(pPModNode);
                l2 = this.getEndNodeID(pPModNode);
            } else {
                l = this.getEndNodeID(pPModNode);
                l2 = this.getStartNodeID(pPModNode);
            }
            StringBuffer stringBuffer = new StringBuffer("");
            if (!this.useRW) {
                stringBuffer.append(this.buildConnectBy(pPModNode, string, string3, l, l2));
            } else {
                stringBuffer.append(this.buildRecursiveWith(pPModNode, string, string3, l, l2));
            }
            if (l2 != null) {
                stringBuffer.insert(0, "SELECT * FROM (");
                stringBuffer.append(") WHERE (" + this.linkObjCol + "=" + l2.toString() + ")\n");
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private StringBuffer buildConnectBy(PPModNode pPModNode, String string, String string2, Long l, Long l2) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT " + QueryUtils.buildAliasExpr(this.ctx, "CONNECT_BY_ROOT T0.START_NODE_ID", "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0." + this.linkObjCol, this.linkObjCol) + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0.G_ID", "G_ID") + "\n" + "FROM (SELECT " + "START_NODE_ID" + ", " + this.linkObjCol + string2 + "\n" + "FROM (" + string + ")\n" + ") T0\n");
        if (l != null) {
            stringBuffer.append("START WITH (START_NODE_ID=" + l.toString() + ")\n");
        } else if (pPModNode.hasConstrainedStart()) {
            ASTTripleAtom aSTTripleAtom = pPModNode.getStartNode();
            if (aSTTripleAtom.type == 7) {
                TriplesBlock.Element element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
                stringBuffer.append("START WITH (START_NODE_ID=" + element.getName() + ")\n");
            }
        }
        stringBuffer.append("CONNECT BY NOCYCLE PRIOR " + this.linkObjCol + "=" + "START_NODE_ID");
        if (this.activeGraph != null) {
            stringBuffer.append(" AND PRIOR G_ID=G_ID");
        }
        if (this.ppMaxDepth > 0) {
            stringBuffer.append(" AND LEVEL <= " + this.ppMaxDepth);
        }
        return stringBuffer;
    }

    private StringBuffer buildRecursiveWith(PPModNode pPModNode, String string, String string2, Long l, Long l2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string3 = "R.G_ID";
        String string4 = "";
        if (this.activeGraph == null) {
            string3 = "NULL AS G_ID";
        } else {
            string4 = "\nAND RW.G_ID =  R.G_ID";
        }
        stringBuffer.append("WITH RW (ROOT_ID, ").append("START_NODE_ID").append(", ").append(this.linkObjCol).append(", ").append("G_ID").append(", LVL) AS\n");
        stringBuffer.append("(SELECT ROOT_ID, ").append("START_NODE_ID").append(", ").append(this.linkObjCol).append(string2).append(", LVL FROM\n");
        stringBuffer.append("(SELECT ").append("START_NODE_ID").append(" ROOT_ID, ").append("START_NODE_ID").append(", ").append(this.linkObjCol).append(", ").append("G_ID").append(", 1 LVL\nFROM(").append(string).append(")\n");
        if (l != null) {
            stringBuffer.append("WHERE ").append("START_NODE_ID").append(" = ").append(l);
        } else if (pPModNode.hasConstrainedStart()) {
            ASTTripleAtom aSTTripleAtom = pPModNode.getStartNode();
            if (aSTTripleAtom.type == 7) {
                TriplesBlock.Element element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
                stringBuffer.append("WHERE ").append("START_NODE_ID").append(" = ").append(element.getName());
            }
        }
        stringBuffer.append(")\n");
        stringBuffer.append("UNION ALL\n");
        stringBuffer.append("SELECT ");
        if (this.distinctRW) {
            stringBuffer.append("DISTINCT ");
        }
        stringBuffer.append("RW.ROOT_ID, ").append("R.").append("START_NODE_ID").append(", R.").append(this.linkObjCol).append(", ").append(string3).append(", RW.LVL+1\n");
        stringBuffer.append("FROM (").append(string).append(") R, RW\n");
        stringBuffer.append("WHERE RW.").append(this.linkObjCol).append(" = R.").append("START_NODE_ID");
        stringBuffer.append(string4);
        if (this.ppMaxDepth > 0) {
            stringBuffer.append(" AND RW.LVL <= ").append(this.ppMaxDepth);
        }
        stringBuffer.append(")\n");
        if (this.searchType != null) {
            stringBuffer.append("SEARCH ").append(this.searchType).append(" FIRST BY ").append("START_NODE_ID").append(" SET SEM$ROWNUM\n");
        }
        stringBuffer.append("CYCLE ").append("START_NODE_ID").append(" set y_cycle to 1 default 0\n");
        stringBuffer.append("SELECT ROOT_ID ").append("START_NODE_ID").append(", ").append(this.linkObjCol).append(", ").append("G_ID").append(" FROM RW\n");
        if (this.ppMaxDepth > 0) {
            stringBuffer.append(" WHERE LVL <= ").append(this.ppMaxDepth);
        }
        return stringBuffer;
    }

    private String buildPlainJoinUnbound(PPModNode pPModNode, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        if (this.joinType != null) {
            string2 = "/*+ " + this.joinType + "(T0 T1) */ ";
        }
        String string3 = "";
        if (!this.disableSJdist) {
            string3 = "DISTINCT ";
        }
        String string4 = ",T0.G_ID";
        if (this.activeGraph == null) {
            string4 = ",NULL AS G_ID";
        }
        Long l = null;
        Long l2 = null;
        if (pPModNode.getDirection() == 0) {
            l = this.getStartNodeID(pPModNode);
            l2 = this.getEndNodeID(pPModNode);
        } else {
            l = this.getEndNodeID(pPModNode);
            l2 = this.getStartNodeID(pPModNode);
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append("HOP" + this.wCount + "_1(" + "START_NODE_ID" + "," + this.linkObjCol + "," + "G_ID" + ") AS\n" + "(\n" + "SELECT " + string3 + "T0." + "START_NODE_ID" + "," + "T0." + this.linkObjCol + string4 + "\n" + "FROM (" + string + ") T0\n");
        if (l != null) {
            stringBuffer2.append("WHERE (T0.START_NODE_ID=" + l.toString() + ")\n");
        }
        stringBuffer2.append(")");
        this.wList.add(stringBuffer2.toString());
        for (int i = 2; i <= this.ppMaxDepth; ++i) {
            stringBuffer2 = new StringBuffer("");
            stringBuffer2.append("HOP" + this.wCount + "_" + i + "(" + "START_NODE_ID" + "," + this.linkObjCol + "," + "G_ID" + ") AS\n" + "(\n" + "SELECT " + string2 + string3 + "T0." + "START_NODE_ID" + "," + "T1." + this.linkObjCol + string4 + "\n" + "FROM HOP" + this.wCount + "_" + (i - 1) + " T0," + "(" + string + ") T1\n" + "WHERE T0." + this.linkObjCol + "=" + "T1." + "START_NODE_ID");
            if (this.activeGraph != null) {
                stringBuffer2.append("\nAND T0.G_ID=T1.G_ID");
            }
            stringBuffer2.append(")");
            this.wList.add(stringBuffer2.toString());
        }
        stringBuffer.append("SELECT * FROM(\n");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (int i = 1; i <= this.ppMaxDepth; ++i) {
            QueryUtils.appendToList(stringBuffer3, "(SELECT * FROM HOP" + this.wCount + "_" + i + ")", "\nUNION ALL\n", "");
        }
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(")");
        if (l2 != null) {
            stringBuffer.insert(0, "SELECT * FROM (");
            stringBuffer.append(") WHERE (" + this.linkObjCol + "=" + l2.toString() + ")\n");
        }
        ++this.wCount;
        return stringBuffer.toString();
    }
}

