/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;

public class SpatialFilterHandler
implements FilterFuncHandler {
    public static final String RDF_SPATIAL_IDX_NAME = "RDF_V$GEO_IDX";
    public static final String RDF_SPATIAL_MIDX_NAME = "RDF_V$GEO_MIDX";
    public static final String STRICT_OGC = "STRICT_OGC=T";
    public static final String OGC_RDF_NS = "http://www.opengis.net/def/";
    public static final String OGC_RDF_FUNC_NS = "http://www.opengis.net/def/function/geosparql/";
    public static final String OGC_SF_EQUALS = "http://www.opengis.net/def/function/geosparql/sfEquals";
    public static final String OGC_SF_DISJOINT = "http://www.opengis.net/def/function/geosparql/sfDisjoint";
    public static final String OGC_SF_DISJOINT_R2R = "http://www.opengis.net/def/function/geosparql/sfDisjointR2R";
    public static final String OGC_SF_INTERSECTS = "http://www.opengis.net/def/function/geosparql/sfIntersects";
    public static final String OGC_SF_TOUCHES = "http://www.opengis.net/def/function/geosparql/sfTouches";
    public static final String OGC_SF_CROSSES = "http://www.opengis.net/def/function/geosparql/sfCrosses";
    public static final String OGC_SF_WITHIN = "http://www.opengis.net/def/function/geosparql/sfWithin";
    public static final String OGC_SF_CONTAINS = "http://www.opengis.net/def/function/geosparql/sfContains";
    public static final String OGC_SF_OVERLAPS = "http://www.opengis.net/def/function/geosparql/sfOverlaps";
    public static final String OGC_RELATE = "http://www.opengis.net/def/function/geosparql/relate";
    public static final String OGC_DISTANCE = "http://www.opengis.net/def/function/geosparql/distance";
    public static final String OGC_BUFFER = "http://www.opengis.net/def/function/geosparql/buffer";
    public static final String OGC_CONVEX_HULL = "http://www.opengis.net/def/function/geosparql/convexHull";
    public static final String OGC_INTERSECTION = "http://www.opengis.net/def/function/geosparql/intersection";
    public static final String OGC_UNION = "http://www.opengis.net/def/function/geosparql/union";
    public static final String OGC_DIFFERENCE = "http://www.opengis.net/def/function/geosparql/difference";
    public static final String OGC_SYM_DIFFERENCE = "http://www.opengis.net/def/function/geosparql/symDifference";
    public static final String OGC_ENVELOPE = "http://www.opengis.net/def/function/geosparql/envelope";
    public static final String OGC_BOUNDARY = "http://www.opengis.net/def/function/geosparql/boundary";
    public static final String OGC_GET_SRID = "http://www.opengis.net/def/function/geosparql/getSRID";
    public static final String SDO_WIN_DIST = "http://xmlns.oracle.com/rdf/geo/withinDistance";
    public static final String SDO_IDX_WIN_DIST = "http://xmlns.oracle.com/rdf/geo/idxWithinDistance";
    public static final String SDO_GEOM_WIN_DIST = "http://xmlns.oracle.com/rdf/geo/funcWithinDistance";
    public static final String SDO_RELATE = "http://xmlns.oracle.com/rdf/geo/relate";
    public static final String SDO_IDX_RELATE = "http://xmlns.oracle.com/rdf/geo/idxRelate";
    public static final String SDO_GEOM_RELATE = "http://xmlns.oracle.com/rdf/geo/funcRelate";
    public static final String SDO_NN = "http://xmlns.oracle.com/rdf/geo/nearestNeighbor";
    public static final String SDO_AREA = "http://xmlns.oracle.com/rdf/geo/area";
    public static final String SDO_CENTROID = "http://xmlns.oracle.com/rdf/geo/centroid";
    public static final String SDO_LENGTH = "http://xmlns.oracle.com/rdf/geo/length";
    public static final String SDO_MAX_MBR = "http://xmlns.oracle.com/rdf/geo/maxMbrOrdinate";
    public static final String SDO_MIN_MBR = "http://xmlns.oracle.com/rdf/geo/minMbrOrdinate";
    public static final String SDO_JOIN = "http://xmlns.oracle.com/rdf/geo/sdoJoin";
    public static final String SDO_DIST_JOIN = "http://xmlns.oracle.com/rdf/geo/sdoDistJoin";
    public static final String SDO_GET_SRID = "http://xmlns.oracle.com/rdf/geo/getSRID";
    public static final String SDO_DISTANCE = "http://xmlns.oracle.com/rdf/geo/distance";
    public static final String SDO_BUFFER = "http://xmlns.oracle.com/rdf/geo/buffer";
    public static final String SDO_CONVEX_HULL = "http://xmlns.oracle.com/rdf/geo/convexHull";
    public static final String SDO_INTERSECTION = "http://xmlns.oracle.com/rdf/geo/intersection";
    public static final String SDO_UNION = "http://xmlns.oracle.com/rdf/geo/union";
    public static final String SDO_DIFFERENCE = "http://xmlns.oracle.com/rdf/geo/difference";
    public static final String SDO_XOR = "http://xmlns.oracle.com/rdf/geo/xor";
    public static final String SDO_MBR = "http://xmlns.oracle.com/rdf/geo/mbr";
    public static final String SDO_AGGR_CENTROID = "http://xmlns.oracle.com/rdf/geo/aggrCentroid";
    public static final String SDO_AGGR_CONCAT_LINES = "http://xmlns.oracle.com/rdf/geo/aggrConcatLines";
    public static final String SDO_AGGR_CONVEXHULL = "http://xmlns.oracle.com/rdf/geo/aggrConvexhull";
    public static final String SDO_AGGR_MBR = "http://xmlns.oracle.com/rdf/geo/aggrMBR";
    public static final String SDO_AGGR_UNION = "http://xmlns.oracle.com/rdf/geo/aggrUnion";
    public static final String SDO_SRID_PREFIX = "http://xmlns.oracle.com/rdf/geo/srid/";
    private static final String UNSUP_FUNC_MSG = "Unsupported function: ";
    private static final String INVALID_INVOKE_MSG = "Invalid invocation of function ";
    private static final String VAR_GML_MSG = "expecting variable, GML 3.1 literal or WKT literal";
    private static final String URI_MSG = "expecting URI";
    private static final String NUMERIC_MSG = "expecting numeric value";
    private static final String STRING_MSG = "expecting plain or xsd:string literal";
    private static final String LOCAL_VAR_MSG = " -- only local variables allowed at position ";
    private static final String NUM_ARG_MSG = " -- incorrect number of arguments";
    private static final String SDO_JOIN_LOCAL_MSG = "http://xmlns.oracle.com/rdf/geo/sdoJoin can only be invoked on local variables";
    private static final String SDO_DIST_JOIN_LOCAL_MSG = "http://xmlns.oracle.com/rdf/geo/sdoDistJoin can only be invoked on local variables";
    private static final String SDO_EQUALS = "EQUAL";
    private static final String SDO_DISJOINT = "DISJOINT";
    private static final String SDO_INTERSECTS = "ANYINTERACT";
    private static final String SDO_ANYINTERACT = "ANYINTERACT";
    private static final String SDO_TOUCHES = "TOUCH";
    private static final String SDO_CROSSES = "OVERLAPBDYDISJOINT";
    private static final String SDO_WITHIN = "INSIDE+COVEREDBY+ON";
    private static final String SDO_CONTAINS = "CONTAINS+COVERS";
    private static final String SDO_OVERLAPS = "OVERLAPBDYINTERSECT";
    private static final String SDO_TRUE = "TRUE";
    public static final String GEOM_COL = "GEOM";
    public static final String VDOL_GEOM_FUNC = "MDSYS.SDO_RDF.GETV$GEOMETRYVAL";
    private static final String RELATE_IDX_OP = "SDO_RELATE";
    private static final String RELATE_FUNC_OP = "SDO_GEOM.RELATE";
    private static final String WIN_DIST_OP = "SDO_WITHIN_DISTANCE";
    private static final String WIN_DIST_FUNC_OP = "SDO_GEOM.WITHIN_DISTANCE";
    private static final String DIST_OP = "SDO_GEOM.SDO_DISTANCE";
    private static final String NN_OP = "SDO_NN";
    private static final String BUFFER_OP = "SDO_GEOM.SDO_BUFFER";
    private static final String CONVEX_HULL_OP = "SDO_GEOM.SDO_CONVEXHULL";
    private static final String INTERSECTION_OP = "SDO_GEOM.SDO_INTERSECTION";
    private static final String UNION_OP = "SDO_GEOM.SDO_UNION";
    private static final String DIFF_OP = "SDO_GEOM.SDO_DIFFERENCE";
    private static final String SYM_DIFF_OP = "SDO_GEOM.SDO_XOR";
    private static final String ENVELOPE_OP = "SDO_GEOM.SDO_MBR";
    private static final String AREA_OP = "SDO_GEOM.SDO_AREA";
    private static final String CENTROID_OP = "SDO_GEOM.SDO_CENTROID";
    private static final String LENGTH_OP = "SDO_GEOM.SDO_LENGTH";
    private static final String MAX_MBR_OP = "SDO_GEOM.SDO_MAX_MBR_ORDINATE";
    private static final String MIN_MBR_OP = "SDO_GEOM.SDO_MIN_MBR_ORDINATE";
    private static final String SRID_OP = "SDO_RDF.GETV$GEOSRID";
    private static final String SDO_SRID_OP = "SDO_RDF.GETV$GEOSRID_SDO";
    private static final String BOUNDARY_OP = "SDO_UTIL.GET_BOUNDARY";
    private static final String SDO_JOIN_OP = "SDO_JOIN";
    private static final String AGG_CENTROID_OP = "SDO_AGGR_CENTROID";
    private static final String AGG_CONCAT_LINES_OP = "SDO_AGGR_CONCAT_LINES";
    private static final String AGG_CONVEXHULL_OP = "SDO_AGGR_CONVEXHULL";
    private static final String AGG_MBR_OP = "SDO_AGGR_MBR";
    private static final String AGG_UNION_OP = "SDO_AGGR_UNION";
    private static final int GEOM_ARG = 0;
    private static final int RELATION_ARG = 1;
    private static final int DIM_ARG = 2;
    private static final int TOL_ARG = 3;
    private static final int PARAMS_ARG = 4;
    private static final int VERBATIM_PARAMS_ARG = 5;
    private static final int NUMERIC_ARG = 6;
    private static final int VERBATIM_CONST_ARG = 7;
    private static final int TABLE_ARG = 8;
    private static final int GENERIC_GEOM_ARG = 9;
    private static final int AGG_GEOM_ARG = 10;
    private static final int MATRIX_PARAM = 0;
    private static final int NO_MASK_MATRIX_PARAM = 1;
    private static final int DIST_PARAM = 2;
    private static final int UNIT_PARAM = 3;
    private static final int OGC_UNIT_PARAM = 4;
    private static final int NO_COMP = 0;
    private static final int TRUE_COMP = 1;
    private static final int FALSE_COMP = 10;
    private static final int BOOL_CASE_COMP = 2;
    private static final int RELATION_COMP = 3;
    private static final int VERBATIM_PARAMS_COMP = 4;
    private static final int CONST_COMP = 5;
    private static final int PARAMS_COMP = 6;
    private static Map<String, Integer> idxArgCol = new HashMap<String, Integer>();
    private static Map<String, Integer> totalArgs = new HashMap<String, Integer>();
    private static Map<String, String> sdoFuncMap;
    private static Map<String, int[]> argPositions;
    private static Map<String, int[]> argTypes;
    private static Map<String, int[]> paramStringPos;
    private static Map<String, int[]> paramStringArgs;
    private static Map<String, String[]> constArgs;
    private static Map<String, String> compConsts;
    private static Map<String, String> idxSdoFuncMap;
    private static Map<String, int[]> idxArgPositions;
    private static Map<String, int[]> idxArgTypes;
    private static Map<String, int[]> idxParamStringPos;
    private static Map<String, int[]> idxParamStringArgs;
    private static Map<String, String[]> idxConstArgs;
    private static Map<String, String> idxCompConsts;
    private SQLGenContext ctx;
    private boolean strictOGC;

    public SpatialFilterHandler(SQLGenContext sQLGenContext, boolean bl) {
        this.ctx = sQLGenContext;
        this.strictOGC = bl;
    }

    @Override
    public String genSQL(List<String[]> list, String string, String string2) throws RDFException {
        String string3 = this.getFuncSQL(list, string, string2);
        return string3;
    }

    private String getFuncSQL(List<String[]> list, String string, String string2) throws RDFException {
        String string3;
        String[] stringArray;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        String string4;
        String string5;
        String string6 = "";
        String string7 = null;
        if (string.equals(SDO_JOIN)) {
            string7 = SDO_JOIN_LOCAL_MSG;
        } else if (string.equals(SDO_DIST_JOIN)) {
            string7 = SDO_DIST_JOIN_LOCAL_MSG;
        }
        if (!(string7 == null || (string5 = QueryUtils.extractPlainOption(string2, "SECONDARY_EXTRACTED")) != null && string5.equals(SDO_TRUE))) {
            throw new RDFException(string7);
        }
        int n = 0;
        boolean bl = false;
        Integer n2 = idxArgCol.get(string);
        if (n2 == null) {
            throw new RDFException(UNSUP_FUNC_MSG + string);
        }
        bl = this.canUseIdx(list, n2);
        System.out.println("idxBased BEFORE=" + bl);
        if ((this.ctx.R2RFlags & 8L) > 0L) {
            bl = true;
        }
        System.out.println("idxBased AFTER=" + bl);
        if (bl) {
            string4 = idxSdoFuncMap.get(string);
            nArray4 = idxArgPositions.get(string);
            nArray3 = idxArgTypes.get(string);
            nArray2 = idxParamStringPos.get(string);
            nArray = idxParamStringArgs.get(string);
            stringArray = idxConstArgs.get(string);
            string3 = idxCompConsts.get(string);
        } else {
            string4 = sdoFuncMap.get(string);
            nArray4 = argPositions.get(string);
            nArray3 = argTypes.get(string);
            nArray2 = paramStringPos.get(string);
            nArray = paramStringArgs.get(string);
            stringArray = constArgs.get(string);
            string3 = compConsts.get(string);
            if (string4 == null) {
                throw new RDFException(INVALID_INVOKE_MSG + string + LOCAL_VAR_MSG + n2);
            }
        }
        Integer n3 = totalArgs.get(string);
        if (list.size() != n3.intValue()) {
            throw new RDFException(INVALID_INVOKE_MSG + string + NUM_ARG_MSG);
        }
        if (string4 != null) {
            int n4;
            int n5;
            int n6;
            string6 = string6 + string4 + "(";
            for (n6 = 0; n6 < nArray3.length - 1; ++n6) {
                try {
                    n5 = nArray3[n6];
                    if (n6 > 0) {
                        string6 = string6 + ", ";
                    }
                    switch (n5) {
                        case 0: {
                            string6 = string6 + this.buildGeometryStr(list.get(nArray4[n6]));
                            break;
                        }
                        case 1: {
                            string6 = string6 + this.genSDOGeomRelateCase(list.get(nArray4[n6]));
                            break;
                        }
                        case 2: {
                            Object object;
                            if ((this.ctx.R2RFlags & 8L) > 0L) {
                                object = nArray4[n6] == -1 ? list.get(nArray4[n6 - 1]) : list.get(nArray4[n6]);
                                string6 = string6 + object[9];
                                break;
                            }
                            string6 = string6 + this.ctx.geoDimension;
                            break;
                        }
                        case 3: {
                            string6 = string6 + this.ctx.geoTolerance;
                            break;
                        }
                        case 6: {
                            string6 = string6 + this.genNumericArg(list.get(nArray4[n6]));
                            break;
                        }
                        case 5: {
                            string6 = string6 + this.genVerbatimParams(list.get(nArray4[n6]));
                            break;
                        }
                        case 7: {
                            string6 = string6 + "'" + stringArray[n] + "'";
                            ++n;
                            break;
                        }
                        case 4: {
                            Object object = "";
                            for (n4 = 0; n4 < nArray.length; ++n4) {
                                try {
                                    int n7 = nArray[n4];
                                    if (n4 > 0) {
                                        object = (String)object + " || ' ' || ";
                                    }
                                    switch (n7) {
                                        case 0: {
                                            object = (String)object + this.genSDORelateMatrix(list.get(nArray2[n4]), true);
                                            break;
                                        }
                                        case 1: {
                                            object = (String)object + this.genSDORelateMatrix(list.get(nArray2[n4]), false);
                                            break;
                                        }
                                        case 2: {
                                            object = (String)object + this.genDistParam(list.get(nArray2[n4]));
                                            break;
                                        }
                                        case 3: {
                                            object = (String)object + this.genUnitParam(list.get(nArray2[n4]));
                                            break;
                                        }
                                        case 4: {
                                            object = (String)object + this.genOGCUnitParam(list.get(nArray2[n4]));
                                        }
                                    }
                                    continue;
                                }
                                catch (SpatialArgException spatialArgException) {
                                    throw new RDFException(UNSUP_FUNC_MSG + string + " -- " + spatialArgException.getMessage() + " at position " + nArray2[n4]);
                                }
                            }
                            string6 = string6 + (String)object;
                            break;
                        }
                        case 8: {
                            string6 = string6 + "'MDSYS.RDF_VALUE$'";
                            break;
                        }
                        case 9: {
                            string6 = string6 + "'" + this.buildGenericGeomStr(list.get(nArray4[n6])) + "'";
                            break;
                        }
                        case 10: {
                            string6 = string6 + this.buildAggregateStr(list.get(nArray4[n6]));
                        }
                    }
                    continue;
                }
                catch (SpatialArgException spatialArgException) {
                    throw new RDFException(INVALID_INVOKE_MSG + string + " -- " + spatialArgException.getMessage() + " at position " + nArray4[n6]);
                }
            }
            string6 = string6 + ")";
            n6 = nArray3.length - 1;
            n5 = nArray3[n6];
            try {
                switch (n5) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string6 = string6 + " = 'TRUE'";
                        break;
                    }
                    case 10: {
                        string6 = string6 + " != 'TRUE'";
                        break;
                    }
                    case 2: {
                        string6 = string6 + " = " + this.genSDORelateValCase(list.get(nArray4[n6]));
                        break;
                    }
                    case 3: {
                        string6 = string6 + " = " + this.genSDOGeomRelateCompCase(list.get(nArray4[n6]));
                        break;
                    }
                    case 4: {
                        string6 = string6 + " = " + this.genSDOGeomRelateVerbatimComp(list.get(nArray4[n6]));
                        break;
                    }
                    case 5: {
                        string6 = string6 + " = '" + string3 + "'";
                        break;
                    }
                    case 6: {
                        string6 = string6 + " = ";
                        for (int i = 0; i < nArray.length; ++i) {
                            try {
                                n4 = nArray[i];
                                if (i > 0) {
                                    string6 = string6 + " || ' ' || ";
                                }
                                switch (n4) {
                                    case 0: {
                                        string6 = string6 + this.genSDORelateMatrix(list.get(nArray2[i]), true);
                                        break;
                                    }
                                    case 1: {
                                        string6 = string6 + this.genSDORelateMatrix(list.get(nArray2[i]), false);
                                        break;
                                    }
                                    case 2: {
                                        string6 = string6 + this.genDistParam(list.get(nArray2[i]));
                                        break;
                                    }
                                    case 3: {
                                        string6 = string6 + this.genUnitParam(list.get(nArray2[i]));
                                        break;
                                    }
                                    case 4: {
                                        string6 = string6 + this.genOGCUnitParam(list.get(nArray2[i]));
                                    }
                                }
                                continue;
                            }
                            catch (SpatialArgException spatialArgException) {
                                throw new RDFException(UNSUP_FUNC_MSG + string + " -- " + spatialArgException.getMessage() + " at position " + nArray2[i]);
                            }
                        }
                        break;
                    }
                }
            }
            catch (SpatialArgException spatialArgException) {
                throw new RDFException(INVALID_INVOKE_MSG + string + " -- " + spatialArgException.getMessage() + " at position " + nArray4[n6]);
            }
            if (string.equals(SDO_JOIN) || string.equals(SDO_DIST_JOIN)) {
                try {
                    string6 = this.buildRowIdPair(list.get(0), list.get(1)) + " IN " + "(SELECT ROWID1, ROWID2" + " FROM(TABLE(" + string6 + ")))";
                }
                catch (SpatialArgException spatialArgException) {
                    throw new RDFException(INVALID_INVOKE_MSG + string + " " + spatialArgException.getMessage());
                }
            }
        }
        return string6;
    }

    private boolean canUseIdx(List<String[]> list, Integer n) {
        boolean bl = false;
        if (Integer.valueOf(list.get(n)[7]) == 4 && list.get(n)[8].equals("LOCAL_VAR") && !this.strictOGC) {
            bl = true;
        }
        return bl;
    }

    private String buildGeometryStr(String[] stringArray) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) == 4 || Integer.valueOf(stringArray[7]) == 22 || Integer.valueOf(stringArray[7]) == 21 || Integer.valueOf(stringArray[7]) == 24 || Integer.valueOf(stringArray[7]) == 23 || Integer.valueOf(stringArray[7]) == 27) {
            string = (this.ctx.matSpaIdx || (this.ctx.R2RFlags & 8L) > 0L) && Integer.valueOf(stringArray[7]) == 4 && stringArray[8].equals("LOCAL_VAR") ? ((this.ctx.R2RFlags & 8L) > 0L ? stringArray[2] : stringArray[2].replace(".VNAME_PREFIX", ".GEOM")) : "MDSYS.SDO_RDF.GETV$GEOMETRYVAL(" + stringArray[1] + "," + stringArray[2] + "," + stringArray[3] + "," + stringArray[4] + "," + stringArray[5] + "," + stringArray[6] + "," + this.ctx.srid + ")";
        } else if (Integer.valueOf(stringArray[7]) == 25) {
            string = stringArray[8];
        } else {
            throw new SpatialArgException(VAR_GML_MSG);
        }
        return string;
    }

    private String buildGenericGeomStr(String[] stringArray) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) != 4) {
            throw new SpatialArgException(LOCAL_VAR_MSG);
        }
        string = this.buildGeomColExpr();
        return string;
    }

    private String buildGeomColExpr() {
        if (!this.ctx.matSpaIdx) {
            return "MDSYS.SDO_RDF.GETV$GEOMETRYVAL(VALUE_TYPE,VNAME_PREFIX,VNAME_SUFFIX,LITERAL_TYPE,LANGUAGE_TYPE,LONG_VALUE," + this.ctx.srid + ")";
        }
        return GEOM_COL;
    }

    private String buildRowIdPair(String[] stringArray, String[] stringArray2) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) != 4 || !stringArray[8].equals("LOCAL_VAR")) {
            throw new SpatialArgException(" -- only local variables allowed at position 0");
        }
        if (Integer.valueOf(stringArray2[7]) != 4 || !stringArray2[8].equals("LOCAL_VAR")) {
            throw new SpatialArgException(" -- only local variables allowed at position 1");
        }
        string = "(" + stringArray[2].replace(".VNAME_PREFIX", ".ROWID") + "," + stringArray2[2].replace(".VNAME_PREFIX", ".ROWID") + ")";
        return string;
    }

    private String buildAggregateStr(String[] stringArray) throws SpatialArgException {
        return "SDOAGGRTYPE(" + this.buildGeometryStr(stringArray) + "," + this.ctx.geoTolerance + ")";
    }

    private String genSDORelateValCase(String[] stringArray) throws SpatialArgException {
        String string = "";
        return string;
    }

    private String genSDORelateMatrix(String[] stringArray, boolean bl) throws SpatialArgException {
        String string;
        String string2 = "";
        if (Integer.valueOf(stringArray[7]) == 8 || Integer.valueOf(stringArray[7]) == 20 || Integer.valueOf(stringArray[7]) == 11 || Integer.valueOf(stringArray[7]) == 4) {
            string = "";
            if (bl) {
                string = "'mask=' || ";
            }
        } else {
            throw new SpatialArgException(STRING_MSG);
        }
        string2 = string + "REPLACE(REPLACE(NLS_UPPER(" + stringArray[0] + "),'T','1'),'F','0')";
        return string2;
    }

    private String genSDOGeomRelateCase(String[] stringArray) throws SpatialArgException {
        String string = "";
        return string;
    }

    private String genSDOGeomRelateCompCase(String[] stringArray) throws SpatialArgException {
        String string = "";
        return string;
    }

    private String genSDOGeomRelateVerbatimComp(String[] stringArray) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) != 8 && Integer.valueOf(stringArray[7]) != 11 && Integer.valueOf(stringArray[7]) != 20) {
            throw new SpatialArgException(STRING_MSG);
        }
        string = "CASE (NLS_UPPER(" + stringArray[0] + "))\n" + "WHEN '" + "ANYINTERACT" + "' THEN '" + SDO_TRUE + "'\n" + "ELSE NLS_UPPER(" + stringArray[0] + ")\n" + "END";
        return string;
    }

    private String genDistParam(String[] stringArray) throws SpatialArgException {
        String string = "";
        int n = Integer.parseInt(stringArray[7]);
        if (n != 3 && n != 29 && n != 12 && n != 4) {
            throw new SpatialArgException(NUMERIC_MSG);
        }
        string = "'distance='||" + stringArray[2];
        return string;
    }

    private String genNumericArg(String[] stringArray) throws SpatialArgException {
        String string = "";
        int n = Integer.parseInt(stringArray[7]);
        if (n == 3 || n == 29 || n == 12) {
            string = "to_number(" + stringArray[2] + ")";
        } else if (n == 4) {
            string = "SEM_APIS.getV$NumericVal(" + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ", " + stringArray[4] + ", " + stringArray[5] + ")";
        } else {
            throw new SpatialArgException(NUMERIC_MSG);
        }
        return string;
    }

    private String genUnitParam(String[] stringArray) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) != 8 && Integer.valueOf(stringArray[7]) != 20 && Integer.valueOf(stringArray[7]) != 11 && Integer.valueOf(stringArray[7]) != 4) {
            throw new SpatialArgException(STRING_MSG);
        }
        string = "'unit='||" + stringArray[2];
        return string;
    }

    private String genOGCUnitParam(String[] stringArray) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) != 5 && Integer.valueOf(stringArray[7]) != 6 && Integer.valueOf(stringArray[7]) != 4) {
            throw new SpatialArgException(STRING_MSG);
        }
        string = "'unit='||NLS_UPPER(REPLACE(" + stringArray[0] + ",'" + "http://xmlns.oracle.com/rdf/geo/uom/" + "'))";
        return string;
    }

    private String genVerbatimParams(String[] stringArray) throws SpatialArgException {
        String string = "";
        if (Integer.valueOf(stringArray[7]) != 8 && Integer.valueOf(stringArray[7]) != 20 && Integer.valueOf(stringArray[7]) != 11 && Integer.valueOf(stringArray[7]) != 4) {
            throw new SpatialArgException(STRING_MSG);
        }
        string = stringArray[2];
        return string;
    }

    static {
        idxSdoFuncMap = new HashMap<String, String>();
        idxArgPositions = new HashMap<String, int[]>();
        idxArgTypes = new HashMap<String, int[]>();
        idxParamStringPos = new HashMap<String, int[]>();
        idxParamStringArgs = new HashMap<String, int[]>();
        idxConstArgs = new HashMap<String, String[]>();
        idxCompConsts = new HashMap<String, String>();
        sdoFuncMap = new HashMap<String, String>();
        argPositions = new HashMap<String, int[]>();
        argTypes = new HashMap<String, int[]>();
        paramStringPos = new HashMap<String, int[]>();
        paramStringArgs = new HashMap<String, int[]>();
        constArgs = new HashMap<String, String[]>();
        compConsts = new HashMap<String, String>();
        idxArgCol.put(OGC_RELATE, 0);
        totalArgs.put(OGC_RELATE, 3);
        idxSdoFuncMap.put(OGC_RELATE, RELATE_IDX_OP);
        idxArgPositions.put(OGC_RELATE, new int[]{0, 1, -1, 2});
        idxArgTypes.put(OGC_RELATE, new int[]{0, 0, 4, 1});
        idxParamStringPos.put(OGC_RELATE, new int[]{2});
        idxParamStringArgs.put(OGC_RELATE, new int[]{0});
        sdoFuncMap.put(OGC_RELATE, RELATE_FUNC_OP);
        argPositions.put(OGC_RELATE, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_RELATE, new int[]{0, 2, 4, 0, 2, 6});
        paramStringPos.put(OGC_RELATE, new int[]{2});
        paramStringArgs.put(OGC_RELATE, new int[]{1});
        idxArgCol.put(OGC_BOUNDARY, 0);
        totalArgs.put(OGC_BOUNDARY, 1);
        idxSdoFuncMap.put(OGC_BOUNDARY, BOUNDARY_OP);
        idxArgPositions.put(OGC_BOUNDARY, new int[]{0, -1});
        idxArgTypes.put(OGC_BOUNDARY, new int[]{0, 0});
        sdoFuncMap.put(OGC_BOUNDARY, BOUNDARY_OP);
        argPositions.put(OGC_BOUNDARY, new int[]{0, -1});
        argTypes.put(OGC_BOUNDARY, new int[]{0, 0});
        idxArgCol.put(OGC_DISTANCE, 0);
        totalArgs.put(OGC_DISTANCE, 3);
        idxSdoFuncMap.put(OGC_DISTANCE, DIST_OP);
        idxArgPositions.put(OGC_DISTANCE, new int[]{0, -1, 1, -1, -1, -1});
        idxArgTypes.put(OGC_DISTANCE, new int[]{0, 2, 0, 2, 4, 0});
        idxParamStringPos.put(OGC_DISTANCE, new int[]{2});
        idxParamStringArgs.put(OGC_DISTANCE, new int[]{4});
        sdoFuncMap.put(OGC_DISTANCE, DIST_OP);
        argPositions.put(OGC_DISTANCE, new int[]{0, -1, 1, -1, -1, -1});
        argTypes.put(OGC_DISTANCE, new int[]{0, 2, 0, 2, 4, 0});
        paramStringPos.put(OGC_DISTANCE, new int[]{2});
        paramStringArgs.put(OGC_DISTANCE, new int[]{4});
        idxArgCol.put(OGC_BUFFER, 0);
        totalArgs.put(OGC_BUFFER, 3);
        idxSdoFuncMap.put(OGC_BUFFER, BUFFER_OP);
        idxArgPositions.put(OGC_BUFFER, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(OGC_BUFFER, new int[]{0, 2, 6, 4, 0});
        idxParamStringPos.put(OGC_BUFFER, new int[]{2});
        idxParamStringArgs.put(OGC_BUFFER, new int[]{4});
        sdoFuncMap.put(OGC_BUFFER, BUFFER_OP);
        argPositions.put(OGC_BUFFER, new int[]{0, -1, 1, -1, -1});
        argTypes.put(OGC_BUFFER, new int[]{0, 2, 6, 4, 0});
        paramStringPos.put(OGC_BUFFER, new int[]{2});
        paramStringArgs.put(OGC_BUFFER, new int[]{4});
        idxArgCol.put(OGC_ENVELOPE, 0);
        totalArgs.put(OGC_ENVELOPE, 1);
        idxSdoFuncMap.put(OGC_ENVELOPE, ENVELOPE_OP);
        idxArgPositions.put(OGC_ENVELOPE, new int[]{0, -1});
        idxArgTypes.put(OGC_ENVELOPE, new int[]{0, 2, 0});
        sdoFuncMap.put(OGC_ENVELOPE, ENVELOPE_OP);
        argPositions.put(OGC_ENVELOPE, new int[]{0, -1});
        argTypes.put(OGC_ENVELOPE, new int[]{0, 2, 0});
        idxArgCol.put(OGC_CONVEX_HULL, 0);
        totalArgs.put(OGC_CONVEX_HULL, 1);
        idxSdoFuncMap.put(OGC_CONVEX_HULL, CONVEX_HULL_OP);
        idxArgPositions.put(OGC_CONVEX_HULL, new int[]{0, -1, -1});
        idxArgTypes.put(OGC_CONVEX_HULL, new int[]{0, 2, 0});
        sdoFuncMap.put(OGC_CONVEX_HULL, CONVEX_HULL_OP);
        argPositions.put(OGC_CONVEX_HULL, new int[]{0, -1, -1});
        argTypes.put(OGC_CONVEX_HULL, new int[]{0, 2, 0});
        idxArgCol.put(OGC_DIFFERENCE, 0);
        totalArgs.put(OGC_DIFFERENCE, 2);
        idxSdoFuncMap.put(OGC_DIFFERENCE, DIFF_OP);
        idxArgPositions.put(OGC_DIFFERENCE, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(OGC_DIFFERENCE, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(OGC_DIFFERENCE, DIFF_OP);
        argPositions.put(OGC_DIFFERENCE, new int[]{0, -1, 1, -1, -1});
        argTypes.put(OGC_DIFFERENCE, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(OGC_SYM_DIFFERENCE, 0);
        totalArgs.put(OGC_SYM_DIFFERENCE, 2);
        idxSdoFuncMap.put(OGC_SYM_DIFFERENCE, SYM_DIFF_OP);
        idxArgPositions.put(OGC_SYM_DIFFERENCE, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(OGC_SYM_DIFFERENCE, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(OGC_SYM_DIFFERENCE, SYM_DIFF_OP);
        argPositions.put(OGC_SYM_DIFFERENCE, new int[]{0, -1, 1, -1, -1});
        argTypes.put(OGC_SYM_DIFFERENCE, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(OGC_UNION, 0);
        totalArgs.put(OGC_UNION, 2);
        idxSdoFuncMap.put(OGC_UNION, UNION_OP);
        idxArgPositions.put(OGC_UNION, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(OGC_UNION, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(OGC_UNION, UNION_OP);
        argPositions.put(OGC_UNION, new int[]{0, -1, 1, -1, -1});
        argTypes.put(OGC_UNION, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(OGC_INTERSECTION, 0);
        totalArgs.put(OGC_INTERSECTION, 2);
        idxSdoFuncMap.put(OGC_INTERSECTION, INTERSECTION_OP);
        idxArgPositions.put(OGC_INTERSECTION, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(OGC_INTERSECTION, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(OGC_INTERSECTION, INTERSECTION_OP);
        argPositions.put(OGC_INTERSECTION, new int[]{0, -1, 1, -1, -1});
        argTypes.put(OGC_INTERSECTION, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(OGC_GET_SRID, 0);
        totalArgs.put(OGC_GET_SRID, 1);
        idxSdoFuncMap.put(OGC_GET_SRID, SRID_OP);
        idxArgPositions.put(OGC_GET_SRID, new int[]{0, -1});
        idxArgTypes.put(OGC_GET_SRID, new int[]{0, 0});
        sdoFuncMap.put(OGC_GET_SRID, SRID_OP);
        argPositions.put(OGC_GET_SRID, new int[]{0, -1});
        argTypes.put(OGC_GET_SRID, new int[]{0, 0});
        idxArgCol.put(OGC_SF_EQUALS, 0);
        totalArgs.put(OGC_SF_EQUALS, 2);
        idxSdoFuncMap.put(OGC_SF_EQUALS, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_EQUALS, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_EQUALS, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_EQUALS, new String[]{"mask=EQUAL"});
        sdoFuncMap.put(OGC_SF_EQUALS, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_EQUALS, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_EQUALS, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_EQUALS, new String[]{SDO_EQUALS});
        compConsts.put(OGC_SF_EQUALS, SDO_EQUALS);
        idxArgCol.put(OGC_SF_DISJOINT, 0);
        totalArgs.put(OGC_SF_DISJOINT, 2);
        idxSdoFuncMap.put(OGC_SF_DISJOINT, RELATE_FUNC_OP);
        idxArgPositions.put(OGC_SF_DISJOINT, new int[]{0, -1, -1, 1, -1, -1});
        idxArgTypes.put(OGC_SF_DISJOINT, new int[]{0, 2, 7, 0, 2, 5});
        idxConstArgs.put(OGC_SF_DISJOINT, new String[]{SDO_DISJOINT});
        idxCompConsts.put(OGC_SF_DISJOINT, SDO_DISJOINT);
        sdoFuncMap.put(OGC_SF_DISJOINT, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_DISJOINT, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_DISJOINT, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_DISJOINT, new String[]{SDO_DISJOINT});
        compConsts.put(OGC_SF_DISJOINT, SDO_DISJOINT);
        idxArgCol.put(OGC_SF_DISJOINT_R2R, 0);
        totalArgs.put(OGC_SF_DISJOINT_R2R, 2);
        idxSdoFuncMap.put(OGC_SF_DISJOINT_R2R, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_DISJOINT_R2R, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_DISJOINT_R2R, new int[]{0, 0, 7, 10});
        idxConstArgs.put(OGC_SF_DISJOINT_R2R, new String[]{"mask=ANYINTERACT"});
        sdoFuncMap.put(OGC_SF_DISJOINT_R2R, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_DISJOINT_R2R, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_DISJOINT_R2R, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_DISJOINT_R2R, new String[]{SDO_DISJOINT});
        compConsts.put(OGC_SF_DISJOINT_R2R, SDO_DISJOINT);
        idxArgCol.put(OGC_SF_INTERSECTS, 0);
        totalArgs.put(OGC_SF_INTERSECTS, 2);
        idxSdoFuncMap.put(OGC_SF_INTERSECTS, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_INTERSECTS, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_INTERSECTS, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_INTERSECTS, new String[]{"mask=ANYINTERACT"});
        sdoFuncMap.put(OGC_SF_INTERSECTS, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_INTERSECTS, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_INTERSECTS, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_INTERSECTS, new String[]{"ANYINTERACT"});
        compConsts.put(OGC_SF_INTERSECTS, SDO_TRUE);
        idxArgCol.put(OGC_SF_TOUCHES, 0);
        totalArgs.put(OGC_SF_TOUCHES, 2);
        idxSdoFuncMap.put(OGC_SF_TOUCHES, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_TOUCHES, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_TOUCHES, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_TOUCHES, new String[]{"mask=TOUCH"});
        sdoFuncMap.put(OGC_SF_TOUCHES, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_TOUCHES, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_TOUCHES, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_TOUCHES, new String[]{SDO_TOUCHES});
        compConsts.put(OGC_SF_TOUCHES, SDO_TOUCHES);
        idxArgCol.put(OGC_SF_CROSSES, 0);
        totalArgs.put(OGC_SF_CROSSES, 2);
        idxSdoFuncMap.put(OGC_SF_CROSSES, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_CROSSES, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_CROSSES, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_CROSSES, new String[]{"mask=OVERLAPBDYDISJOINT"});
        sdoFuncMap.put(OGC_SF_CROSSES, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_CROSSES, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_CROSSES, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_CROSSES, new String[]{SDO_CROSSES});
        compConsts.put(OGC_SF_CROSSES, SDO_CROSSES);
        idxArgCol.put(OGC_SF_WITHIN, 0);
        totalArgs.put(OGC_SF_WITHIN, 2);
        idxSdoFuncMap.put(OGC_SF_WITHIN, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_WITHIN, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_WITHIN, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_WITHIN, new String[]{"mask=INSIDE+COVEREDBY+ON"});
        sdoFuncMap.put(OGC_SF_WITHIN, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_WITHIN, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_WITHIN, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_WITHIN, new String[]{SDO_WITHIN});
        compConsts.put(OGC_SF_WITHIN, SDO_WITHIN);
        idxArgCol.put(OGC_SF_CONTAINS, 0);
        totalArgs.put(OGC_SF_CONTAINS, 2);
        idxSdoFuncMap.put(OGC_SF_CONTAINS, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_CONTAINS, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_CONTAINS, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_CONTAINS, new String[]{"mask=CONTAINS+COVERS"});
        sdoFuncMap.put(OGC_SF_CONTAINS, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_CONTAINS, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_CONTAINS, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_CONTAINS, new String[]{SDO_CONTAINS});
        compConsts.put(OGC_SF_CONTAINS, SDO_CONTAINS);
        idxArgCol.put(OGC_SF_OVERLAPS, 0);
        totalArgs.put(OGC_SF_OVERLAPS, 2);
        idxSdoFuncMap.put(OGC_SF_OVERLAPS, RELATE_IDX_OP);
        idxArgPositions.put(OGC_SF_OVERLAPS, new int[]{0, 1, -1, -1});
        idxArgTypes.put(OGC_SF_OVERLAPS, new int[]{0, 0, 7, 1});
        idxConstArgs.put(OGC_SF_OVERLAPS, new String[]{"mask=OVERLAPBDYINTERSECT"});
        sdoFuncMap.put(OGC_SF_OVERLAPS, RELATE_FUNC_OP);
        argPositions.put(OGC_SF_OVERLAPS, new int[]{0, -1, -1, 1, -1, -1});
        argTypes.put(OGC_SF_OVERLAPS, new int[]{0, 2, 7, 0, 2, 5});
        constArgs.put(OGC_SF_OVERLAPS, new String[]{SDO_OVERLAPS});
        compConsts.put(OGC_SF_OVERLAPS, SDO_OVERLAPS);
        idxArgCol.put(SDO_JOIN, 0);
        totalArgs.put(SDO_JOIN, 3);
        idxSdoFuncMap.put(SDO_JOIN, SDO_JOIN_OP);
        idxArgPositions.put(SDO_JOIN, new int[]{0, 0, 1, 1});
        idxArgTypes.put(SDO_JOIN, new int[]{8, 9, 8, 9, 0});
        idxArgCol.put(SDO_DIST_JOIN, 0);
        totalArgs.put(SDO_DIST_JOIN, 3);
        idxSdoFuncMap.put(SDO_DIST_JOIN, SDO_JOIN_OP);
        idxArgPositions.put(SDO_DIST_JOIN, new int[]{0, 0, 1, 1, 2});
        idxArgTypes.put(SDO_DIST_JOIN, new int[]{8, 9, 8, 9, 5, 0});
        idxArgCol.put(SDO_WIN_DIST, 0);
        totalArgs.put(SDO_WIN_DIST, 4);
        idxSdoFuncMap.put(SDO_WIN_DIST, WIN_DIST_OP);
        idxArgPositions.put(SDO_WIN_DIST, new int[]{0, 1, -1});
        idxArgTypes.put(SDO_WIN_DIST, new int[]{0, 0, 4, 1});
        idxParamStringPos.put(SDO_WIN_DIST, new int[]{2, 3});
        idxParamStringArgs.put(SDO_WIN_DIST, new int[]{2, 3});
        sdoFuncMap.put(SDO_WIN_DIST, WIN_DIST_FUNC_OP);
        argPositions.put(SDO_WIN_DIST, new int[]{0, -1, 2, 1, -1, -1});
        argTypes.put(SDO_WIN_DIST, new int[]{0, 2, 6, 0, 2, 4, 1});
        paramStringPos.put(SDO_WIN_DIST, new int[]{3});
        paramStringArgs.put(SDO_WIN_DIST, new int[]{3});
        idxArgCol.put(SDO_IDX_WIN_DIST, 0);
        totalArgs.put(SDO_IDX_WIN_DIST, 3);
        idxSdoFuncMap.put(SDO_IDX_WIN_DIST, WIN_DIST_OP);
        idxArgPositions.put(SDO_IDX_WIN_DIST, new int[]{0, 1, 2, -1});
        idxArgTypes.put(SDO_IDX_WIN_DIST, new int[]{0, 0, 5, 1});
        idxArgCol.put(SDO_GEOM_WIN_DIST, 0);
        totalArgs.put(SDO_GEOM_WIN_DIST, 4);
        idxSdoFuncMap.put(SDO_GEOM_WIN_DIST, WIN_DIST_FUNC_OP);
        idxArgPositions.put(SDO_GEOM_WIN_DIST, new int[]{0, -1, 2, 1, -1, 3});
        idxArgTypes.put(SDO_GEOM_WIN_DIST, new int[]{0, 2, 6, 0, 2, 5, 1});
        sdoFuncMap.put(SDO_GEOM_WIN_DIST, WIN_DIST_FUNC_OP);
        argPositions.put(SDO_GEOM_WIN_DIST, new int[]{0, -1, 2, 1, -1, 3});
        argTypes.put(SDO_GEOM_WIN_DIST, new int[]{0, 2, 6, 0, 2, 5, 1});
        idxArgCol.put(SDO_RELATE, 0);
        totalArgs.put(SDO_RELATE, 3);
        idxSdoFuncMap.put(SDO_RELATE, RELATE_IDX_OP);
        idxArgPositions.put(SDO_RELATE, new int[]{0, 1, 2, -1});
        idxArgTypes.put(SDO_RELATE, new int[]{0, 0, 5, 1});
        sdoFuncMap.put(SDO_RELATE, RELATE_FUNC_OP);
        argPositions.put(SDO_RELATE, new int[]{0, -1, 2, 1, -1, 2});
        argTypes.put(SDO_RELATE, new int[]{0, 2, 5, 0, 2, 4});
        idxArgCol.put(SDO_IDX_RELATE, 0);
        totalArgs.put(SDO_IDX_RELATE, 3);
        idxSdoFuncMap.put(SDO_IDX_RELATE, RELATE_IDX_OP);
        idxArgPositions.put(SDO_IDX_RELATE, new int[]{0, 1, 2, -1});
        idxArgTypes.put(SDO_IDX_RELATE, new int[]{0, 0, 5, 1});
        idxArgCol.put(SDO_GEOM_RELATE, 0);
        totalArgs.put(SDO_GEOM_RELATE, 3);
        idxSdoFuncMap.put(SDO_GEOM_RELATE, RELATE_FUNC_OP);
        idxArgPositions.put(SDO_GEOM_RELATE, new int[]{0, -1, 2, 1, -1});
        idxArgTypes.put(SDO_GEOM_RELATE, new int[]{0, 2, 5, 0, 2, 0});
        sdoFuncMap.put(SDO_GEOM_RELATE, RELATE_FUNC_OP);
        argPositions.put(SDO_GEOM_RELATE, new int[]{0, -1, 2, 1, -1});
        argTypes.put(SDO_GEOM_RELATE, new int[]{0, 2, 5, 0, 2, 0});
        idxArgCol.put(SDO_NN, 0);
        totalArgs.put(SDO_NN, 3);
        idxSdoFuncMap.put(SDO_NN, NN_OP);
        idxArgPositions.put(SDO_NN, new int[]{0, 1, 2, -1});
        idxArgTypes.put(SDO_NN, new int[]{0, 0, 5, 1});
        idxArgCol.put(SDO_AREA, 0);
        totalArgs.put(SDO_AREA, 2);
        idxSdoFuncMap.put(SDO_AREA, AREA_OP);
        idxArgPositions.put(SDO_AREA, new int[]{0, -1, 1, -1});
        idxArgTypes.put(SDO_AREA, new int[]{0, 2, 5, 0});
        sdoFuncMap.put(SDO_AREA, AREA_OP);
        argPositions.put(SDO_AREA, new int[]{0, -1, 1, -1});
        argTypes.put(SDO_AREA, new int[]{0, 2, 5, 0});
        idxArgCol.put(SDO_CENTROID, 0);
        totalArgs.put(SDO_CENTROID, 1);
        idxSdoFuncMap.put(SDO_CENTROID, CENTROID_OP);
        idxArgPositions.put(SDO_CENTROID, new int[]{0, -1, -1});
        idxArgTypes.put(SDO_CENTROID, new int[]{0, 2, 0});
        sdoFuncMap.put(SDO_CENTROID, CENTROID_OP);
        argPositions.put(SDO_CENTROID, new int[]{0, -1, -1});
        argTypes.put(SDO_CENTROID, new int[]{0, 2, 0});
        idxArgCol.put(SDO_LENGTH, 0);
        totalArgs.put(SDO_LENGTH, 2);
        idxSdoFuncMap.put(SDO_LENGTH, LENGTH_OP);
        idxArgPositions.put(SDO_LENGTH, new int[]{0, -1, 1, -1});
        idxArgTypes.put(SDO_LENGTH, new int[]{0, 2, 5, 0});
        sdoFuncMap.put(SDO_LENGTH, LENGTH_OP);
        argPositions.put(SDO_LENGTH, new int[]{0, -1, 1, -1});
        argTypes.put(SDO_LENGTH, new int[]{0, 2, 5, 0});
        idxArgCol.put(SDO_MAX_MBR, 0);
        totalArgs.put(SDO_MAX_MBR, 2);
        idxSdoFuncMap.put(SDO_MAX_MBR, MAX_MBR_OP);
        idxArgPositions.put(SDO_MAX_MBR, new int[]{0, -1, 1, -1});
        idxArgTypes.put(SDO_MAX_MBR, new int[]{0, 2, 6, 0});
        sdoFuncMap.put(SDO_MAX_MBR, MAX_MBR_OP);
        argPositions.put(SDO_MAX_MBR, new int[]{0, -1, 1, -1});
        argTypes.put(SDO_MAX_MBR, new int[]{0, 2, 6, 0});
        idxArgCol.put(SDO_MIN_MBR, 0);
        totalArgs.put(SDO_MIN_MBR, 2);
        idxSdoFuncMap.put(SDO_MIN_MBR, MIN_MBR_OP);
        idxArgPositions.put(SDO_MIN_MBR, new int[]{0, -1, 1, -1});
        idxArgTypes.put(SDO_MIN_MBR, new int[]{0, 2, 6, 0});
        sdoFuncMap.put(SDO_MIN_MBR, MIN_MBR_OP);
        argPositions.put(SDO_MIN_MBR, new int[]{0, -1, 1, -1});
        argTypes.put(SDO_MIN_MBR, new int[]{0, 2, 6, 0});
        idxArgCol.put(SDO_GET_SRID, 0);
        totalArgs.put(SDO_GET_SRID, 1);
        idxSdoFuncMap.put(SDO_GET_SRID, SDO_SRID_OP);
        idxArgPositions.put(SDO_GET_SRID, new int[]{0, -1});
        idxArgTypes.put(SDO_GET_SRID, new int[]{0, 0});
        sdoFuncMap.put(SDO_GET_SRID, SDO_SRID_OP);
        argPositions.put(SDO_GET_SRID, new int[]{0, -1});
        argTypes.put(SDO_GET_SRID, new int[]{0, 0});
        idxArgCol.put(SDO_DISTANCE, 0);
        totalArgs.put(SDO_DISTANCE, 3);
        idxSdoFuncMap.put(SDO_DISTANCE, DIST_OP);
        idxArgPositions.put(SDO_DISTANCE, new int[]{0, -1, 1, -1, 2, -1});
        idxArgTypes.put(SDO_DISTANCE, new int[]{0, 2, 0, 2, 5, 0});
        sdoFuncMap.put(SDO_DISTANCE, DIST_OP);
        argPositions.put(SDO_DISTANCE, new int[]{0, -1, 1, -1, 2, -1});
        argTypes.put(SDO_DISTANCE, new int[]{0, 2, 0, 2, 5, 0});
        idxArgCol.put(SDO_BUFFER, 0);
        totalArgs.put(SDO_BUFFER, 3);
        idxSdoFuncMap.put(SDO_BUFFER, BUFFER_OP);
        idxArgPositions.put(SDO_BUFFER, new int[]{0, -1, 1, 2, -1});
        idxArgTypes.put(SDO_BUFFER, new int[]{0, 2, 6, 5, 0});
        sdoFuncMap.put(SDO_BUFFER, BUFFER_OP);
        argPositions.put(SDO_BUFFER, new int[]{0, -1, 1, 2, -1});
        argTypes.put(SDO_BUFFER, new int[]{0, 2, 6, 5, 0});
        idxArgCol.put(SDO_MBR, 0);
        totalArgs.put(SDO_MBR, 1);
        idxSdoFuncMap.put(SDO_MBR, ENVELOPE_OP);
        idxArgPositions.put(SDO_MBR, new int[]{0, -1});
        idxArgTypes.put(SDO_MBR, new int[]{0, 2, 0});
        sdoFuncMap.put(SDO_MBR, ENVELOPE_OP);
        argPositions.put(SDO_MBR, new int[]{0, -1});
        argTypes.put(SDO_MBR, new int[]{0, 2, 0});
        idxArgCol.put(SDO_CONVEX_HULL, 0);
        totalArgs.put(SDO_CONVEX_HULL, 1);
        idxSdoFuncMap.put(SDO_CONVEX_HULL, CONVEX_HULL_OP);
        idxArgPositions.put(SDO_CONVEX_HULL, new int[]{0, -1, -1});
        idxArgTypes.put(SDO_CONVEX_HULL, new int[]{0, 2, 0});
        sdoFuncMap.put(SDO_CONVEX_HULL, CONVEX_HULL_OP);
        argPositions.put(SDO_CONVEX_HULL, new int[]{0, -1, -1});
        argTypes.put(SDO_CONVEX_HULL, new int[]{0, 2, 0});
        idxArgCol.put(SDO_DIFFERENCE, 0);
        totalArgs.put(SDO_DIFFERENCE, 2);
        idxSdoFuncMap.put(SDO_DIFFERENCE, DIFF_OP);
        idxArgPositions.put(SDO_DIFFERENCE, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(SDO_DIFFERENCE, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(SDO_DIFFERENCE, DIFF_OP);
        argPositions.put(SDO_DIFFERENCE, new int[]{0, -1, 1, -1, -1});
        argTypes.put(SDO_DIFFERENCE, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(SDO_XOR, 0);
        totalArgs.put(SDO_XOR, 2);
        idxSdoFuncMap.put(SDO_XOR, SYM_DIFF_OP);
        idxArgPositions.put(SDO_XOR, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(SDO_XOR, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(SDO_XOR, SYM_DIFF_OP);
        argPositions.put(SDO_XOR, new int[]{0, -1, 1, -1, -1});
        argTypes.put(SDO_XOR, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(SDO_UNION, 0);
        totalArgs.put(SDO_UNION, 2);
        idxSdoFuncMap.put(SDO_UNION, UNION_OP);
        idxArgPositions.put(SDO_UNION, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(SDO_UNION, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(SDO_UNION, UNION_OP);
        argPositions.put(SDO_UNION, new int[]{0, -1, 1, -1, -1});
        argTypes.put(SDO_UNION, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(SDO_INTERSECTION, 0);
        totalArgs.put(SDO_INTERSECTION, 2);
        idxSdoFuncMap.put(SDO_INTERSECTION, INTERSECTION_OP);
        idxArgPositions.put(SDO_INTERSECTION, new int[]{0, -1, 1, -1, -1});
        idxArgTypes.put(SDO_INTERSECTION, new int[]{0, 2, 0, 2, 0});
        sdoFuncMap.put(SDO_INTERSECTION, INTERSECTION_OP);
        argPositions.put(SDO_INTERSECTION, new int[]{0, -1, 1, -1, -1});
        argTypes.put(SDO_INTERSECTION, new int[]{0, 2, 0, 2, 0});
        idxArgCol.put(SDO_AGGR_CENTROID, 0);
        totalArgs.put(SDO_AGGR_CENTROID, 1);
        idxSdoFuncMap.put(SDO_AGGR_CENTROID, AGG_CENTROID_OP);
        idxArgPositions.put(SDO_AGGR_CENTROID, new int[]{0, -1});
        idxArgTypes.put(SDO_AGGR_CENTROID, new int[]{10, 0});
        sdoFuncMap.put(SDO_AGGR_CENTROID, AGG_CENTROID_OP);
        argPositions.put(SDO_AGGR_CENTROID, new int[]{0, -1});
        argTypes.put(SDO_AGGR_CENTROID, new int[]{10, 0});
        idxArgCol.put(SDO_AGGR_CONCAT_LINES, 0);
        totalArgs.put(SDO_AGGR_CONCAT_LINES, 1);
        idxSdoFuncMap.put(SDO_AGGR_CONCAT_LINES, AGG_CONCAT_LINES_OP);
        idxArgPositions.put(SDO_AGGR_CONCAT_LINES, new int[]{0, -1});
        idxArgTypes.put(SDO_AGGR_CONCAT_LINES, new int[]{0, 0});
        sdoFuncMap.put(SDO_AGGR_CONCAT_LINES, AGG_CONCAT_LINES_OP);
        argPositions.put(SDO_AGGR_CONCAT_LINES, new int[]{0, -1});
        argTypes.put(SDO_AGGR_CONCAT_LINES, new int[]{0, 0});
        idxArgCol.put(SDO_AGGR_CONVEXHULL, 0);
        totalArgs.put(SDO_AGGR_CONVEXHULL, 1);
        idxSdoFuncMap.put(SDO_AGGR_CONVEXHULL, AGG_CONVEXHULL_OP);
        idxArgPositions.put(SDO_AGGR_CONVEXHULL, new int[]{0, -1});
        idxArgTypes.put(SDO_AGGR_CONVEXHULL, new int[]{10, 0});
        sdoFuncMap.put(SDO_AGGR_CONVEXHULL, AGG_CONVEXHULL_OP);
        argPositions.put(SDO_AGGR_CONVEXHULL, new int[]{0, -1});
        argTypes.put(SDO_AGGR_CONVEXHULL, new int[]{10, 0});
        idxArgCol.put(SDO_AGGR_MBR, 0);
        totalArgs.put(SDO_AGGR_MBR, 1);
        idxSdoFuncMap.put(SDO_AGGR_MBR, AGG_MBR_OP);
        idxArgPositions.put(SDO_AGGR_MBR, new int[]{0, -1});
        idxArgTypes.put(SDO_AGGR_MBR, new int[]{0, 0});
        sdoFuncMap.put(SDO_AGGR_MBR, AGG_MBR_OP);
        argPositions.put(SDO_AGGR_MBR, new int[]{0, -1});
        argTypes.put(SDO_AGGR_MBR, new int[]{0, 0});
        idxArgCol.put(SDO_AGGR_UNION, 0);
        totalArgs.put(SDO_AGGR_UNION, 1);
        idxSdoFuncMap.put(SDO_AGGR_UNION, AGG_UNION_OP);
        idxArgPositions.put(SDO_AGGR_UNION, new int[]{0, -1});
        idxArgTypes.put(SDO_AGGR_UNION, new int[]{10, 0});
        sdoFuncMap.put(SDO_AGGR_UNION, AGG_UNION_OP);
        argPositions.put(SDO_AGGR_UNION, new int[]{0, -1});
        argTypes.put(SDO_AGGR_UNION, new int[]{10, 0});
    }

    public static class SpatialArgException
    extends Exception {
        public SpatialArgException(String string) {
            super(string);
        }
    }
}

