/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlFilterOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTBooleanSpecialNode;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class UnDefVarFilterOptimizer
implements SparqlFilterOptimizer {
    private Set<String> patternVars;
    private Map<String, String> funcTypeMap;
    private Set<String> allInScopeVars;
    private Set<String> pfInScopeVars;
    private static final String[] EXISTS_FUNCS = new String[]{"EXISTS", "NOT EXISTS"};
    private static final String[] COALESCE_FUNC = new String[]{"COALESCE"};
    private static final String[] BOUND_FUNC = new String[]{"BOUND"};

    public UnDefVarFilterOptimizer(Set<String> set, Map<String, String> map) {
        this(set, map, new HashSet<String>(), new HashSet<String>());
    }

    public UnDefVarFilterOptimizer(Set<String> set, Map<String, String> map, Set<String> set2, Set<String> set3) {
        this.patternVars = set;
        this.funcTypeMap = map;
        this.allInScopeVars = set2;
        this.pfInScopeVars = set3;
    }

    @Override
    public Node optimizeFilter(Node node) throws RDFException, FilterException {
        int n;
        if (this.isBuiltInFuncNode((SimpleNode)node, EXISTS_FUNCS)) {
            return node;
        }
        Node node2 = node.cloneSubTree();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Node[] nodeArray = new Node[1];
        boolean[] blArray = new boolean[1];
        arrayList.add(node2);
        arrayList2.add(new Integer(0));
        nodeArray[0] = node2;
        blArray[0] = true;
        for (n = 0; blArray[0] && n < 10000; ++n) {
            blArray[0] = false;
            this.removeSingleBadVar(nodeArray[0], arrayList, arrayList2, nodeArray, blArray);
        }
        if (n >= 10000) {
            throw new FilterException("UnDefVarFilterOptimizer: entered infinite loop when optimizing query tree");
        }
        Node node3 = nodeArray[0];
        return nodeArray[0];
    }

    private void removeSingleBadVar(Node node, List<Node> list, List<Integer> list2, Node[] nodeArray, boolean[] blArray) throws RDFException {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        if (!blArray[0]) {
            if (this.isBadVarNode((SimpleNode)node)) {
                Node node5;
                for (int i = list.size() - 2; i >= 0 && !blArray[0]; --i) {
                    node2 = list.get(i);
                    if (Filter.getNodeRetType((SimpleNode)node2, this.funcTypeMap) == 2) {
                        blArray[0] = true;
                        node5 = new ASTBooleanSpecialNode(((SimpleNode)node2).parser, -1);
                        ((ASTBooleanSpecialNode)node5).name = this.isBuiltInFuncNode((SimpleNode)node2, BOUND_FUNC) ? "(1=0)" : "(null=null)";
                        if (i != 0) {
                            node4 = list.get(i - 1);
                            node4.jjtAddChild(node5, list2.get(i));
                            ((SimpleNode)node5).jjtSetParent(node4);
                            continue;
                        }
                        nodeArray[0] = node5;
                        continue;
                    }
                    if (!this.isBuiltInFuncNode((SimpleNode)node2, COALESCE_FUNC)) continue;
                    blArray[0] = true;
                    node5 = new ASTBooleanSpecialNode(((SimpleNode)nodeArray[0]).parser, -1);
                    ((ASTBooleanSpecialNode)node5).name = "(null=null)";
                    node2.jjtAddChild(node5, list2.get(i + 1));
                    ((SimpleNode)node5).jjtSetParent(node2);
                }
                if (!blArray[0]) {
                    ASTBooleanSpecialNode aSTBooleanSpecialNode = new ASTBooleanSpecialNode(((SimpleNode)nodeArray[0]).parser, -1);
                    aSTBooleanSpecialNode.name = "(null=null)";
                    if (((SimpleNode)nodeArray[0]).id == 56) {
                        node5 = nodeArray[0].cloneNode();
                        node5.jjtSetParent(nodeArray[0].jjtGetParent());
                        aSTBooleanSpecialNode.jjtSetParent(node5);
                        node5.jjtAddChild(aSTBooleanSpecialNode, 0);
                        nodeArray[0] = node5;
                    } else {
                        nodeArray[0] = aSTBooleanSpecialNode;
                    }
                    blArray[0] = true;
                }
            } else {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    node3 = node.jjtGetChild(i);
                    if (this.isBuiltInFuncNode((SimpleNode)node3, EXISTS_FUNCS)) continue;
                    list.add(node3);
                    list2.add(new Integer(i));
                    this.removeSingleBadVar(node3, list, list2, nodeArray, blArray);
                    list.remove(list.size() - 1);
                    list2.remove(list2.size() - 1);
                }
            }
        }
    }

    private boolean isBadVarNode(SimpleNode simpleNode) throws RDFException {
        boolean bl = false;
        if (simpleNode.id == 73) {
            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
            if (aSTTripleAtom.type == 0 && !this.patternVars.contains(aSTTripleAtom.name) && !this.pfInScopeVars.contains(aSTTripleAtom.name)) {
                bl = true;
                if (this.allInScopeVars.contains(aSTTripleAtom.name)) {
                    throw new RDFException("Illegal reference of variable " + aSTTripleAtom.name + " inside FILTER within EXISTS pattern");
                }
            }
        }
        return bl;
    }

    private boolean isBuiltInFuncNode(SimpleNode simpleNode, String[] stringArray) {
        boolean bl = false;
        if (simpleNode.id == 88) {
            String string = ((ASTBuiltInCall)simpleNode).name;
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
            }
        }
        return bl;
    }
}

