/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleStatement;
import oracle.spatial.rdf.server.BNPropListExpandOptimizer;
import oracle.spatial.rdf.server.BlankNodesRewriteOptimizer;
import oracle.spatial.rdf.server.CollectionExpandOptimizer;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.ModifyRewriteOptimizer;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLEntryPoints;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.TurtleExpandOptimizer;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructTemplate;
import oracle.spatial.rdf.server.parser.sparql.ASTCopy;
import oracle.spatial.rdf.server.parser.sparql.ASTDeleteClause;
import oracle.spatial.rdf.server.parser.sparql.ASTDeleteData;
import oracle.spatial.rdf.server.parser.sparql.ASTDeleteWhere;
import oracle.spatial.rdf.server.parser.sparql.ASTFullSparqlQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphOrDefault;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphRefAll;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTInsertClause;
import oracle.spatial.rdf.server.parser.sparql.ASTInsertData;
import oracle.spatial.rdf.server.parser.sparql.ASTLoad;
import oracle.spatial.rdf.server.parser.sparql.ASTModify;
import oracle.spatial.rdf.server.parser.sparql.ASTMove;
import oracle.spatial.rdf.server.parser.sparql.ASTQuadData;
import oracle.spatial.rdf.server.parser.sparql.ASTQuadPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTQuadsNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.SparqlSelectDescriptor;
import oracle.spatial.rdf.server.parser.sparql.SparqlSourceDescriptor;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;
import oracle.spatial.util.Util;
import oracle.sql.ARRAY;
import oracle.sql.CLOB;

public class UpdateEngine {
    private static Connection sConn;
    private sparqlParse parser = new sparqlParse((Reader)null);
    private Connection conn = this.getConnection();
    private String[] matchModels;
    private String precompIdx;
    private long precompIdxId;
    private String matchIndexStatus;
    private String vmViewName;
    private int isRdfVWModel;
    private String applyModel;
    private long applyModelId;
    private String modelOwner;
    private String appTabName;
    private String appColName;
    private SQLGenContext ctx;
    private String matchOptions = "";
    private String options = "";
    private static final String ANON_BN = "[]";
    private static final String DELETE_TAB_NAME = "RDF_UPD_DEL$";
    private static final String INSERT_TAB_NAME = "RDF_UPD_INS$";
    private static final String INSERT_CLOB_TAB_NAME = "RDF_UPD_INS_CLOB$";
    private static final String GRAPH_COL_NAME = "RDF$STC_GRAPH";
    private static final String SUB_COL_NAME = "RDF$STC_SUB";
    private static final String PRED_COL_NAME = "RDF$STC_PRED";
    private static final String OBJ_COL_NAME = "RDF$STC_OBJ";
    private static final String CLOB_COL_NAME = "RDF$STC_CLOB";
    private static final String P_VALUE_ID = "P_VALUE_ID";
    private static final String START_NODE_ID = "START_NODE_ID";
    private static final String CANON_END_NODE_ID = "CANON_END_NODE_ID";
    private static final String END_NODE_ID = "END_NODE_ID";
    private static final String MODEL_ID = "MODEL_ID";
    private static final String COST = "COST";
    private static final String CTXT1 = "CTXT1";
    private static final String CTXT2 = "CTXT2";
    private static final String DISTANCE = "DISTANCE";
    private static final String EXPLAIN = "EXPLAIN";
    private static final String PATH = "PATH";
    private static final String G_ID = "G_ID";
    private static final String LINK_ID = "LINK_ID";
    private static final String EXT_TAB_PREFIX = "EXT_TAB";
    private static final String LOAD_DATA_DIR_PREFIX = "LOAD_DATA_DIR";
    private static final int DEFAULT_FETCH_SIZE = 500;
    private static final int DEFAULT_BATCH_SIZE = 500;
    private static final int MAX_TERM_LOG_LEN = 500;
    private String insertTabName = "RDF_UPD_INS$";
    private String deleteTabName = "RDF_UPD_DEL$";
    private static DateFormat dateFormat;
    private static final Pattern SIMPLE_IDX_NAME;
    private static final int[] SUBJ_TYPES_ARRAY;
    private static final int[] PRED_TYPES_ARRAY;
    private static final int[] OBJ_TYPES_ARRAY;
    private List<String> transientTables;
    public static final int MAX_COL_LEN = 4000;
    private String rdfTablespace;
    private String currentSchema;
    private boolean debug = false;
    private static final String DEBUG_FLAG = "DEBUG=T";
    private int numOps = 0;
    private boolean bulkSafe = false;
    private boolean mmSafe = false;
    private boolean disableMM = false;
    private static final String DISABLE_MM_FLAG = "ENABLE_MM=F";
    private boolean forceMM = false;
    private static final String FORCE_MM_FLAG = "FORCE_MM=T";
    private boolean disableMMValidity = false;
    private static final String DISABLE_MM_VALIDITY_FLAG = "MM_VALIDITY=F";
    private String mmOptions = "";
    private static final String MM_OPTIONS_FLAG = "MM_OPTIONS";
    private static final String APP_IDX_FLAG = "APP_TAB_IDX";
    private String appIdxName = "";
    private boolean disableBulk = false;
    private static final String DISABLE_BULK_FLAG = "ENABLE_BULK=F";
    private boolean forceBulk = false;
    private static final String FORCE_BULK_FLAG = "FORCE_BULK=T";
    private static final long BULK_THRESHOLD = 1000L;
    private String bulkOptions = "";
    private static final String BULK_OPTIONS_FLAG = "BULK_OPTIONS";
    private boolean disableTripleValidity = false;
    private static final String DISABLE_VALID_CHECK = "TRIPLE_VALID_CHECK=F";
    private boolean disableTripleDup = false;
    private static final String DISABLE_DUP_CHECK = "TRIPLE_DUP_CHECK=F";
    private boolean dumpTempTabs = false;
    private static final String DUMP_TEMP_TABS_FLAG = "DUMP_TEMP_TABS=T";
    private boolean strictBNode = false;
    private static final String STRICT_BNODE_FLAG = "STRICT_BNODE=T";
    private static final String NO_STRICT_BNODE_FLAG = "STRICT_BNODE=F";
    private boolean recordBindings = false;
    private static final String RECORD_BINDINGS_FLAG = "RECORD_BINDINGS=T";
    private static final String BINDINGS_TAB_NAME = "BINDINGS_TAB";
    private boolean recordMM = false;
    private static final String RECORD_MM_FLAG = "RECORD_MM=T";
    private static final String MM_TAB_NAME = "MM_TAB";
    private boolean recordInserts = false;
    private static final String RECORD_INSERTS_FLAG = "RECORD_INSERTS=T";
    private static final String INSERTS_TAB_NAME = "INSERTS_TAB";
    private boolean recordDeletes = false;
    private static final String RECORD_DELETES_FLAG = "RECORD_DELETES=T";
    private static final String DELETES_TAB_NAME = "DELETES_TAB";
    private boolean clobSupport = false;
    private static final String CLOB_SUPPORT_FLAG = "CLOB_UPDATE_SUPPORT=T";
    private static final String NO_CLOB_SUPPORT_FLAG = "CLOB_UPDATE_SUPPORT=F";
    private static final String CLOB_BULK_ERROR = "BULK_LOAD is not supported with CLOB_UPDATE_SUPPORT";
    private boolean safeForHints = false;
    private boolean append = false;
    private static final String APPEND_FLAG = "APPEND";
    private boolean parallel = false;
    private static final String PARALLEL_FLAG = "PARALLEL";
    private int dop = 0;
    private boolean ods = false;
    private static final String ODS_FLAG = "DYNAMIC_SAMPLING";
    private int ods_level = 0;
    private boolean inStream = true;
    private static final String NO_STREAMING_FLAG = "STREAMING=F";
    private static final String STREAMING_FLAG = "STREAMING=T";
    ResultSet insertRS = null;
    ResultSet deleteRS = null;
    Statement delStmt = null;
    Statement insStmt = null;
    private boolean delAsIns = false;
    private static final String DEL_AS_INS_FLAG = "DEL_AS_INS=T";
    private boolean daiSafe = false;
    private boolean resumeLoad = false;
    private static final String RESUME_LOAD_FLAG = "RESUME_LOAD=T";
    private String loadOptions = "";
    private static final String LOAD_OPTIONS_FLAG = "LOAD_OPTIONS";
    private String loadDirName = "";
    private static final String LOAD_DIR_FLAG = "LOAD_DIR";
    private boolean projExact = false;
    private static final String PROJ_EXACT_FLAG = "PROJ_EXACT_VALUES=T";
    private boolean truncateSafe = false;
    private static final String READ_COMMITTED = "READ COMMITTED";
    private static final String SERIALIZABLE = "SERIALIZABLE";
    private static final String SERIAL_ISO_FLAG = "SERIALIZABLE=T";
    private String isoLevel = null;
    private int nonautoFlag = 0;
    private static final String SERIAL_STREAM_ERROR = "Serializable isolation level is not supported with STREAMING=F";
    private static final String SERIAL_MM_ERROR = "Serializable isolation level is not supported with MERGE_MODELS";
    private static final String SERIAL_BULK_ERROR = "Serializable isolation level is not supported with BULK_LOAD";
    private static final String SERIAL_DEL_INS_ERROR = "Serializable isolation level is not supported with DELETE AS INSERT";
    private static final String SERIAL_LOAD_ERROR = "Serializable isolation level is not supported for LOAD";
    private static final String BAD_ISO_VALUE = "Unrecognized isolation level: ";
    private static final String FILE_INVALID_CHAR_ERROR = "Invalid file URI: ";
    private static final int TABLE_DOES_NOT_EXIST_CODE = 942;
    private static final String TABLE_DOES_NOT_EXIST_MSG = "ORA-00942";
    private static final String MISSING_TEMPORARY_TABS = "Temporary tables do not exist. Call sem_apis.create_sparql_update_tables procedure";
    private int fetchSize = 500;
    private int batchSize = 500;
    private boolean autocommit = true;
    private static final String AUTOCOMMIT_FLAG = "AUTOCOMMIT=T";
    private static final String NO_AUTOCOMMIT_FLAG = "AUTOCOMMIT=F";
    private static final String AUTOCOMMIT_LOAD_ERROR = "AUTOCOMMIT=F is not supported for LOAD";
    private static final String AUTOCOMMIT_BULK_ERROR = "AUTOCOMMIT=F is not supported with BULK_LOAD";
    private static final String AUTOCOMMIT_MM_ERROR = "AUTOCOMMIT=F is not supported with MERGE_MODELS";
    private static final String AUTOCOMMIT_DEL_INS_ERROR = "AUTOCOMMIT=F is not supported with DELETE AS INSERT";
    private static final String AUTOCOMMIT_STREAM_ERROR = "AUTOCOMMIT=F is not supported with STREAMING=F";
    private static final String UNKNOWN_TYPE_ERROR = "Unknown value_type found in update statement";
    private static final String STRICT_BN_MM_ERROR = "STRICT_BNODE=F flag should be used for MERGE MODELS";
    private int ctxFlag = 0;
    private static final int NO_AUTOCOMMIT_HEX_FLAG = 1;
    private static final int NO_STRICT_BNODE_HEX_FLAG = 2;
    private static final int CLOB_SUPPORT_HEX_FLAG = 4;
    private static final int NO_STREAMING_HEX_FLAG = 8;
    private static List<SparqlQueryOptimizer> astOptimizers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String string, boolean bl) {
        if (bl) {
            String string2;
            DateFormat dateFormat = UpdateEngine.dateFormat;
            synchronized (dateFormat) {
                string2 = UpdateEngine.dateFormat.format(Calendar.getInstance().getTime());
            }
            QueryUtils.log("SPARQL UPDATE [" + string2 + "] " + string + "\n");
        }
    }

    private static <T> void dumpArray(T[] TArray, StringBuffer stringBuffer) {
        stringBuffer.append("[");
        for (int i = 0; i < TArray.length; ++i) {
            stringBuffer.append(" " + TArray[i]);
        }
        stringBuffer.append("]");
    }

    private static void dumpArray(long[] lArray, StringBuffer stringBuffer) {
        stringBuffer.append("[");
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(" " + lArray[i]);
        }
        stringBuffer.append("]");
    }

    private static void dumpArray(int[] nArray, StringBuffer stringBuffer) {
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(" " + nArray[i]);
        }
        stringBuffer.append("]");
    }

    private static <T> void dumpCollection(Collection<T> collection, StringBuffer stringBuffer) {
        stringBuffer.append("[");
        for (T t : collection) {
            stringBuffer.append(" " + t);
        }
        stringBuffer.append("]");
    }

    public UpdateEngine(String string, long l, String string2, String string3, String string4, String[] stringArray, String string5, long l2, String string6, String string7, int n, String string8, String string9, String string10, String string11, int n2) throws SQLException, RDFException {
        this.applyModel = string;
        this.applyModelId = l;
        this.modelOwner = string2;
        this.appTabName = string3;
        this.appColName = string4;
        this.matchModels = stringArray;
        this.precompIdx = string5;
        this.precompIdxId = l2;
        this.matchIndexStatus = string6;
        this.vmViewName = string7;
        this.isRdfVWModel = n;
        if (string8 != null) {
            this.matchOptions = string8;
        }
        if (string9 != null) {
            this.options = string9;
        }
        this.ctxFlag = n2;
        this.setDefaults();
        this.setOptions();
        this.postProcessOptions();
        this.transientTables = new ArrayList<String>();
        this.rdfTablespace = string11;
        this.currentSchema = string10;
    }

    private Connection getConnection() throws SQLException {
        if (sConn == null) {
            sConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return sConn;
    }

    private void setDefaults() {
        this.autocommit = (this.ctxFlag & 1) == 0;
        this.strictBNode = (this.ctxFlag & 2) == 0;
        this.clobSupport = (this.ctxFlag & 4) > 0;
        this.inStream = (this.ctxFlag & 8) == 0;
    }

    private void setOptions() throws RDFException {
        String string;
        String[] stringArray = new String[]{this.options.toUpperCase()};
        this.debug = false;
        if (stringArray[0].contains(DEBUG_FLAG)) {
            this.debug = true;
        }
        if (stringArray[0].contains(LOAD_OPTIONS_FLAG)) {
            this.loadOptions = this.extractEnclosedOption(LOAD_OPTIONS_FLAG, stringArray, this.options);
        }
        if (stringArray[0].contains(LOAD_DIR_FLAG) && (string = this.extractEnclosedOption(LOAD_DIR_FLAG, stringArray, null).trim()).length() > 0) {
            this.loadDirName = string;
        }
        if (stringArray[0].contains(BULK_OPTIONS_FLAG)) {
            this.bulkOptions = this.extractEnclosedOption(BULK_OPTIONS_FLAG, stringArray, null);
        }
        if (stringArray[0].contains(MM_OPTIONS_FLAG)) {
            this.mmOptions = this.extractEnclosedOption(MM_OPTIONS_FLAG, stringArray, null);
        }
        if (stringArray[0].contains(APP_IDX_FLAG) && (string = this.extractEnclosedOption(APP_IDX_FLAG, stringArray, null).trim()).length() > 0) {
            this.appIdxName = string;
        }
        this.disableBulk = false;
        if (stringArray[0].contains(DISABLE_BULK_FLAG)) {
            this.disableBulk = true;
        }
        this.forceBulk = false;
        if (stringArray[0].contains(FORCE_BULK_FLAG)) {
            this.forceBulk = true;
        }
        this.disableMM = false;
        if (stringArray[0].contains(DISABLE_MM_FLAG)) {
            this.disableMM = true;
        }
        this.forceMM = false;
        if (stringArray[0].contains(FORCE_MM_FLAG)) {
            this.forceMM = true;
        }
        this.disableMMValidity = false;
        if (stringArray[0].contains(DISABLE_MM_VALIDITY_FLAG)) {
            this.disableMMValidity = true;
        }
        this.disableTripleValidity = false;
        if (stringArray[0].contains(DISABLE_VALID_CHECK)) {
            this.disableTripleValidity = true;
        }
        this.disableTripleDup = false;
        if (stringArray[0].contains(DISABLE_DUP_CHECK)) {
            this.disableTripleDup = true;
        }
        this.dumpTempTabs = false;
        if (stringArray[0].contains(DUMP_TEMP_TABS_FLAG)) {
            this.dumpTempTabs = true;
        }
        if (stringArray[0].contains(STRICT_BNODE_FLAG)) {
            this.strictBNode = true;
        }
        if (stringArray[0].contains(NO_STRICT_BNODE_FLAG)) {
            this.strictBNode = false;
        }
        this.recordBindings = false;
        if (stringArray[0].contains(RECORD_BINDINGS_FLAG)) {
            this.recordBindings = true;
        }
        this.recordMM = false;
        if (stringArray[0].contains(RECORD_MM_FLAG)) {
            this.recordMM = true;
        }
        this.recordInserts = false;
        if (stringArray[0].contains(RECORD_INSERTS_FLAG)) {
            this.recordInserts = true;
        }
        this.recordDeletes = false;
        if (stringArray[0].contains(RECORD_DELETES_FLAG)) {
            this.recordDeletes = true;
        }
        if (stringArray[0].contains(CLOB_SUPPORT_FLAG)) {
            this.clobSupport = true;
            this.disableBulk = true;
            this.insertTabName = INSERT_CLOB_TAB_NAME;
        }
        if (stringArray[0].contains(NO_CLOB_SUPPORT_FLAG)) {
            this.clobSupport = false;
            this.insertTabName = INSERT_TAB_NAME;
        }
        this.append = false;
        this.parallel = false;
        if (stringArray[0].contains(APPEND_FLAG)) {
            this.append = true;
        }
        if (stringArray[0].contains(PARALLEL_FLAG)) {
            this.parallel = true;
            this.dop = this.extractNumericParenOption(PARALLEL_FLAG, stringArray[0]);
        }
        if (stringArray[0].contains(ODS_FLAG)) {
            this.ods = true;
            this.ods_level = this.extractNumericParenOption(ODS_FLAG, stringArray[0]);
        }
        this.projExact = false;
        if (stringArray[0].contains(PROJ_EXACT_FLAG)) {
            this.projExact = true;
        }
        if (stringArray[0].contains(NO_STREAMING_FLAG)) {
            this.inStream = false;
        }
        if (stringArray[0].contains(STREAMING_FLAG)) {
            this.inStream = true;
        }
        this.delAsIns = false;
        if (stringArray[0].contains(DEL_AS_INS_FLAG)) {
            this.delAsIns = true;
        }
        this.resumeLoad = false;
        if (stringArray[0].contains(RESUME_LOAD_FLAG)) {
            this.resumeLoad = true;
        }
        this.isoLevel = READ_COMMITTED;
        if (stringArray[0].contains(SERIAL_ISO_FLAG)) {
            this.isoLevel = SERIALIZABLE;
            this.nonautoFlag = 1;
        }
        if (stringArray[0].contains(NO_AUTOCOMMIT_FLAG)) {
            this.autocommit = false;
        }
        if (stringArray[0].contains(AUTOCOMMIT_FLAG)) {
            this.autocommit = true;
        }
        UpdateEngine.log("Options\n            ctxFlag=[" + this.ctxFlag + "]\n" + "              debug=[" + this.debug + "]\n" + "        disableBulk=[" + this.disableBulk + "]\n" + "          forceBulk=[" + this.forceBulk + "]\n" + "          disableMM=[" + this.disableMM + "]\n" + "            forceMM=[" + this.forceMM + "]\n" + "  disableMMValidity=[" + this.disableMMValidity + "]\n" + "       dumpTempTabs=[" + this.dumpTempTabs + "]\n" + "        strictBNode=[" + this.strictBNode + "]\n" + "        clobSupport=[" + this.clobSupport + "]\n" + "             append=[" + this.append + "]\n" + "                dop=[" + this.dop + "]\n" + "          ods_level=[" + this.ods_level + "]\n" + "         appIdxName=[" + this.appIdxName + "]\n" + "           inStream=[" + this.inStream + "]\n" + "           delAsIns=[" + this.delAsIns + "]\n" + "         resumeLoad=[" + this.resumeLoad + "]\n" + "           isoLevel=[" + this.isoLevel + "]\n" + "         autocommit=[" + this.autocommit + "]\n" + "        loadDirName=[" + this.loadDirName + "]\n" + "          projExact=[" + this.projExact + "]\n", this.debug);
        this.matchOptions = this.matchOptions + " PLUS_RDFT=VC ";
        UpdateEngine.log("Query Translation Options=[" + this.matchOptions + "]", this.debug);
    }

    private void postProcessOptions() throws RDFException {
        boolean bl = this.isoLevel.equals(SERIALIZABLE);
        if (!this.inStream) {
            if (bl) {
                throw new RDFException(SERIAL_STREAM_ERROR);
            }
            if (!this.autocommit) {
                throw new RDFException(AUTOCOMMIT_STREAM_ERROR);
            }
        }
        if (this.forceMM) {
            if (this.strictBNode) {
                throw new RDFException(STRICT_BN_MM_ERROR);
            }
            if (bl) {
                throw new RDFException(SERIAL_MM_ERROR);
            }
            if (!this.autocommit) {
                throw new RDFException(AUTOCOMMIT_MM_ERROR);
            }
            this.inStream = false;
        }
        if (this.forceBulk) {
            if (bl) {
                throw new RDFException(SERIAL_BULK_ERROR);
            }
            if (!this.autocommit) {
                throw new RDFException(AUTOCOMMIT_BULK_ERROR);
            }
            this.inStream = false;
        }
        if (this.delAsIns) {
            if (bl) {
                throw new RDFException(SERIAL_DEL_INS_ERROR);
            }
            if (!this.autocommit) {
                throw new RDFException(AUTOCOMMIT_DEL_INS_ERROR);
            }
            this.inStream = false;
        }
        if (this.forceBulk && this.clobSupport) {
            throw new RDFException(CLOB_BULK_ERROR);
        }
    }

    private int extractNumericParenOption(String string, String string2) {
        int n;
        int n2 = -1;
        int n3 = string2.indexOf(string);
        if (n3 >= 0 && (n = string2.indexOf("(", n3)) >= 0) {
            int n4;
            String string3 = string2.substring(n3, n + 1);
            if ((string3 = string3.replaceAll("\n", "").replaceAll("\t", "").replaceAll(" ", "")).equals(string + "(") && (n4 = string2.indexOf(")", n)) > n + 1) {
                try {
                    n2 = Integer.parseInt(string2.substring(n + 1, n4).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    UpdateEngine.log("Error extracting numeric value for option [" + string + "]" + ": " + numberFormatException.getMessage(), this.debug);
                }
            }
        }
        return n2;
    }

    private String extractEnclosedOption(String string, String[] stringArray, String string2) {
        char c = '{';
        char c2 = '}';
        int n = 1;
        String string3 = "";
        UpdateEngine.log("Extracting enclosed option:\n    optionName=[" + string + "]\n" + "     optionStr=[" + stringArray[0] + "]", this.debug);
        String string4 = string + "=" + c;
        int n2 = stringArray[0].indexOf(string4);
        int n3 = 0;
        if (n2 >= 0) {
            for (int i = n2 += string4.length(); i < stringArray[0].length() && n > 0; ++i) {
                if (stringArray[0].charAt(i) == c) {
                    ++n;
                } else if (stringArray[0].charAt(i) == c2) {
                    --n;
                }
                if (n != 0) continue;
                n3 = i;
            }
            if (n3 > 0 && n == 0) {
                string3 = string2 != null ? string2.substring(n2, n3) : stringArray[0].substring(n2, n3);
                stringArray[0] = stringArray[0].substring(0, n2) + stringArray[0].substring(n3);
            }
        }
        UpdateEngine.log("Extracted enclosed option:\n          optionKey=[" + string4 + "]\n" + "    extractedOption=[" + string3 + "]\n" + "          optionStr=[" + stringArray[0] + "]", this.debug);
        return string3;
    }

    private String enquoteLiteral(String string) {
        if (string.contains("'")) {
            return "''";
        }
        return "'" + string + "'";
    }

    private boolean containsIllegalChars(String string) {
        return string.contains("'") || string.contains("\"") || string.contains(" ") || string.contains(";");
    }

    private String getLocation(String string, List<String> list) throws RDFException, SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string2 : list) {
            if (this.containsIllegalChars(string2)) {
                throw new RDFException("Invalid file URI: <" + string + "/" + string2 + ">");
            }
            if (bl) {
                stringBuffer.append(",");
            }
            bl = true;
            stringBuffer.append(this.getSanitizedLiteral(string2));
        }
        return stringBuffer.toString();
    }

    public void doUpdate(String string) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        UpdateEngine.log("Processing Update Statement\n" + string, this.debug);
        this.delStmt = this.conn.createStatement();
        this.insStmt = this.conn.createStatement();
        UpdateEngine.log("Setting fetch size: " + this.fetchSize, this.debug);
        this.delStmt.setFetchSize(this.fetchSize);
        this.insStmt.setFetchSize(this.fetchSize);
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(null);
        this.parser.reset();
        SimpleNode simpleNode = this.parser.parse(string, hashMap, this.matchOptions);
        if (this.debug) {
            UpdateEngine.log("Syntax Tree:\n", this.debug);
            UpdateEngine.log("\n" + simpleNode.dumpToStr(""), this.debug);
        }
        for (SparqlQueryOptimizer sparqlQueryOptimizer : astOptimizers) {
            simpleNode = (SimpleNode)sparqlQueryOptimizer.optimizeQuery(simpleNode);
        }
        if (this.debug) {
            UpdateEngine.log("Optimized Syntax Tree:\n", this.debug);
            UpdateEngine.log("\n" + simpleNode.dumpToStr(""), this.debug);
        }
        if (this.matchOptions != null && this.matchOptions.contains("INPUT_ESCAPE=F")) {
            this.checkForUnescapedChars(string);
        }
        this.insertConstVals(simpleNode);
        if (this.autocommit) {
            this.setTransction();
        }
        boolean bl = false;
        while (!bl) {
            if (simpleNode.id == 26) {
                bl = true;
                continue;
            }
            if (simpleNode.jjtGetNumChildren() > 0) {
                simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
                continue;
            }
            throw new ParseException("No UPDATE command found");
        }
        this.numOps = simpleNode.jjtGetNumChildren();
        try {
            block27: for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                UpdateEngine.log("Processing Update " + i, this.debug);
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                switch (simpleNode2.id) {
                    case 27: {
                        UpdateEngine.log("Executing LOAD", this.debug);
                        if (this.numOps > 1) {
                            throw new ParseException("LOAD should be called as a single operation");
                        }
                        if (this.isoLevel.equals(SERIALIZABLE)) {
                            throw new ParseException(SERIAL_LOAD_ERROR);
                        }
                        if (!this.autocommit) {
                            throw new ParseException(AUTOCOMMIT_LOAD_ERROR);
                        }
                        this.inStream = false;
                        this.insertTabName = INSERT_TAB_NAME;
                        this.doLoad((ASTLoad)simpleNode2);
                        continue block27;
                    }
                    case 28: 
                    case 29: {
                        UpdateEngine.log("Executing CLEAR/DROP", this.debug);
                        if (this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for delete as insert", this.debug);
                            this.daiSafe = true;
                            if (this.autocommit) {
                                UpdateEngine.log("Marking as safe for truncate", this.debug);
                                this.truncateSafe = true;
                            }
                        }
                        if ((this.append || this.parallel) && this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for SQL hints", this.debug);
                            this.safeForHints = true;
                        }
                        this.doClear(simpleNode2);
                        continue block27;
                    }
                    case 31: {
                        UpdateEngine.log("Executing ADD", this.debug);
                        if (!this.disableBulk && this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for bulk load", this.debug);
                            this.bulkSafe = true;
                        }
                        if ((this.append || this.parallel) && this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for SQL hints", this.debug);
                            this.safeForHints = true;
                        }
                        this.doAdd(simpleNode2);
                        continue block27;
                    }
                    case 32: {
                        UpdateEngine.log("Executing MOVE", this.debug);
                        this.doMove((ASTMove)simpleNode2);
                        continue block27;
                    }
                    case 33: {
                        UpdateEngine.log("Executing COPY", this.debug);
                        this.doCopy((ASTCopy)simpleNode2);
                        continue block27;
                    }
                    case 30: {
                        UpdateEngine.log("Executing CREATE", this.debug);
                        this.doCreate();
                        continue block27;
                    }
                    case 34: {
                        UpdateEngine.log("Executing INSERT DATA", this.debug);
                        this.doInsertData((ASTInsertData)simpleNode2);
                        continue block27;
                    }
                    case 35: {
                        UpdateEngine.log("Executing DELETE DATA", this.debug);
                        this.doDeleteData((ASTDeleteData)simpleNode2);
                        continue block27;
                    }
                    case 36: {
                        UpdateEngine.log("Executing DELETE WHERE", this.debug);
                        if ((this.append || this.parallel) && this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for SQL hints", this.debug);
                            this.safeForHints = true;
                        }
                        if (this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for delete as insert", this.debug);
                            this.daiSafe = true;
                        }
                        this.doDeleteWhere((ASTDeleteWhere)simpleNode2);
                        continue block27;
                    }
                    case 37: {
                        UpdateEngine.log("Executing MODIFY", this.debug);
                        if (!this.disableBulk && this.numOps == 1 && simpleNode2.jjtGetNumChildren() >= 1 && ((SimpleNode)simpleNode2.jjtGetChild((int)0)).id == 39) {
                            UpdateEngine.log("Marking as safe for bulk load", this.debug);
                            this.bulkSafe = true;
                        }
                        if ((this.append || this.parallel) && this.numOps == 1) {
                            UpdateEngine.log("Marking as safe for SQL hints", this.debug);
                            this.safeForHints = true;
                        }
                        if (this.numOps == 1 && simpleNode2.jjtGetNumChildren() >= 2 && ((SimpleNode)simpleNode2.jjtGetChild((int)0)).id == 38 && ((SimpleNode)simpleNode2.jjtGetChild((int)1)).id != 39) {
                            UpdateEngine.log("Marking as safe for delete as insert", this.debug);
                            this.daiSafe = true;
                        }
                        boolean bl2 = this.strictBNode;
                        if (!this.strictBNode && simpleNode2.jjtGetNumChildren() >= 1 && ((SimpleNode)simpleNode2.jjtGetChild((int)0)).id == 39) {
                            this.strictBNode = OptimizerUtils.hasBNVar(simpleNode2.jjtGetChild(0));
                        } else if (!this.strictBNode && simpleNode2.jjtGetNumChildren() >= 2 && ((SimpleNode)simpleNode2.jjtGetChild((int)1)).id == 39) {
                            this.strictBNode = OptimizerUtils.hasBNVar(simpleNode2.jjtGetChild(1));
                        }
                        UpdateEngine.log("MODIFY, strictBNode=[" + this.strictBNode + "]", this.debug);
                        this.doModify((ASTModify)simpleNode2, false);
                        this.strictBNode = bl2;
                        UpdateEngine.log("End MODIFY, strictBNode=[" + this.strictBNode + "]", this.debug);
                        continue block27;
                    }
                    default: {
                        throw new ParseException("Unexpected node type under Update");
                    }
                }
            }
        }
        catch (Exception exception) {
            UpdateEngine.log("Exception found: " + exception.getClass().toString() + ": " + exception.getMessage() + "\n ...Rolling back transaction", this.debug);
            this.conn.rollback();
            this.dropTransientTables();
            throw new RDFException(exception.getMessage());
        }
        finally {
            if (this.delStmt != null) {
                try {
                    this.delStmt.close();
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing delete statement:" + sQLException.getMessage(), this.debug);
                }
            }
            if (this.insStmt != null) {
                try {
                    this.insStmt.close();
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing insert statement:" + sQLException.getMessage(), this.debug);
                }
            }
        }
        if (this.autocommit) {
            UpdateEngine.log("Operations completed normally ...committing transaction", this.debug);
            this.conn.commit();
        } else {
            UpdateEngine.log("Autocommit is off", this.debug);
        }
        UpdateEngine.log("Dropping transient tables", this.debug);
        this.dropTransientTables();
        if (!this.inStream) {
            UpdateEngine.log("Cleaning up temporary tables", this.debug);
            this.cleanupTemporaryTables(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad(ASTLoad aSTLoad) throws ParseException, SQLException, RDFException {
        if (aSTLoad.jjtGetNumChildren() < 1) {
            throw new ParseException("Wrong number of children under LOAD node");
        }
        String string = EXT_TAB_PREFIX + this.applyModelId + "$";
        String string2 = this.getSanitizedTabName(string);
        boolean bl = this.loadDirName.length() == 0;
        String string3 = bl ? LOAD_DATA_DIR_PREFIX + this.applyModelId + "$" : this.loadDirName;
        string3 = this.getSanitizedTabName(string3);
        if (!this.resumeLoad) {
            try {
                this.checkEmptyTable(this.insertTabName);
            }
            catch (SQLException sQLException) {
                if (this.isMissingTabsException(sQLException)) {
                    throw new RDFException(MISSING_TEMPORARY_TABS);
                }
                throw sQLException;
            }
            this.checkTableNotExists(string);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Statement statement = null;
        Statement statement2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        String string4 = "";
        try {
            int n;
            Object object;
            String string5;
            if (!this.resumeLoad) {
                CharSequence charSequence;
                Object object2;
                string5 = this.extractGraphName(aSTLoad);
                object = new File(new URI(string5));
                String string6 = ((File)object).getParent();
                UpdateEngine.log("Directory:" + string6, this.debug);
                String string7 = ((File)object).getName();
                StringBuffer stringBuffer2 = new StringBuffer();
                int n2 = string7.lastIndexOf(".");
                if (n2 < 0) {
                    stringBuffer2.append(string7);
                } else {
                    stringBuffer2.append(string7.substring(0, string7.lastIndexOf(".")));
                }
                stringBuffer2.append(".bad");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string7);
                if (this.loadOptions.length() > 0) {
                    object2 = new StringTokenizer(this.loadOptions, " ");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        arrayList.add(((StringTokenizer)object2).nextToken());
                    }
                }
                object2 = "";
                if (arrayList.size() > 1) {
                    object2 = ",parallel=>" + arrayList.size();
                }
                if (this.debug) {
                    charSequence = new StringBuffer("File names:[");
                    for (String string8 : arrayList) {
                        ((StringBuffer)charSequence).append(" ").append(string8);
                    }
                    ((StringBuffer)charSequence).append("]");
                    UpdateEngine.log(((StringBuffer)charSequence).toString(), this.debug);
                }
                if (this.containsIllegalChars(string6) || this.containsIllegalChars(stringBuffer2.toString())) {
                    throw new RDFException("Invalid file URI: <" + string5 + ">");
                }
                charSequence = this.getLocation(string6, arrayList);
                string6 = this.getSanitizedLiteral(string6);
                if (bl) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("CREATE OR REPLACE DIRECTORY ").append(string3).append(" AS ").append(string6);
                    UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
                    statement = this.conn.createStatement();
                    n = statement.executeUpdate(stringBuffer.toString());
                    UpdateEngine.log("Number of rows affected: " + n, this.debug);
                    statement.close();
                    stringBuffer.setLength(0);
                    stringBuffer.append("GRANT READ,WRITE ON DIRECTORY ").append(string3).append(" TO MDSYS");
                    if (this.recordInserts) {
                        this.recordString(stringBuffer.toString(), INSERTS_TAB_NAME, 4000);
                    }
                    UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
                    statement = this.conn.createStatement();
                    n = statement.executeUpdate(stringBuffer.toString());
                    UpdateEngine.log("Number of rows affected: " + n, this.debug);
                    statement.close();
                }
                stringBuffer.setLength(0);
                stringBuffer.append("BEGIN").append("\n  sem_apis.create_source_external_table(").append("source_table=>?,").append("def_directory=>?,").append("bad_file=>?").append((String)object2).append(");\nEND;");
                string4 = this.buildBindVarLog(new String[]{string2, string3, stringBuffer2.toString()});
                if (this.recordInserts) {
                    this.recordString(stringBuffer.toString() + string4, INSERTS_TAB_NAME, 4000);
                }
                UpdateEngine.log("Executing: \n" + stringBuffer + string4, this.debug);
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(stringBuffer.toString());
                oracleCallableStatement.setString(1, string2);
                oracleCallableStatement.setString(2, string3);
                oracleCallableStatement.setString(3, stringBuffer2.toString());
                oracleCallableStatement.execute();
                n = oracleCallableStatement.getUpdateCount();
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
                oracleCallableStatement.close();
                stringBuffer.setLength(0);
                stringBuffer.append("ALTER TABLE ").append(string2).append(" LOCATION (").append((String)charSequence).append(")");
                UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
                statement = this.conn.createStatement();
                n = statement.executeUpdate(stringBuffer.toString());
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
                statement.close();
                stringBuffer.setLength(0);
                stringBuffer.append("SELECT COUNT(*) FROM ").append(string2).append(" WHERE ROWNUM < 2");
                UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
                statement = this.conn.createStatement();
                n = statement.executeUpdate(stringBuffer.toString());
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
                statement.close();
                stringBuffer.setLength(0);
                stringBuffer.append("BEGIN").append("\n  sem_apis.load_into_staging_table(").append("staging_table=>?,").append("source_table=>?,").append("input_format=>'N-QUAD',").append("staging_table_owner=>?").append((String)object2).append(");").append("\n  commit;").append("\nEND;");
                string4 = this.buildBindVarLog(new String[]{this.insertTabName, string2, this.currentSchema});
                if (this.recordInserts) {
                    this.recordString(stringBuffer.toString() + string4, INSERTS_TAB_NAME, 4000);
                }
                UpdateEngine.log("Executing: \n" + stringBuffer + string4, this.debug);
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(stringBuffer.toString());
                oracleCallableStatement.setString(1, this.insertTabName);
                oracleCallableStatement.setString(2, string2);
                oracleCallableStatement.setString(3, this.currentSchema);
                oracleCallableStatement.execute();
                n = oracleCallableStatement.getUpdateCount();
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
                oracleCallableStatement.close();
            }
            if (aSTLoad.jjtGetNumChildren() > 1) {
                string5 = this.extractGraphName((SimpleNode)aSTLoad.jjtGetChild(1));
                UpdateEngine.log("Destination graph:" + string5, this.debug);
                stringBuffer.setLength(0);
                stringBuffer.append("UPDATE ").append(this.insertTabName).append(" SET ").append(GRAPH_COL_NAME).append("=?");
                string4 = this.buildBindVarLog(new String[]{"<" + string5 + ">"});
                UpdateEngine.log("Executing: \n" + stringBuffer + string4, this.debug);
                statement2 = this.conn.prepareStatement(stringBuffer.toString());
                statement2.setString(1, "<" + string5 + ">");
                n = statement2.executeUpdate();
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
            }
            boolean bl2 = false;
            object = "";
            stringBuffer.setLength(0);
            stringBuffer.append("BEGIN").append("\n  sem_apis.bulk_load_from_staging_table(").append("model_name=>?,").append("table_owner=>?,").append("table_name=>?");
            if (this.bulkOptions.length() > 0) {
                stringBuffer.append(",flags =>?");
                object = this.bulkOptions;
                bl2 = true;
            } else if (this.parallel && this.dop > 0) {
                stringBuffer.append(",flags =>?");
                object = " PARALLEL=" + this.dop + " ";
                bl2 = true;
            }
            stringBuffer.append(");\nEND;");
            string4 = this.buildBindVarLog(new String[]{this.applyModel, this.currentSchema, this.insertTabName, object});
            if (this.recordInserts) {
                this.recordString(stringBuffer.toString() + string4, INSERTS_TAB_NAME, 4000);
            }
            UpdateEngine.log("Executing: \n" + stringBuffer + string4, this.debug);
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(stringBuffer.toString());
            oracleCallableStatement.setString(1, this.applyModel);
            oracleCallableStatement.setString(2, this.currentSchema);
            oracleCallableStatement.setString(3, this.insertTabName);
            if (bl2) {
                oracleCallableStatement.setString(4, (String)object);
            }
            oracleCallableStatement.execute();
            n = oracleCallableStatement.getUpdateCount();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
            stringBuffer.setLength(0);
            stringBuffer.append("DROP TABLE ").append(string2);
            UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
            statement = this.conn.createStatement();
            n = statement.executeUpdate(stringBuffer.toString());
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
            statement.close();
            if (bl) {
                stringBuffer.setLength(0);
                stringBuffer.append("DROP DIRECTORY ").append(string3);
                UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
                statement = this.conn.createStatement();
                n = statement.executeUpdate(stringBuffer.toString());
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
            }
        }
        catch (Exception exception) {
            UpdateEngine.log("Error in load: " + exception.getClass().toString() + ": " + exception.getMessage(), this.debug);
            if (!aSTLoad.getSilent()) {
                throw new RDFException(exception.getMessage());
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doClear(SimpleNode simpleNode) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        if (((SimpleNode)simpleNode.jjtGetChild((int)0)).id != 43) {
            throw new ParseException("GraphRefAll expected");
        }
        ASTGraphRefAll aSTGraphRefAll = (ASTGraphRefAll)simpleNode.jjtGetChild(0);
        if (aSTGraphRefAll.jjtGetNumChildren() > 0) {
            String string = ((ASTTripleAtom)aSTGraphRefAll.jjtGetChild((int)0).jjtGetChild((int)0)).name;
            if (!this.doDelAsIns()) {
                String string2 = this.parser.URIs.get(string);
                if (string2 != null) {
                    UpdateEngine.log("Clearing graphID=[" + string2 + "]", this.debug);
                    this.dropGraph(" = " + Long.toString(Long.parseLong(string2)));
                    return;
                } else {
                    UpdateEngine.log("Cannot clear nonexistent graph <" + string + ">", this.debug);
                }
                return;
            } else {
                UpdateEngine.log("Using modify operation to allow delete as insert", this.debug);
                ASTDeleteClause aSTDeleteClause = (ASTDeleteClause)this.getDummyInsOrDelClause(string, false, 1);
                ASTGroupGraphPattern aSTGroupGraphPattern = this.getDummyGroupGraphPattern(string, 1);
                ASTModify aSTModify = new ASTModify(37);
                aSTModify.jjtAddChild(aSTDeleteClause, 0);
                aSTDeleteClause.jjtSetParent(aSTModify);
                aSTModify.jjtAddChild(aSTGroupGraphPattern, 1);
                aSTGroupGraphPattern.jjtSetParent(aSTModify);
                UpdateEngine.log("Transformed Modify Operation:\n", this.debug);
                UpdateEngine.log("\n" + aSTModify.dumpToStr(""), this.debug);
                this.doModify(aSTModify, true);
            }
            return;
        }
        if (aSTGraphRefAll.name.equals("DEFAULT")) {
            UpdateEngine.log("Clearing default graph", this.debug);
            if (!this.doDelAsIns()) {
                this.dropGraph(" = 0");
                return;
            } else {
                UpdateEngine.log("Using modify operation to allow delete as insert", this.debug);
                ASTDeleteClause aSTDeleteClause = (ASTDeleteClause)this.getDummyInsOrDelClause(null, false, 0);
                ASTGroupGraphPattern aSTGroupGraphPattern = this.getDummyGroupGraphPattern(null, 0);
                ASTModify aSTModify = new ASTModify(37);
                aSTModify.jjtAddChild(aSTDeleteClause, 0);
                aSTDeleteClause.jjtSetParent(aSTModify);
                aSTModify.jjtAddChild(aSTGroupGraphPattern, 1);
                aSTGroupGraphPattern.jjtSetParent(aSTModify);
                UpdateEngine.log("Transformed Modify Operation:\n", this.debug);
                UpdateEngine.log("\n" + aSTModify.dumpToStr(""), this.debug);
                this.doModify(aSTModify, true);
            }
            return;
        }
        if (aSTGraphRefAll.name.equals("NAMED")) {
            UpdateEngine.log("Clearing all named graphs", this.debug);
            if (!this.doDelAsIns()) {
                this.dropGraph(" != 0");
                return;
            } else {
                UpdateEngine.log("Using modify operation to allow delete as insert", this.debug);
                ASTDeleteClause aSTDeleteClause = (ASTDeleteClause)this.getDummyInsOrDelClause("G", false, 0);
                ASTGroupGraphPattern aSTGroupGraphPattern = this.getDummyGroupGraphPattern("G", 0);
                ASTModify aSTModify = new ASTModify(37);
                aSTModify.jjtAddChild(aSTDeleteClause, 0);
                aSTDeleteClause.jjtSetParent(aSTModify);
                aSTModify.jjtAddChild(aSTGroupGraphPattern, 1);
                aSTGroupGraphPattern.jjtSetParent(aSTModify);
                UpdateEngine.log("Transformed Modify Operation:\n", this.debug);
                UpdateEngine.log("\n" + aSTModify.dumpToStr(""), this.debug);
                this.doModify(aSTModify, true);
            }
            return;
        }
        if (!aSTGraphRefAll.name.equals("ALL")) throw new ParseException("Unknown clear option");
        UpdateEngine.log("Clearing all graphs", this.debug);
        if (!this.truncateSafe) {
            this.dropGraph("");
            return;
        }
        UpdateEngine.log("Truncating application table", this.debug);
        String string = "TRUNCATE TABLE " + this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName();
        OracleCallableStatement oracleCallableStatement = null;
        try {
            UpdateEngine.log("Executing: \n" + string, this.debug);
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.execute();
            int n = oracleCallableStatement.getUpdateCount();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
            return;
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(SimpleNode simpleNode) throws ParseException, RDFException, SQLException, TypeException, FilterException {
        if (simpleNode.jjtGetNumChildren() < 2) {
            throw new ParseException("Wrong number of children under ADD node");
        }
        if (this.doIdOnlyAdd()) {
            UpdateEngine.log("Match model == apply model: doing id-based insert into application table", this.debug);
            String string = this.getGraphIDString((SimpleNode)simpleNode.jjtGetChild(0), true);
            String string2 = this.getGraphIDString((SimpleNode)simpleNode.jjtGetChild(1), false);
            String string3 = this.getSanitizedModelOwner();
            String string4 = this.getSanitizedAppTabName();
            String string5 = this.getSanitizedAppColName();
            String string6 = "INSERT " + this.getSQLInsertHint() + " INTO " + string3 + "." + string4 + "(" + string5 + ")\n" + "SELECT " + this.getSQLSelectHint() + " mdsys.sdo_rdf_triple_s(s." + string5 + ".rdf_c_id," + string2 + ", s." + string5 + ".rdf_s_id" + ", s." + string5 + ".rdf_p_id" + ", s." + string5 + ".rdf_o_id)\n" + "FROM " + string3 + "." + string4 + " s\n" + "WHERE s.rowid in (select t.rowid from " + string3 + "." + string4 + " t\n" + "WHERE " + this.tripleGraphToIDString("t", string5) + " = " + string + ")";
            Statement statement = null;
            try {
                UpdateEngine.log("Executing: \n" + string6, this.debug);
                statement = this.conn.createStatement();
                int n = statement.executeUpdate(string6.toString());
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
                }
            }
        }
        if (this.matchModels.length != 1 || !this.applyModel.equals(this.matchModels[0])) {
            UpdateEngine.log("Match model =/= apply model: doing modfiy operation", this.debug);
        } else {
            UpdateEngine.log("Match model == apply model, but using modify operation to allow bulk load and hints", this.debug);
        }
        ASTInsertClause aSTInsertClause = (ASTInsertClause)this.getDummyInsOrDelClause(this.extractGraphName((ASTGraphOrDefault)simpleNode.jjtGetChild(1)), true, 1);
        ASTGroupGraphPattern aSTGroupGraphPattern = this.getDummyGroupGraphPattern(this.extractGraphName((ASTGraphOrDefault)simpleNode.jjtGetChild(0)), 1);
        ASTModify aSTModify = new ASTModify(37);
        aSTModify.jjtAddChild(aSTInsertClause, 0);
        aSTInsertClause.jjtSetParent(aSTModify);
        aSTModify.jjtAddChild(aSTGroupGraphPattern, 1);
        aSTGroupGraphPattern.jjtSetParent(aSTModify);
        UpdateEngine.log("Transformed Modify Operation:\n", this.debug);
        UpdateEngine.log("\n" + aSTModify.dumpToStr(""), this.debug);
        this.doModify(aSTModify, true);
    }

    private void doMove(ASTMove aSTMove) throws ParseException, RDFException, SQLException, TypeException, FilterException {
        if (aSTMove.jjtGetNumChildren() < 2) {
            throw new ParseException("Wrong number of children under MOVE node");
        }
        String string = this.getGraphIDString((SimpleNode)aSTMove.jjtGetChild(0), true);
        String string2 = this.getGraphIDString((SimpleNode)aSTMove.jjtGetChild(1), true);
        UpdateEngine.log("From graph=[" + string + "] destination graph=[" + string2 + "]", this.debug);
        if (!string.equals(string2) || this.matchModels.length != 1 || !this.applyModel.equals(this.matchModels[0])) {
            UpdateEngine.log("Dropping destination graph", this.debug);
            this.dropGraph(" = " + string2);
            UpdateEngine.log("Adding from graph to destination graph", this.debug);
            this.doAdd(aSTMove);
            if (this.updateSameModel()) {
                UpdateEngine.log("Dropping from graph", this.debug);
                this.dropGraph(" = " + string);
            } else {
                UpdateEngine.log("Match model =/= apply model: do not drop source graph", this.debug);
            }
        }
    }

    private void doCopy(ASTCopy aSTCopy) throws ParseException, RDFException, SQLException, TypeException, FilterException {
        if (aSTCopy.jjtGetNumChildren() < 2) {
            throw new ParseException("Wrong number of children under COPY node");
        }
        String string = this.getGraphIDString((SimpleNode)aSTCopy.jjtGetChild(0), true);
        String string2 = this.getGraphIDString((SimpleNode)aSTCopy.jjtGetChild(1), true);
        UpdateEngine.log("From graph=[" + string + "] destination graph=[" + string2 + "]", this.debug);
        if (!string.equals(string2) || this.matchModels.length != 1 || !this.applyModel.equals(this.matchModels[0])) {
            UpdateEngine.log("Dropping destination graph", this.debug);
            this.dropGraph(" = " + string2);
            UpdateEngine.log("Adding from graph to destination graph", this.debug);
            this.doAdd(aSTCopy);
        }
    }

    private void doCreate() {
        UpdateEngine.log("Create called ...not supported", this.debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertData(ASTInsertData aSTInsertData) throws ParseException, RDFException, SQLException {
        if (((SimpleNode)aSTInsertData.jjtGetChild((int)0)).id != 45) {
            throw new ParseException("Quad data expected");
        }
        ASTQuadData aSTQuadData = (ASTQuadData)aSTInsertData.jjtGetChild(0);
        PreparedStatement preparedStatement = null;
        String string = "INSERT INTO " + this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName() + "(" + this.getSanitizedAppColName() + ") VALUES" + "(sdo_rdf_triple_s(?,?,?,?,?))";
        ArrayList<Clob> arrayList = new ArrayList<Clob>();
        try {
            preparedStatement = this.conn.prepareStatement(string);
            this.conn.setAutoCommit(false);
            UpdateEngine.log("Dumping INSERT DATA", this.debug);
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.debug) {
                stringBuffer.append("\n[RDF$STC_GRAPH, RDF$STC_SUC, RDF$STC_PRED, RDF$STC_OBJ]").append("\n=======================================================");
            }
            for (int i = 0; i < aSTQuadData.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTQuadData.jjtGetChild(i);
                ASTTriplesBlock aSTTriplesBlock = null;
                StringBuffer stringBuffer2 = new StringBuffer(this.applyModel);
                if (simpleNode.id == 46) {
                    ASTQuadsNotTriples aSTQuadsNotTriples = (ASTQuadsNotTriples)simpleNode;
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)aSTQuadsNotTriples.jjtGetChild(0);
                    this.checkQuadElement(aSTTripleAtom, 0);
                    stringBuffer2.append(":<").append(aSTTripleAtom.name).append(">");
                    aSTTriplesBlock = (ASTTriplesBlock)aSTQuadsNotTriples.jjtGetChild(1);
                } else if (simpleNode.id == 47) {
                    aSTTriplesBlock = (ASTTriplesBlock)simpleNode;
                }
                this.addTBToInsert(preparedStatement, aSTTriplesBlock, stringBuffer2.toString(), arrayList);
                if (!this.debug) continue;
                this.dumpQuad(stringBuffer2.toString(), aSTTriplesBlock, stringBuffer, this.debug);
            }
            if (this.debug) {
                stringBuffer.append("\n=======================================================");
            }
            UpdateEngine.log(stringBuffer.toString(), this.debug);
            preparedStatement.executeBatch();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
            }
            this.cleanupClobs(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeleteData(ASTDeleteData aSTDeleteData) throws ParseException, RDFException, SQLException {
        if (((SimpleNode)aSTDeleteData.jjtGetChild((int)0)).id != 45) {
            throw new ParseException("Quad data expected");
        }
        ASTQuadData aSTQuadData = (ASTQuadData)aSTDeleteData.jjtGetChild(0);
        PreparedStatement preparedStatement = null;
        String string = this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName();
        String string2 = this.getSanitizedAppColName();
        String string3 = "DELETE FROM " + string + " WHERE rowid IN (" + " select " + this.getSanitizedAppIdxHint() + " s.rowid " + " from " + string + " s" + " where (" + "  " + this.tripleGraphToIDString("s", string2) + ", " + "  s." + string2 + ".rdf_s_id, s." + string2 + ".rdf_p_id, s." + string2 + ".rdf_c_id) " + " in((NVL2(?,sem_apis.res2vid('MDSYS.RDF_VALUE$',?, null, null),0)," + " sem_apis.res2vid('MDSYS.RDF_VALUE$',?,null,null)," + " sem_apis.res2vid('MDSYS.RDF_VALUE$',?,null,null)," + " sem_apis.res2vid('MDSYS.RDF_VALUE$',?,?,?,?))))";
        if (this.recordDeletes) {
            this.recordString(string3, DELETES_TAB_NAME, 4000);
        }
        ArrayList<Clob> arrayList = new ArrayList<Clob>();
        try {
            preparedStatement = this.conn.prepareStatement(string3);
            this.conn.setAutoCommit(false);
            UpdateEngine.log("Dumping DELETE DATA", this.debug);
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.debug) {
                stringBuffer.append("\n[RDF$STC_GRAPH, RDF$STC_SUC, RDF$STC_PRED, RDF$STC_OBJ]").append("\n=======================================================");
            }
            for (int i = 0; i < aSTQuadData.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTQuadData.jjtGetChild(i);
                ASTTriplesBlock aSTTriplesBlock = null;
                String string4 = "";
                if (simpleNode.id == 46) {
                    ASTQuadsNotTriples aSTQuadsNotTriples = (ASTQuadsNotTriples)simpleNode;
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)aSTQuadsNotTriples.jjtGetChild(0);
                    this.checkQuadElement(aSTTripleAtom, 0);
                    string4 = "<" + aSTTripleAtom.name + ">";
                    aSTTriplesBlock = (ASTTriplesBlock)aSTQuadsNotTriples.jjtGetChild(1);
                } else if (simpleNode.id == 47) {
                    aSTTriplesBlock = (ASTTriplesBlock)simpleNode;
                }
                this.addTBToDelete(preparedStatement, aSTTriplesBlock, string4, arrayList);
                if (!this.debug) continue;
                this.dumpQuad(string4, aSTTriplesBlock, stringBuffer, this.debug);
            }
            if (this.debug) {
                stringBuffer.append("\n=======================================================");
            }
            UpdateEngine.log(stringBuffer.toString(), this.debug);
            preparedStatement.executeBatch();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
            }
            this.cleanupClobs(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeleteWhere(ASTDeleteWhere aSTDeleteWhere) throws ParseException, RDFException, SQLException, TypeException, FilterException {
        if (!this.inStream) {
            UpdateEngine.log("Cleaning up temporary tables", this.debug);
            this.cleanupTemporaryTables(this.bulkSafe);
        }
        ASTConstructQuery aSTConstructQuery = UpdateEngine.genConstructQuery((ASTQuadPattern)aSTDeleteWhere.jjtGetChild(0), null, "");
        int n = 0;
        boolean bl = false;
        if (this.doDelAsIns()) {
            n = n | 0x800 | 0x1000;
            bl = true;
        }
        String string = this.buildSQLfromSPARQL((SimpleNode)aSTConstructQuery.jjtGetParent(), aSTConstructQuery, "", null, n, true, bl, true);
        UpdateEngine.log("Performing DELETE WHERE", this.debug);
        if (!this.inStream) {
            if (this.doDelAsIns()) {
                UpdateEngine.log("Creating transient insert id table", this.debug);
                String string2 = this.createTransientIdTable();
                this.populateIDTable(string2, string);
                this.performDelete(string2);
            } else {
                this.populateTable(string, 38, false);
                this.performDelete("");
            }
        } else {
            try {
                UpdateEngine.log("Populating result set", this.debug);
                this.populateResultSet(string, 38, false);
                this.performDeleteFromRS();
            }
            finally {
                try {
                    if (this.deleteRS != null) {
                        this.deleteRS.close();
                    }
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing delete RS:" + sQLException.getMessage(), this.debug);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doModify(ASTModify aSTModify, boolean bl) throws ParseException, RDFException, SQLException, TypeException, FilterException {
        if (!this.inStream) {
            UpdateEngine.log("Cleaning up temporary tables", this.debug);
            this.cleanupTemporaryTables(this.bulkSafe);
        }
        int n = 0;
        if (bl) {
            n |= 0x200;
        }
        Set<String> set = this.extractTemplateVars(aSTModify, true);
        int n2 = aSTModify.jjtGetNumChildren();
        if (((SimpleNode)aSTModify.jjtGetChild((int)(n2 - 1))).id != 48) {
            throw new ParseException("Group graph pattern expected");
        }
        ASTGroupGraphPattern aSTGroupGraphPattern = (ASTGroupGraphPattern)aSTModify.jjtGetChild(n2 - 1);
        SparqlSourceDescriptor sparqlSourceDescriptor = aSTModify.getsourceDesc();
        ASTSelectQuery aSTSelectQuery = UpdateEngine.whereToSelectQuery(aSTGroupGraphPattern.cloneSubTree(), sparqlSourceDescriptor);
        if (this.checkMMSafe()) {
            this.mmSafe = this.isMMSafe(aSTSelectQuery, set, sparqlSourceDescriptor);
        }
        UpdateEngine.log("mmSafe=[" + this.mmSafe + "]", this.debug);
        if (this.doMergeModels()) {
            set = this.extractTemplateVars(aSTModify, false);
        }
        String string = this.buildSQLfromSPARQL(aSTSelectQuery, aSTSelectQuery, "", set, n, false, bl || this.disableMMValidity || this.doDelAsIns(), true);
        if (this.recordBindings) {
            this.recordLongString(string, BINDINGS_TAB_NAME, 4000);
        }
        String string2 = null;
        if (!this.inStream) {
            UpdateEngine.log("Creating transient bindings table", this.debug);
            String string3 = this.createTransientTable(aSTSelectQuery.getselDesc(), string);
            string2 = "select * from " + string3;
            if (this.safeForHints) {
                this.conn.commit();
                UpdateEngine.log("Committing to be able to read from transient table", this.debug);
            }
        } else {
            UpdateEngine.log("Skipping bindings table creation", this.debug);
            string2 = string;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = "";
        try {
            for (int i = 0; i < n2 - 1; ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTModify.jjtGetChild(i);
                if (simpleNode.id == 38 || simpleNode.id == 39) {
                    ASTConstructQuery aSTConstructQuery = null;
                    if (simpleNode.id == 38) {
                        bl2 = true;
                        aSTConstructQuery = UpdateEngine.genConstructQuery((ASTQuadPattern)simpleNode.jjtGetChild(0).cloneSubTree(), (ASTGroupGraphPattern)aSTGroupGraphPattern.cloneSubTree(), aSTModify.getsourceDesc().getWithGraph());
                    }
                    if (simpleNode.id == 39) {
                        bl3 = true;
                        aSTConstructQuery = UpdateEngine.genConstructQuery((ASTQuadPattern)simpleNode.jjtGetChild(0).cloneSubTree(), aSTGroupGraphPattern, aSTModify.getsourceDesc().getWithGraph());
                    }
                    n = 0;
                    if (this.doDelAsIns()) {
                        n = n | 0x800 | 0x1000;
                    } else if (this.doMergeModels()) {
                        n |= 0x800;
                        if (!bl && !this.disableMMValidity) {
                            n |= 0x400;
                        }
                        n |= 0x1000;
                    } else {
                        if (!this.disableTripleDup && !this.clobSupport) {
                            n |= 0x800;
                        }
                        if (!this.disableTripleValidity) {
                            n |= 0x400;
                        }
                    }
                    String string5 = this.buildSQLfromSPARQL((SimpleNode)aSTConstructQuery.jjtGetParent(), aSTConstructQuery, string2, null, n, true, true, false);
                    if (!this.inStream) {
                        if (this.doMergeModels() || this.doDelAsIns()) {
                            UpdateEngine.log("Creating transient insert id table", this.debug);
                            string4 = this.createTransientIdTable();
                            this.populateIDTable(string4, string5);
                            continue;
                        }
                        UpdateEngine.log("Populating temporary INSERT/DELETE table", this.debug);
                        this.populateTable(string5, simpleNode.id, simpleNode.id == 39);
                        continue;
                    }
                    UpdateEngine.log("Populating result set", this.debug);
                    this.populateResultSet(string5, simpleNode.id, simpleNode.id == 39);
                    continue;
                }
                if (simpleNode.id == 40) continue;
                throw new RDFException("Unexpected child node under ASTModify");
            }
            if (!this.inStream) {
                if (bl2) {
                    this.performDelete(string4);
                }
                if (bl3) {
                    this.performInsert(string4);
                }
            } else {
                if (bl2) {
                    this.performDeleteFromRS();
                }
                if (bl3) {
                    this.performInsertFromRS();
                }
            }
        }
        finally {
            try {
                if (this.deleteRS != null) {
                    this.deleteRS.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing delete RS:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (this.insertRS != null) {
                    this.insertRS.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing insert RS:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransction() throws SQLException, RDFException {
        UpdateEngine.log("Setting Transaction", this.debug);
        String string = "";
        if (this.isoLevel.equals(READ_COMMITTED)) {
            string = READ_COMMITTED;
        } else if (this.isoLevel.equals(SERIALIZABLE)) {
            string = SERIALIZABLE;
        } else {
            throw new RDFException(BAD_ISO_VALUE + this.isoLevel);
        }
        String string2 = "SET TRANSACTION ISOLATION LEVEL " + string;
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + string2, this.debug);
            statement = this.conn.createStatement();
            int n = statement.executeUpdate(string2);
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private boolean isMMSafe(Node node, Set<String> set, SparqlSourceDescriptor sparqlSourceDescriptor) throws ParseException, RDFException, FilterException, SQLException, TypeException {
        UpdateEngine.log("Checking isMMSafe", this.debug);
        Set<String> set2 = Collections.emptySet();
        Set<String> set3 = Collections.emptySet();
        SPARQLTreeNode sPARQLTreeNode = SPARQLEngine.buildSPARQLTree(node, this.ctx, null, set2, set3, null);
        Set<String> set4 = sPARQLTreeNode.getAllLexVars();
        if (this.debug) {
            StringBuffer stringBuffer = new StringBuffer("");
            UpdateEngine.dumpCollection(set, stringBuffer);
            UpdateEngine.log("  neededVars=" + stringBuffer.toString(), this.debug);
            stringBuffer.delete(0, stringBuffer.length());
            UpdateEngine.dumpCollection(set4, stringBuffer);
            UpdateEngine.log("  lexVars=" + stringBuffer.toString(), this.debug);
        }
        return !QueryUtils.containsAny(set, set4);
    }

    private static ASTSelectQuery whereToSelectQuery(Node node, SparqlSourceDescriptor sparqlSourceDescriptor) throws ParseException {
        List<Node> list = Collections.emptyList();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        ASTSelectQuery aSTSelectQuery = OptimizerUtils.genSelectQuery(arrayList, list, false, null);
        aSTSelectQuery.getselDesc().setIsTopSelect(true);
        if (sparqlSourceDescriptor != null) {
            if (sparqlSourceDescriptor.getDefaultGraphs().size() == 0 && sparqlSourceDescriptor.getWithGraph() != null) {
                sparqlSourceDescriptor.addDefaultGraph("<" + sparqlSourceDescriptor.getWithGraph() + ">");
                sparqlSourceDescriptor.setDefaultFromWith(true);
            }
            aSTSelectQuery.setsourceDesc(sparqlSourceDescriptor);
        }
        return aSTSelectQuery;
    }

    private static ASTConstructQuery genConstructQuery(SimpleNode simpleNode, ASTGroupGraphPattern aSTGroupGraphPattern, String string) {
        SimpleNode simpleNode2;
        ASTConstructQuery aSTConstructQuery = new ASTConstructQuery(10);
        SparqlSelectDescriptor sparqlSelectDescriptor = new SparqlSelectDescriptor();
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 0;
        aSTTripleAtom.name = "SUBJ";
        ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
        aSTTripleAtom2.type = 0;
        aSTTripleAtom2.name = "PRED";
        ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
        aSTTripleAtom3.type = 0;
        aSTTripleAtom3.name = "OBJ";
        ASTTripleAtom aSTTripleAtom4 = new ASTTripleAtom(73);
        aSTTripleAtom4.type = 0;
        aSTTripleAtom4.name = "GRAPH";
        sparqlSelectDescriptor.addSelection(aSTTripleAtom, null);
        sparqlSelectDescriptor.addSelection(aSTTripleAtom2, null);
        sparqlSelectDescriptor.addSelection(aSTTripleAtom3, null);
        sparqlSelectDescriptor.addSelection(aSTTripleAtom4, null);
        sparqlSelectDescriptor.setIsTopSelect(true);
        aSTConstructQuery.setselDesc(sparqlSelectDescriptor);
        if (aSTGroupGraphPattern != null) {
            simpleNode2 = new ASTConstructTemplate(59);
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (string != null && simpleNode3.id == 47) {
                    ASTQuadsNotTriples aSTQuadsNotTriples = new ASTQuadsNotTriples(46);
                    ASTTripleAtom aSTTripleAtom5 = new ASTTripleAtom(73);
                    aSTTripleAtom5.type = 1;
                    aSTTripleAtom5.name = string;
                    aSTTripleAtom5.jjtSetParent(aSTQuadsNotTriples);
                    aSTQuadsNotTriples.jjtAddChild(aSTTripleAtom5, 0);
                    aSTQuadsNotTriples.jjtAddChild(simpleNode3, 1);
                    simpleNode3.jjtSetParent(aSTQuadsNotTriples);
                    simpleNode2.jjtAddChild(aSTQuadsNotTriples, i);
                    aSTQuadsNotTriples.jjtSetParent(simpleNode2);
                    continue;
                }
                simpleNode2.jjtAddChild(simpleNode3, i);
                simpleNode3.jjtSetParent(simpleNode2);
            }
            aSTConstructQuery.jjtAddChild(simpleNode2, 0);
            simpleNode2.jjtSetParent(aSTConstructQuery);
            aSTConstructQuery.jjtAddChild(aSTGroupGraphPattern, 1);
            aSTGroupGraphPattern.jjtSetParent(aSTConstructQuery);
        } else {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(i);
                aSTConstructQuery.jjtAddChild(simpleNode4, i);
                simpleNode4.jjtSetParent(aSTConstructQuery);
            }
        }
        simpleNode2 = new ASTFullSparqlQuery(5);
        simpleNode2.jjtAddChild(aSTConstructQuery, 0);
        aSTConstructQuery.jjtSetParent(simpleNode2);
        return aSTConstructQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphsInfo processGraphs(String string, String[] stringArray, String[] stringArray2) throws SQLException, RDFException {
        UpdateEngine.log("Processing graphs", this.debug);
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall("begin  mdsys.sdo_rdf.processGraphs(?,?,?,?,?,?,?,?); end;");
            ARRAY aRRAY = new ARRAY(SQLEntryPoints.rdfgDesc, this.conn, (Object)stringArray);
            ARRAY aRRAY2 = new ARRAY(SQLEntryPoints.rdfgDesc, this.conn, (Object)stringArray2);
            int n = 0;
            oracleCallableStatement.setArray(1, (Array)aRRAY);
            oracleCallableStatement.setArray(2, (Array)aRRAY2);
            oracleCallableStatement.setString(3, string);
            oracleCallableStatement.registerOutParameter(4, 2003, "SYS.ODCINUMBERLIST");
            oracleCallableStatement.registerOutParameter(5, 2003, "SYS.ODCINUMBERLIST");
            oracleCallableStatement.registerOutParameter(6, 2003, "MDSYS.RDF_MODELS");
            oracleCallableStatement.registerOutParameter(7, 2003, "SYS.ODCINUMBERLIST");
            oracleCallableStatement.setInt(8, n);
            oracleCallableStatement.registerOutParameter(8, 4);
            oracleCallableStatement.execute();
            GraphsInfo graphsInfo = new GraphsInfo();
            graphsInfo.dgids = SQLEntryPoints.getlongArray(oracleCallableStatement.getARRAY(4));
            graphsInfo.ngids = SQLEntryPoints.getlongArray(oracleCallableStatement.getARRAY(5));
            graphsInfo.dmodels = SQLEntryPoints.getStringArray(oracleCallableStatement.getARRAY(6));
            graphsInfo.dmids = SQLEntryPoints.getlongArray(oracleCallableStatement.getARRAY(7));
            graphsInfo.flag = oracleCallableStatement.getInt(8);
            oracleCallableStatement.close();
            UpdateEngine.log(graphsInfo.dump(), this.debug);
            GraphsInfo graphsInfo2 = graphsInfo;
            return graphsInfo2;
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private int[] fillPList(SparqlSelectDescriptor sparqlSelectDescriptor, boolean bl, boolean bl2, boolean bl3, Collection<String> collection) {
        UpdateEngine.log("Building PID list", this.debug);
        if (this.debug && collection != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            UpdateEngine.dumpArray(collection.toArray(new String[0]), stringBuffer);
            UpdateEngine.log("includeVars=" + stringBuffer.toString(), this.debug);
        }
        int n = 8;
        if (bl) {
            n = 9;
        }
        if (bl2) {
            n = 10;
        }
        List<String> list = sparqlSelectDescriptor.getSelectList();
        int n2 = list.size();
        int[] nArray = new int[n * n2 + 1];
        int n3 = 0;
        int n4 = 0;
        for (String string : list) {
            boolean bl4 = collection == null || collection.contains(string);
            UpdateEngine.log("  var=[" + string + "] include=[" + bl4 + "]", this.debug);
            if (bl4) {
                if ((this.doMergeModels() || this.doDelAsIns()) && bl3) {
                    nArray[n4] = n3 * n + 1;
                    ++n4;
                } else {
                    for (int i = 0; i < n; ++i) {
                        nArray[n4] = n3 * n + i;
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        nArray[n4] = n3 * n;
        Object object = new int[++n4];
        for (int i = 0; i < n4; ++i) {
            object[i] = nArray[i];
        }
        StringBuffer stringBuffer = new StringBuffer("");
        UpdateEngine.dumpArray((int[])object, stringBuffer);
        UpdateEngine.log("PIDs: " + stringBuffer.toString(), this.debug);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTransientTableName() throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall("begin  select 'RDF$UPD' || lpad(to_char(mod(sys_context('USERENV','SESSION_USERID'),65535),'FMXXXX'),4,0) || '$' || lpad(to_char(mod(sys_op_combined_hash(sys_guid()),18446744073709551615),'FMXXXXXXXXXXXXXXXX'),18,'0')  into ?  from dual; end;");
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.execute();
            String string = this.getSanitizedTabName(oracleCallableStatement.getString(1));
            UpdateEngine.log("Generated transient table name: [" + string + "]", this.debug);
            String string2 = string;
            return string2;
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private void setupSQLContext() throws SQLException {
        this.parser.URIs.resolve(this.conn);
        if (this.matchOptions.indexOf("OPT_SAMEAS=T") != -1) {
            this.parser.URIs.updateToCanonicalIDs(this.conn, this.precompIdx);
        }
        this.parser.literals.resolve(this.conn);
        this.ctx = new SQLGenContext();
        this.ctx.srcTabName = "BASIC_TRIPLES";
        this.ctx.URImap = this.parser.URIs;
        this.ctx.varMap = this.parser.variables;
        this.ctx.litMap = this.parser.literals;
        this.ctx.models = this.matchModels;
        this.ctx.isRdfVWModel = this.isRdfVWModel == 1;
        this.ctx.queryOptions = this.matchOptions;
        if (this.parser.baseURISet) {
            this.ctx.baseURI = this.parser.baseURI.getBaseURI();
            this.ctx.baseURIset = 1;
        }
    }

    private String buildSQLfromSPARQL(SimpleNode simpleNode, ASTTopLevelQueryNode aSTTopLevelQueryNode, String string, Collection<String> collection, int n, boolean bl, boolean bl2, boolean bl3) throws ParseException, RDFException, FilterException, SQLException, TypeException {
        SparqlSourceDescriptor sparqlSourceDescriptor = aSTTopLevelQueryNode.getsourceDesc();
        GraphsInfo graphsInfo = null;
        graphsInfo = bl3 ? this.processGraphs(this.precompIdx, sparqlSourceDescriptor.getDefaultGraphs().toArray(new String[0]), sparqlSourceDescriptor.getNamedGraphs().toArray(new String[0])) : new GraphsInfo();
        int n2 = graphsInfo.flag;
        if (sparqlSourceDescriptor.getDefaultFromWith()) {
            n2 |= 0x100;
        }
        if (!this.projExact) {
            n2 |= 0x2000;
        }
        UpdateEngine.log("buildSQLfromSPARQL flag=[" + (n2 |= n) + "]", this.debug);
        SPARQLEngine.setQueryOptions(this.ctx, n2);
        SPARQLEngine.setTripleRowSources(this.ctx, this.matchModels, this.precompIdx, this.precompIdxId, this.matchIndexStatus, this.vmViewName, graphsInfo.dgids, graphsInfo.ngids, graphsInfo.dmids, graphsInfo.dmodels, n2);
        return SPARQLEngine.translateSPARQL(this.ctx, simpleNode, aSTTopLevelQueryNode, this.fillPList(aSTTopLevelQueryNode.getselDesc(), true, bl, bl2, collection), string);
    }

    private String getTablespaceClause() throws SQLException {
        String string = "";
        if (this.rdfTablespace != null) {
            string = " tablespace " + this.getSanitizedTabName(this.rdfTablespace) + " ";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTransientTable(SparqlSelectDescriptor sparqlSelectDescriptor, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("(");
        String[] stringArray = sparqlSelectDescriptor.returnVDollarSignature(true, true);
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(" ").append(this.getSanitizedTabName(stringArray[i + 1]));
            if (stringArray[i].equals("VC")) {
                stringBuffer.append(" VARCHAR2(").append(4000).append(")");
                continue;
            }
            if (stringArray[i].equals("VC3")) {
                stringBuffer.append(" VARCHAR2(3)");
                continue;
            }
            if (stringArray[i].equals("NU")) {
                stringBuffer.append(" NUMBER");
                continue;
            }
            if (!stringArray[i].equals("CL")) continue;
            stringBuffer.append(" CLOB");
        }
        stringBuffer.append(")");
        String string2 = this.getTransientTableName();
        StringBuffer stringBuffer2 = new StringBuffer("DECLARE\n");
        stringBuffer2.append("  PRAGMA AUTONOMOUS_TRANSACTION;\n").append("BEGIN\n").append("  EXECUTE IMMEDIATE\n").append("    'CREATE TABLE ").append(string2).append(stringBuffer).append(this.getTablespaceClause()).append("';\n").append("END;");
        OracleCallableStatement oracleCallableStatement = null;
        try {
            UpdateEngine.log("Executing: \n" + stringBuffer2, this.debug);
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(stringBuffer2.toString());
            oracleCallableStatement.execute();
            int n = oracleCallableStatement.getUpdateCount();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
        this.transientTables.add(string2);
        String string3 = "";
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i > 0) {
                string3 = string3 + ",";
            }
            string3 = string3 + " " + this.getSanitizedTabName(stringArray[i + 1]);
        }
        StringBuffer stringBuffer3 = new StringBuffer("INSERT").append(this.getSQLInsertHint()).append(" INTO ").append(string2).append("\n").append(" SELECT ").append(this.getSQLSelectHint()).append(" ").append(string3).append(" FROM (").append(string).append(")");
        if (this.recordInserts) {
            this.recordString(stringBuffer3.toString(), INSERTS_TAB_NAME, 1000);
        }
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + stringBuffer3, this.debug);
            statement = this.conn.createStatement();
            int n = statement.executeUpdate(stringBuffer3.toString());
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTransientTable(String string) throws SQLException {
        String string2 = this.getSanitizedTabName(string);
        String string3 = "DROP TABLE " + string2 + " PURGE";
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + string3, this.debug);
            statement = this.conn.createStatement();
            int n = statement.executeUpdate(string3);
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing stmt: " + sQLException.getMessage(), this.debug);
            }
        }
    }

    private void dropTransientTables() throws SQLException {
        for (String string : this.transientTables) {
            this.dropTransientTable(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEmptyTable(String string) throws SQLException, RDFException {
        Statement statement = null;
        ResultSet resultSet = null;
        long l = 0L;
        try {
            statement = this.conn.createStatement();
            String string2 = this.getSanitizedTabName(string);
            String string3 = "select count(*) from (" + string2 + ") " + "where rownum < 2";
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            UpdateEngine.log("Checking empty table: tabName=[" + string + "] count=[" + l + "]", this.debug);
            if (l > 0L) {
                throw new RDFException("Table " + string + " is not empty, truncate or " + "use RESUME_LOAD=T flag in case of interrupted load");
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing RS:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTableNotExists(String string) throws SQLException, RDFException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long l = 0L;
        try {
            String string2 = "select count(*) from user_tables where table_name = ?";
            preparedStatement = this.conn.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            UpdateEngine.log("Checking table does not exist: tabName=[" + string + "] count=[" + l + "]", this.debug);
            if (l > 0L) {
                throw new RDFException("Table " + string + " already exists, drop or " + "use RESUME_LOAD=T flag in case of interrupted load");
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing RS:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private void cleanupTemporaryTables(boolean bl) throws SQLException, RDFException {
        String string = "";
        String string2 = this.getSanitizedTabName(this.deleteTabName);
        String string3 = this.getSanitizedTabName(this.insertTabName);
        if (bl) {
            UpdateEngine.log("Truncating temporary tables", this.debug);
            string = "BEGIN\n  execute immediate " + this.getSanitizedLiteral("TRUNCATE TABLE " + string2) + ";\n" + "  execute immediate " + this.getSanitizedLiteral("TRUNCATE TABLE " + string3) + ";\n" + "END;";
        } else {
            UpdateEngine.log("Deleting temporary tables", this.debug);
            string = "BEGIN\n  DELETE " + string2 + ";\n" + "  DELETE " + string3 + ";\n" + "END;";
        }
        OracleCallableStatement oracleCallableStatement = null;
        try {
            UpdateEngine.log("Executing: \n" + string, this.debug);
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.execute();
            int n = oracleCallableStatement.getUpdateCount();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        catch (SQLException sQLException) {
            if (this.isMissingTabsException(sQLException)) {
                throw new RDFException(MISSING_TEMPORARY_TABS);
            }
            throw sQLException;
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTable(String string, int n, boolean bl) throws SQLException {
        String string2 = "";
        if (n == 38) {
            string2 = this.getSanitizedTabName(this.deleteTabName);
        } else if (n == 39) {
            string2 = this.getSanitizedTabName(this.insertTabName);
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT").append(this.getSQLInsertHint()).append(" INTO ").append(string2).append("(").append(GRAPH_COL_NAME).append(",").append(SUB_COL_NAME).append(",").append(PRED_COL_NAME).append(",").append(OBJ_COL_NAME);
        StringBuffer stringBuffer2 = new StringBuffer("SUBJ$RDFTERM");
        StringBuffer stringBuffer3 = new StringBuffer("OBJ$RDFTERM");
        if (this.clobSupport) {
            stringBuffer.append(",").append(CLOB_COL_NAME);
        }
        if (bl) {
            stringBuffer2 = new StringBuffer("decode(substr(SUBJ$RDFTERM,1,3),");
            stringBuffer2.append("'_:m', '_:'||substr(SUBJ$RDFTERM,(instr(SUBJ$RDFTERM, 'm',1,2)+1)),").append("SUBJ$RDFTERM)");
            stringBuffer3 = new StringBuffer("decode(substr(OBJ$RDFTERM,1,3),");
            stringBuffer3.append("'_:m', '_:'||substr(OBJ$RDFTERM,(instr(OBJ$RDFTERM, 'm',1,2)+1)),").append("OBJ$RDFTERM)");
        }
        stringBuffer.append(") SELECT ").append(this.getSQLSelectHint()).append(" GRAPH$RDFTERM,").append(stringBuffer2).append(",PRED$RDFTERM,").append(stringBuffer3);
        if (this.clobSupport) {
            stringBuffer.append(",NVL2(OBJ$RDFCLOB,OBJ$RDFCLBT,OBJ$RDFCLOB)");
        }
        stringBuffer.append(" FROM (").append(string).append(")");
        if (this.recordInserts) {
            this.recordString(stringBuffer.toString(), INSERTS_TAB_NAME, 1000);
        }
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
            statement = this.conn.createStatement();
            int n2 = statement.executeUpdate(stringBuffer.toString());
            UpdateEngine.log("Number of rows affected: " + n2, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
        if (this.safeForHints) {
            this.conn.commit();
            UpdateEngine.log("Committing to be able to read from temporary table", this.debug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTransientIdTable() throws SQLException {
        String string = this.getTransientTableName();
        String string2 = "DECLARE\n  PRAGMA AUTONOMOUS_TRANSACTION;\nBEGIN\n  EXECUTE IMMEDIATE\n    " + this.getSanitizedLiteral("CREATE TABLE " + string + "(\n" + "       " + P_VALUE_ID + "            NUMBER NOT NULL\n" + "     , " + START_NODE_ID + "         NUMBER\n" + "     , " + CANON_END_NODE_ID + "     NUMBER\n" + "     , " + END_NODE_ID + "           NUMBER\n" + "     , " + MODEL_ID + "              NUMBER\n" + "     , " + COST + "                  NUMBER\n" + "     , " + CTXT1 + "                 NUMBER\n" + "     , " + CTXT2 + "                 VARCHAR2(4000)\n" + "     , " + DISTANCE + "              NUMBER\n" + "     , " + EXPLAIN + "               VARCHAR2(4000)\n" + "     , " + PATH + "                  VARCHAR2(4000)\n" + "     , " + G_ID + "                  NUMBER\n" + "     )\n" + "    " + this.getTablespaceClause() + "\n" + "    COMPRESS") + ";\n" + "\n\n" + "  EXECUTE IMMEDIATE\n" + "    " + this.getSanitizedLiteral("ALTER TABLE " + string + " add\n" + "     (" + LINK_ID + " as (\n" + "       to_char(" + MODEL_ID + ",         'FMXXXXXXXXXXXXXXXX') ||\n" + "       (CASE when " + G_ID + " IS NOT NULL then\n" + "                  'g'|| to_char(" + G_ID + ",  'FMXXXXXXXXXXXXXXXX')\n" + "             else NULL\n" + "        END)                                             ||'_'||\n" + "       to_char(" + START_NODE_ID + ",    'FMXXXXXXXXXXXXXXXX') ||'_'||\n" + "       to_char(" + P_VALUE_ID + ",       'FMXXXXXXXXXXXXXXXX') ||'_'||\n" + "       to_char(" + CANON_END_NODE_ID + ",'FMXXXXXXXXXXXXXXXX')))") + ";\n" + "\n\n" + " EXECUTE IMMEDIATE\n" + "   " + this.getSanitizedLiteral("GRANT SELECT ON " + string + " TO MDSYS") + ";\n" + "END;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            UpdateEngine.log("Executing: \n" + string2, this.debug);
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.execute();
            int n = oracleCallableStatement.getUpdateCount();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
        this.transientTables.add(string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIDTable(String string, String string2) throws SQLException {
        String string3 = "INSERT " + this.getSQLInsertHint() + " INTO " + string + "(" + P_VALUE_ID + "," + START_NODE_ID + "," + CANON_END_NODE_ID + "," + END_NODE_ID + "," + MODEL_ID + "," + COST + "," + CTXT1 + "," + CTXT2 + "," + DISTANCE + "," + EXPLAIN + "," + PATH + "," + G_ID + " ) " + " SELECT " + this.getSQLSelectHint() + " " + "PRED$RDFVID" + ", " + "SUBJ$RDFVID" + ", " + "OBJ$RDFVID" + ", " + "OBJ$RDFVID" + ", " + Long.toString(this.applyModelId) + ", " + "1" + ", " + "NULL" + ", " + "NULL" + ", " + "NULL" + ", " + "NULL" + ", " + "NULL" + ", " + "GRAPH$RDFVID" + " FROM (" + string2 + ")";
        if (this.recordInserts) {
            this.recordString(string3, INSERTS_TAB_NAME, 1000);
        }
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + string3, this.debug);
            statement = this.conn.createStatement();
            int n = statement.executeUpdate(string3);
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
        if (this.safeForHints) {
            this.conn.commit();
            UpdateEngine.log("Committing to be able to read from bindings id table", this.debug);
        }
    }

    private void populateResultSet(String string, int n, boolean bl) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("SUBJ$RDFTERM");
        StringBuffer stringBuffer2 = new StringBuffer("OBJ$RDFTERM");
        if (bl) {
            stringBuffer = new StringBuffer("decode(substr(SUBJ$RDFTERM,1,3),");
            stringBuffer.append("'_:m', '_:'||substr(SUBJ$RDFTERM,(instr(SUBJ$RDFTERM, 'm',1,2)+1)),").append("SUBJ$RDFTERM)");
            stringBuffer2 = new StringBuffer("decode(substr(OBJ$RDFTERM,1,3),");
            stringBuffer2.append("'_:m', '_:'||substr(OBJ$RDFTERM,(instr(OBJ$RDFTERM, 'm',1,2)+1)),").append("OBJ$RDFTERM)");
        }
        StringBuffer stringBuffer3 = new StringBuffer("SELECT ");
        stringBuffer3.append(this.getSQLSelectHint()).append(" GRAPH$RDFTERM,").append(stringBuffer).append(",PRED$RDFTERM,").append(stringBuffer2);
        if (this.clobSupport) {
            stringBuffer3.append(",NVL2(OBJ$RDFCLOB,OBJ$RDFCLBT,OBJ$RDFCLOB)");
        }
        stringBuffer3.append(" FROM (").append(string).append(")");
        if (this.recordInserts) {
            this.recordString(stringBuffer3.toString(), INSERTS_TAB_NAME, 4000);
        }
        UpdateEngine.log("Executing: \n" + stringBuffer3, this.debug);
        if (n == 38) {
            UpdateEngine.log("Creating Delete Result Set", this.debug);
            this.deleteRS = this.delStmt.executeQuery(stringBuffer3.toString());
        } else if (n == 39) {
            UpdateEngine.log("Creating Insert Result Set", this.debug);
            this.insertRS = this.insStmt.executeQuery(stringBuffer3.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getGraphID(String string) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            long l;
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall("declare dummy boolean;begin mdsys.sdo_rdf.parse_property_value(?,'UR',?,dummy); end;");
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.registerOutParameter(2, 2);
            oracleCallableStatement.execute();
            long l2 = l = oracleCallableStatement.getLong(2);
            return l2;
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private String tripleGraphToIDString(String string, String string2) {
        return "(bitand(" + string + "." + string2 + ".rdf_m_id,((power(2,96)-1)-(power(2,32)-1)))/(power(2,32)))";
    }

    private String getGraphIDString(SimpleNode simpleNode, boolean bl) throws ParseException, SQLException {
        String string;
        if (simpleNode.id != 41) {
            throw new ParseException("GraphOrDefault expected");
        }
        if (bl) {
            string = "0";
            if (simpleNode.jjtGetNumChildren() > 0) {
                string = Long.toString(Long.parseLong(this.parser.URIs.get(((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name)));
            }
        } else {
            string = "" + Long.toString(this.applyModelId);
            if (simpleNode.jjtGetNumChildren() > 0) {
                string = Long.toString(this.getGraphID(((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name)) + "*power(2,32) + " + Long.toString(this.applyModelId);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropGraph(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName();
        stringBuffer.append("BEGIN\n ").append(" DELETE FROM ").append(string2).append(" s").append(" WHERE s.rowid in (").append(" select ").append(this.getSanitizedAppIdxHint()).append(" t.rowid from ").append(string2).append(" t");
        if (!string.equals("")) {
            stringBuffer.append(" WHERE ").append(this.tripleGraphToIDString("t", this.getSanitizedAppColName())).append(string);
        }
        stringBuffer.append(");\nEND;");
        OracleCallableStatement oracleCallableStatement = null;
        try {
            UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(stringBuffer.toString());
            oracleCallableStatement.execute();
            int n = oracleCallableStatement.getUpdateCount();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDelete(String string) throws SQLException {
        CharSequence charSequence;
        String string2 = "";
        if (this.dumpTempTabs) {
            UpdateEngine.log("Dumping DELETE table", this.debug);
            charSequence = new StringBuffer("");
            if (this.doDelAsIns()) {
                this.dumpIDTable(string, (StringBuffer)charSequence);
            } else {
                this.dumpQuadTable(DELETE_TAB_NAME, (StringBuffer)charSequence);
            }
            UpdateEngine.log(((StringBuffer)charSequence).toString(), this.debug);
        }
        if (this.doDelAsIns()) {
            UpdateEngine.log("Performing delete as insert:" + string, this.debug);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("BEGIN\n").append("sdo_rdf.delete_as_insert(model_name=>?").append(",\nmodel_id_value=>?").append(",\ndel_tab_name=>?").append(",\ntablespace_name=>?").append(",\noptions=>?");
            boolean bl = false;
            if (this.mmOptions.length() > 0) {
                bl = true;
                ((StringBuffer)charSequence).append(",\nmm_options=>?");
            }
            ((StringBuffer)charSequence).append(");\nEND;");
            string2 = this.buildBindVarLog(new String[]{this.applyModel, Long.toString(this.applyModelId), string, this.rdfTablespace, this.options, this.mmOptions});
            if (this.recordMM) {
                this.recordString(((StringBuffer)charSequence).toString() + string2, MM_TAB_NAME, 4000);
            }
            OracleCallableStatement oracleCallableStatement = null;
            try {
                UpdateEngine.log("Executing: \n" + charSequence + string2, this.debug);
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(((StringBuffer)charSequence).toString());
                oracleCallableStatement.setString(1, this.applyModel);
                oracleCallableStatement.setLong(2, this.applyModelId);
                oracleCallableStatement.setString(3, string);
                oracleCallableStatement.setString(4, this.rdfTablespace);
                oracleCallableStatement.setString(5, this.options);
                if (bl) {
                    oracleCallableStatement.setString(6, this.mmOptions);
                }
                oracleCallableStatement.execute();
                int n = oracleCallableStatement.getUpdateCount();
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
            }
            finally {
                try {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
                }
            }
        }
        UpdateEngine.log("Deleting from application table", this.debug);
        charSequence = this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName();
        String string3 = this.getSanitizedAppColName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append((String)charSequence).append(" WHERE rowid IN (").append(" select ").append(this.getSanitizedAppIdxHint()).append(" s.rowid ").append(" from ").append((String)charSequence).append(" s,").append(DELETE_TAB_NAME).append(" dm ").append(" where (  ").append(this.tripleGraphToIDString("s", string3)).append(", ").append("  s.").append(string3).append(".rdf_s_id, s.").append(string3).append(".rdf_p_id, s.").append(string3).append(".rdf_c_id) ").append(" in( ").append(" (NVL2(dm.").append(GRAPH_COL_NAME).append(",").append("       sem_apis.res2vid('MDSYS.RDF_VALUE$', dm.").append(GRAPH_COL_NAME).append(", null, null),").append("       0),").append("  sem_apis.res2vid('MDSYS.RDF_VALUE$', dm.").append(SUB_COL_NAME).append(", null, null),").append("  sem_apis.res2vid('MDSYS.RDF_VALUE$', dm.").append(PRED_COL_NAME).append(", null, null),").append("  sem_apis.res2vid('MDSYS.RDF_VALUE$', dm.").append(OBJ_COL_NAME).append(", ").append("  sdo_rdf.ltype(dm.").append(OBJ_COL_NAME).append("),").append("  sdo_rdf.latag(dm.").append(OBJ_COL_NAME).append(")");
        if (this.clobSupport) {
            stringBuffer.append(", ").append(CLOB_COL_NAME);
        }
        stringBuffer.append("))))");
        if (this.recordDeletes) {
            this.recordString(stringBuffer.toString(), DELETES_TAB_NAME, 4000);
        }
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + stringBuffer, this.debug);
            statement = this.conn.createStatement();
            int n = statement.executeUpdate(stringBuffer.toString());
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDeleteFromRS() throws SQLException {
        UpdateEngine.log("Deleting from application table", this.debug);
        PreparedStatement preparedStatement = null;
        String string = this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName();
        String string2 = this.getSanitizedAppColName();
        String string3 = "DELETE FROM " + string + " WHERE rowid IN (" + " select " + this.getSanitizedAppIdxHint() + " s.rowid " + " from " + string + " s" + " where (" + "  " + this.tripleGraphToIDString("s", string2) + ", " + "  s." + string2 + ".rdf_s_id, s." + string2 + ".rdf_p_id, s." + string2 + ".rdf_c_id) " + " in((NVL2(?,sem_apis.res2vid('MDSYS.RDF_VALUE$',?, null, null),0)," + " sem_apis.res2vid('MDSYS.RDF_VALUE$',?,null,null)," + " sem_apis.res2vid('MDSYS.RDF_VALUE$',?,null,null)," + " sem_apis.res2vid('MDSYS.RDF_VALUE$',?,sdo_rdf.ltype(?),sdo_rdf.latag(?),?))))";
        if (this.recordDeletes) {
            this.recordString(string3, DELETES_TAB_NAME, 4000);
        }
        CLOB cLOB = null;
        ArrayList<Clob> arrayList = null;
        if (this.clobSupport) {
            arrayList = new ArrayList<Clob>();
        }
        try {
            preparedStatement = this.conn.prepareStatement(string3);
            this.conn.setAutoCommit(false);
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.dumpTempTabs) {
                UpdateEngine.log("Dumping DELETE Result Set", this.debug);
                stringBuffer.append("\n[RDF$STC_GRAPH, RDF$STC_SUC, RDF$STC_PRED, RDF$STC_OBJ]").append("\n=======================================================");
            }
            int n = 0;
            while (this.deleteRS.next()) {
                preparedStatement.setString(1, this.deleteRS.getString(1));
                preparedStatement.setString(2, this.deleteRS.getString(1));
                preparedStatement.setString(3, this.deleteRS.getString(2));
                preparedStatement.setString(4, this.deleteRS.getString(3));
                preparedStatement.setString(5, this.deleteRS.getString(4));
                preparedStatement.setString(6, this.deleteRS.getString(4));
                preparedStatement.setString(7, this.deleteRS.getString(4));
                if (!this.clobSupport || this.deleteRS.getString(5) == null) {
                    cLOB = null;
                } else {
                    cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
                    cLOB.setString(1L, this.deleteRS.getString(5));
                    arrayList.add((Clob)cLOB);
                }
                preparedStatement.setClob(8, (Clob)cLOB);
                preparedStatement.addBatch();
                if (++n == this.batchSize) {
                    preparedStatement.executeBatch();
                    n = 0;
                    this.cleanupClobs(arrayList);
                }
                if (!this.dumpTempTabs) continue;
                stringBuffer.append("\n[").append(this.deleteRS.getString(1)).append(",").append(this.deleteRS.getString(2)).append(",").append(this.deleteRS.getString(3)).append(",");
                if (this.clobSupport && this.deleteRS.getString(5) != null) {
                    stringBuffer.append(this.deleteRS.getString(5).substring(0, 20)).append("...]");
                    continue;
                }
                stringBuffer.append(this.deleteRS.getString(4)).append("]");
            }
            if (this.dumpTempTabs) {
                stringBuffer.append("\n=======================================================");
                UpdateEngine.log(stringBuffer.toString(), this.debug);
            }
            if (n > 0) {
                preparedStatement.executeBatch();
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
            }
            this.cleanupClobs(arrayList);
        }
    }

    private void cleanupClobs(List<Clob> list) {
        if (list != null) {
            for (Clob clob : list) {
                try {
                    if (clob == null) continue;
                    clob.free();
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found cleaning clob:" + sQLException.getMessage(), this.debug);
                }
            }
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInsert(String string) throws SQLException {
        CharSequence charSequence;
        String string2 = "";
        if (this.dumpTempTabs) {
            UpdateEngine.log("Dumping INSERT table", this.debug);
            charSequence = new StringBuffer("");
            if (this.doMergeModels()) {
                this.dumpIDTable(string, (StringBuffer)charSequence);
            } else {
                this.dumpQuadTable(this.insertTabName, (StringBuffer)charSequence);
            }
            UpdateEngine.log(((StringBuffer)charSequence).toString(), this.debug);
        }
        if (this.doMergeModels()) {
            UpdateEngine.log("Performing merge models", this.debug);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("BEGIN\n").append("  sdo_rdf.merge_models(source_model=>'',\n").append("     destination_model=>?,\n").append("     source_table=>?");
            boolean bl = false;
            String string3 = "";
            if (this.mmOptions.length() > 0) {
                bl = true;
                ((StringBuffer)charSequence).append(",\n").append("     options=>?");
                string3 = this.mmOptions;
            } else if (this.parallel && this.dop > 0) {
                bl = true;
                ((StringBuffer)charSequence).append(",\n").append("     options=>?");
                string3 = " DOP=" + this.dop + " ";
            }
            ((StringBuffer)charSequence).append(");\nEND;");
            string2 = this.buildBindVarLog(new String[]{this.applyModel, string, string3});
            if (this.recordMM) {
                this.recordString(((StringBuffer)charSequence).toString() + string2, MM_TAB_NAME, 4000);
            }
            OracleCallableStatement oracleCallableStatement = null;
            try {
                UpdateEngine.log("Executing: \n" + charSequence + string2, this.debug);
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(((StringBuffer)charSequence).toString());
                oracleCallableStatement.setString(1, this.applyModel);
                oracleCallableStatement.setString(2, string);
                if (bl) {
                    oracleCallableStatement.setString(3, string3);
                }
                oracleCallableStatement.execute();
                int n = oracleCallableStatement.getUpdateCount();
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
            }
            finally {
                try {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
                }
            }
        }
        if (this.doBulkLoad()) {
            UpdateEngine.log("Performing bulk load", this.debug);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("BEGIN\n").append("  sem_apis.bulk_load_from_staging_table(\n").append("    model_name  =>?,\n").append("    table_owner =>?,\n").append("    table_name  =>?");
            boolean bl = false;
            String string4 = "";
            if (this.bulkOptions.length() > 0) {
                ((StringBuffer)charSequence).append(",\n    flags =>? ");
                bl = true;
                string4 = this.bulkOptions;
            } else if (this.parallel && this.dop > 0) {
                ((StringBuffer)charSequence).append(",\n    flags =>? ");
                bl = true;
                string4 = " PARALLEL=" + this.dop + " ";
            }
            ((StringBuffer)charSequence).append(");\nEND;");
            string2 = this.buildBindVarLog(new String[]{this.applyModel, this.currentSchema, this.insertTabName, string4});
            if (this.recordInserts) {
                this.recordString(((StringBuffer)charSequence).toString() + string2, INSERTS_TAB_NAME, 500);
            }
            OracleCallableStatement oracleCallableStatement = null;
            try {
                UpdateEngine.log("Executing: \n" + charSequence + string2, this.debug);
                oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(((StringBuffer)charSequence).toString());
                oracleCallableStatement.setString(1, this.applyModel);
                oracleCallableStatement.setString(2, this.currentSchema);
                oracleCallableStatement.setString(3, this.insertTabName);
                if (bl) {
                    oracleCallableStatement.setString(4, string4);
                }
                oracleCallableStatement.execute();
                int n = oracleCallableStatement.getUpdateCount();
                UpdateEngine.log("Number of rows affected: " + n, this.debug);
            }
            finally {
                try {
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
                }
            }
        }
        UpdateEngine.log("Inserting into application table", this.debug);
        charSequence = this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName();
        StringBuffer stringBuffer = new StringBuffer("INSERT").append(this.getSQLInsertHint()).append(" INTO ").append((String)charSequence).append("(").append(this.getSanitizedAppColName()).append(")").append(" select ").append(this.getSQLSelectHint()).append(" sdo_rdf_triple_s(").append(this.getSanitizedLiteral(this.applyModel)).append(" || ").append("NVL2(dm.").append(GRAPH_COL_NAME).append(",").append("':'||dm.").append(GRAPH_COL_NAME).append(",").append("''), ").append("?, ").append("dm.").append(SUB_COL_NAME).append(", ").append("dm.").append(PRED_COL_NAME).append(", ");
        if (!this.clobSupport) {
            stringBuffer.append("dm.").append(OBJ_COL_NAME).append(")");
        } else {
            stringBuffer.append("COALESCE(dm.").append(CLOB_COL_NAME).append(",to_clob(dm.").append(OBJ_COL_NAME).append(")))");
        }
        stringBuffer.append(" from ").append(this.getSanitizedTabName(this.insertTabName)).append(" dm");
        string2 = this.buildBindVarLog(new String[]{Integer.toString(this.nonautoFlag)});
        if (this.recordInserts) {
            this.recordString(stringBuffer.toString() + string2, INSERTS_TAB_NAME, 1000);
        }
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + stringBuffer + string2, this.debug);
            statement = this.conn.prepareStatement(stringBuffer.toString());
            statement.setInt(1, this.nonautoFlag);
            int n = statement.executeUpdate();
            UpdateEngine.log("Number of rows affected: " + n, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private boolean updateSameModel() {
        return this.matchModels.length == 1 && this.applyModel.equals(this.matchModels[0]);
    }

    private boolean doIdOnlyAdd() {
        return !this.doBulkLoad() && this.updateSameModel() && !this.strictBNode;
    }

    private boolean doBulkLoad() {
        return this.bulkSafe && this.forceBulk;
    }

    private boolean checkMMSafe() {
        return this.bulkSafe && this.forceMM && !this.disableMM && !this.inStream;
    }

    private boolean doMergeModels() {
        return this.forceMM && this.mmSafe && !this.disableMM && !this.strictBNode && this.bulkSafe && !this.forceBulk && this.modelOwner.equals(this.currentSchema);
    }

    private boolean doDelAsIns() {
        return this.daiSafe && this.delAsIns && this.modelOwner.equals(this.currentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInsertFromRS() throws SQLException {
        UpdateEngine.log("Inserting into application table", this.debug);
        PreparedStatement preparedStatement = null;
        String string = "INSERT INTO " + this.getSanitizedModelOwner() + "." + this.getSanitizedAppTabName() + "(" + this.getSanitizedAppColName() + ") VALUES" + "(sdo_rdf_triple_s(?,?,?,?,?))";
        CLOB cLOB = null;
        ArrayList<Clob> arrayList = null;
        if (this.clobSupport) {
            arrayList = new ArrayList<Clob>();
        }
        try {
            preparedStatement = this.conn.prepareStatement(string);
            this.conn.setAutoCommit(false);
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.dumpTempTabs) {
                UpdateEngine.log("Dumping INSERT Result Set", this.debug);
                stringBuffer.append("\n[RDF$STC_GRAPH, RDF$STC_SUC, RDF$STC_PRED, RDF$STC_OBJ]").append("\n=======================================================");
            }
            int n = 0;
            while (this.insertRS.next()) {
                if (this.insertRS.getString(1) == null) {
                    preparedStatement.setString(1, this.applyModel);
                } else {
                    preparedStatement.setString(1, this.applyModel + ":" + this.insertRS.getString(1));
                }
                preparedStatement.setInt(2, this.nonautoFlag);
                preparedStatement.setString(3, this.insertRS.getString(2));
                preparedStatement.setString(4, this.insertRS.getString(3));
                if (!this.clobSupport || this.insertRS.getString(5) == null) {
                    preparedStatement.setString(5, this.insertRS.getString(4));
                } else {
                    cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
                    cLOB.setString(1L, this.insertRS.getString(5));
                    preparedStatement.setClob(5, (Clob)cLOB);
                    arrayList.add((Clob)cLOB);
                }
                preparedStatement.addBatch();
                if (++n == this.batchSize) {
                    preparedStatement.executeBatch();
                    n = 0;
                    this.cleanupClobs(arrayList);
                }
                if (!this.dumpTempTabs) continue;
                stringBuffer.append("\n[").append(this.insertRS.getString(1)).append(",").append(this.insertRS.getString(2)).append(",").append(this.insertRS.getString(3)).append(",");
                if (this.clobSupport && this.insertRS.getString(5) != null) {
                    stringBuffer.append(this.insertRS.getString(5).substring(0, 20)).append("...]");
                    continue;
                }
                stringBuffer.append(this.insertRS.getString(4)).append("]");
            }
            if (this.dumpTempTabs) {
                stringBuffer.append("\n=======================================================");
                UpdateEngine.log(stringBuffer.toString(), this.debug);
            }
            if (n > 0) {
                preparedStatement.executeBatch();
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
            }
            this.cleanupClobs(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQuadTable(String string, StringBuffer stringBuffer) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.createStatement();
            String string2 = this.getSanitizedTabName(string);
            stringBuffer.append(" Table [" + string + "]:");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("select RDF$STC_GRAPH, RDF$STC_SUB, RDF$STC_PRED, RDF$STC_OBJ ");
            if (this.clobSupport) {
                stringBuffer2.append(",NVL2(RDF$STC_CLOB,substr(RDF$STC_CLOB,1,20),'')");
            }
            stringBuffer2.append("from ").append(string2);
            resultSet = statement.executeQuery(stringBuffer2.toString());
            if (!this.clobSupport) {
                stringBuffer.append("\n[RDF$STC_GRAPH, RDF$STC_SUC, RDF$STC_PRED, RDF$STC_OBJ]").append("\n=======================================================");
                while (resultSet.next()) {
                    stringBuffer.append("\n[").append(resultSet.getString(1) + ", ").append(resultSet.getString(2) + ", ").append(resultSet.getString(3) + ", ").append(resultSet.getString(4) + "]");
                }
                stringBuffer.append("\n=======================================================");
            } else {
                stringBuffer.append("\n[RDF$STC_GRAPH, RDF$STC_SUC, RDF$STC_PRED, RDF$STC_OBJ, substr(RDF$STC_CLOB,1,20)]").append("\n==================================================================================");
                while (resultSet.next()) {
                    stringBuffer.append("\n[").append(resultSet.getString(1) + ", ").append(resultSet.getString(2) + ", ").append(resultSet.getString(3) + ", ").append(resultSet.getString(4) + ", ").append(resultSet.getString(5) + "]");
                }
                stringBuffer.append("\n==================================================================================");
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing RS:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIDTable(String string, StringBuffer stringBuffer) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.createStatement();
            String string2 = this.getSanitizedTabName(string);
            stringBuffer.append(" Table [" + string + "]:");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("select G_ID, START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID ").append("from ").append(string2);
            resultSet = statement.executeQuery(stringBuffer2.toString());
            stringBuffer.append("\n[G_ID, START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID]").append("\n=======================================================");
            while (resultSet.next()) {
                stringBuffer.append("\n[").append(resultSet.getBigDecimal(1) + ", ").append(resultSet.getBigDecimal(2) + ", ").append(resultSet.getBigDecimal(3) + ", ").append(resultSet.getBigDecimal(4) + "]");
            }
            stringBuffer.append("\n=======================================================");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing RS:" + sQLException.getMessage(), this.debug);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private void dumpQuad(String string, ASTTriplesBlock aSTTriplesBlock, StringBuffer stringBuffer, boolean bl) throws ParseException {
        if (bl) {
            stringBuffer.append("\n[").append(string).append(", ").append(((ASTTripleAtom)aSTTriplesBlock.jjtGetChild(0)).printSPARQLTextForUpd()).append(", ").append(((ASTTripleAtom)aSTTriplesBlock.jjtGetChild(1)).printSPARQLTextForUpd()).append(", ");
            String string2 = ((ASTTripleAtom)aSTTriplesBlock.jjtGetChild(2)).printSPARQLTextForUpd();
            if (string2.length() > 500) {
                string2 = string2.substring(0, 20) + "...";
            }
            stringBuffer.append(string2).append("]");
            if (aSTTriplesBlock.jjtGetNumChildren() == 4) {
                this.dumpQuad(string, (ASTTriplesBlock)aSTTriplesBlock.jjtGetChild(3), stringBuffer, bl);
            }
        }
    }

    private String extractGraphName(SimpleNode simpleNode) {
        String string = null;
        if (simpleNode.jjtGetNumChildren() > 0) {
            string = ((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name;
        }
        return string;
    }

    private SimpleNode getDummyInsOrDelClause(String string, boolean bl, int n) {
        SimpleNode simpleNode;
        ASTTriplesBlock aSTTriplesBlock = this.getDummyTriplesBlock();
        SimpleNode simpleNode2 = null;
        if (string == null) {
            simpleNode2 = aSTTriplesBlock;
        } else {
            simpleNode = new ASTTripleAtom(73);
            ((ASTTripleAtom)simpleNode).type = n;
            ((ASTTripleAtom)simpleNode).name = string;
            simpleNode2 = new ASTQuadsNotTriples(46);
            simpleNode2.jjtAddChild(simpleNode, 0);
            simpleNode.jjtSetParent(simpleNode2);
            simpleNode2.jjtAddChild(aSTTriplesBlock, 1);
            aSTTriplesBlock.jjtSetParent(simpleNode2);
        }
        simpleNode = new ASTQuadPattern(44);
        simpleNode.jjtAddChild(simpleNode2, 0);
        simpleNode2.jjtSetParent(simpleNode);
        SimpleNode simpleNode3 = null;
        simpleNode3 = bl ? new ASTInsertClause(39) : new ASTDeleteClause(38);
        simpleNode3.jjtAddChild(simpleNode, 0);
        simpleNode.jjtSetParent(simpleNode3);
        return simpleNode3;
    }

    private ASTGroupGraphPattern getDummyGroupGraphPattern(String string, int n) {
        ASTGroupGraphPattern aSTGroupGraphPattern;
        ASTTriplesBlock aSTTriplesBlock = this.getDummyTriplesBlock();
        SimpleNode simpleNode = null;
        if (string == null) {
            simpleNode = aSTTriplesBlock;
        } else {
            aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
            aSTGroupGraphPattern.jjtAddChild(aSTTriplesBlock, 0);
            aSTTriplesBlock.jjtSetParent(aSTGroupGraphPattern);
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.type = n;
            aSTTripleAtom.name = string;
            ASTGraphGraphPattern aSTGraphGraphPattern = new ASTGraphGraphPattern(51);
            aSTGraphGraphPattern.jjtAddChild(aSTTripleAtom, 0);
            aSTTripleAtom.jjtSetParent(aSTGraphGraphPattern);
            aSTGraphGraphPattern.jjtAddChild(aSTGroupGraphPattern, 1);
            aSTGroupGraphPattern.jjtSetParent(aSTGraphGraphPattern);
            simpleNode = new ASTGraphPatternNotTriples(49);
            simpleNode.jjtAddChild(aSTGraphGraphPattern, 0);
            aSTGraphGraphPattern.jjtSetParent(simpleNode);
        }
        aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGroupGraphPattern.jjtAddChild(simpleNode, 0);
        simpleNode.jjtSetParent(aSTGroupGraphPattern);
        return aSTGroupGraphPattern;
    }

    private ASTTriplesBlock getDummyTriplesBlock() {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 0;
        aSTTripleAtom.name = "S";
        ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
        aSTTripleAtom2.type = 0;
        aSTTripleAtom2.name = "P";
        ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
        aSTTripleAtom3.type = 0;
        aSTTripleAtom3.name = "O";
        ASTTriplesBlock aSTTriplesBlock = new ASTTriplesBlock(47);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom, 0);
        aSTTripleAtom.jjtSetParent(aSTTriplesBlock);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom2, 1);
        aSTTripleAtom2.jjtSetParent(aSTTriplesBlock);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom3, 2);
        aSTTripleAtom3.jjtSetParent(aSTTriplesBlock);
        return aSTTriplesBlock;
    }

    private void addTBToInsert(PreparedStatement preparedStatement, ASTTriplesBlock aSTTriplesBlock, String string, List<Clob> list) throws ParseException, SQLException {
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, this.nonautoFlag);
        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(0);
        this.checkQuadElement(aSTTripleAtom, 1);
        preparedStatement.setString(3, aSTTripleAtom.printSPARQLTextForUpd());
        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(1);
        this.checkQuadElement(aSTTripleAtom2, 2);
        preparedStatement.setString(4, aSTTripleAtom2.printSPARQLTextForUpd());
        ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(2);
        this.checkQuadElement(aSTTripleAtom3, 3);
        if (QueryUtils.computeConstTermLen(aSTTripleAtom3.name, aSTTripleAtom3.litLang, aSTTripleAtom3.litType) <= 4000) {
            preparedStatement.setString(5, aSTTripleAtom3.printSPARQLTextForUpd());
        } else {
            CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
            cLOB.setString(1L, aSTTripleAtom3.printSPARQLTextForUpd());
            preparedStatement.setClob(5, (Clob)cLOB);
            list.add((Clob)cLOB);
        }
        preparedStatement.addBatch();
        if (aSTTriplesBlock.jjtGetNumChildren() == 4) {
            this.addTBToInsert(preparedStatement, (ASTTriplesBlock)aSTTriplesBlock.jjtGetChild(3), string, list);
        }
    }

    private void addTBToDelete(PreparedStatement preparedStatement, ASTTriplesBlock aSTTriplesBlock, String string, List<Clob> list) throws ParseException, SQLException {
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(0);
        this.checkQuadElement(aSTTripleAtom, 1);
        preparedStatement.setString(3, aSTTripleAtom.printSPARQLTextForUpd());
        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(1);
        this.checkQuadElement(aSTTripleAtom2, 2);
        preparedStatement.setString(4, aSTTripleAtom2.printSPARQLTextForUpd());
        ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(2);
        if (QueryUtils.computeConstTermLen(aSTTripleAtom3.name, aSTTripleAtom3.litLang, aSTTripleAtom3.litType) <= 4000) {
            this.checkQuadElement(aSTTripleAtom3, 3);
            String string2 = aSTTripleAtom3.printSPARQLTextForUpd();
            preparedStatement.setString(5, string2);
            Clob clob = null;
            preparedStatement.setClob(8, clob);
        } else {
            preparedStatement.setString(5, "");
            CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
            cLOB.setString(1L, aSTTripleAtom3.printSPARQLTextForUpd());
            preparedStatement.setClob(8, (Clob)cLOB);
            list.add((Clob)cLOB);
        }
        preparedStatement.setString(6, aSTTripleAtom3.literalHasType() ? aSTTripleAtom3.litType : null);
        preparedStatement.setString(7, aSTTripleAtom3.literalHasLang() ? aSTTripleAtom3.litLang : null);
        preparedStatement.addBatch();
        if (aSTTriplesBlock.jjtGetNumChildren() == 4) {
            this.addTBToDelete(preparedStatement, (ASTTriplesBlock)aSTTriplesBlock.jjtGetChild(3), string, list);
        }
    }

    private void checkAtomType(ASTTripleAtom aSTTripleAtom, int[] nArray, boolean bl) throws ParseException {
        if (bl) {
            boolean bl2 = false;
            for (int i = 0; i < nArray.length; ++i) {
                bl2 = bl2 || aSTTripleAtom.type == nArray[i];
            }
            if (!bl2) {
                throw new ParseException("Unexpected element in UPDATE DATA request:" + aSTTripleAtom.printSPARQLTextForUpd());
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (aSTTripleAtom.type != nArray[i]) continue;
                throw new ParseException("Unexpected element in UPDATE DATA request:" + aSTTripleAtom.printSPARQLTextForUpd());
            }
        }
    }

    private void checkQuadElement(ASTTripleAtom aSTTripleAtom, int n) throws ParseException {
        switch (n) {
            case 1: {
                this.checkAtomType(aSTTripleAtom, SUBJ_TYPES_ARRAY, true);
                break;
            }
            case 0: 
            case 2: {
                this.checkAtomType(aSTTripleAtom, PRED_TYPES_ARRAY, true);
                break;
            }
            case 3: {
                this.checkAtomType(aSTTripleAtom, OBJ_TYPES_ARRAY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordString(String string, String string2, int n) throws SQLException {
        String string3 = string;
        if (string3.length() > n) {
            string3 = string3.substring(0, n);
        }
        String string4 = "INSERT INTO " + this.getSanitizedModelOwner() + "." + this.getSanitizedTabName(string2) + " VALUES" + "(?)";
        Statement statement = null;
        try {
            UpdateEngine.log("Executing: \n" + string4, this.debug);
            statement = this.conn.prepareStatement(string4);
            statement.setString(1, string3);
            int n2 = statement.executeUpdate();
            UpdateEngine.log("Number of rows affected: " + n2, this.debug);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordLongString(String string, String string2, int n) throws SQLException {
        String string3 = "";
        String string4 = string;
        String string5 = "";
        int n2 = 0;
        int n3 = 0;
        Statement statement = null;
        try {
            int n4;
            String string6 = this.getSanitizedModelOwner() + "." + this.getSanitizedTabName(string2);
            while (string4.length() - n2 > n) {
                string5 = string4.substring(n2, n + n2);
                n2 += n;
                string3 = "INSERT INTO " + string6 + " VALUES" + "(?,?)";
                UpdateEngine.log("Executing: \n" + string3, this.debug);
                statement = this.conn.prepareStatement(string3);
                statement.setInt(1, n3);
                statement.setString(2, string5);
                n4 = statement.executeUpdate();
                UpdateEngine.log("Number of rows affected: " + n4, this.debug);
                ++n3;
            }
            if (n2 < string4.length() - 1) {
                string5 = string4.substring(n2);
                string3 = "INSERT INTO " + string6 + " VALUES" + "(?,?)";
                UpdateEngine.log("Executing: \n" + string3, this.debug);
                statement = this.conn.prepareStatement(string3);
                statement.setInt(1, n3);
                statement.setString(2, string5);
                n4 = statement.executeUpdate();
                UpdateEngine.log("Number of rows affected: " + n4, this.debug);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing statement:" + sQLException.getMessage(), this.debug);
            }
        }
    }

    private Set<String> extractTemplateVars(Node node, boolean bl) {
        UpdateEngine.log("Extracting template variables: includeObj=[" + bl + "]", this.debug);
        HashSet<String> hashSet = new HashSet<String>();
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            UpdateEngine.log("  Current Node=[" + node2.toString() + "]", this.debug);
            int n = ((SimpleNode)node2).id;
            if (n == 39 || n == 38) {
                UpdateEngine.log("  Found INSERT/DELETE template", this.debug);
                Stack<Node> stack2 = new Stack<Node>();
                stack2.push(node2);
                while (!stack2.isEmpty()) {
                    int n2;
                    ASTTripleAtom aSTTripleAtom = null;
                    Node node3 = (Node)stack2.pop();
                    UpdateEngine.log("    Current Template Node=[" + node3.toString() + "]", this.debug);
                    int n3 = ((SimpleNode)node3).id;
                    if (n3 == 47) {
                        for (n2 = 0; n2 < 3; ++n2) {
                            if (((SimpleNode)node3.jjtGetChild((int)n2)).id != 73) continue;
                            aSTTripleAtom = (ASTTripleAtom)node3.jjtGetChild(n2);
                            if (aSTTripleAtom.type != 0) continue;
                            UpdateEngine.log("      Found triple pattern template variable=[" + aSTTripleAtom.name + "] position=[" + n2 + "]", this.debug);
                            if (n2 >= 2 && !bl) continue;
                            UpdateEngine.log("        Adding triple pattern template variable=[" + aSTTripleAtom.name + "] position=[" + n2 + "]", this.debug);
                            hashSet.add(aSTTripleAtom.name);
                        }
                        for (n2 = 3; n2 < node3.jjtGetNumChildren(); ++n2) {
                            stack2.push(node3.jjtGetChild(n2));
                        }
                        continue;
                    }
                    if (n3 == 73) {
                        aSTTripleAtom = (ASTTripleAtom)node3;
                        if (aSTTripleAtom.type != 0) continue;
                        UpdateEngine.log("      Found graph template variable=[" + aSTTripleAtom.name + "]", this.debug);
                        UpdateEngine.log("        Adding graph template variable=[" + aSTTripleAtom.name + "]", this.debug);
                        hashSet.add(aSTTripleAtom.name);
                        continue;
                    }
                    for (n2 = 0; n2 < node3.jjtGetNumChildren(); ++n2) {
                        stack2.push(node3.jjtGetChild(n2));
                    }
                }
                continue;
            }
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertConstVals(Node node) throws SQLException, RDFException {
        UpdateEngine.log("Inserting constant values", this.debug);
        OracleCallableStatement oracleCallableStatement = null;
        Set<ASTTripleAtom> set = this.extractAllConstants(node);
        CLOB cLOB = null;
        ArrayList<Clob> arrayList = new ArrayList<Clob>();
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall("declare\n dummy1 number;\n dummy2 number;\n dummy3 boolean;\nbegin\n mdsys.sdo_rdf.parse_object_node(?,?,?,?,dummy1,dummy2,dummy3);\nend;");
            boolean bl = false;
            for (ASTTripleAtom aSTTripleAtom : set) {
                String string = "";
                int n = aSTTripleAtom.type;
                if (n == 10) continue;
                switch (n) {
                    case 1: {
                        string = "UR";
                        break;
                    }
                    case 3: {
                        string = "PL";
                        break;
                    }
                    case 4: {
                        string = "PL@";
                        break;
                    }
                    case 2: 
                    case 5: {
                        string = "TL";
                        break;
                    }
                    default: {
                        throw new RDFException(UNKNOWN_TYPE_ERROR);
                    }
                }
                if (QueryUtils.computeConstTermLen(aSTTripleAtom.name, aSTTripleAtom.litLang, aSTTripleAtom.litType) <= 4000) {
                    oracleCallableStatement.setString(1, aSTTripleAtom.name);
                } else {
                    cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
                    cLOB.setString(1L, aSTTripleAtom.name);
                    oracleCallableStatement.setClob(1, (Clob)cLOB);
                    switch (n) {
                        case 3: {
                            string = "PLL";
                            break;
                        }
                        case 4: {
                            string = "PLL@";
                            break;
                        }
                        case 2: 
                        case 5: {
                            string = "TLL";
                            break;
                        }
                        default: {
                            string = "UK";
                        }
                    }
                    arrayList.add((Clob)cLOB);
                }
                oracleCallableStatement.setString(2, aSTTripleAtom.litType);
                oracleCallableStatement.setString(3, aSTTripleAtom.litLang);
                oracleCallableStatement.setString(4, string);
                if (aSTTripleAtom.name.length() <= 500) {
                    UpdateEngine.log("Inserting value=[" + aSTTripleAtom.name + "][" + aSTTripleAtom.litType + "][" + aSTTripleAtom.litLang + "][" + string + "]", this.debug);
                } else {
                    UpdateEngine.log("Inserting value=[" + aSTTripleAtom.name.substring(0, 20) + "...][" + aSTTripleAtom.litType + "][" + aSTTripleAtom.litLang + "][" + string + "]", this.debug);
                }
                oracleCallableStatement.addBatch();
                bl = true;
            }
            if (bl) {
                oracleCallableStatement.executeBatch();
                this.cleanupClobs(arrayList);
            }
            UpdateEngine.log("Updating SQLGenContext", this.debug);
            this.setupSQLContext();
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (SQLException sQLException) {
                UpdateEngine.log("Exception found closing ocs:" + sQLException.getMessage(), this.debug);
            }
            this.cleanupClobs(arrayList);
        }
    }

    private Set<ASTTripleAtom> extractAllConstants(Node node) {
        UpdateEngine.log("Extracting template constants", this.debug);
        HashSet<ASTTripleAtom> hashSet = new HashSet<ASTTripleAtom>();
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            UpdateEngine.log("    Current Template Node=[" + node2.toString() + "]", this.debug);
            int n = ((SimpleNode)node2).id;
            ASTTripleAtom aSTTripleAtom = null;
            if (n == 73) {
                aSTTripleAtom = (ASTTripleAtom)node2;
                if (aSTTripleAtom.type == 0) continue;
                UpdateEngine.log("      Found template constant=[" + aSTTripleAtom.name + "]", this.debug);
                hashSet.add(aSTTripleAtom);
                continue;
            }
            if (n == 34 || n == 35) continue;
            if (n == 37) {
                ASTTopLevelQueryNode aSTTopLevelQueryNode = (ASTTopLevelQueryNode)node2;
                SparqlSourceDescriptor sparqlSourceDescriptor = aSTTopLevelQueryNode.getsourceDesc();
                if (sparqlSourceDescriptor.getWithGraph() != null) {
                    UpdateEngine.log("      Found template constant=[" + sparqlSourceDescriptor.getWithGraph() + "]", this.debug);
                    hashSet.add(this.uriToTripleAtom(sparqlSourceDescriptor.getWithGraph()));
                }
                Collection<String> collection = sparqlSourceDescriptor.getDefaultGraphs();
                for (String string : collection) {
                    UpdateEngine.log("      Found template constant=[" + string + "]", this.debug);
                    hashSet.add(this.uriToTripleAtom(string));
                }
                Collection<String> collection2 = sparqlSourceDescriptor.getNamedGraphs();
                Iterator object2 = collection2.iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    UpdateEngine.log("      Found template constant=[" + string + "]", this.debug);
                    hashSet.add(this.uriToTripleAtom(string));
                }
            }
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return hashSet;
    }

    private ASTTripleAtom uriToTripleAtom(String string) {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 1;
        aSTTripleAtom.name = string;
        return aSTTripleAtom;
    }

    private boolean isMissingTabsException(SQLException sQLException) {
        if (sQLException.getErrorCode() == 942) {
            return true;
        }
        return sQLException.getMessage().contains(TABLE_DOES_NOT_EXIST_MSG);
    }

    private int hasIllegalChar(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                int n = string.codePointAt(i);
                if (n <= 127) continue;
                return i;
            }
        }
        return -1;
    }

    private void checkForUnescapedChars(String string) throws RDFException {
        UpdateEngine.log("Checking for unescaped Unicode or special characters", this.debug);
        int n = this.hasIllegalChar(string);
        if (n > -1) {
            throw new RDFException("Unescaped special character or Unicode character: " + string.charAt(n));
        }
    }

    private String buildBindVarLog(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("Bind Vals=");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("\n          ");
            }
            stringBuffer.append("[").append(stringArray[i]).append("]");
        }
        return stringBuffer.toString();
    }

    private String getSQLSelectHint() {
        String string = "";
        if (this.parallel || this.ods) {
            string = " /*+";
            if (this.parallel) {
                string = string + " PARALLEL";
                if (this.dop > 0) {
                    string = string + "(" + Integer.toString(this.dop) + ")";
                }
            }
            if (this.ods_level > 0) {
                string = string + " DYNAMIC_SAMPLING(" + Integer.toString(this.ods_level) + ")";
            }
            string = string + " */ ";
        }
        return string;
    }

    private String getSQLInsertHint() {
        String string = "";
        if (this.safeForHints && (this.append || this.parallel)) {
            string = " /*+";
            if (this.append) {
                string = string + " APPEND";
            }
            if (this.parallel) {
                string = string + " PARALLEL";
                if (this.dop > 0) {
                    string = string + "(" + Integer.toString(this.dop) + ")";
                }
            }
            string = string + " */ ";
        }
        return string;
    }

    private String getSanitizedAppColName() throws SQLException {
        String string = Util.enquoteNameSQLName((Connection)this.conn, (String)this.appColName);
        return string;
    }

    private String getSanitizedModelOwner() throws SQLException {
        String string = Util.enquoteNameSQLName((Connection)this.conn, (String)this.modelOwner);
        return string;
    }

    private String getSanitizedAppTabName() throws SQLException {
        return this.getSanitizedTabName(this.appTabName);
    }

    private String getSanitizedTabName(String string) throws SQLException {
        String string2 = Util.enquoteNameSQLName((Connection)this.conn, (String)string);
        return string2;
    }

    private String getSanitizedAppIdxHint() throws SQLException {
        String string = "";
        if (this.appIdxName.length() > 0) {
            string = Util.enquoteNameSQLName((Connection)this.conn, (String)this.appIdxName);
            string = " /*+ INDEX(s " + string + ") */ ";
        }
        return string;
    }

    private String getSanitizedLiteral(String string) throws SQLException {
        Statement statement = this.conn.createStatement();
        String string2 = ((OracleStatement)statement).enquoteLiteral(string);
        statement.close();
        return string2;
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        SIMPLE_IDX_NAME = Pattern.compile("^[A-Z][A-Z0-9\\$_]*$");
        SUBJ_TYPES_ARRAY = new int[]{1, 10};
        PRED_TYPES_ARRAY = new int[]{1};
        OBJ_TYPES_ARRAY = new int[]{0, 7, 8, 9};
        astOptimizers = new ArrayList<SparqlQueryOptimizer>();
        astOptimizers.add(new CollectionExpandOptimizer());
        astOptimizers.add(new BNPropListExpandOptimizer());
        astOptimizers.add(new BlankNodesRewriteOptimizer());
        astOptimizers.add(new TurtleExpandOptimizer());
        astOptimizers.add(new ModifyRewriteOptimizer());
    }

    private static class GraphsInfo {
        public long[] dgids = null;
        public long[] ngids = null;
        public String[] dmodels = null;
        public long[] dmids = null;
        public int flag = 0;

        private GraphsInfo() {
        }

        public String dump() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("Default GIDs: ");
            if (this.dgids != null) {
                UpdateEngine.dumpArray(this.dgids, stringBuffer);
            }
            stringBuffer.append("\n");
            stringBuffer.append("Named GIDs: ");
            if (this.ngids != null) {
                UpdateEngine.dumpArray(this.ngids, stringBuffer);
            }
            stringBuffer.append("\n");
            stringBuffer.append("Default Models: ");
            if (this.dmodels != null) {
                UpdateEngine.dumpArray(this.dmodels, stringBuffer);
            }
            stringBuffer.append("\n");
            stringBuffer.append("Default Model IDs: ");
            if (this.dmids != null) {
                UpdateEngine.dumpArray(this.dmids, stringBuffer);
            }
            stringBuffer.append("\n");
            stringBuffer.append("flag: [" + this.flag + "]");
            return stringBuffer.toString();
        }
    }
}

