/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Arrays;
import java.util.List;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;

public class XSDConstructFilterHandler
implements FilterFuncHandler {
    public static final String BOOL_OP = "sem_apis.castToBoolean";
    public static final String DOUBLE_OP = "sem_apis.castToDouble";
    public static final String FLOAT_OP = "sem_apis.castToFloat";
    public static final String DECIMAL_OP = "sem_apis.castToDecimal";
    public static final String INTEGER_OP = "sem_apis.castToInteger";
    public static final String DATETIME_OP = "sem_apis.castToDateTime";
    public static final String STRING_OP = "sem_apis.castToString";

    @Override
    public String genSQL(List<String[]> list, String string, String string2) throws RDFException {
        String string3 = "";
        String string4 = "";
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        if (list.size() != 1) {
            throw new RDFException("Invalid number of arguments to " + string + ". Expecting 1 argument");
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema#string")) {
            string4 = STRING_OP;
            nArray = new int[]{1, 2, 3, 4, 5, 6};
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            string4 = BOOL_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            string4 = DATETIME_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#integer") || string.equals("http://www.w3.org/2001/XMLSchema#int")) {
            string4 = INTEGER_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#decimal")) {
            string4 = DECIMAL_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#double")) {
            string4 = DOUBLE_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#float")) {
            string4 = FLOAT_OP;
        } else {
            throw new RDFException("Unrecognized XSD constructor function");
        }
        string3 = QueryUtils.buildFuncCall(string4, nArray, Arrays.asList((Object[])list.get(0)));
        if (string4 == BOOL_OP) {
            string3 = "(" + string3 + " = 1)";
        }
        return string3;
    }
}

