/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import oracle.diagram.dif.DiagramElement;
import oracle.diagram.dif.GraphConnector;
import oracle.diagram.dif.GraphEdge;
import oracle.diagram.dif.GraphElement;
import oracle.diagram.dif.GraphicBridge;
import oracle.diagram.dif.JViewsGraphicMap;
import oracle.diagram.dif.Point;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.manager.ManagerUtil;

public abstract class JViewsGraphicBridge
implements GraphicBridge<IlvGraphic> {
    public static final String REBUILD_LINK = "oracle.diagram.framework.rebuildLink";
    private static final String BRIDGE = "oracle.diagram.dif.JViewsGraphicBridge";
    private JViewsGraphicMap m_graphicMap = new JViewsGraphicMap();

    @Override
    public void connectGraphics(GraphEdge ge) {
        IlvLinkImage link = this.m_graphicMap.findEdgeGraphic(ge);
        if (link == null) {
            return;
        }
        boolean origin = true;
        for (GraphConnector gc : ge.anchors()) {
            GraphElement end = gc.getGraphElement();
            IlvGraphic endGraphic = (IlvGraphic)this.m_graphicMap.findGraphic(end);
            if (endGraphic != null) {
                IlvPoint connPoint = JViewsGraphicBridge.createGraphicPoint(origin ? ge.getStartPoint() : ge.getEndPoint());
                IlvManager endGraphicManager = ManagerUtil.getManager(endGraphic);
                IlvTransformer endTrans = ManagerUtil.getConversionTransformer((IlvManager)link.getGraphicBag(), endGraphicManager);
                GraphicConnector graphicConnector = this.createGraphicConnector(endGraphic);
                graphicConnector.connectLink(link, connPoint, origin, endTrans);
            }
            origin = false;
        }
    }

    @Override
    public void updateConnector(GraphConnector gc) {
        GraphicConnector connector;
        IlvGraphic g = (IlvGraphic)this.getGraphicMap().findGraphic(gc.getGraphElement());
        if (g != null && (connector = GraphicConnector.findConnector(g)) != null) {
            for (GraphicPin pin : connector.getPins()) {
                IlvLinkImage link = pin.getLink();
                GraphEdge edge = this.getGraphicMap().findGraphEdge(link);
                if (edge == null) continue;
                gc.addGraphEdge(edge, pin.isOrigin());
            }
        }
    }

    public JViewsGraphicMap getGraphicMap() {
        return this.m_graphicMap;
    }

    public void updateContainedElements(GraphElement ge, IlvGraphic graphic) {
        ge.clearContained();
        this.updateChildren(ge, graphic);
    }

    private void updateChildren(GraphElement ge, IlvGraphic graphic) {
        if (graphic instanceof IlvGraphicBag) {
            IlvGraphicEnumeration children = ((IlvGraphicBag)graphic).getObjects();
            while (children.hasMoreElements()) {
                IlvGraphic child = children.nextElement();
                DiagramElement element = this.m_graphicMap.findDiagramElement(child);
                if (element == null) {
                    this.updateChildren(ge, child);
                    continue;
                }
                ge.addContained(element);
                element.update(this);
            }
        }
    }

    public void addGraphic(IlvGraphic parentGraphic, DiagramElement de, IlvGraphic graphic) {
        this.m_graphicMap.linkGraphic(de, graphic);
        if (parentGraphic != null) {
            if (parentGraphic instanceof IlvGrapher) {
                IlvGrapher grapher = (IlvGrapher)parentGraphic;
                if (graphic instanceof IlvLinkImage) {
                    grapher.addLink((IlvLinkImage)graphic, false);
                } else {
                    grapher.addNode(graphic, false);
                }
            } else if (parentGraphic instanceof IlvGraphicBag) {
                ((IlvGraphicBag)parentGraphic).addObject(graphic, false);
            } else {
                throw new IllegalArgumentException("Parent graphic not graphic bag");
            }
        }
    }

    protected GraphicConnector createGraphicConnector(IlvGraphic g) {
        return GraphicConnector.findOrCreateConnector(g);
    }

    public void setBridge(IlvGrapher rootGrapher) {
        if (rootGrapher.getGraphicBag() != null) {
            throw new IllegalStateException("Root grapher must not have bag");
        }
        rootGrapher.setProperty(BRIDGE, (Object)this);
    }

    public static JViewsGraphicBridge getBridge(IlvGraphic graphic) {
        IlvGraphicBag current;
        if (graphic == null) {
            return null;
        }
        IlvGraphicBag ilvGraphicBag = current = graphic instanceof IlvGraphicBag ? (IlvGraphicBag)graphic : graphic.getGraphicBag();
        while (true) {
            IlvGraphicBag parent;
            if ((parent = current.getGraphicBag()) == null) {
                if (current instanceof IlvGrapher) {
                    IlvGrapher g = (IlvGrapher)current;
                    return (JViewsGraphicBridge)g.getProperty(BRIDGE);
                }
                return null;
            }
            current = parent;
        }
    }

    public static IlvPoint createGraphicPoint(Point p) {
        return new IlvPoint((float)p.getX(), (float)p.getY());
    }

    public static Point createPoint(IlvPoint p) {
        return new Point(p.getX(), p.getY());
    }
}

