/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerViewInteractor;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditContext;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;

public class DefaultInPlaceEditPlugin
extends AbstractPlugin
implements InPlaceEditPlugin {
    private final DiagramContext _context;

    public DefaultInPlaceEditPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public boolean performInPlaceEdit(IlvManager mgr, IlvGraphic mainObj, IlvGraphic subObj) {
        if (this._context.getManagerView().getInteractor() instanceof EditInteractor) {
            return false;
        }
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this._context)) {
            return false;
        }
        if (!this.isEditable(mgr, mainObj, subObj)) {
            return false;
        }
        if (ReadOnlyUtil.checkWritableEdit(this._context, mainObj)) {
            InPlaceEditContext context = this.createInPlaceEditContext(mgr, mainObj, subObj);
            this._context.getManagerView().pushInteractor(this.createEditInteractor(context));
            return true;
        }
        return false;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected boolean isEditable(IlvManager mgr, IlvGraphic hit, IlvGraphic subHit) {
        IlvGraphic toEdit = subHit != null ? subHit : hit;
        return toEdit instanceof IlvLabelInterface && toEdit.isVisible();
    }

    protected InPlaceEditContext createInPlaceEditContext(IlvManager manager, IlvGraphic hit, IlvGraphic subHit) {
        return new InPlaceEditContext(manager, hit, subHit);
    }

    protected final IlvManagerViewInteractor createEditInteractor(JViewsEditor editor, InPlaceEditContext context) {
        throw new IllegalStateException("Should be calling createEditInteractor(InPlaceEditContext)");
    }

    protected IlvManagerViewInteractor createEditInteractor(InPlaceEditContext context) {
        return new EditInteractor(context);
    }
}

