/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.menu;

import java.util.EventObject;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.menu.DiagramContextMenuPlugin;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.view.View;

public class ViewDiagramContextMenuPlugin
extends AbstractPlugin
implements DiagramContextMenuPlugin {
    private final DiagramContext _context;
    private final View _view;
    private final ContextMenuListener _listener = new ContextMenuListener(){

        public void menuWillShow(ContextMenu contextMenu) {
            ViewDiagramContextMenuPlugin.this.menuWillShow(contextMenu);
        }

        public void menuWillHide(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(ViewDiagramContextMenuPlugin.this._listener);
            ViewDiagramContextMenuPlugin.this.menuWillHide(contextMenu);
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    };

    public ViewDiagramContextMenuPlugin(DiagramContext context, View view) {
        this._context = context;
        this._view = view;
    }

    @Override
    public void showContextMenu(EventObject event) {
        Context context = new Context(this._view.getContext());
        context.setEvent(event);
        ContextMenu menu = this._view.getContextMenu();
        if (menu == null) {
            menu = new ContextMenu();
        }
        menu.addContextMenuListener(this._listener);
        menu.show(context);
    }

    protected void menuWillShow(ContextMenu contextMenu) {
    }

    protected void menuWillHide(ContextMenu contextMenu) {
    }

    protected final View getView() {
        return this._view;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }
}

