/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import java.awt.dnd.DropTargetListener;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.framework.palette.AbstractUnifiedPaletteItemHandler;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDragEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetDropEvent;
import oracle.diagram.framework.palette.event.PaletteItemDropTargetEvent;

public final class DragEventDispatch {
    private static final String ACTIVE_TASK_KEY = "__ActivePaletteTask";

    private DragEventDispatch() {
    }

    public static void dragEnter(AbstractUnifiedPaletteItemHandler handler, PaletteItemDropTargetDragEvent dtde) {
        DropTargetListener dtl;
        PaletteTask task = handler.createPaletteTask(dtde.getDiagramContext(), dtde.getPaletteItem());
        dtde.getView().getManager().setProperty(ACTIVE_TASK_KEY, (Object)task);
        if (task != null) {
            task.invoke(false);
        }
        if ((dtl = DragEventDispatch.getDropTargetListener(dtde.getView())) != null) {
            dtl.dragEnter(dtde.getAWTDragEvent());
        }
    }

    public static void dragExit(AbstractUnifiedPaletteItemHandler handler, PaletteItemDropTargetEvent dte) {
        PaletteTask task;
        DropTargetListener dtl = DragEventDispatch.getDropTargetListener(dte.getView());
        if (dtl != null) {
            dtl.dragExit(dte.getAWTEvent());
        }
        if ((task = (PaletteTask)dte.getView().getManager().getProperty(ACTIVE_TASK_KEY)) != null) {
            task.abort();
            dte.getView().getManager().removeProperty(ACTIVE_TASK_KEY);
        }
    }

    public static void dragOver(AbstractUnifiedPaletteItemHandler handler, PaletteItemDropTargetDragEvent dtde) {
        DropTargetListener dtl = DragEventDispatch.getDropTargetListener(dtde.getView());
        if (dtl != null) {
            dtl.dragOver(dtde.getAWTDragEvent());
        }
    }

    public static void dropActionChanged(AbstractUnifiedPaletteItemHandler handler, PaletteItemDropTargetDragEvent dtde) {
        DropTargetListener dtl = DragEventDispatch.getDropTargetListener(dtde.getView());
        if (dtl != null) {
            dtl.dropActionChanged(dtde.getAWTDragEvent());
        }
    }

    public static PaletteTask drop(AbstractUnifiedPaletteItemHandler handler, PaletteItemDropTargetDropEvent dtde) {
        DropTargetListener dtl = DragEventDispatch.getDropTargetListener(dtde.getView());
        if (dtl != null) {
            dtl.drop(dtde.getAWTDropEvent());
        }
        return DragEventDispatch.getActivePaletteTask(dtde.getView());
    }

    protected static PaletteTask getActivePaletteTask(IlvManagerView view) {
        PaletteTask task = (PaletteTask)view.getManager().getProperty(ACTIVE_TASK_KEY);
        return task;
    }

    protected static DropTargetListener getDropTargetListener(IlvManagerView view) {
        IlvManagerViewInteractor interactor = view.getInteractor();
        if (interactor instanceof DragAndDropAwareInteractor) {
            DragAndDropAwareInteractor dnd = (DragAndDropAwareInteractor)interactor;
            return dnd.getDropTargetListener();
        }
        return null;
    }
}

