/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.ToStringConverter;
import oracle.diagram.framework.preference.propertyeditor.ColorTableCellEditor;
import oracle.ide.controls.CustomColorChoice;

public class ColorPropertyEditor
extends PropertyEditorSupport
implements PropertyEditorFactory,
PropertyEditorFactory2 {
    private static final int PAINT_INSETS = 3;
    private PropertyChangeListener _listener = new Listener();
    private TableCellRenderer _renderer;
    private ColorTableCellEditor _cellEditor;
    private ColorChoice _colorChoice;
    private PropertyValueApplier propertyValueApplier;

    public void applyValueFrom(Component c) {
        if (c instanceof JTextComponent) {
            this.setValue(((JTextComponent)c).getText());
            return;
        }
        if (c instanceof TextComponent) {
            this.setValue(((TextComponent)c).getText());
            return;
        }
        if (c instanceof JLabel) {
            this.setValue(((JLabel)c).getText());
            return;
        }
        if (c instanceof Label) {
            this.setValue(((Label)c).getText());
        }
    }

    public void setSelectedItemToStringConverter(ToStringConverter selectedItemToStringConverter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object newValue) {
        if (this._colorChoice != null) {
            Color color = (Color)newValue;
            try {
                this._colorChoice.removePropertyChangeListener(this._listener);
                try {
                    this._colorChoice.setSelectedColor(color);
                }
                catch (IllegalArgumentException iaex) {
                    this._colorChoice.setSelectedColor(null);
                }
            }
            finally {
                this._colorChoice.addPropertyChangeListener(this._listener);
            }
        }
        super.setValue(newValue);
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public final void paintValue(Graphics g, Rectangle paintBounds) {
        this.paintValue(this.getValue(), g, paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
    }

    @Override
    public String getJavaInitializationString() {
        return "new java.awt.Color(" + this.getAsText() + ")";
    }

    @Override
    public final String getAsText() {
        return null;
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object value) {
        this.setValue(value);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        if (this._renderer == null) {
            this._renderer = new ValueRenderer();
        }
        return this._renderer;
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        if (this._cellEditor == null) {
            this._cellEditor = new ColorTableCellEditor(this.getColorChoice());
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        return false;
    }

    public Component getTearOffEditor() {
        return null;
    }

    public boolean hasAdvancedEditor() {
        return false;
    }

    public Component getAdvancedEditor() {
        return null;
    }

    public boolean hasInlineEditor() {
        return true;
    }

    public Component getInlineEditor() {
        return this.getColorChoice();
    }

    protected void paintValue(Object value, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        Color currColor = (Color)value;
        g.setColor(Color.black);
        if (width > 20) {
            width = 20;
        }
        g.drawRect(x += 3, y += 3, width -= 6, height -= 6);
        g.setColor(currColor);
        g.fillRect(x + 1, y + 1, width - 1, height - 1);
        g.setColor(savedColor);
    }

    protected ColorChoice getColorChoice() {
        if (this._colorChoice == null) {
            this._colorChoice = new ColorChoice();
            this._colorChoice.setEditAllowed(true);
            this._colorChoice.setTransparentAllowed(false);
            this._colorChoice.setColorPalette(CustomColorChoice.DEFAULT_SWATCH_MODEL);
            this._colorChoice.setCustomColorPalette(MyCustomColorChoice.getCustomizedPalette());
            try {
                this._colorChoice.setSelectedColor((Color)this.getValue());
            }
            catch (IllegalArgumentException iaex) {
                this._colorChoice.setSelectedColor(null);
            }
            HelpUtils.setHelpID((JComponent)this._colorChoice.getCustomColorPane(), (String)"f1_dgmdselectcustomcolor_html");
            this._colorChoice.addPropertyChangeListener(this._listener);
        }
        return this._colorChoice;
    }

    private void _setValue(Object newValue) {
        super.setValue(newValue);
    }

    public EditorComponentInfo getEditorComponentInfo() {
        return null;
    }

    public void setEditorComponentInfo(EditorComponentInfo editorComponentInfo) {
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this.propertyValueApplier;
    }

    public void setPropertyValueApplier(PropertyValueApplier propertyValueApplier) {
        this.propertyValueApplier = propertyValueApplier;
    }

    private static final class MyCustomColorChoice
    extends CustomColorChoice {
        private MyCustomColorChoice() {
        }

        private static TwoDModel getCustomizedPalette() {
            return MyCustomColorChoice.getCustomPalette();
        }
    }

    private class ValueRenderer
    extends DefaultTableCellRenderer {
        private ValueRenderer() {
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setValue(null);
            Rectangle r = this.getBounds();
            r.x = 0;
            r.y = 0;
            Color c = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
            super.paintComponent(g);
            ColorPropertyEditor.this.paintValue(g, r);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == ColorPropertyEditor.this._colorChoice && "selectedColor".equals(e.getPropertyName())) {
                ColorPropertyEditor.this._setValue(ColorPropertyEditor.this._colorChoice.getSelectedColor());
                if (ColorPropertyEditor.this._cellEditor != null) {
                    ColorPropertyEditor.this._cellEditor.stopCellEditing();
                }
            }
        }
    }
}

