/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.editors.FontEditor;
import oracle.diagram.res.PreferenceResource;
import oracle.javatools.dialogs.MessageDialog;

class FontPropertyEditorImpl
extends FontEditor {
    public Component getCustomEditor() {
        VetoableFontPanelWrapper res = new VetoableFontPanelWrapper(super.getCustomEditor());
        HelpUtils.setHelpID((JComponent)res, (String)"f1_amodpropinspfont_html");
        this.setValue(this.getValue());
        return res;
    }

    public Component getSmallCustomEditor() {
        Component res = super.getSmallCustomEditor();
        this.setValue(this.getValue());
        return res;
    }

    public FontPane getTearOffFontPane() {
        FontPane res = super.getTearOffFontPane();
        this.setValue(this.getValue());
        return res;
    }

    public FontPane getAdvancedFontPane() {
        FontPane res = super.getAdvancedFontPane();
        this.setValue(this.getValue());
        return res;
    }

    public void paintValue(Object value, Graphics g, Locale locale, int x, int y, int width, int height) {
        Font savedFont = g.getFont();
        Font currFont = (Font)value;
        if (currFont == null) {
            currFont = savedFont;
        }
        if (currFont != null) {
            Font displayFont = currFont.deriveFont(12.0f);
            g.setFont(displayFont);
            FontMetrics metrics = g.getFontMetrics(displayFont);
            int ascent = metrics.getAscent();
            int fontHeight = ascent + metrics.getDescent();
            String s = displayFont.getName();
            g.drawString(s, x, y + (height - fontHeight) / 2 + ascent);
        }
        g.setFont(savedFont);
    }

    private class VetoableFontPanelWrapper
    extends JPanel
    implements VetoableChangeListener {
        VetoableFontPanelWrapper(Component actualPanel) {
            this.setLayout(new BorderLayout());
            this.add(actualPanel, "Center");
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            String propName = evt.getPropertyName();
            if ("closed".equals(propName)) {
                int fontSize;
                Boolean newValue = (Boolean)evt.getNewValue();
                if (!newValue.booleanValue()) {
                    return;
                }
                Font font = (Font)FontPropertyEditorImpl.this.getValue();
                if (font != null && (fontSize = font.getSize()) <= 0) {
                    ResourceBundle rb = PreferenceResource.getBundle();
                    String title = rb.getString("font.size.dialog.title.text");
                    String message = rb.getString("font.size.dialog.message.text");
                    MessageDialog.error((Component)this, (Object)message, (String)title, null);
                    throw new PropertyVetoException("", evt);
                }
            }
        }
    }
}

