/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.prototypes;

import ilog.views.IlvPoint;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;

public class PalettePrototypes {
    private static final String CSS_CLASS = "CSSclass";
    private final URL _url;
    private IlvSDMEngine _engine = null;
    private Map<String, Object> _prototypes = new HashMap<String, Object>();

    public PalettePrototypes(URL url) {
        this._url = url;
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
    }

    public IlvSDMModel getModel() {
        this.lazyInitialize();
        return this._engine.getModel();
    }

    public final Object getPrototype(String key) {
        this.lazyInitialize();
        return this._prototypes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object createFromPrototype(Object prototype, IlvSDMEngine engine, Object parent, Object after, IlvPoint location, int alignment, Map<String, Object> additionalProperties) {
        IlvSDMModel model = engine.getModel();
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        try {
            model.setAdjusting(true);
            IlvSDMModel srcModel = this._engine.getModel();
            Object o = this.createFromPrototype(srcModel, prototype, model, parent, after, m);
            for (Object oldObject : m.keySet()) {
                if (!srcModel.isLink(oldObject)) continue;
                Object newObject = m.get(oldObject);
                Object oldFrom = srcModel.getFrom(oldObject);
                Object oldTo = srcModel.getTo(oldObject);
                Object newFrom = m.get(oldFrom);
                Object newTo = m.get(oldTo);
                model.setFrom(newObject, newFrom);
                model.setTo(newObject, newTo);
            }
            if (o != null && additionalProperties != null) {
                for (String prop : additionalProperties.keySet()) {
                    Object value = additionalProperties.get(prop);
                    model.setObjectProperty(o, prop, value);
                }
            }
            if (o != null && location != null) {
                engine.moveObject(o, null, location.x, location.y, false, alignment, true);
            }
            Object object = o;
            return object;
        }
        finally {
            model.setAdjusting(false);
        }
    }

    protected String makeKey(IlvSDMModel model, Object object) {
        String tag = model.getTag(object);
        String cssClass = (String)model.getObjectProperty(object, CSS_CLASS);
        String key = null;
        key = cssClass != null && cssClass.length() > 0 ? tag + "." + cssClass : tag;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void lazyInitialize() {
        if (this._engine == null) {
            this._engine = new IlvSDMEngine();
            this._engine.setMetadataEnabled(true);
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(URLFileSystem.openInputStream((URL)this._url));
                this._engine.readXML((InputStream)bis);
                bis.close();
                bis = null;
                IlvSDMModel model = this._engine.getModel();
                Enumeration objects = model.getObjects();
                while (objects.hasMoreElements()) {
                    Object obj = objects.nextElement();
                    String key = this.makeKey(model, obj);
                    if (this._prototypes.containsKey(key)) continue;
                    this._prototypes.put(key, obj);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                    }
                }
            }
        }
    }

    private Object createFromPrototype(IlvSDMModel srcModel, Object src, IlvSDMModel destModel, Object parent, Object after, Map<Object, Object> map) {
        Object newObject = null;
        newObject = !srcModel.isLink(src) ? destModel.createNode(srcModel.getTag(src)) : destModel.createLink(srcModel.getTag(src));
        map.put(src, newObject);
        PalettePrototypes.copyProperties(srcModel, src, destModel, newObject);
        destModel.addObject(newObject, parent, after);
        Enumeration children = srcModel.getChildren(src);
        while (children != null && children.hasMoreElements()) {
            Object child = children.nextElement();
            this.createFromPrototype(srcModel, child, destModel, newObject, null, map);
        }
        return newObject;
    }

    public static void setNodeProperties(IlvSDMModel srcModel, Object srcObject, IlvSDMModel dstModel, Object dstObject) {
        if (srcModel != null && srcObject != null) {
            PalettePrototypes.copyProperties(srcModel, srcObject, dstModel, dstObject);
            PalettePrototypes.setNodePropertiesImpl(srcModel, srcObject, dstModel, dstObject);
        }
    }

    public static void setLinkProperties(IlvSDMModel srcModel, Object srcObject, IlvSDMModel dstModel, Object dstObject) {
        PalettePrototypes.copyProperties(srcModel, srcObject, dstModel, dstObject);
    }

    private static void copyProperties(IlvSDMModel srcModel, Object srcObject, IlvSDMModel dstModel, Object dstObject) {
        if (srcModel != null && srcObject != null) {
            String[] propNames = srcModel.getObjectPropertyNames(srcObject);
            for (int i = 0; i < propNames.length; ++i) {
                dstModel.setObjectProperty(dstObject, propNames[i], srcModel.getObjectProperty(srcObject, propNames[i]));
            }
            PalettePrototypes.setNodePropertiesImpl(srcModel, srcObject, dstModel, dstObject);
        }
    }

    private static void setNodePropertiesImpl(IlvSDMModel srcModel, Object srcObject, IlvSDMModel dstModel, Object dstObject) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        PalettePrototypes.setNodePropertiesImpl(srcModel, srcObject, dstModel, dstObject, map);
        for (Object obj : map.keySet()) {
            if (!srcModel.isLink(obj)) continue;
            Object newLink = map.get(obj);
            Object oldFrom = srcModel.getFrom(obj);
            Object oldTo = srcModel.getTo(obj);
            Object newFrom = map.get(oldFrom);
            Object newTo = map.get(oldTo);
            dstModel.setFrom(newLink, newFrom);
            dstModel.setTo(newLink, newTo);
        }
    }

    private static void setNodePropertiesImpl(IlvSDMModel srcModel, Object srcObject, IlvSDMModel dstModel, Object dstObject, Map<Object, Object> map) {
        Enumeration enumeration = srcModel.getChildren(srcObject);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object oldObj = enumeration.nextElement();
                Object newObj = srcModel.isLink(oldObj) ? dstModel.createLink(srcModel.getTag(oldObj)) : dstModel.createNode(srcModel.getTag(oldObj));
                if (newObj != null) {
                    map.put(oldObj, newObj);
                    dstModel.addObject(newObj, dstObject, null);
                    PalettePrototypes.copyProperties(srcModel, oldObj, dstModel, newObj);
                }
                PalettePrototypes.setNodePropertiesImpl(srcModel, oldObj, dstModel, newObj, map);
            }
        }
    }
}

