/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.menu.ActionRegistry;
import javax.ide.progress.IProgressListener;
import javax.ide.progress.ProgressManager;
import javax.ide.util.MetaResource;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.layout.LayoutUtil;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ComponentVersionManager;
import oracle.ide.Context;
import oracle.ide.ExitNotAllowedException;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeClipboard;
import oracle.ide.IdeController;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMacros;
import oracle.ide.IdeMainWindow;
import oracle.ide.LogWindowContentReader;
import oracle.ide.Version;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.DTCache;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.PlatformProperties;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.AcceleratorDefinitions;
import oracle.ide.keyboard.AcceleratorHook;
import oracle.ide.keyboard.DialogWatcher;
import oracle.ide.keyboard.GrabbableFocusManager;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogManager;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.MigrationManager;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.IdeSystemMigrator;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.accessibility.HighContrast;
import oracle.ide.net.TraceFileSystemAccess;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.nulls.NullSecurityManager;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.osgi.boot.api.SplashScreen;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.usages.UsagesTracker;
import oracle.ide.util.AddinPolicyUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.ChainingUncaughtExceptionHandler;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.JDevUncaughtExceptionHandler;
import oracle.ide.util.OutOfFileHandlesUncaughtHandler;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideri.util.Product;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.internal.ui.EventQueueObserver;
import oracle.javatools.internal.ui.EventQueueWrapper;
import oracle.javatools.internal.ui.EventThreadHangMonitor;
import oracle.javatools.internal.ui.SwingThreadViolationDetector;
import oracle.javatools.jndi.LocalInitialContextFactoryBuilder;
import oracle.javatools.jndi.Names;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.ui.InputInfo;
import oracle.javatools.util.AccessibleUtils;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import oracle.javatools.util.SwingUtils2;

public class IdeCore {
    private static final String APPLICATIONS_FILENAME = "applications.xml";
    private static final Logger LOG = Logger.getLogger(IdeCore.class.getName());
    private static final String STARTUP_TIMING_PROPERTY = "oracle.ide.launcher.startup.time";
    private static final String INSTALL_PATH = "Ide.InstallPath";
    private final IdeArgs ideArgs;
    private final IdeController _controller;
    private final HashMap cmdTable = new HashMap();
    private final HashMap cmdHash = new HashMap();
    private static int nextUniqueCmd = 90;
    private WaitCursor waitCursor;
    private ActionMap anyActionMap;
    private String oracleHome;
    private String ideHome;
    private String userHome;
    private String trueUserHome;
    private String binDir;
    private String systemDirectory;
    private String productVersion;
    private IdeSettings settings;
    private DTCache dtCache;
    private KeyStrokeContextRegistry keyStrokeContextRegistry;
    private IdeProperties idePropertiesInstance;
    private IdeSystem ideSystem;
    private Workspaces workspaces;
    private ComponentVersionManager versionMgr = new ComponentVersionManager();
    private Map _macros;
    private ArrayList _ideListeners;
    private volatile IdeMainWindow mainWindow;
    private boolean _quitting;
    private boolean _starting;
    private boolean forceInvokeLater;
    private String startupCaption = Version.NAME;
    protected String productID = "oracle.ide";
    private SplashScreen _splashScreen;
    private Boolean mainWindowAlreadyOpened = Boolean.FALSE;
    private static ThreadLocal<WorkspaceProject> activeWorkspaceProject = new ThreadLocal();
    private static final Log ACTIVE_LOG = new Log("active-override");
    private static final boolean ACTIVE_WORKSPACE_OVERRIDE = !Boolean.getBoolean("ide.disable.active.workspace.override");

    protected IdeCore(IdeArgs ideArgs) {
        this.ideArgs = ideArgs;
        this._controller = new IdeController();
    }

    public void useInvokeLaterForAddinsLoadedEvenThoughHeadless() {
        this.forceInvokeLater = true;
    }

    protected SecurityManager getSecurityManager() {
        return new NullSecurityManager(){
            private SecurityManager clipboardDelegate = IdeClipboard.createSecurityManagerForSystemClipboard();

            public void checkExit(int status) {
                if (Beans.isDesignTime() && System.getProperty("oracle.ide.ignore.checkExit") == null) {
                    throw new ExitNotAllowedException();
                }
            }

            public void checkSystemClipboardAccess() {
                if (this.clipboardDelegate != null) {
                    this.clipboardDelegate.checkSystemClipboardAccess();
                }
            }

            public ThreadGroup getThreadGroup() {
                AddinPolicyUtils.creatingThreadPolicyCheck();
                return super.getThreadGroup();
            }
        };
    }

    protected AddinManager getAddinManager() {
        return null;
    }

    protected Addin[] createCoreModules(IdeMainWindow mainWindow) {
        return null;
    }

    protected void initializeLookAndFeel() {
        this.initializePlatformLookAndFeel();
    }

    private void initializePlatformLookAndFeel() {
        try {
            if (!SwingUtils2.isInHighConstrastMode()) {
                try {
                    UIManager.getDefaults().put("ClassLoader", IdeCore.class.getClassLoader());
                    Class<?> cls = Class.forName("oracle.bali.ewt.olaf2.OracleLookAndFeel");
                    UIManager.setLookAndFeel(cls.getName());
                }
                catch (Exception e) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception ex) {
            Assert.println((String)"Failed setting Oracle look and feel");
        }
    }

    public IdeArgs getIdeArgs() {
        return this.ideArgs;
    }

    protected boolean isHeadless() {
        return !this.ideArgs.getCreateUI();
    }

    protected boolean isInOSGiMode() {
        String value = System.getProperty("oracle.ide.classload.layer");
        return value != null && value.equalsIgnoreCase("osgi");
    }

    Controller getController() {
        return this._controller;
    }

    protected String getProductID() {
        return this.productID;
    }

    String getProductVersion() {
        return this.productVersion;
    }

    String getBinDirectory() {
        return this.binDir;
    }

    String getHomeDirectory() {
        return this.ideHome;
    }

    String getOracleHomeDirectory() {
        if (this.oracleHome == null) {
            this.oracleHome = System.getProperty("oracle.home");
            if (this.oracleHome == null) {
                File f = new File(this.getHomeDirectory());
                this.oracleHome = f.getParent();
            }
            if (!this.oracleHome.endsWith(File.separator)) {
                this.oracleHome = this.oracleHome + File.separator;
            }
        }
        return this.oracleHome;
    }

    String getLibDirectory() {
        return this.getHomeDirectory() + "lib" + File.separator;
    }

    String getUserHomeDirectory() {
        return this.userHome;
    }

    String getTrueUserHomeDirectory() {
        return this.trueUserHome;
    }

    String getSystemDirectory() {
        return this.systemDirectory;
    }

    String getWorkDirectory() {
        Workspaces wsps = this.getWorkspaces();
        if (wsps != null && wsps.getWorkDirectory() != null) {
            URL workDirURL = wsps.getWorkDirectory();
            return URLFileSystem.getPlatformPathName((URL)workDirURL) + File.separator;
        }
        return this.getDefaultWorkDirectoryLocation();
    }

    private String getDefaultWorkDirectoryLocation() {
        String defaultLocation = System.getProperty("ide.work.dir");
        if (ModelUtil.hasLength((String)defaultLocation)) {
            if (!(defaultLocation = IdeCore.canonicalize(defaultLocation)).endsWith(File.separator)) {
                defaultLocation = defaultLocation + File.separator;
            }
            defaultLocation = defaultLocation + "mywork";
            defaultLocation = defaultLocation + File.separator;
        } else {
            defaultLocation = this.getHomeDirectory() + "mywork" + File.separator;
        }
        return defaultLocation;
    }

    String getProgramName() {
        return IdeUtil.getProgramName();
    }

    String getProgramShortName() {
        return IdeUtil.getProgramShortName();
    }

    IdeProperties getIdeProperties() {
        return this.idePropertiesInstance;
    }

    protected String getProperty(String key, String def) {
        IdeProperties props = this.getIdeProperties();
        return props != null ? props.getProperty(key, def) : def;
    }

    String setProperty(String key, String value) {
        IdeProperties props = this.getIdeProperties();
        return (String)(props != null ? props.setProperty(key, value) : null);
    }

    protected IdeMainWindow getMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = (IdeMainWindow)MainWindow.getMainWindow((javax.naming.Context)Names.newInitialContext(), (int)1);
        }
        return this.mainWindow;
    }

    @Deprecated
    WaitCursor getWaitCursor() {
        if (this.waitCursor == null) {
            this.waitCursor = new MainWindowWaitCursor((Component)((Object)this.getMainWindow()));
        }
        return this.waitCursor;
    }

    ComponentVersionManager getVersionInfo() {
        return this.versionMgr;
    }

    IdeSettings getSettings() {
        return this.loadIdeSettings();
    }

    KeyStrokeContextRegistry getKeyStrokeContextRegistry() {
        if (this.keyStrokeContextRegistry == null) {
            this.keyStrokeContextRegistry = new KeyStrokeContextRegistry();
            this.keyStrokeContextRegistry.addListener(new CollectionListener(){

                @Override
                public void elementAdded(CollectionEvent event) {
                    KeyStrokeOptions kso = IdeCore.this.getSettings().getKeyStrokeOptions();
                    KeyStrokeContext ksc = (KeyStrokeContext)event.getElement();
                    kso.addContext(ksc);
                }

                @Override
                public void elementRemoved(CollectionEvent event) {
                    KeyStrokeOptions kso = IdeCore.this.getSettings().getKeyStrokeOptions();
                    KeyStrokeContext ksc = (KeyStrokeContext)event.getElement();
                    kso.removeContext(ksc);
                }
            });
        }
        return this.keyStrokeContextRegistry;
    }

    EnvironOptions getEnvironOptions() {
        return EnvironOptions.getInstance(Preferences.getPreferences());
    }

    DTCache getDTCache() {
        if (this.dtCache == null) {
            this.dtCache = new DTCache();
            this.dtCache.load();
        }
        return this.dtCache;
    }

    protected URL productSystemDirectory() {
        return ExtensionRegistry.getExtensionRegistry().getSystemDirectory(this.getProductID());
    }

    IdeSystem getSystem() {
        if (this.ideSystem == null) {
            URL systemDir = this.productSystemDirectory();
            URL url = URLFactory.newURL((URL)systemDir, (String)"System.sys");
            if (URLFileSystem.exists((URL)url)) {
                this.ideSystem = new IdeSystem(url);
            } else {
                IdeSystem s = IdeSystemMigrator.getRestoredSystem();
                if (s != null) {
                    this.ideSystem = s;
                } else {
                    url = URLFactory.newURL((URL)systemDir, (String)APPLICATIONS_FILENAME);
                    this.ideSystem = new IdeSystem(url);
                }
            }
        }
        return this.ideSystem;
    }

    oracle.ide.model.Preferences getPreferences() {
        return this.getSystem().getPreferences();
    }

    Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = (Workspaces)this.getSystem().getChild(Workspaces.class);
            if (this.workspaces == null) {
                this.workspaces = new Workspaces();
            }
        }
        return this.workspaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdeListener(final IdeListener l) {
        if (this._ideListeners == null) {
            this._ideListeners = new ArrayList(2);
        }
        Boolean bl = this.mainWindowAlreadyOpened;
        synchronized (bl) {
            if (!this.mainWindowAlreadyOpened.booleanValue()) {
                this._ideListeners.add(l);
            } else {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            l.mainWindowOpened(new IdeEvent(2));
                        }
                        catch (Throwable e) {
                            LOG.log(Level.SEVERE, "Exception firing mainWindowOpened to " + l, e);
                        }
                    }
                });
                t.start();
            }
        }
    }

    void removeIdeListener(IdeListener l) {
        if (this._ideListeners != null) {
            this._ideListeners.remove(l);
        }
    }

    InputMap getIdeInputMap() {
        return this.getMainWindow().getInputMap();
    }

    ActionMap getIdeActionMap() {
        IdeMainWindow mainWindow = this.getMainWindow();
        if (mainWindow == null) {
            if (this.anyActionMap == null) {
                this.anyActionMap = new ActionMap();
            }
            return this.anyActionMap;
        }
        return mainWindow.getActionMap();
    }

    boolean isQuitting() {
        return this._quitting;
    }

    boolean isStarting() {
        return this._starting;
    }

    int createCmdID(String commandName) {
        return this.createCmdID(-1, commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createCmdID(int nCmdID, String commandName) {
        HashMap hashMap = this.cmdHash;
        synchronized (hashMap) {
            if (nCmdID == -1) {
                nCmdID = ++nextUniqueCmd;
            }
            Integer cmdID = nCmdID;
            this.cmdTable.put(cmdID, commandName);
            this.cmdHash.put(commandName, cmdID);
        }
        return nCmdID;
    }

    int findOrCreateCmdID(String commandName) {
        return this.findOrCreateCmdID(-1, commandName);
    }

    private int findOrCreateCmdID(int nCmdID, String commandName) {
        Integer cmdID = this.findCmdID(commandName);
        if (cmdID != null) {
            return cmdID;
        }
        return this.createCmdID(nCmdID, commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer findCmdID(String commandName) {
        HashMap hashMap = this.cmdHash;
        synchronized (hashMap) {
            return (Integer)this.cmdHash.get(commandName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findCmdName(int cmdId) {
        HashMap hashMap = this.cmdHash;
        synchronized (hashMap) {
            return (String)this.cmdTable.get(cmdId);
        }
    }

    Map getMacros() {
        if (this._macros == null) {
            String mIdeHome = this.getHomeDirectory();
            String mSystem = this.getSystemDirectory();
            String mUserHome = this.getUserHomeDirectory();
            String mWorkDir = this.getWorkDirectory();
            this._macros = new IdeMacros(mIdeHome, mSystem, mUserHome, mWorkDir).getMap();
        }
        return this._macros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int quit(IdeAction action, Context context) {
        if (this._quitting) {
            return 1;
        }
        this._quitting = true;
        Command command = CommandProcessor.createCommandFromMeta(action.getCommandMetaClass(), context);
        command.setData(this.getMainWindow().getIdeMainWindowView());
        int status = 1;
        try {
            status = CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            status = 1;
        }
        finally {
            if (status == 1) {
                this._quitting = false;
            }
        }
        return status;
    }

    void terminate() {
        this.fireMainWindowEvent(3);
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.activateLayout(null, false);
        }
        Set<Feature> reload = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry().getFeaturesToReloadAtStartup();
        HashSet<String> ids = new HashSet<String>(reload.size());
        for (Feature f : reload) {
            ids.add(f.getId());
        }
        ExtensionPreferences extPrefs = ExtensionPreferences.getInstance();
        extPrefs.setFeatureIdsToReloadAtStartup(ids);
        try {
            extPrefs.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!Ide.isQuitting() || GraphicsEnvironment.isHeadless()) {
            SaveAllCommand.saveSystemFiles();
        }
        TraceFileSystemAccess.shutdown();
        ExitCommand.runTerminateHook();
        AddinPolicyUtils.applicationExiting();
    }

    void fireMainWindowEvent(final int nEventID) {
        if (2 == nEventID) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    JFrame mainWindow = SplashScreen.getMainWindow();
                    if (mainWindow != null) {
                        mainWindow.setEnabled(true);
                        if (!mainWindow.hasFocus()) {
                            mainWindow.setVisible(true);
                        }
                    }
                    if (IdeCore.this._splashScreen != null && WindowManagerStartingController.getInstance() == null) {
                        IdeCore.this._splashScreen.destroy();
                    }
                    IdeCore.this._splashScreen = null;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception while trying to dismiss splash screen and enable main window", e);
                }
            }
        }
        if (this._ideListeners != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = IdeCore.this._ideListeners.size();
                    if (n > 0) {
                        IdeEvent e = new IdeEvent(nEventID);
                        Assert.startTiming((String)("oracle.ide.Ide.fireMainWindowEvent(" + e + ")"), (String)("Firing " + e), (boolean)false);
                        IdeListener[] l = IdeCore.this._ideListeners.toArray(new IdeListener[n]);
                        for (int i = 0; i < n; ++i) {
                            IdeCore.this.fireMainWindowEvent(l[i], e);
                        }
                        Assert.endTiming((String)("oracle.ide.Ide.fireMainWindowEvent(" + e + ")"), (String)("Fired " + e), null, (boolean)false);
                    }
                }
            };
            if ((this.getIdeArgs().getCreateUI() || this.forceInvokeLater) && nEventID != 3) {
                Thread t = new Thread(runnable);
                t.start();
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMainWindowEvent(IdeListener l, IdeEvent e) {
        switch (e.getID()) {
            case 2: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.mainWindowOpened");
                    l.mainWindowOpened(e);
                    PerformanceLogger.get().stopTiming("IdeListener.mainWindowOpened", l.getClass().getName());
                    break;
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing mainWindowOpened to " + l, exc);
                    break;
                }
                finally {
                    LogWindowContentReader.printLogWindowContentToFileForTestingOnly();
                }
            }
            case 3: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.mainWindowClosing");
                    l.mainWindowClosing(e);
                    PerformanceLogger.get().stopTiming("IdeListener.mainWindowClosing", l.getClass().getName());
                    break;
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing mainWindowClosing to " + l, exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstallDirectory(File systemDir) {
        BufferedInputStream in = null;
        try {
            Properties ideProps = new Properties();
            File propsFile = new File(systemDir, "ide.properties");
            in = new BufferedInputStream(new FileInputStream(propsFile));
            ideProps.load(in);
            String string = ideProps.getProperty(INSTALL_PATH, null);
            return string;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load ide.properties", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static void _registerStreamFactory() {
        try {
            URL.setURLStreamHandlerFactory(URLStreamHandlerFactoryQueue.getInstance());
        }
        catch (Error error) {
            // empty catch block
        }
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.startsWith("ide.")) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) {
                            return new URLConnection(u){

                                @Override
                                public void connect() {
                                    this.connected = true;
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return URLFileSystem.openInputStream((URL)this.url);
                                }

                                @Override
                                public OutputStream getOutputStream() throws IOException {
                                    return URLFileSystem.openOutputStream((URL)this.url);
                                }
                            };
                        }
                    };
                }
                return null;
            }
        });
    }

    protected void registerStreamFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startupImpl() {
        Logger l2;
        LogManager lgm;
        HashStructureHook hook;
        URLFileSystemHelper fileSystemHelper;
        String systemDirProperty;
        IdeMainWindow mainWindow;
        if (this._starting) {
            throw new IllegalStateException("IDE is already started");
        }
        LayoutUtil.setDesignTime(null, (boolean)false);
        this._starting = true;
        SplashScreen splashScreen = this._splashScreen = this.isHeadless() ? null : SplashScreen.getInstance();
        if (this._splashScreen != null) {
            ProgressManager.beginProgress();
            ProgressManager.registerListener((String)"extensions", (IProgressListener)new SplashScreenProgressListener("extensions"));
            ProgressManager.registerListener((String)"migration", (IProgressListener)new SplashScreenProgressListener("migration"));
            ProgressManager.registerListener((String)"initializing", (IProgressListener)new SplashScreenProgressListener("initializing"));
            ProgressManager.registerListener((String)"windows", (IProgressListener)new SplashScreenProgressListener("windows"));
            ProgressManager.registerListener((String)"editors", (IProgressListener)new SplashScreenProgressListener("editors"));
        }
        if (this.isHeadless()) {
            mainWindow = null;
        } else {
            mainWindow = (IdeMainWindow)((Object)SplashScreen.getMainWindow());
            JFrame startupWindow = SplashScreen.getOwner();
            if (startupWindow != null) {
                IdeUtil.setStartupWindow(startupWindow);
            }
        }
        this.registerStreamFactory();
        System.setProperty("ide.build", Version.BUILD_LABEL);
        ToStringManager.registerCustomConverter(KeyStroke2String.class);
        Object2Dom.exemptTypeFromIdref(Reference.class);
        Object2Dom.exemptTypeFromIdref(KeyStroke.class);
        this.binDir = IdeCore.canonicalize(System.getProperty("user.dir", "."));
        if (!this.binDir.endsWith(File.separator)) {
            this.binDir = this.binDir + File.separator;
        }
        this.ideHome = IdeCore.canonicalize(System.getProperty("ide.home", null));
        if (!ModelUtil.hasLength((String)this.ideHome)) {
            File f = new File(this.binDir);
            this.ideHome = f.getParent();
        }
        if (!this.ideHome.endsWith(File.separator)) {
            this.ideHome = this.ideHome + File.separator;
        }
        String ideUserDir = System.getProperty("ide.pref.dir");
        this.userHome = IdeCore.canonicalize(ideUserDir);
        if (!ModelUtil.hasLength((String)this.userHome)) {
            ideUserDir = System.getProperty("ide.user.dir");
            this.userHome = IdeCore.canonicalize(ideUserDir);
            if (!ModelUtil.hasLength((String)this.userHome)) {
                this.userHome = this.ideHome;
            }
        }
        if (!this.userHome.endsWith(File.separator)) {
            this.userHome = this.userHome + File.separator;
        }
        this.trueUserHome = IdeCore.canonicalize(System.getProperty("user.home", null));
        if (!ModelUtil.hasLength((String)this.trueUserHome)) {
            this.trueUserHome = this.userHome;
        } else if (!this.trueUserHome.endsWith(File.separator)) {
            this.trueUserHome = this.trueUserHome + File.separator;
        }
        this.productVersion = System.getProperty("product.version", null);
        if (!ModelUtil.hasLength((String)this.productVersion)) {
            this.productVersion = Version.VER + "." + Version.BUILD_NUM;
        }
        this.systemDirectory = (systemDirProperty = System.getProperty("ide.system.dir")) != null ? systemDirProperty : this.userHome + "system" + Version.VER_FULL + File.separator;
        URLFileSystemHelper fileHelper = URLFileSystem.findHelper((String)"file");
        if (fileHelper != null && (fileSystemHelper = IdeCore.getFileSystemHelper(fileHelper)) != null) {
            URLFileSystem.registerHelper((String)"file", (URLFileSystemHelper)fileSystemHelper);
        }
        boolean userDirectoryCreated = false;
        boolean systemDirectoryCreated = false;
        int numOfFilesInSystemBeforePrefsAreMigrated = 6;
        try {
            URL systemDirectoryURL;
            URL userSettingsDirURL = URLFactory.newFileURL((String)Ide.getUserSettingsDirectory());
            if (!URLFileSystem.exists((URL)userSettingsDirURL)) {
                URLFileSystem.mkdirs((URL)userSettingsDirURL);
                userDirectoryCreated = true;
            }
            if (URLFileSystem.exists((URL)(systemDirectoryURL = URLFactory.newFileURL((String)Ide.getSystemDirectory())))) {
                URLFileSystem.FileInfo[] systemDirContents = URLFileSystem.ls((URL)systemDirectoryURL);
                systemDirectoryCreated = systemDirContents.length <= 6;
            } else {
                System.err.println(systemDirectoryURL + " was not found. It should have been created as part of configuring Equinox. Creating it now, but the product might not work as intended ... ");
                URLFileSystem.mkdirs((URL)systemDirectoryURL);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.createCmdID(0, "Ide.NEW_WORKSPACE_CMD_ID");
        this.createCmdID(67, "Ide.NEW_VIEW_CMD_ID");
        this.createCmdID(68, "Ide.FREEZE_CMD_ID");
        this.createCmdID(70, "ACTIVATE_LEFT_BUTTON_CMD_ID");
        this.createCmdID(71, "ACTIVATE_RIGHT_BUTTON_CMD_ID");
        this.createCmdID(2, "Ide.NEW_PROJECT_CMD_ID");
        this.createCmdID(3, "Ide.NEW_EMPTY_PROJECT_CMD_ID");
        this.createCmdID(4, "Ide.EXIT_CMD_ID");
        this.createCmdID(5, "Ide.UNDO_CMD_ID");
        this.createCmdID(6, "Ide.REDO_CMD_ID");
        this.createCmdID(65, "Ide.SYSTEM_CMD_ID");
        this.createCmdID(64, "Ide.APPLICATIONS_CMD_ID");
        this.createCmdID(66, "Ide.CONNECTIONS_CMD_ID");
        this.createCmdID(8, "Ide.NEW_CLASS_CMD_ID");
        this.createCmdID(9, "Ide.OPEN_CMD_ID");
        this.createCmdID(10, "Ide.REOPEN_CMD_ID");
        this.createCmdID(11, "Ide.SAVE_CMD_ID");
        this.createCmdID(12, "Ide.SAVE_AS_CMD_ID");
        this.createCmdID(13, "Ide.SAVE_ALL_CMD_ID");
        this.createCmdID(52, "Ide.REVERT_CMD_ID");
        this.createCmdID(14, "Ide.RENAME_CMD_ID");
        this.createCmdID(15, "Ide.PRINTER_SETUP_CMD_ID");
        this.createCmdID(16, "Ide.PRINT_CMD_ID");
        this.createCmdID(17, "Ide.CUT_CMD_ID");
        this.createCmdID(18, "Ide.COPY_CMD_ID");
        this.createCmdID(77, "Ide.COPY_PATH_CMD_ID");
        this.createCmdID(19, "Ide.PASTE_CMD_ID");
        this.createCmdID(78, "Ide.EXTENDED_PASTE_CMD_ID");
        this.createCmdID(20, "Ide.DELETE_CMD_ID");
        this.createCmdID(48, "Ide.CLOSE_NODE_CMD_ID");
        this.createCmdID(51, "Ide.REFRESH_CMD_ID");
        this.createCmdID(21, "Ide.REMOVE_FILE_CMD_ID");
        this.createCmdID(72, "Ide.RELOAD_NODES_CMD_ID");
        this.createCmdID(47, "Ide.REMOVE_FROM_DISK_CMD_ID");
        this.createCmdID(22, "Ide.SELECT_ALL_CMD_ID");
        this.createCmdID(23, "Ide.FIND_CMD_ID");
        this.createCmdID(24, "Ide.REPLACE_CMD_ID");
        this.createCmdID(25, "Ide.SEARCH_AGAIN_CMD_ID");
        this.createCmdID(53, "Ide.SEARCH_BACKWARD_CMD_ID");
        this.createCmdID(26, "Ide.INCREMENTAL_SEARCH_FORWARD_CMD_ID");
        this.createCmdID(27, "Ide.INCREMENTAL_SEARCH_BACKWARD_CMD_ID");
        this.createCmdID(28, "Ide.SEARCH_SOURCE_PATH_CMD_ID");
        this.createCmdID(29, "Ide.GOTO_LINE_NUMBER_CMD_ID");
        this.createCmdID(30, "Ide.NEXTMSG_CMD_ID");
        this.createCmdID(31, "Ide.PREVMSG_CMD_ID");
        this.createCmdID(32, "Ide.BROWSE_SYMBOL_CMD_ID");
        this.createCmdID(83, "Ide.BROWSE_SYMBOL_DOC_CMD_ID");
        this.createCmdID(33, "Ide.INSPECTOR_CMD_ID");
        this.createCmdID(34, "Ide.LOG_WINDOW_CMD_ID");
        this.createCmdID(35, "Ide.PROJECT_SETTINGS_CMD_ID");
        this.createCmdID(36, "Ide.TOOLBAR_CMD_ID");
        this.createCmdID(69, "Ide.STATUS_BAR_CMD_ID");
        this.createCmdID(37, "Ide.DEFAULT_PROJECT_SETTINGS_CMD_ID");
        this.createCmdID(38, "Ide.IDE_SETTINGS_CMD_ID");
        this.createCmdID(39, "Ide.CLOSE_ALL_CMD_ID");
        this.createCmdID(44, "Ide.STRUCTURE_CHANGE_CMD_ID");
        this.createCmdID(45, "Ide.PROPERTY_SET_CMD_ID");
        this.createCmdID(49, "Ide.EXPLORER_CMD_ID");
        this.createCmdID(40, "Ide.NEXT_EDITOR_CMD_ID");
        this.createCmdID(41, "Ide.PREV_EDITOR_CMD_ID");
        this.createCmdID(42, "Ide.NEXT_EDITORFRAME_CMD_ID");
        this.createCmdID(43, "Ide.PREV_EDITORFRAME_CMD_ID");
        this.createCmdID(50, "Ide.CONTEXT_MENU_CMD_ID");
        this.createCmdID(54, "Ide.EXPAND_ALL_CMD_ID");
        this.createCmdID(55, "Ide.COLLAPSE_ALL_CMD_ID");
        this.createCmdID(84, "Ide.EXPAND_METHODS_CMD_ID");
        this.createCmdID(85, "Ide.COLLAPSE_METHODS_CMD_ID");
        this.createCmdID(86, "Ide.EXPAND_DOC_CMD_ID");
        this.createCmdID(87, "Ide.COLLAPSE_DOC_CMD_ID");
        this.createCmdID(88, "Ide.COLLAPSE_BLOCK_CMD_ID");
        this.createCmdID(89, "Ide.EXPAND_BLOCK_CMD_ID");
        this.createCmdID(56, "Ide.PROPERTIES_CMD_ID");
        this.createCmdID(57, "Ide.NAVIGATE_CMD_ID");
        this.createCmdID(58, "Ide.WINDOW_TILE_HORZ_CMD_ID");
        this.createCmdID(59, "Ide.WINDOW_TILE_VERT_CMD_ID");
        this.createCmdID(60, "Ide.WINDOW_CASCADE_CMD_ID");
        this.createCmdID(61, "Ide.WINDOWS_DOT_DOT_DOT_CMD_ID");
        this.createCmdID(73, "Ide.BACK_CMD_ID");
        this.createCmdID(74, "Ide.FORWARD_CMD_ID");
        this.createCmdID(75, "Ide.LAST_EDIT_CMD_ID");
        this.createCmdID(76, "Ide.REPLACE_SOURCE_PATH_CMD_ID");
        this.createCmdID(79, "Ide.ABOUT_CMD_ID");
        this.createCmdID(82, "Ide.DUPLICATE_SELECTION_CMD_ID");
        this.createCmdID(81, "Ide.SELECT_BLOCK_CMD_ID");
        String encodingsFileStr22 = System.getProperty("ide.encodings.file");
        String oracleHome = this.getOracleHomeDirectory();
        File ideBinDir = new File(oracleHome, "ide" + File.separatorChar + "bin");
        File encodingsFile = new File(ideBinDir, encodingsFileStr22 != null ? encodingsFileStr22 : "encodings.xml");
        Encodings.setEncodingsFile((File)encodingsFile);
        Assert.startTiming((String)"oracle.ide.Ide.initializeIDEFeatures", null, (boolean)false);
        System.setProperty("java.naming.factory.initial", "oracle.javatools.jndi.LocalInitialContextFactory");
        try {
            NamingManager.setInitialContextFactoryBuilder((InitialContextFactoryBuilder)new LocalInitialContextFactoryBuilder());
        }
        catch (NamingException encodingsFileStr22) {
            // empty catch block
        }
        Assert.endTiming((String)"oracle.ide.Ide.initializeIDEFeatures", (String)"Initialized IDE features", null, (boolean)false);
        InputInfo.initialize();
        if (this.ideArgs.getCreateUI()) {
            this.initializePlatformLookAndFeel();
        }
        PlatformProperties.setForceLoad(this.ideArgs.getPlatformFileName());
        this.initializeBeansDesignTime();
        File systemDir = new File(this.getSystemDirectory() + File.separator + "o.ide");
        System.setProperty("ide.firstrun", String.valueOf(!systemDir.exists()));
        boolean inAde = false;
        for (File dir = new File(this.oracleHome); dir != null; dir = dir.getParentFile()) {
            String lowerName = dir.getName().toLowerCase();
            if (!"ade".equals(lowerName) && !".ade".equals(lowerName)) continue;
            inAde = true;
            break;
        }
        System.setProperty("ide.devbuild", String.valueOf(inAde));
        Diagnostics.setDiagnosticDirectory((File)new File(System.getProperty("ide.diagnostics.dir")));
        Assert.startTiming((String)"oracle.ide.Ide.startupImpl(AddinManager)", null, (boolean)false);
        this.getAddinManager();
        Assert.endTiming((String)"oracle.ide.Ide.startupImpl(AddinManager)", (String)"Initialized Addin Manager", null, (boolean)false);
        if (this._splashScreen != null) {
            this._splashScreen.completeProgress("startup");
        }
        ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
        PerformanceLogger.get().stopTiming("init_extensionRegistry", "Initialized extensions");
        ProgressManager.completeProgress((String)"extensions");
        if (!Boolean.getBoolean("ide.eventqueuewrapper.disable")) {
            EventQueueWrapper eventQueue = EventQueueWrapper.install();
            EventThreadHangMonitor monitor = EventThreadHangMonitor.create((JFrame)((Object)mainWindow));
            if (monitor != null) {
                eventQueue.addObserver((EventQueueObserver)monitor);
            }
        }
        if (!AccessibleUtils.isAssistiveTechnologySet()) assert (SwingThreadViolationDetector.install());
        PerformanceLogger.get().startTiming("init_branding", "Branding...");
        String productId = this.productID = Product.getProductID();
        if (productId != null && reg.findExtension(productId) == null) {
            System.err.println("Product extension " + productId + " could not be loaded. The product cannot start.");
            System.err.println("Disabled extensions:");
            for (String id : reg.getDisabledExtensions()) {
                System.err.println("  " + id + ": " + reg.getNotLoadedReason(id));
            }
            System.exit(1);
        }
        if (this.ideArgs.getCreateUI()) {
            this.installAboutBox();
        }
        PerformanceLogger.get().stopTiming("init_branding", "Branded");
        Assert.startTiming((String)"oracle.ide.Ide.startupImpl(userHome)", null, (boolean)false);
        this.verifyUserHome();
        Assert.endTiming((String)"oracle.ide.Ide.startupImpl(userHome)", (String)"Verified user home", null, (boolean)false);
        Assert.startTiming((String)"oracle.ide.Ide.startupImpl(UserData)", null, (boolean)false);
        this.copyExtensionUserData();
        Assert.endTiming((String)"oracle.ide.Ide.startupImpl(UserData)", (String)"Copied user data into system", null, (boolean)false);
        this.loadIdeSettings();
        this.loadIdeProperties();
        new NativeHandler().initialize();
        String errorsFromMigration = null;
        MigrationManager migrationManager = MigrationManager.getMigrationManager();
        ProgressManager.updateProgressTitle((String)"migration", (String)IdeArb.getString(517));
        if (migrationManager != null) {
            Assert.startTiming((String)"oracle.ide.Ide.startupImpl(Migration)", null, (boolean)false);
            errorsFromMigration = migrationManager.migrate(userDirectoryCreated, systemDirectoryCreated);
            Assert.endTiming((String)"oracle.ide.Ide.startupImpl(Migration)", (String)"Migrated user settings", null, (boolean)false);
        }
        MessageDialog.setPersistence((MessageDialogPersistence)new MessageDialogPersistence(){

            protected File getUserDirectory() {
                return new File(URLFileSystem.getPlatformPathName((URL)ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.ide")));
            }
        });
        IdeClipboard.installIdeClipboardIntoSwingComponents();
        IdeClipboard.installIdeClipboardIntoJavatools();
        SecurityManager security = this.getSecurityManager();
        if (!(security == null || security instanceof NullSecurityManager && System.getSecurityManager() != null)) {
            try {
                System.setSecurityManager(security);
            }
            catch (SecurityException se) {
                LOG.log(Level.WARNING, "Failed to register security manager " + security.getClass().getName(), se);
            }
        }
        if (this.ideArgs.getCreateUI()) {
            Assert.startTiming((String)"oracle.ide.IdeCore.initializeLookAndFeel", null, (boolean)false);
            this.initializeLookAndFeel();
            Assert.endTiming((String)"oracle.ide.IdeCore.initializeLookAndFeel", (String)"Initialize look-and-feel", null, (boolean)false);
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled((boolean)HighContrast.isHighContrastModeEnabled());
        }
        try {
            Image image;
            JFrame startupWindow;
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.initializeCoreModules", "Initializing core modules...");
            if (this._splashScreen == null) {
                if (!this.isHeadless()) {
                    SplashScreen.destroyHiddenWindow();
                }
            } else {
                if (!this.isHeadless()) {
                    IdeUtil.setStartupWindow(null);
                }
                if (this.ideArgs.getCreateUI()) {
                    this._splashScreen.readySplashScreenForMainWindow();
                }
            }
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.createCoreModules");
            Addin[] coreModules = this.createCoreModules(mainWindow);
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.createCoreModules", "Created core modules");
            ProgressManager.updateProgressTitle((String)"initializing", (String)IdeArb.getString(518));
            this.brandMainWindow();
            if (!this.isHeadless() && (startupWindow = SplashScreen.getOwner()) != null && (image = mainWindow.getIconImage()) != null) {
                startupWindow.setIconImage(image);
            }
            if (mainWindow != null) {
                SwingUtils.setMainWindow((JFrame)((Object)mainWindow));
                SwingUtils.setProgramName((String)this.getProductNameFromBranding());
                SwingUtils.setProgramShortName((String)this.getProductShortNameFromBranding());
            }
            IdeCore.initializeModules(coreModules);
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.initializeCoreModules", "Initialized core modules");
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ChainingUncaughtExceptionHandler());
            ChainingUncaughtExceptionHandler.registerHandler((JDevUncaughtExceptionHandler)new OutOfFileHandlesUncaughtHandler(), (int)1);
            if (mainWindow != null) {
                mainWindow.setEnabled(false);
                mainWindow.getLastActiveView();
            }
            this.initProductAndUserAddinsAndActionRegistry();
        }
        finally {
            ProgressManager.completeProgress((String)"initializing");
        }
        ExtensionPreferences extensionPreferences = ExtensionPreferences.getInstance();
        Set<String> features = extensionPreferences.getFeatureIdsToReloadAtStartup();
        if (!features.isEmpty()) {
            FeatureRegistry featureRegistry = reg.getFeatureRegistry();
            for (String id : features) {
                Feature feature = featureRegistry.getFeature(id);
                if (feature == null) {
                    Assert.println((String)("Failed to find feature: " + id));
                    continue;
                }
                List<String> extIds = feature.getMembers();
                for (String xId : extIds) {
                    Extension x = reg.findExtension(xId);
                    Assert.println((x == null ? 1 : 0) != 0, (String)("Failed to find and reload extension: " + xId));
                    if (x == null) continue;
                    reg.fullyLoadExtension(x, "Marked to reload at startup");
                }
            }
        }
        if ((hook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(AcceleratorHook.NAME)) != null) {
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    this.handleFiles(e.getNewElementHashStructure());
                }

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    this.handleFiles(e.getCombinedHashStructure());
                }

                private void handleFiles(HashStructure hashStructure) {
                    AcceleratorDefinitions defs = AcceleratorHook.getAcceleratorDefinitions(hashStructure);
                    List<MetaResource> metaResourceList = defs.getAcceleratorMetaResourceList();
                    KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
                    for (MetaResource metaResource : metaResourceList) {
                        registry.addAcceleratorDefinitionFile(metaResource.getClassLoader(), metaResource.getResourcePath());
                    }
                    KeyStrokeOptions keyStrokeOptions = IdeCore.this.settings.getKeyStrokeOptions();
                    keyStrokeOptions.solvePostponedMaps();
                }
            });
        }
        XMLKeystrokeContextDefs.getInstance().unload();
        oracle.ide.model.Preferences preferences = this.getPreferences();
        if (preferences == null) {
            lgm = LogManager.getLogManager();
            if (lgm != null) {
                lgm.getMsgPage().log("SEVERE: NULL Preferences during startup");
            } else {
                l2 = Logger.getLogger(this.getClass().getName());
                l2.log(Level.SEVERE, "NULL Preferences during startup");
            }
        }
        if (migrationManager != null) {
            migrationManager.finishMigration();
        }
        ProgressManager.completeProgress((String)"migration");
        if (this.ideArgs.getCreateUI()) {
            try {
                ProgressManager.updateProgressTitle((String)"windows", (String)IdeArb.getString(519));
                FileOpenHistory.getInstance();
                GrabbableFocusManager.install();
                DialogWatcher.install();
                long startTime = Long.getLong(STARTUP_TIMING_PROPERTY, -1L);
                if (startTime != -1L) {
                    LOG.log(Level.FINE, "Timing Startup - oracle.ide.launcher.startup.time : " + (System.currentTimeMillis() - startTime));
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IdeCore.this.getMainWindow().postInitialize(IdeCore.this.ideArgs);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IllegalStateException("Problem creating IdeMainWindow on ETD");
                    }
                }
                Boolean bl = this.mainWindowAlreadyOpened;
                synchronized (bl) {
                    this.mainWindowAlreadyOpened = Boolean.TRUE;
                }
            }
            finally {
                ProgressManager.completeProgress((String)"windows");
            }
            ProgressManager.updateProgressTitle((String)"editors", (String)IdeArb.getString(520));
            UsagesTracker.getUsagesTracker().initTracker();
            IdeAction showAction = IdeAction.find("oracle.jdevimpl.help.welcomePageOnStartup");
            if (showAction != null && showAction.isEnabled()) {
                try {
                    showAction.performAction();
                }
                catch (Exception l2) {
                    // empty catch block
                }
            }
        }
        if (errorsFromMigration != null) {
            lgm = LogManager.getLogManager();
            if (lgm != null) {
                lgm.getMsgPage().log(errorsFromMigration);
            } else {
                l2 = Logger.getLogger(this.getClass().getName());
                l2.log(Level.WARNING, errorsFromMigration);
            }
        }
        ProgressManager.completeProgress((String)"editors");
        boolean showImages = Boolean.getBoolean("ide.wizard.legacyimages");
        if (!showImages) {
            BaseWizard.setImageWizardPageSupported((boolean)false);
        }
        BaseWizard.setAllowSequentialJump((boolean)true);
        this.defaultMyWorkDirectory();
        if (this.ideArgs.getCreateUI() && WindowManagerStartingController.getInstance() == null) {
            mainWindow.notifyWindowOpened();
        }
        ProgressManager.endProgress();
        this._starting = false;
    }

    private void defaultMyWorkDirectory() {
        Workspaces ws = this.getWorkspaces();
        if (ws == null) {
            return;
        }
        URL workDir = ws.getWorkDirectory();
        if (workDir != null) {
            return;
        }
        ws.setWorkDirectory(URLFactory.newDirURL((String)this.getDefaultWorkDirectoryLocation()));
    }

    private static URLFileSystemHelper getFileSystemHelper(URLFileSystemHelper helper) {
        String traceFileName = null;
        PrintStream printStream = null;
        IdeArgs ideArgs = Ide.getIdeArgs();
        String[] args = ideArgs.getArgs();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String option = "-TraceFS";
            if (!arg.startsWith("-TraceFS")) continue;
            String optionArg = arg.substring("-TraceFS".length());
            if (optionArg.length() == 0) {
                printStream = System.err;
                break;
            }
            if (optionArg.charAt(0) != '=') break;
            traceFileName = optionArg.substring(1);
            break;
        }
        if (traceFileName == null && printStream == null) {
            return null;
        }
        TraceFileSystemAccess traceFileSystemAccess = traceFileName != null ? TraceFileSystemAccess.start(helper, traceFileName, true) : TraceFileSystemAccess.start(helper, printStream, true);
        return traceFileSystemAccess;
    }

    private static String canonicalize(String dir) {
        if (dir == null || dir.trim().length() == 0) {
            return dir;
        }
        File f = new File(IdeCore.stripDoubleQuotes(dir));
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return f.toString();
    }

    private static String stripDoubleQuotes(String dir) {
        String[] tokens;
        StringBuffer sb = new StringBuffer();
        for (String token : tokens = dir.split("[\\\"]")) {
            if ("".equals(token)) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    private void verifyUserHome() {
        File userHomeFile = new File(this.userHome + File.separator).getAbsoluteFile();
        userHomeFile.mkdirs();
        if (!userHomeFile.isDirectory() || !userHomeFile.canWrite()) {
            String msg = IdeArb.format(234, userHomeFile.getAbsolutePath());
            if (Ide.getIdeArgs().getCreateUI()) {
                String title = this.startupCaption;
                MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)msg, (String)title, null);
            } else {
                LOG.log(Level.SEVERE, msg);
            }
            System.exit(1);
        }
    }

    private synchronized IdeSettings loadIdeSettings() {
        if (this.settings == null) {
            this.settings = new IdeSettings();
            this.settings.load();
            this.settings.init();
            EnvironOptions opts = this.getEnvironOptions();
            IdeUtil.setIdeEncoding(opts.getEncoding());
            opts.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    IdeUtil.setIdeEncoding(IdeCore.this.getEnvironOptions().getEncoding());
                }
            });
            KeyStrokeOptions keyStrokeOptions = this.settings.getKeyStrokeOptions();
            keyStrokeOptions.setKeyboardPanelEventDispatcher(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdeCore.this.fireMainWindowEvent(4);
                }
            });
        }
        return this.settings;
    }

    private void loadIdeProperties() {
        Assert.check((this.idePropertiesInstance == null ? 1 : 0) != 0);
        if (this.idePropertiesInstance == null) {
            Assert.startTiming((String)"oracle.ide.Ide.loadIdeProperties", null, (boolean)false);
            this.idePropertiesInstance = new IdeProperties();
            this.idePropertiesInstance.ensureOpen();
            this.idePropertiesInstance.setProperty(INSTALL_PATH, this.binDir);
            Assert.endTiming((String)"oracle.ide.Ide.loadIdeProperties", (String)"Loaded IDE properties", null, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeModules(Addin[] modules) {
        if (modules != null) {
            for (Addin module : modules) {
                if (module == null) continue;
                String className = module.getClass().getName();
                try {
                    PerformanceLogger.get().startTiming("oracle.ide.IdeCore.module." + className);
                    module.initialize();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.module." + className, className);
                }
            }
        }
    }

    protected void initProductAndUserAddins() {
        AddinManager.getAddinManager().initProductAndUserAddins();
    }

    protected void initProductAndUserAddinsAndActionRegistry() {
        AddinManager.getAddinManager().initProductAndUserAddins();
        ActionRegistry.getActionRegistry().initAfterAddinsLoad();
    }

    protected void copyExtensionUserData() {
    }

    private void installAboutBox() {
        AboutBoxModel model = new AboutBoxModel();
        model.setProductName(Ide.getProgramName());
        AboutBoxFactory factory = new AboutBoxFactory();
        factory.setModel(model);
        this.installAboutBox(factory);
        AboutBoxFactory.setAboutBoxFactory(factory);
        this.initAboutBoxModel();
    }

    protected void installAboutBox(AboutBoxFactory factory) {
    }

    protected String getProductNameFromBranding() {
        return "";
    }

    protected String getProductShortNameFromBranding() {
        return "";
    }

    protected void initAboutBoxModel() {
    }

    protected void brandMainWindow() {
    }

    WorkspaceProject getActiveWorkspaceProjectOverride() {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            return activeWorkspaceProject.get();
        }
        return null;
    }

    public static void setActiveWorkspaceOverrideEnabled(boolean enabled) {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            WorkspaceProject override = activeWorkspaceProject.get();
            if (enabled) {
                ACTIVE_LOG.trace("enabling active workspace override");
                if (override != null) {
                    throw new IllegalStateException("active workspace/project already enabled");
                }
                activeWorkspaceProject.set(new WorkspaceProject());
            } else {
                ACTIVE_LOG.trace("disabling active workspace override");
                if (override == null) {
                    throw new IllegalStateException("active workspace/project override not enabled");
                }
                activeWorkspaceProject.set(null);
            }
        }
    }

    public static void setActiveWorkspaceOverride(Workspace workspace) {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            ACTIVE_LOG.trace("overriding workspace to {0}", (Object)workspace);
            WorkspaceProject override = activeWorkspaceProject.get();
            if (override == null) {
                throw new IllegalStateException("active workspace/project override not enabled");
            }
            override.workspace = workspace;
        }
    }

    public static void setActiveProjectOverride(Project project) {
        if (ACTIVE_WORKSPACE_OVERRIDE) {
            ACTIVE_LOG.trace("overriding project to {0}", (Object)project);
            WorkspaceProject override = activeWorkspaceProject.get();
            if (override == null) {
                throw new IllegalStateException("active workspace/project override not enabled");
            }
            if (project != null && override.workspace == null) {
                throw new IllegalStateException("workspace null");
            }
            override.project = project;
        }
    }

    private void initializeBeansDesignTime() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Beans.setDesignTime(true);
            }
        };
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        if (root != null) {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            if (root != null) {
                ThreadGroup[] threadGroups = new ThreadGroup[root.activeGroupCount()];
                root.enumerate(threadGroups, true);
                Thread thread = new Thread(root, runnable);
                thread.start();
                for (ThreadGroup group : threadGroups) {
                    thread = new Thread(group, runnable);
                    thread.start();
                }
            }
        }
    }

    public static Set<String> getFrameworkCommandLineOptions() {
        Set<String> options = IdeCore.getFrameworkCommandLineOptions(IdeBootProperties.getIdeFrameworkCommandlineOptions());
        options.addAll(IdeCore.getFrameworkCommandLineOptions(IdeBootProperties.getProductFrameworkCommandlineOptions()));
        return options;
    }

    public static boolean isFrameworkCommandLineOption(String option) {
        Set<String> handledOptions = IdeCore.getFrameworkCommandLineOptions();
        if (handledOptions.contains(option)) {
            return true;
        }
        for (String handledOption : handledOptions) {
            boolean optionTakesArguments = handledOption.endsWith(":");
            if (!optionTakesArguments || !option.startsWith(handledOption)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getFrameworkCommandLineOptions(String optionString) {
        if (optionString != null) {
            String[] options = optionString.split(",");
            int len = options.length;
            HashSet<String> finalOptions = new HashSet<String>(len);
            for (String option : options) {
                if ((option = option.trim()).length() <= 1) continue;
                finalOptions.add(option);
            }
            return finalOptions;
        }
        return Collections.emptySet();
    }

    static class WorkspaceProject {
        Workspace workspace;
        Project project;

        WorkspaceProject() {
        }
    }

    private class SplashScreenProgressListener
    implements IProgressListener {
        private String _name;

        public SplashScreenProgressListener(String name) {
            this._name = name;
        }

        public void updateProgressTitle(String title) {
            if (IdeCore.this._splashScreen != null) {
                IdeCore.this._splashScreen.updateProgressTitle(this._name, title);
            }
        }

        public void updateProgressDescription(String description, int count) {
            if (IdeCore.this._splashScreen != null) {
                IdeCore.this._splashScreen.updateProgressDescription(this._name, description, count);
            }
        }

        public void updateProgress(int count) {
            if (IdeCore.this._splashScreen != null) {
                IdeCore.this._splashScreen.updateProgress(this._name, count);
            }
        }

        public void finalizeProgress(int count) {
            if (IdeCore.this._splashScreen != null) {
                IdeCore.this._splashScreen.finalizeDeterminateProgress(this._name, count);
            }
        }

        public void completeProgress() {
            if (IdeCore.this._splashScreen != null) {
                IdeCore.this._splashScreen.completeProgress(this._name);
            }
        }
    }

    @Deprecated
    private final class MainWindowWaitCursor
    extends WaitCursor {
        MainWindowWaitCursor(Component c) {
            this.attachSuper(this.findRootPaneContainer(c));
        }

        private void attachSuper(RootPaneContainer c) {
            super.attach(c);
        }

        @Deprecated
        public void attach(RootPaneContainer c) {
            this.complain();
            super.attach(c);
        }

        @Deprecated
        public void detach(RootPaneContainer c) {
            if (!Ide.isQuitting()) {
                this.complain();
            }
            super.detach(c);
        }

        private void complain() {
            new IllegalStateException("WARNING: attaching and detaching from the WaitCursor returned by Ide.getWaitCursor() is no longer supported. Instead, clients should create a new WaitCursor instance. The WaitCursor returned by Ide.getWaitCursor should only be used by the IDE's main window.").printStackTrace();
        }
    }
}

