/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.awt.Window;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.SingletonProvider;

public abstract class HelpSystem {
    private static HelpSystem _helpSystem;
    public static final String VIEW_TYPE = "HelpSystemAddin";
    public static final String VIEW_NAME = "HelpWindow";
    public static final int ADD_BEFORE = 0;
    public static final int ADD_AFTER = 1;
    public static final int ADD_UPDATE_ACTION = 0;
    public static final int REMOVE_ACTION = 1;

    public static HelpSystem getHelpSystem() {
        if (_helpSystem == null) {
            _helpSystem = SingletonProvider.find(HelpSystem.class);
            return _helpSystem;
        }
        return _helpSystem;
    }

    public static void setHelpSystem(HelpSystem helpSystem) {
        _helpSystem = helpSystem;
    }

    public abstract boolean doesTopicExist(String var1);

    public abstract void showHelp(JComponent var1);

    public abstract Editor showHelp(URL var1);

    public abstract void showHelp(Context var1);

    public abstract void showHelp(HelpInfo var1);

    public abstract void goTo(String var1);

    public abstract void registerTopic(JComponent var1, String var2);

    public abstract void registerClientWindow(Window var1);

    public abstract void unregisterClientWindow(Window var1);

    public abstract void showLanguageHelp(Context var1, String var2);

    public abstract void registerHelpSetURL(URL var1);

    public abstract void registerHelpSetURL(URL var1, String var2, int var3);

    public void registerHelpSetURL(String name, int helpAction, URL controlFileURL, String relativeName, int relativeLocation) {
        this.registerHelpSetURL(name, helpAction, controlFileURL, relativeName, relativeLocation, null);
    }

    public abstract void registerHelpSetURL(String var1, int var2, URL var3, String var4, int var5, Map<String, String> var6);

    public abstract void registerBrowseSymbolResolver(String var1);

    public abstract void clearHelpSystem();

    public abstract void registerTopicSubstitute(String var1, String var2);

    public abstract URL resolveTopicId(String var1);

    @Deprecated
    public abstract void invokeWizard(String var1, Context var2);

    public abstract Boolean checkWizard(String var1, Context var2);

    @Deprecated
    public abstract void invokeAction(String var1, Context var2);
}

