/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.model.DependableFactoryReference;
import oracle.javatools.data.HashStructure;

public class DependableFactoryHook
extends HashStructureHook {
    public static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "dependable-factory-hook");
    private final Map<String, DependableFactoryReference> references = new ConcurrentHashMap<String, DependableFactoryReference>();
    private final List<DependableFactoryReference> recognizers = new ArrayList<DependableFactoryReference>();

    public static DependableFactoryHook getHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        return (DependableFactoryHook)registry.getHook(HOOK_NAME);
    }

    public DependableFactoryHook() {
        super(true);
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                DependableFactoryHook.this.populateDependableFactories(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
            }
        });
    }

    private void populateDependableFactories(HashStructure hs) {
        List factories = hs.getAsList("factory");
        if (factories != null) {
            for (Object f : factories) {
                DependableFactoryReference dfr;
                if (!(f instanceof HashStructure) || (dfr = DependableFactoryReference.create((HashStructure)f)) == null) continue;
                this.references.put(dfr.getId(), dfr);
                this.recognizers.add(dfr);
            }
        }
    }

    Iterable<DependableFactoryReference> getAllFactories() {
        return this.recognizers;
    }

    DependableFactoryReference getFactoryById(String id) {
        return this.references.get(id);
    }
}

