/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class NodeMigrationTracker
extends HashStructureAdapter {
    private static final String DATA_KEY = NodeMigrationTracker.class.getName();
    private static final String UNMIGRATED_NODES_HASH = "migration-incomplete";
    private static final String URL_KEY = "urls";

    public static NodeMigrationTracker getInstance() {
        HashStructure hash = Preferences.getPreferences().getProperties().getOrCreateHashStructure(DATA_KEY);
        return new NodeMigrationTracker(hash);
    }

    private NodeMigrationTracker(HashStructure hash) {
        super(hash);
    }

    public boolean needsMigration(URL url) {
        return this.find(url) != null;
    }

    public void startTracking(URL url) {
        this.updateMigrationStatus(url, false);
    }

    public void stopTracking(URL url) {
        this.updateMigrationStatus(url, true);
    }

    private void updateMigrationStatus(URL url, boolean removeURL) {
        URL found;
        boolean exists = this._hash.containsKey(UNMIGRATED_NODES_HASH);
        if (!removeURL) {
            if (!exists || this.find(url) == null) {
                HashStructure nodeHash = this._hash.getOrCreateHashStructure(UNMIGRATED_NODES_HASH);
                ListStructure list = nodeHash.getOrCreateListStructure(URL_KEY);
                list.add((Object)url);
            }
        } else if (exists && (found = this.find(url)) != null) {
            HashStructure nodeHash = this._hash.getHashStructure(UNMIGRATED_NODES_HASH);
            ListStructure urls = nodeHash.getListStructure(URL_KEY);
            urls.remove((Object)found);
        }
    }

    private URL find(URL url) {
        ListStructure urls;
        int index;
        HashStructure hash;
        if (this._hash.containsKey(UNMIGRATED_NODES_HASH) && (hash = this._hash.getHashStructure(UNMIGRATED_NODES_HASH)).containsKey(URL_KEY) && (index = (urls = hash.getListStructure(URL_KEY)).indexOf((Object)url)) >= 0) {
            return (URL)urls.get(index);
        }
        return null;
    }
}

