/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.compiler;

import java.util.logging.Level;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.compiler.BuildSystemHook;
import oracle.javatools.data.HashStructure;

public class BuildToolDefinition<T> {
    protected HashStructure hash;
    private String className;
    protected T buildTool;
    protected String extensionId;
    private boolean initializedModule;
    private boolean hasBeenRetrievedFromHook;
    private Boolean headless;

    public BuildToolDefinition(String extensionId, HashStructure hash) {
        this.extensionId = extensionId;
        this.hash = hash;
    }

    public BuildToolDefinition(T buildTool) {
        this.buildTool = buildTool;
        this.className = buildTool.getClass().getName();
        this.headless = Boolean.TRUE;
        this.initializedModule = true;
    }

    public synchronized boolean hasBeenRetrievedFromHook() {
        return this.hasBeenRetrievedFromHook;
    }

    protected boolean hasInitializedModule() {
        if (!this.initializedModule) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = registry.findExtension(this.extensionId);
            this.initializedModule = extension != null && registry.isFullyLoaded(extension);
        }
        return this.initializedModule;
    }

    public boolean conditionsSatisfied(Workspace workspace, Project project) {
        String rule;
        if (!this.isHeadless() && IdeUtil.isHeadless()) {
            return false;
        }
        String string = rule = this.hash != null ? this.hash.getString("rule") : null;
        if (rule != null && rule.trim().length() > 0) {
            RuleEngine engine = RuleEngine.getInstance();
            if (engine.getRule(rule) != null) {
                Context context = new Context(workspace, project);
                return engine.evaluateRule(rule, context);
            }
            return false;
        }
        return true;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.hash.getString("class-name");
        }
        return this.className;
    }

    public synchronized T retrieveBuildTool() {
        this.hasBeenRetrievedFromHook = true;
        return this.getOrInstantiateBuildTool();
    }

    protected T getOrInstantiateBuildTool() {
        if (this.buildTool == null) {
            ClassLoader classLoader = this.getClassLoader();
            MetaClass metaClass = new MetaClass(classLoader, this.getClassName());
            try {
                this.buildTool = metaClass.newInstance();
                this.initializedModule = true;
            }
            catch (Exception ex) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create instance of class " + this.getClassName());
            }
        }
        return this.buildTool;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = null;
        if (this.extensionId != null) {
            loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extensionId);
        }
        if (loader == null) {
            loader = BuildSystemHook.class.getClass().getClassLoader();
        }
        return loader;
    }

    public boolean isHeadless() {
        if (this.headless == null) {
            Object object;
            this.headless = Boolean.TRUE;
            if (this.hash.containsKey("headless") && (object = this.hash.getObject("headless")).toString().toLowerCase().equals("false")) {
                this.headless = Boolean.FALSE;
            }
        }
        return this.headless;
    }
}

