/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.Dockable;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.shutter.MouseActivationController;
import oracle.ideimpl.docking.shutter.ShutterTab;
import oracle.ideimpl.docking.shutter.ShutterTabListener;

public final class AutoExpandListener
extends MouseAdapter
implements MouseMotionListener,
ShutterTabListener {
    private TitledPanel titledPanel;
    private Dockable dockable;
    private boolean dockableInSelectedTab;
    private ShutterTab shutterTab;
    private CustomTab tabs;
    private MouseActivationController activationController;
    private TitledPanelHolder titledPanelHolder;
    private int raiseDelay;

    public int raiseDelay() {
        return this.activationController.raiseDelay();
    }

    public void raiseDelay(int newValue) {
        this.raiseDelay = newValue;
        this.updateActivationControllerRaiseDelay();
    }

    private void updateActivationControllerRaiseDelay() {
        this.activationController.raiseDelay(this.raiseDelay);
    }

    Dockable dockable() {
        return this.dockable;
    }

    AutoExpandListener(ShutterTab shutterTab, TitledPanel titledPanel, TitledPanelHolder titledPanelHolder, CustomTab tabs, Dockable dockable) {
        this.shutterTab = shutterTab;
        this.titledPanelHolder = titledPanelHolder;
        this.activationController = new MouseActivationController(true);
        this.titledPanel = titledPanel;
        this.addTo(tabs);
        this.addTo(dockable);
    }

    private void addTo(CustomTab tabs) {
        this.tabs = tabs;
        this.addThisListenerTo(this.tabs);
    }

    private void addTo(Dockable dockable) {
        this.dockable = dockable;
        this.addThisListenerTo(this.toolbarFrom(this.dockable));
    }

    private Toolbar toolbarFrom(Dockable dockable) {
        if (!(dockable instanceof View)) {
            return null;
        }
        View view = (View)((Object)dockable);
        return view.getToolbar();
    }

    private void addThisListenerTo(JComponent component) {
        if (component == null) {
            return;
        }
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.shouldProcessEvent(e)) {
            return;
        }
        if (!this.dockableTabHovered(e)) {
            return;
        }
        this.showShutterTabWithDelay();
    }

    public void mouseMovedFromAWTEventListener(MouseEvent e) {
        if (!this.shouldProcessEvent(e)) {
            return;
        }
        if (!this.dockableHovered(e)) {
            return;
        }
        this.showShutterTabWithDelay();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    private boolean shouldProcessEvent(MouseEvent e) {
        return this.dockable != null && e.getButton() == 0 && this.dockable.isAutoExpandableEnabled();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1 || !this.dockable.isAutoExpandableEnabled()) {
            return;
        }
        if (!this.dockableTabHovered(e)) {
            return;
        }
        if (!this.dockableInSelectedTab) {
            return;
        }
        this.showShutterTab();
    }

    void showShutterTab() {
        this.updateDockPanel();
        this.dockableInSelectedTab = true;
        this.activationController.raiseDelay(1);
        this.showShutterTabWithDelay();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.activationController.mouseExited(this.shutterTab);
    }

    private void showShutterTabWithDelay() {
        if (this.titledPanel.isFloating()) {
            return;
        }
        this.titledPanel.beTransparent();
        this.shutterTab.setDockableInSelectedTab(this.dockableInSelectedTab);
        this.shutterTab.setDockedTitledPanel(this.titledPanel);
        this.activationController.mouseMoved(this.shutterTab, this.titledPanelHolder);
    }

    void hideShutterTab() {
        this.shutterTab.retractPanel(0);
    }

    private boolean dockableTabHovered(MouseEvent e) {
        Point point;
        int hoveredTabIndex;
        Object source = e.getSource();
        if (source instanceof Component) {
            SwingUtilities.convertMouseEvent((Component)source, e, this.tabs);
        }
        if ((hoveredTabIndex = this.tabs.getPageAt(point = e.getPoint())) < 0) {
            return false;
        }
        if (!this.isDockableTab(this.tabs.getPage(hoveredTabIndex))) {
            return false;
        }
        this.updateDockPanel();
        this.dockableInSelectedTab = hoveredTabIndex == this.tabs.getSelectedPage();
        return true;
    }

    private boolean isDockableTab(CustomTabPage tab) {
        if (tab == null) {
            return false;
        }
        if (tab instanceof DefaultCustomTabPage) {
            return this.isDockableTab((DefaultCustomTabPage)tab);
        }
        return false;
    }

    private boolean isDockableTab(DefaultCustomTabPage tab) {
        Object userObject = tab.getUserObject();
        if (!(userObject instanceof TitledPanelHolder)) {
            return false;
        }
        TitledPanelHolder tabTitledPanelHolder = (TitledPanelHolder)userObject;
        return this.dockable == tabTitledPanelHolder.getDockable();
    }

    private void updateDockPanel() {
        DockPanel dockPanel = this.findDockPanel(this.titledPanel);
        this.shutterTab.dockPanelForOrientation(dockPanel);
    }

    private DockPanel findDockPanel(Component c) {
        if (c == null) {
            return null;
        }
        Container parent = c.getParent();
        if (parent instanceof DockPanel) {
            return (DockPanel)parent;
        }
        return this.findDockPanel(parent);
    }

    private boolean dockableHovered(MouseEvent e) {
        boolean dockableHovered = this.dockableHovered(e.getSource(), e.getPoint());
        if (!dockableHovered) {
            return false;
        }
        this.updateDockPanel();
        int selectedTabIndex = this.tabs.getSelectedPage();
        if (selectedTabIndex >= 0) {
            this.dockableInSelectedTab = this.isDockableTab(this.tabs.getPage(selectedTabIndex));
        }
        return dockableHovered;
    }

    private boolean dockableHovered(Object mouseEventSource, Point mouseEventPoint) {
        if (!(mouseEventSource instanceof Component)) {
            return false;
        }
        JComponent dockableGUI = this.dockableGUI();
        if (dockableGUI == null || !dockableGUI.isShowing()) {
            return false;
        }
        Rectangle rectangle = dockableGUI.getBounds();
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(mouseEventPoint) && this.isInDockable((Component)mouseEventSource, dockableGUI);
    }

    private boolean isInDockable(Component c, JComponent dockableGUI) {
        Container parent = c.getParent();
        if (parent == dockableGUI) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        return this.isInDockable(parent, dockableGUI);
    }

    private JComponent dockableGUI() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getHostedComponent();
    }

    @Override
    public void shutterPanelHidden(Dimension shutterPanelSize, boolean userResized, int flags, int orientation) {
        this.titledPanel.beOpaque();
        this.dockable.afterRestoringFromAutoExpansion(orientation, shutterPanelSize, userResized);
        if (!this.dockableInSelectedTab) {
            return;
        }
        this.titledPanel.restoreHolder(this.titledPanelHolder);
        this.updateActivationControllerRaiseDelay();
    }

    void dispose() {
        this.removeThisListenerFrom(this.tabs);
        this.removeThisListenerFrom(this.dockable);
        this.activationController = null;
        this.dockable = null;
        if (this.shutterTab != null) {
            this.shutterTab.setShutterTabListener(null);
        }
        this.shutterTab = null;
        this.tabs = null;
        this.titledPanel = null;
        this.titledPanelHolder = null;
    }

    private void removeThisListenerFrom(Dockable dockable) {
        Toolbar toolbar = this.toolbarFrom(dockable);
        if (toolbar == null) {
            return;
        }
        this.removeThisListenerFrom(toolbar);
    }

    private void removeThisListenerFrom(JComponent component) {
        if (component == null) {
            return;
        }
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }
}

