/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.rules;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.extension.rules.composite.AndOperator;
import oracle.ide.extension.rules.composite.BooleanOperator;
import oracle.ide.extension.rules.composite.CompositeRule;
import oracle.ide.extension.rules.composite.CompositeRuleParticle;
import oracle.ide.extension.rules.composite.NotOperator;
import oracle.ide.extension.rules.composite.OrOperator;
import oracle.ide.extension.rules.composite.RuleReference;

public class CompositeRuleVisitor
extends ElementVisitor {
    public static final ElementName COMPOSITE_RULE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "composite-rule");
    public static final ElementName AND_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "and");
    public static final ElementName OR_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "or");
    public static final ElementName NOT_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "not");
    public static final ElementName RULE_REFERENCE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rule-reference");
    public static final String ID_ATTR = "id";
    private static final String _KEY_COMPOSITE_RULE_INFO = "key-ide-extension-composite-rule-info";
    private static final String _KEY_CURRENT_OPERATOR = "key-ide-extension-composite-current-operator";
    private AndVisitor _andVisitor = new AndVisitor();
    private OrVisitor _orVisitor = new OrVisitor();
    private NotVisitor _notVisitor = new NotVisitor();
    private RuleReferenceVisitor _ruleRefVisitor = new RuleReferenceVisitor();

    public void start(ElementStartContext context) {
        String id = this.getAttributeHelper(context, ID_ATTR, true, true);
        if (id != null) {
            CompositeRuleInfo ruleInfo = new CompositeRuleInfo(id);
            context.getScopeData().put(_KEY_COMPOSITE_RULE_INFO, ruleInfo);
            this._registerChildVisitors(context, false);
        }
    }

    public void end(ElementEndContext context) {
        CompositeRuleInfo ruleInfo = (CompositeRuleInfo)context.getScopeData().get(_KEY_COMPOSITE_RULE_INFO);
        if (ruleInfo != null) {
            BooleanOperator topLevelOperator = ruleInfo.getTopLevelBooleanOperator();
            if (topLevelOperator != null) {
                RuleEngine ruleEngine = RuleEngine.getInstance();
                Extension extension = (Extension)context.getScopeData().get("extension");
                CompositeRule rule = new CompositeRule(ruleInfo.getId(), extension, topLevelOperator);
                boolean registered = ruleEngine.registerRule(rule);
                if (!registered) {
                    Rule duplicate = ruleEngine.getRule(rule.getId());
                    this.log((ElementContext)context, Level.SEVERE, "Duplicate rule id encountered.  The id '" + rule.getId() + "' is already registered in extension: " + duplicate.getExtension().getID());
                }
            } else {
                this.log((ElementContext)context, Level.SEVERE, "<composite-rule> requires one and only one child (a boolean operator)");
            }
        }
    }

    private void _addCompositeRuleParticle(ElementContext context, CompositeRuleParticle particle) {
        BooleanOperator currentOperator = this._getCurrentOperatorInScope(context);
        if (currentOperator != null) {
            currentOperator.addParticle(particle);
        }
        if (particle instanceof BooleanOperator) {
            if (currentOperator == null) {
                CompositeRuleInfo ruleInfo = (CompositeRuleInfo)context.getScopeData().get(_KEY_COMPOSITE_RULE_INFO);
                if (ruleInfo.getTopLevelBooleanOperator() == null) {
                    ruleInfo.setTopLevelBooleanOperator((BooleanOperator)particle);
                } else {
                    this.log(context, Level.SEVERE, "Unexpected element.  <composite-rule> must have only one child (a boolean operator)");
                }
            }
            this._setCurrentOperatorInScope(context, (BooleanOperator)particle);
        }
    }

    private BooleanOperator _getCurrentOperatorInScope(ElementContext context) {
        return (BooleanOperator)context.getScopeData().get(_KEY_CURRENT_OPERATOR);
    }

    private void _setCurrentOperatorInScope(ElementContext context, BooleanOperator operator) {
        context.getScopeData().put(_KEY_CURRENT_OPERATOR, operator);
    }

    private void _registerChildVisitors(ElementStartContext context, boolean registerRuleRef) {
        context.registerChildVisitor(AND_ELEMENT, (ElementVisitor)this._andVisitor);
        context.registerChildVisitor(OR_ELEMENT, (ElementVisitor)this._orVisitor);
        context.registerChildVisitor(NOT_ELEMENT, (ElementVisitor)this._notVisitor);
        if (registerRuleRef) {
            context.registerChildVisitor(RULE_REFERENCE_ELEMENT, (ElementVisitor)this._ruleRefVisitor);
        }
    }

    private class CompositeRuleInfo {
        private final String _id;
        private BooleanOperator _operator = null;

        public CompositeRuleInfo(String id) {
            this._id = id;
        }

        public String getId() {
            return this._id;
        }

        public void setTopLevelBooleanOperator(BooleanOperator operator) {
            this._operator = operator;
        }

        public BooleanOperator getTopLevelBooleanOperator() {
            return this._operator;
        }
    }

    private class NotVisitor
    extends ElementVisitor {
        private NotVisitor() {
        }

        public void start(ElementStartContext context) {
            NotOperator operator = new NotOperator();
            CompositeRuleVisitor.this._addCompositeRuleParticle((ElementContext)context, operator);
            CompositeRuleVisitor.this._registerChildVisitors(context, true);
        }

        public void end(ElementEndContext context) {
            NotOperator operator = (NotOperator)CompositeRuleVisitor.this._getCurrentOperatorInScope((ElementContext)context);
            if (operator != null && operator.getParticles().size() != 1) {
                this.log((ElementContext)context, Level.SEVERE, "<not> element must have exactly one child (boolean operator or rule-reference element)");
            }
        }
    }

    private class OrVisitor
    extends ElementVisitor {
        private OrVisitor() {
        }

        public void start(ElementStartContext context) {
            OrOperator operator = new OrOperator();
            CompositeRuleVisitor.this._addCompositeRuleParticle((ElementContext)context, operator);
            CompositeRuleVisitor.this._registerChildVisitors(context, true);
        }

        public void end(ElementEndContext context) {
            OrOperator operator = (OrOperator)CompositeRuleVisitor.this._getCurrentOperatorInScope((ElementContext)context);
            if (operator != null && operator.getParticles().size() < 2) {
                this.log((ElementContext)context, Level.SEVERE, "<or> element must have two or more children (boolean operators or rule-reference elements)");
            }
        }
    }

    private class AndVisitor
    extends ElementVisitor {
        private AndVisitor() {
        }

        public void start(ElementStartContext context) {
            AndOperator operator = new AndOperator();
            CompositeRuleVisitor.this._addCompositeRuleParticle((ElementContext)context, operator);
            CompositeRuleVisitor.this._registerChildVisitors(context, true);
        }

        public void end(ElementEndContext context) {
            AndOperator operator = (AndOperator)CompositeRuleVisitor.this._getCurrentOperatorInScope((ElementContext)context);
            if (operator != null && operator.getParticles().size() < 2) {
                this.log((ElementContext)context, Level.SEVERE, "<and> element must have two or more children (boolean operators or rule-reference elements)");
            }
        }
    }

    private class RuleReferenceVisitor
    extends ElementVisitor {
        private RuleReferenceVisitor() {
        }

        public void start(ElementStartContext context) {
            RuleEngine ruleEngine;
            boolean valid;
            String id = this.getAttributeHelper(context, CompositeRuleVisitor.ID_ATTR, true, true);
            if (id != null && (valid = (ruleEngine = RuleEngine.getInstance()).validateRuleReference(id, (ElementContext)context))) {
                RuleReference ruleRef = new RuleReference(id);
                CompositeRuleVisitor.this._addCompositeRuleParticle((ElementContext)context, ruleRef);
            }
        }
    }
}

