/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.net.URI;
import java.net.URL;
import javax.ide.model.Document;
import javax.ide.model.DocumentFactory;
import javax.ide.model.Element;
import javax.ide.model.ElementDisplayInfo;
import javax.ide.net.URIFactory;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;
import javax.ide.util.MissingIconException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ideimpl.jsr198.model.Custom;
import oracle.ideimpl.jsr198.model.OracleDocumentFactory;

public final class CustomUtil {
    private CustomUtil() {
    }

    public static Document getJSRDocument(URL url) {
        Document document = null;
        URI uri = URIFactory.newURI((URL)url);
        MetaClass docClass = ((OracleDocumentFactory)DocumentFactory.getDocumentFactory()).recognize(uri);
        if (docClass == null) {
            throw new IllegalStateException("Unrecognized JSR-198 custom node: " + uri);
        }
        try {
            document = (Document)docClass.newInstance();
            document.setURI(URIFactory.newURI((URL)url));
        }
        catch (Exception e) {
            e.printStackTrace();
            document = new Document();
        }
        return document;
    }

    public static Icon getIcon(Custom c) {
        Document doc = c.getJSRDocument();
        ElementDisplayInfo display = doc.getDisplayInfo();
        if (display == null) {
            return null;
        }
        IconDescription id = display.getIcon((Element)doc);
        if (id != null) {
            try {
                URL iconURL = id.getURL();
                ImageIcon i = new ImageIcon(iconURL);
                if (i.getImageLoadStatus() == 8) {
                    return i;
                }
            }
            catch (MissingIconException mie) {
                mie.printStackTrace();
            }
        }
        return null;
    }

    public static String getLabel(Custom c) {
        Document doc = c.getJSRDocument();
        ElementDisplayInfo display = doc.getDisplayInfo();
        if (display == null) {
            return null;
        }
        return display.getLabel((Element)doc);
    }

    public static String getLongLabel(Custom c) {
        Document doc = c.getJSRDocument();
        ElementDisplayInfo display = doc.getDisplayInfo();
        if (display == null) {
            return null;
        }
        return display.getLongLabel((Element)doc);
    }

    public static String getToolTip(Custom c) {
        Document doc = c.getJSRDocument();
        ElementDisplayInfo display = doc.getDisplayInfo();
        if (display == null) {
            return null;
        }
        return display.getToolTip((Element)doc);
    }
}

