/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dmt.dataminer.controls.BaseTreeTable;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONFilterCellEditor;
import oracle.dmt.dataminer.controls.JSONStructureTreeTable;
import oracle.dmt.dataminer.controls.renderers.JSONFilterCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONAddAggregationSelectionChange;
import oracle.ide.Context;
import oracle.javatools.ui.checktree.TriStateNode;

public class JSONQueryStructureTreeTable
extends JSONStructureTreeTable {
    private boolean filterSupport = false;
    private Map<String, TableCellEditor> editors;
    private JSONFilterCellRenderer renderer;
    private JSONAddAggregationSelectionChange listener;

    public JSONQueryStructureTreeTable(Context context, boolean bl) {
        super(context, true, bl);
        this.filterSupport = bl;
        this.enableCheckBoxes();
    }

    @Override
    public void enableCheckBoxes() {
        this.setCheckBoxesEnabled(true);
        this.setCheckboxCellRenderer();
        this.setCheckboxCellEditor();
        this.getTree().setEditable(true);
    }

    protected void initialize() {
        if (closedIcon == null) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getTree().getCellRenderer();
            closedIcon = defaultTreeCellRenderer.getDefaultClosedIcon();
            openIcon = defaultTreeCellRenderer.getDefaultOpenIcon();
            textSelectionColor = defaultTreeCellRenderer.getTextSelectionColor();
            textNonSelectionColor = defaultTreeCellRenderer.getTextNonSelectionColor();
        }
        if (this.filterSupport) {
            this.editors = new HashMap<String, TableCellEditor>();
            this.editors.put("BOOLEAN", new JSONFilterCellEditor(this.getContext(), "BOOLEAN"));
            this.editors.put("ARRAY", new JSONFilterCellEditor(this.getContext(), "ARRAY"));
            this.editors.put("NUMBER", new JSONFilterCellEditor(this.getContext(), "NUMBER"));
            this.editors.put("STRING", new JSONFilterCellEditor(this.getContext(), "STRING"));
            this.renderer = new JSONFilterCellRenderer();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == JSONElement.JSON_FILTER_COLUMN) {
            Object object = this.getValueAt(n, JSONElement.JSON_DATA_COLUMN);
            String string = (String)object;
            return DatabaseMetadataUtils.isJSONPredicateSupported(string);
        }
        return super.isCellEditable(n, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3;
        Object object;
        String string;
        TableCellEditor tableCellEditor;
        if (this.filterSupport && n2 == JSONElement.JSON_FILTER_COLUMN && (tableCellEditor = this.editors.get(string = (String)(object = this.getValueAt(n3 = this.convertRowIndexToModel(n), JSONElement.JSON_DATA_COLUMN)))) != null) {
            return tableCellEditor;
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3;
        Object object;
        String string;
        if (this.filterSupport && n2 == JSONElement.JSON_FILTER_COLUMN && DatabaseMetadataUtils.isJSONPredicateSupported(string = (String)(object = this.getValueAt(n3 = this.convertRowIndexToModel(n), JSONElement.JSON_DATA_COLUMN)))) {
            return this.renderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public void addSelectionChangeListener(JSONAddAggregationSelectionChange jSONAddAggregationSelectionChange) {
        this.listener = jSONAddAggregationSelectionChange;
    }

    @Override
    protected void selectionChanged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.listener != null) {
            this.listener.selectionChanged();
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
        if (this.tree != null) {
            this.tree.updateUI();
        }
    }

    @Override
    protected void setCheckboxCellRenderer() {
        this.initialize();
        this.getTree().setCellRenderer(new CheckboxCellRendererGroupBy());
    }

    @Override
    protected void setCheckboxCellEditor() {
        this.getTree().setCellEditor(new CheckboxCellEditorGroupBy());
    }

    private boolean isNodeLocked(Object object) {
        boolean bl = false;
        if (object instanceof JSONElement) {
            JSONElement jSONElement = (JSONElement)((Object)object);
            bl = jSONElement.isNodeLocked();
        }
        return bl;
    }

    private boolean isInvalid(Object object) {
        boolean bl = false;
        if (object instanceof JSONElement) {
            JSONElement jSONElement = (JSONElement)((Object)object);
            bl = jSONElement.isElementInvalid();
        }
        return bl;
    }

    protected class CheckboxCellRendererGroupBy
    extends BaseTreeTable.CheckboxCellRendererHideShowCheckBox {
        protected CheckboxCellRendererGroupBy() {
        }

        @Override
        protected boolean isCheckBoxVisible(Object object) {
            return JSONQueryStructureTreeTable.this.isNodeLocked(object);
        }

        @Override
        protected boolean isInvalidElement(Object object) {
            return JSONQueryStructureTreeTable.this.isInvalid(object);
        }
    }

    protected class CheckboxCellEditorGroupBy
    extends BaseTreeTable.CheckboxCellEditor {
        protected CheckboxCellEditorGroupBy() {
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            TreePath treePath = JSONQueryStructureTreeTable.this.getTree().getSelectionPath();
            if (treePath == null) {
                return false;
            }
            TriStateNode triStateNode = (TriStateNode)treePath.getLastPathComponent();
            return !JSONQueryStructureTreeTable.this.isNodeLocked(triStateNode);
        }

        @Override
        protected boolean isInvalidElement(Object object) {
            return JSONQueryStructureTreeTable.this.isInvalid(object);
        }
    }
}

