/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.formatters;

import java.util.HashMap;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARObjectAbstractFormatter;
import oracle.dmt.dataminer.utils.FileHelper;

public abstract class ARItemSetAbstractFormatter
extends ARObjectAbstractFormatter<ItemSet> {
    private static final String ITEMSET_ID_LABEL = "ITEMSET_ID_LABEL";
    private static final String ITEMSET_ID_VALUE = "ITEMSET_ID_VALUE";
    private static final String ITEM_LIST_LABEL = "ITEM_LIST_LABEL";
    private static final String ITEMSET_DETAIL = "ITEMSET_DETAIL";
    protected String headerHtml = FileHelper.loadFile("/oracle/dmt/dataminer/mviewer/res/ARItemsetHeader.html");

    @Override
    protected String getNoItemSelectedMessage() {
        return ARRulesLrb.get("NO_ITEM_SET_TO_DISPLAY");
    }

    @Override
    protected String getSingleSelectionMessage() {
        return ARRulesLrb.get("SELECT_SINGLE_ITEMSET");
    }

    @Override
    protected String formatHeader(ItemSet itemSet) {
        String string = "<span style=\"font-weight: bold;\">" + CoreCommonLrb.get((String)"ID") + ":" + "</span>";
        String string2 = itemSet.getId() + "";
        String string3 = ARRulesLrb.get(ITEM_LIST_LABEL);
        String string4 = itemSet.getItemsToString();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ITEMSET_ID_LABEL, string);
        hashMap.put(ITEMSET_ID_VALUE, string2);
        hashMap.put(ITEM_LIST_LABEL, string3);
        hashMap.put(ITEMSET_DETAIL, string4);
        String string5 = StringUtils.getReplacedString((String)this.headerHtml, hashMap);
        return string5;
    }
}

