/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.clus.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.core.model.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.core.model.generated.server.DmHistograms;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.compare.ClusterCompareTableModel;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class CompareClusterViewerState
extends BaseViewerState
implements GraphModelProvider {
    static final Color[] colors = new Color[]{Color.RED, Color.BLUE};
    static final Color[] color = new Color[]{Color.RED};
    private static final int _DEPTH_RADIUS = 0;
    private static ModelViewerPreferenceSettings preferences = ModelViewerPreferenceSettings.getInstance();
    private int _depthRadius = 0;
    private boolean _loaded;
    private boolean _levelDetails = true;
    private String clusterLabel1;
    private String clusterLabel2;
    private boolean _leafsOnly = true;
    private boolean _maxPrecision;
    private int _precisionLevelOfHistogramLabels = 5;
    private Map<String, ClusteringDetailRowShort> _clusterCountsMap;
    private List<String> _clusterLabels;
    private ClusteringFilterSetting _filterSetting;
    private GenericBaseTableModel _tableModel;
    private List<CompareClustersModelRow> compareClustersData;
    private Version version = this.connectionManager.getDbVersion();
    public static final String alter_reverse_expression_cluster_id = "when value = [CLUSTER_ID] then ";
    public static final String alter_reverse_expression_case_rename = "'[NEW_NAME]'\n";
    public static final String alter_reverse_expression_case_keep_old = "'[OLD_NAME]'\n";
    public static final String alter_reverse_expression_case_end = "                else TO_CHAR(value) end";
    public static final String alter_reverse_expression_final = "BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n";

    public CompareClusterViewerState(Context context) {
        super(context);
    }

    public HelpInfo getHelpInfo() {
        String string = "cluster_compare_help";
        return new HelpInfo(string);
    }

    public void loadClusterLabelsNew() {
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        this._clusterLabels = new ArrayList<String>(map.keySet());
        Collections.sort(this._clusterLabels, LetterNumberComparator.getComparator());
    }

    private Map<String, ClusteringDetailRowShort> getLeafsOnlyMap(Map<String, ClusteringDetailRowShort> map) {
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        for (Map.Entry<String, ClusteringDetailRowShort> entry : map.entrySet()) {
            String string = entry.getKey();
            ClusteringDetailRowShort clusteringDetailRowShort = entry.getValue();
            if (clusteringDetailRowShort.hasChildren()) continue;
            hashMap.put(string, clusteringDetailRowShort);
        }
        return hashMap;
    }

    public void reloadClusterLabelsNew(String string, String string2) {
        ClusteringDetailRowShort clusteringDetailRowShort = new ClusteringDetailRowShort(this._clusterCountsMap.get(string2));
        this._clusterCountsMap.remove(string2);
        this._clusterCountsMap.put(string, clusteringDetailRowShort);
        this.loadClusterLabelsNew();
        if (this.clusterLabel1.equals(string2)) {
            this.clusterLabel1 = string;
        }
        if (this.clusterLabel2 != null && this.clusterLabel2.equals(string2)) {
            this.clusterLabel2 = string;
        }
    }

    public void reloadClusterCacheNew() {
        this.loadClusterLabelsNew();
    }

    private Map<String, ClusteringDetailRowShort> getMap() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.context.getNode();
        Map<String, ClusteringDetailRowShort> map = clusteringModelNode.getClusterCountsMap(this.getUserName(), this.getModelName());
        return map;
    }

    private void setMap(Map<String, ClusteringDetailRowShort> map) {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.context.getNode();
        clusteringModelNode.setClusterCountsMap(this.getUserName(), this.getModelName(), map);
    }

    private void loadDataNew(boolean bl, String string, boolean bl2) throws ODMrDAOException {
        assert (this.isClustering()) : "Only for clustering models";
        Clustering clustering = this.getModel();
        clustering.setPartitionId(string);
        if (this._clusterCountsMap == null || StringUtils.isNotEmpty(string) || bl2) {
            this._clusterCountsMap = this.getMap();
            if (this._clusterCountsMap == null || string != null && !"".equals(string) || bl2) {
                this._clusterCountsMap = clustering.getTotalNumberOfModelAttributesPerCluster2();
            }
        }
        if (bl || string != null && !"".equals(string) || bl2) {
            this._filterSetting = new ClusteringFilterSetting();
            this._filterSetting.setFetchSize(preferences.getFetchSizeClusteringModel());
            this.loadDefaultClustersNew();
        }
        this.loadClusterLabelsNew();
        this.compareClustersData = clustering.getDivergenceHistogramCentroid(this.getClusterIdNew(this.clusterLabel1), this.clusterLabel1, this.getClusterIdNew(this.clusterLabel2), this.clusterLabel2, this._filterSetting.getFetchSize());
    }

    public void loadDataUI(boolean bl) throws SQLException {
        if (this.isKM()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this.setMap(this._clusterCountsMap);
                }
            }
        } else if (this.isOC()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this.setMap(this._clusterCountsMap);
                }
            }
        } else if (this.isEM()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this.setMap(this._clusterCountsMap);
                }
            }
        } else assert (false) : this.getClass().getName() + " not loaded.";
        if (this._tableModel instanceof ClusterCompareTableModel) {
            ((ClusterCompareTableModel)this._tableModel).clear();
        }
        this._tableModel = this.compareClustersData != null ? new ClusterCompareTableModel(this.compareClustersData, this.clusterLabel1, this.clusterLabel2) : new EmptyClusterCompareTableModel();
        this.createAllGraphDataModelsTotalPopulation();
    }

    private void loadDefaultClustersNew() {
        this.clusterLabel1 = null;
        this.clusterLabel2 = null;
        Iterator<String> iterator = this._clusterCountsMap.keySet().iterator();
        while (iterator.hasNext() && (this.clusterLabel1 == null || this.clusterLabel2 == null)) {
            String string = iterator.next();
            ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(string);
            if (this._leafsOnly) {
                if (clusteringDetailRowShort.hasChildren()) continue;
                if (this.clusterLabel1 == null) {
                    this.clusterLabel1 = string;
                    continue;
                }
                if (this.clusterLabel2 != null) continue;
                this.clusterLabel2 = string;
                continue;
            }
            if (this.clusterLabel1 == null) {
                this.clusterLabel1 = string;
                continue;
            }
            if (this.clusterLabel2 != null) continue;
            this.clusterLabel2 = string;
        }
    }

    public CompareClusterViewerState load(String string, boolean bl) throws ODMrDAOException {
        assert (this.isClustering()) : "For clustering only";
        Node node = this.context.getNode();
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)node;
        if (this.isKM()) {
            this._levelDetails = !clusteringModelNode.isKMnoneOptionEnabled() && (clusteringModelNode.isStatsEnabled() || !DbVersionHelper.isDB122Up((Version)this.version));
        } else if (this.isEM()) {
            this._levelDetails = clusteringModelNode.isStatsEnabled();
        }
        try {
            if (this._levelDetails) {
                this._loaded = false;
                this.loadDataNew(true, string, bl);
            }
            this._loaded = true;
        }
        catch (ODMrDAOException oDMrDAOException) {
            throw oDMrDAOException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        return this;
    }

    public void reload(String string) throws ODMrDAOException, SQLException {
        Node node;
        ClusteringModelNode clusteringModelNode;
        if (DbVersionHelper.isDB122Up((Version)this.version) && ((clusteringModelNode = (ClusteringModelNode)(node = this.context.getNode())).isKMnoneOptionEnabled() || !clusteringModelNode.isStatsEnabled())) {
            this._levelDetails = false;
        }
        if (this._levelDetails) {
            this._loaded = false;
            this.loadDataNew(false, string, false);
        }
        this._loaded = true;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        return null;
    }

    @Override
    public String getStyleSelection() {
        return null;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public boolean getLevelDetails() {
        return this._levelDetails;
    }

    public Version getDbVersion() {
        return this.version;
    }

    public GenericBaseTableModel getTableModel() {
        return this._tableModel;
    }

    public void setFilterSetting(ClusteringFilterSetting clusteringFilterSetting) {
        this._filterSetting = clusteringFilterSetting;
    }

    public ClusteringFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    private void createAllGraphDataModelsTotalPopulation() throws SQLException {
        if (this._tableModel instanceof EmptyClusterCompareTableModel) {
            return;
        }
        List list = ((ClusterCompareTableModel)this._tableModel).getSrcData();
        for (CompareClustersModelRow compareClustersModelRow : list) {
            String string = compareClustersModelRow.getFullAttributeName();
            GraphDataModel graphDataModel = this.createGraphDataModelClusterPopulationGeneric(string, false);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(Integer.valueOf(0));
            graphDataModel.setLineDataLineDisplayed(false);
            compareClustersModelRow.setGraphDataModel(graphDataModel);
        }
    }

    public GraphDataModel createGraphDataModelForAttribute(String string) throws Exception {
        return this.createGraphDataModelClusterPopulationGeneric(string, true);
    }

    private GraphDataModel createGraphDataModelClusterPopulationGeneric(String string, boolean bl) throws SQLException {
        if (this._tableModel instanceof EmptyClusterCompareTableModel) {
            return null;
        }
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 20, null, null, null);
        CompareClustersModelRow compareClustersModelRow = ((ClusterCompareTableModel)this._tableModel).getClusterDetailRow(string);
        DmHistograms dmHistograms = compareClustersModelRow.getFirstClusterHistogram();
        DmHistograms dmHistograms2 = compareClustersModelRow.getSecondClusterHistogram();
        if (!(dmHistograms != null && dmHistograms.length() != 0 || dmHistograms2 != null && dmHistograms2.length() != 0)) {
            return defaultGraphDataModel;
        }
        ArrayList<DmHistograms> arrayList = new ArrayList<DmHistograms>();
        if (dmHistograms != null && dmHistograms.length() > 0) {
            arrayList.add(dmHistograms);
        }
        if (dmHistograms2 != null && dmHistograms2.length() > 0) {
            arrayList.add(dmHistograms2);
        }
        int n = dmHistograms != null ? dmHistograms.length() : dmHistograms2.length();
        int n2 = arrayList.size();
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        objectArray3[0] = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SERIES") + this.clusterLabel1;
        if (n2 > 1) {
            objectArray3[1] = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SERIES") + this.clusterLabel2;
        }
        for (int i = 0; i < n2; ++i) {
            BigDecimal bigDecimal;
            DmHistogramBin dmHistogramBin;
            int n3;
            DmHistograms dmHistograms3 = (DmHistograms)arrayList.get(i);
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                dmHistogramBin = dmHistograms3.getElement((long)n3);
                bigDecimal = dmHistogramBin.getCount();
                n4 += bigDecimal.intValue();
            }
            for (n3 = 0; n3 < n; ++n3) {
                dmHistogramBin = dmHistograms3.getElement((long)n3);
                bigDecimal = dmHistogramBin.getCount();
                BigDecimal bigDecimal2 = dmHistogramBin.getUpperBound();
                BigDecimal bigDecimal3 = dmHistogramBin.getLowerBound();
                int n5 = dmHistogramBin.getBinId().intValue();
                if (n5 > n) {
                    n5 = n;
                }
                String string2 = bigDecimal2 != null && bigDecimal3 != null ? (this._maxPrecision ? dmHistogramBin.getLabel() : this.formatLabelFromBoundaries(bigDecimal3, bigDecimal2)) : dmHistogramBin.getLabel();
                objectArray[n5 - 1][i] = this.isKM() || this.isEM() ? (n4 == 0 ? Double.valueOf(bigDecimal.doubleValue() * 100.0) : Double.valueOf(bigDecimal.doubleValue() / (double)n4 * 100.0)) : Double.valueOf(bigDecimal.doubleValue() * 100.0);
                objectArray2[n5 - 1] = bl ? string2 : "";
            }
        }
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        if (n2 > 1) {
            defaultGraphDataModel.addRowColors(colors);
        } else {
            defaultGraphDataModel.addRowColors(color);
        }
        defaultGraphDataModel.setTitle(string);
        return defaultGraphDataModel;
    }

    public void setLeafsOnlyNew(boolean bl) {
        if (this.isLoaded() && this._leafsOnly != bl) {
            this._leafsOnly = bl;
            this.loadClusterLabelsNew();
        }
    }

    public boolean isLeafsOnly() {
        return this._leafsOnly;
    }

    public void setMaxPrecision(boolean bl) {
        this._maxPrecision = bl;
    }

    public boolean isMaxPrecision() {
        return this._maxPrecision;
    }

    private String formatLabelFromBoundaries(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        double d = bigDecimal.doubleValue();
        double d2 = bigDecimal2.doubleValue();
        String string = NumericFormat.format((double)d, (boolean)true, (int)this._precisionLevelOfHistogramLabels) + "";
        String string2 = NumericFormat.format((double)d2, (boolean)true, (int)this._precisionLevelOfHistogramLabels) + "";
        return string + " : " + string2;
    }

    public void setPrecisionLevelOfHistogramLabels(int n) {
        this._precisionLevelOfHistogramLabels = n;
    }

    public int getPrecisionLevelOfHistogramLabels() {
        return this._precisionLevelOfHistogramLabels;
    }

    public int getTotalNumberOfModelAttributesNew() {
        if (this._clusterCountsMap == null || this._clusterCountsMap.size() == 0) {
            return 0;
        }
        return this._clusterCountsMap.get(this.getClusterLabel1()).getAttributeCount();
    }

    public List<String> getClusterLabels() {
        return this._clusterLabels;
    }

    public int getDepthRadius() {
        return this._depthRadius;
    }

    public void setClusterLabel1(String string) {
        this.clusterLabel1 = string;
    }

    public String getClusterLabel1() {
        return this.clusterLabel1;
    }

    public void setClusterLabel2(String string) {
        this.clusterLabel2 = string;
    }

    public String getClusterLabel2() {
        return this.clusterLabel2;
    }

    public Integer getClusterIdNew(String string) {
        if (string == null) {
            return null;
        }
        ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(string);
        return clusteringDetailRowShort.getId();
    }

    public boolean isClusterLabelUniquieNew(String string) {
        return null != this._clusterCountsMap.get(string);
    }

    public String renameClusterLabelNew(String string, String string2) throws Exception {
        ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(string2);
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (String object2 : this._clusterCountsMap.keySet()) {
            ClusteringDetailRowShort sQLException = this._clusterCountsMap.get(object2);
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = StringUtils.getReplacedString(alter_reverse_expression_cluster_id, "[CLUSTER_ID]", sQLException.getId().toString());
            stringBuilder2.append(string3);
            if (clusteringDetailRowShort.getId().equals(sQLException.getId())) {
                sQLException.setClusterId(string);
                string3 = StringUtils.getReplacedString(alter_reverse_expression_case_rename, "[NEW_NAME]", string);
            } else {
                string3 = StringUtils.getReplacedString(alter_reverse_expression_case_keep_old, "[OLD_NAME]", sQLException.getClusterId());
            }
            stringBuilder2.append(string3);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(alter_reverse_expression_case_end);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(alter_reverse_expression_final);
            sQLHelper.opstmt.setQueryTimeout(5);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            this.reloadClusterLabelsNew(string, string2);
        }
        return string;
    }

    public Map<String, ClusteringDetailRowShort> getClusterCountsMap() {
        return this._clusterCountsMap;
    }

    @Override
    public Clustering getModel() {
        return (Clustering)this.getModelViewerState().getOdmModel();
    }

    public static class EmptyClusterCompareTableModel
    extends SimpleBaseTableModel {
        public static final int _COLUMN_NAME = 0;
        private Vector<String> _data = new Vector();

        public EmptyClusterCompareTableModel() {
            Object[] objectArray = new String[]{CompareClustersLrb.get("COMPARE_CLUSTERS_NOT_ENOUGH_ERROR")};
            String string = CompareClustersLrb.get("COMPARE_CLUSTERS_NOT_ENOUGH_CLUSTERS");
            this.setColumnIdentifiers(objectArray);
            this._data.add(string);
            this.setRowCount(this._data.size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                default: {
                    assert (false) : "Invalid option";
                    break;
                }
            }
            return string2 != null ? string2 : "";
        }
    }
}

