/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.model.ar.PredicateRowData;
import oracle.dmt.dataminer.core.model.ar.RuleRowData;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.utils.HTMLStringUtils;

public class ClusTreeRule {
    private static final Logger LOGGER = Logger.getLogger(ClusTreeRule.class.getName());
    private static String ruleSeparatorIf = ClusteringTreeEditorLrb.get("RULE_SEPARATOR_IF");
    private static String ruleSeparatorAnd = ClusteringTreeEditorLrb.get("RULE_SEPARATOR_AND");
    private static String ruleSeparatorThen = ClusteringTreeEditorLrb.get("RULE_SEPARATOR_THEN");
    private static String ruleSeparatorRoot = "";
    private static Map<String, String> mathSymbolsHtml = new HashMap<String, String>();
    private static Map<String, String> reverseMathSymbolsHtml = new HashMap<String, String>();
    private static Map<String, String> categoricalOperators = new HashMap<String, String>();
    private static final String GT = ">";
    private static final String LT = "<";
    private static final String GTE = ">=";
    private static final String LTE = "<=";
    private static final String GREATER = ">";
    private static final String LESS = "<";
    private static final String EQUAL = "=";
    private static final String ISIN = "IN";
    private static final String ISNOTIN = "NOT IN";
    private static final String IS = "IS";
    private static final String ISNOT = "IS NOT";
    private static final String I1 = "  ";
    private static final String I2 = "    ";
    private static final String I3 = "      ";
    private static final String SPACE = " ";

    private static boolean isSecondaryRule(RuleElement ruleElement, RuleElement ruleElement2) {
        String string = ruleElement2.getOperator();
        String string2 = ruleElement.getOperator();
        return !((!string.equals(">") && !string.equals(GTE) || !string2.equals("<") && !string2.equals(LTE)) && (!string.equals("<") && !string.equals(LTE) || !string2.equals(">") && !string2.equals(GTE)) || ruleElement2.getSecondaryRule() != null);
    }

    public static String getRulesHtml(ClusTreeNode clusTreeNode, boolean bl, int n) {
        return ClusTreeRule.getRulesHtml(clusTreeNode, bl, n, false);
    }

    public static String getRulesHtml(ClusTreeNode clusTreeNode, boolean bl, int n, boolean bl2) {
        String string = "";
        LinkedHashMap<String, RuleElement> linkedHashMap = new LinkedHashMap<String, RuleElement>();
        RuleRowData ruleRowData = clusTreeNode.getData().getRule();
        if (ruleRowData == null) {
            return "<html>" + ClusteringTreeEditorLrb.get("RULES_NONE") + "</hmtl>";
        }
        List list = ruleRowData.getAntecedent();
        List<RuleElement> list2 = ClusTreeRule.getAllRules(clusTreeNode, list, n);
        for (RuleElement ruleElement : list2) {
            if (linkedHashMap.containsKey(ruleElement.getField())) {
                RuleElement ruleElement2 = (RuleElement)linkedHashMap.get(ruleElement.getField());
                if (ClusTreeRule.isSecondaryRule(ruleElement, ruleElement2)) {
                    ruleElement2.setSecondaryRule(ruleElement);
                    continue;
                }
                if (!ruleElement.getOperator().equals(ISIN)) continue;
                ruleElement2.setExpression(ruleElement2.getExpression() + ", " + ruleElement.getExpression());
                continue;
            }
            linkedHashMap.put(ruleElement.getField(), ruleElement);
        }
        if (!bl2) {
            string = "<html>\n";
        }
        Collection collection = linkedHashMap.values();
        string = string + ClusTreeRule.getRulesHtmlTable(collection, clusTreeNode, bl, true);
        if (!bl2) {
            string = string + "</html>\n";
        }
        return string;
    }

    public static String getSplitRulesHtml(ClusTreeNode clusTreeNode, boolean bl) {
        List list;
        String string = "";
        LinkedHashMap<String, RuleElement> linkedHashMap = new LinkedHashMap<String, RuleElement>();
        ClusTreeNode clusTreeNode2 = clusTreeNode.findParentNode();
        boolean bl2 = false;
        ClusterTreeSDMModel clusterTreeSDMModel = clusTreeNode.getModel();
        if (clusTreeNode2 == null) {
            return "None";
        }
        if (!clusterTreeSDMModel.isSplitPredicateForNode(clusTreeNode)) {
            bl2 = true;
        }
        if ((list = clusTreeNode2.getData().getSplitPredicate()) == null) {
            if (clusTreeNode.getContext().getNode() instanceof OCModelNode) {
                LOGGER.log(Level.SEVERE, "Encountered null Split_predicate when it is required");
            }
            return "";
        }
        List<RuleElement> list2 = ClusTreeRule.getAllRules(clusTreeNode, list, 0);
        for (RuleElement ruleElement : list2) {
            if (linkedHashMap.containsKey(ruleElement.getField())) {
                RuleElement ruleElement2 = (RuleElement)linkedHashMap.get(ruleElement.getField());
                if (ClusTreeRule.isSecondaryRule(ruleElement, ruleElement2)) {
                    ruleElement2.setSecondaryRule(ruleElement);
                    continue;
                }
                if (!ruleElement.getOperator().equals(ISIN)) continue;
                ruleElement2.setExpression(ruleElement2.getExpression() + ", " + ruleElement.getExpression());
                continue;
            }
            linkedHashMap.put(ruleElement.getField(), ruleElement);
        }
        if (bl2) {
            ClusTreeRule.complementAllRules(linkedHashMap.values());
        }
        string = "<html>\n";
        string = string + ClusteringTreeEditorLrb.get("CLUSTER_SPLIT_PREDICATE") + "<br>";
        Collection collection = linkedHashMap.values();
        string = string + ClusTreeRule.getRulesHtmlTable(collection, clusTreeNode, bl, false);
        string = string + "</html>\n";
        return string;
    }

    private static void complementAllRules(Collection<RuleElement> collection) {
        for (RuleElement ruleElement : collection) {
            String string = ClusTreeRule.getComplementOperator(ruleElement.getOperator());
            ruleElement.setOperator(string);
            RuleElement ruleElement2 = ruleElement.getSecondaryRule();
            if (ruleElement2 == null) continue;
            string = ClusTreeRule.getComplementOperator(ruleElement2.getOperator());
            ruleElement2.setOperator(ClusTreeRule.getComplementOperator(string));
        }
    }

    private static String getComplementOperator(String string) {
        if (string.equals(">")) {
            return LTE;
        }
        if (string.equals("<")) {
            return GTE;
        }
        if (string.equals(LTE)) {
            return ">";
        }
        if (string.equals(GTE)) {
            return "<";
        }
        if (string.equals(ISIN)) {
            return ISNOTIN;
        }
        if (string.equals(IS)) {
            return ISNOT;
        }
        throw new RuntimeException("Unexpected operator encountered");
    }

    private static List<RuleElement> getAllRules(ClusTreeNode clusTreeNode, List<PredicateRowData> list, int n) {
        List list2;
        Object object;
        Object object2;
        ArrayList<RuleElement> arrayList = new ArrayList<RuleElement>();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            object2 = list.get(i);
            String string = ClusTreeNode.getQualifiedAttributeName((PredicateRowData)object2);
            object = (List)hashMap.get(string);
            if (object == null) {
                list2 = new ArrayList<Object>();
                list2.add(object2);
                hashMap.put(string, list2);
                continue;
            }
            object.add(object2);
        }
        Set<String> set = clusTreeNode.getTopItems().keySet();
        object2 = set.iterator();
        int n2 = 0;
        while (object2.hasNext()) {
            object = (String)object2.next();
            list2 = (List)hashMap.get(object);
            if (list2 == null) continue;
            for (PredicateRowData predicateRowData : list2) {
                arrayList.add(ClusTreeRule.constructRuleElement(predicateRowData));
            }
            if (n == 0 || ++n2 < n) continue;
            break;
        }
        return arrayList;
    }

    private static String getRulesHtmlTable(Collection<RuleElement> collection, ClusTreeNode clusTreeNode, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (bl2) {
            stringBuilder.append(I1);
            stringBuilder.append("<table>\n");
        } else {
            stringBuilder.append(I1);
            stringBuilder.append("<table width=\"400\">\n");
        }
        int n = 0;
        for (RuleElement ruleElement : collection) {
            String string2 = ClusTreeRule.getFormattedPredicateString(ruleElement);
            if (bl2) {
                string = n == 0 ? ruleSeparatorIf : ruleSeparatorAnd;
            }
            stringBuilder.append(ClusTreeRule.getTableRow(true, string2, string, bl));
            ++n;
        }
        if (bl2) {
            string = ruleSeparatorThen;
            stringBuilder.append(ClusTreeRule.getTableRow(true, ClusteringTreeEditorLrb.get("RULE_CONSEQUENT") + SPACE + clusTreeNode.getData().getClusterId(), string, bl));
        }
        stringBuilder.append(I1);
        stringBuilder.append("</table>\n\n");
        stringBuilder.append("<table style='text-align: left; width: 33%;' border=1 cellpadding=1 cellspacing=1>\n");
        stringBuilder.append("<tbody>\n");
        stringBuilder.append("<tr>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        stringBuilder.append(ClusteringTreeEditorLrb.get("RULE_CONFIDENCE"));
        stringBuilder.append("<br></code>\n");
        stringBuilder.append("</td>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        if (clusTreeNode.getData().getRule().getConfidence() != null) {
            stringBuilder.append(clusTreeNode.getData().getRule().getConfidence());
        } else {
            stringBuilder.append("0");
        }
        stringBuilder.append("</code></td>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("<tr>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        stringBuilder.append(ClusteringTreeEditorLrb.get("RULE_SUPPORT"));
        stringBuilder.append("<br></code>\n");
        stringBuilder.append("</td>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        if (clusTreeNode.getData().getRule().getSupport() != null) {
            stringBuilder.append(clusTreeNode.getData().getRule().getSupport());
        } else {
            stringBuilder.append("0");
        }
        stringBuilder.append("</code></td>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("</tbody>\n");
        stringBuilder.append("</table>\n");
        return stringBuilder.toString();
    }

    private static String getTableRow(boolean bl, String string, String string2, boolean bl2) {
        String string3 = "";
        String string4 = bl ? string2 : "";
        String string5 = bl2 ? "" : "nowrap";
        string3 = string3 + "    <tr>\n";
        string3 = string3 + "      <td align=\"left\" valign=\"top\" style=\"font-family: monospace\"><b>" + string4 + "</b></td>\n";
        string3 = string3 + "      <td style=\"font-family: monospace\" " + string5 + ">" + string + "</td>\n";
        string3 = string3 + "    </tr>\n";
        return string3;
    }

    private static String getMathSymbolForOperator(String string, boolean bl) {
        string = string.trim();
        Map<String, String> map = bl ? reverseMathSymbolsHtml : mathSymbolsHtml;
        return map.get(string);
    }

    public static String getFormattedPredicateString(RuleElement ruleElement) {
        return ClusTreeRule.getFormattedPredicateString(ruleElement, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFormattedPredicateString(RuleElement ruleElement, int n) {
        String string = "";
        String string2 = ruleElement.getOperator();
        if (string2.equals(ISIN) || string2.equals(IS) || string2.equals(ISNOTIN) || string2.equals(ISNOT)) {
            string = string + ruleElement.getField() + SPACE;
            string = string + categoricalOperators.get(ruleElement.getOperator()) + SPACE;
            string = string + "(" + ruleElement.getExpression() + ")";
        } else if (ruleElement.getSecondaryRule() == null) {
            string = string + ruleElement.getField() + SPACE;
            string = string + ClusTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false) + SPACE;
            string = string + ruleElement.getExpression();
        } else {
            if (ruleElement.getSecondaryRule() == null) throw new RuntimeException("Unexpected expression");
            RuleElement ruleElement2 = ruleElement.getSecondaryRule();
            if (ruleElement.getOperator().startsWith("<")) {
                string = string + ruleElement2.getExpression() + SPACE;
                string = string + ClusTreeRule.getMathSymbolForOperator(ruleElement2.getOperator(), true) + SPACE;
                string = string + ruleElement.getField() + SPACE;
                string = string + ClusTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false) + SPACE;
                string = string + ruleElement.getExpression();
            } else {
                if (!ruleElement.getOperator().startsWith(">")) throw new RuntimeException("Unexpected expression");
                string = string + ruleElement.getExpression() + SPACE;
                string = string + ClusTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), true) + SPACE;
                string = string + ruleElement2.getField() + SPACE;
                string = string + ClusTreeRule.getMathSymbolForOperator(ruleElement2.getOperator(), false) + SPACE;
                string = string + ruleElement2.getExpression();
            }
        }
        if (n <= 0) return HTMLStringUtils.forHTML(string);
        if (string.length() <= n) return HTMLStringUtils.forHTML(string);
        string = string.substring(0, n) + " ...";
        return HTMLStringUtils.forHTML(string);
    }

    private static RuleElement constructRuleElement(PredicateRowData predicateRowData) {
        RuleElement ruleElement = new RuleElement();
        String string = predicateRowData.getAttributeStrValue();
        if (string != null) {
            ruleElement.setExpression("\"" + predicateRowData.getValue() + "\"");
        } else {
            ruleElement.setExpression(predicateRowData.getValue());
        }
        ruleElement.setField(ClusTreeNode.getQualifiedAttributeName(predicateRowData));
        ruleElement.setOperator(predicateRowData.getConditionalOperator());
        return ruleElement;
    }

    static {
        mathSymbolsHtml.put(">", ">");
        mathSymbolsHtml.put("<", "<");
        mathSymbolsHtml.put(GTE, GTE);
        mathSymbolsHtml.put(LTE, LTE);
        mathSymbolsHtml.put(EQUAL, EQUAL);
        reverseMathSymbolsHtml.put(">", "<");
        reverseMathSymbolsHtml.put("<", ">");
        reverseMathSymbolsHtml.put(GTE, LTE);
        reverseMathSymbolsHtml.put(LTE, GTE);
        reverseMathSymbolsHtml.put(EQUAL, EQUAL);
        categoricalOperators.put(ISIN, ClusteringTreeEditorLrb.get("RULE_IS_IN_COMPARISON"));
        categoricalOperators.put(IS, ClusteringTreeEditorLrb.get("RULE_IS_COMPARISON"));
        categoricalOperators.put(ISNOTIN, ClusteringTreeEditorLrb.get("RULE_IS_NOT_IN_COMPARISON"));
        categoricalOperators.put(ISNOT, ClusteringTreeEditorLrb.get("RULE_IS_NOT_COMPARISON"));
    }

    public static class RuleElement {
        String field = null;
        String operator = null;
        String expression = null;
        RuleElement secondaryRule = null;

        public void setField(String string) {
            this.field = string;
        }

        public String getField() {
            return this.field;
        }

        public void setOperator(String string) {
            this.operator = string;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setSecondaryRule(RuleElement ruleElement) {
            this.secondaryRule = ruleElement;
        }

        public RuleElement getSecondaryRule() {
            return this.secondaryRule;
        }
    }
}

