/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.mviewer.coefficients.RegrCoefficientFilterPanel;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class RegrCoefViewer
extends JPanel
implements GeneralCoeffViewer {
    private static final int GLM_FROZEN_COLUMNS = 2;
    private boolean loadedFilterSetting;
    private Context context;
    private CoefViewerState state;
    private CoefViewerMainPanel mainPanel;
    private NumberFormat labelNumericalFormat;
    private NumberFormat labelPercentageFormat;
    private BlockingComponent overlayPanel;
    private HistogramBarRenderer barRenderer;
    private DataMinerTablePanel dataMinerTablePanel;

    public RegrCoefViewer(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        this.mainPanel = coefViewerMainPanel;
        this.context = coefViewerState.getContext();
        this.state = coefViewerState;
        this.labelNumericalFormat = Formats.ModelViewer.getNumeric();
        this.labelPercentageFormat = Formats.ModelViewer.getPercentage();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 504, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, -1, Short.MAX_VALUE));
    }

    @Override
    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overlayPanel = blockingComponent;
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    @Override
    public void initUI() {
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = "";
        if (this.state.isSVM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        } else if (this.state.isGLM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        }
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this.state.isSVM() || this.state.isGLM()) {
            n3 = 0;
        }
        Integer n4 = n2 + n3;
        String string2 = NumericFormat.format((int)n);
        String string3 = NumericFormat.format((int)n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void setLoading(boolean bl) {
        this.mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this.loadedFilterSetting) {
            this.mainPanel.setFilterPanelInitialState(this.state.getFilterSetting());
            this.loadedFilterSetting = true;
        }
        this.mainPanel.updateLoaded(bl);
    }

    private boolean isLoading() {
        return this.mainPanel.isLoading();
    }

    @Override
    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this.state.setFilterSetting(coefficientFilterSetting);
        this.prepareReload();
    }

    public CoefficientFilterSetting getFilterState() {
        return this.state.getFilterSetting();
    }

    @Override
    public CoefficientFilterSetting getCachedFilterState() {
        return this.state.getCachedFilterSetting();
    }

    @Override
    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this.state.setCachedFilterSetting(coefficientFilterSetting);
    }

    @Override
    public void prepareReload() {
        QueryWorker queryWorker = new QueryWorker();
        queryWorker.execute();
    }

    private void setupSVMTable(CoefViewerTableModel coefViewerTableModel) {
        UITools.setModelPresevingSort(this.dataMinerTablePanel, coefViewerTableModel);
        this.barRenderer = new HistogramBarRenderer(1.0, true, this.labelNumericalFormat);
        this.dataMinerTablePanel.getTable().getColumnModel().getColumn(2).setCellRenderer(this.barRenderer);
        this.barRenderer.setMaximumValue(this.state.getMaximumABSCoefficient().longValue());
    }

    private void setupGLMTable(GLMCoefViewerTableModel gLMCoefViewerTableModel) {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        dataMinerTable.setFixedColumns(2, new int[0]);
        gLMCoefViewerTableModel.setAbsoluteValueSort(this.state.getFilterSetting().getFilterAndSortByAbsolute());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, gLMCoefViewerTableModel);
        dataMinerTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = dataMinerTable.getFullColumnModel();
        this.barRenderer = new HistogramBarRenderer(1.0, true, this.labelNumericalFormat);
        this.barRenderer.setMaximumValue(this.state.getMaximumABSCoefficient().longValue());
        tableColumnModel.getColumn(2).setCellRenderer(this.barRenderer);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer);
        if (this.state.isCovarianceIndicator()) {
            tableColumnModel.getColumn(7).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(6).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(4).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(5).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(8).setCellRenderer(tableCellRenderer);
        }
        dataMinerTable.autoSizeColumnsToFit();
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    private void setupTable() {
        if (this.state.isSVM()) {
            this.setupSVMTable((CoefViewerTableModel)this.state.getTableModel());
        } else if (this.state.isGLM()) {
            this.setupGLMTable((GLMCoefViewerTableModel)this.state.getTableModel());
        }
        this.dataMinerTablePanel.trySearch();
        this.loadRowsOutOfTotalLabel(this.state.getTableModel().getRowCount(), this.state.getTotalDetailCount());
        if (this.dataMinerTablePanel.getTable().getRowCount() > 0) {
            this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{0});
        }
        this.setLoaded(true);
    }

    private class QueryWorker
    extends ODMrSwingWorker<Void, Void> {
        public QueryWorker() {
            super(RegrCoefViewer.this, RegrCoefViewer.this.overlayPanel, RegrCoefViewer.this.dataMinerTablePanel.getTable());
        }

        @Override
        protected void beforeExecute() {
            RegrCoefViewer.this.setLoading(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            RegrCoefficientFilterPanel regrCoefficientFilterPanel = (RegrCoefficientFilterPanel)RegrCoefViewer.this.mainPanel.getViewerFilterPanel();
            RegrCoefViewer.this.state.reloadCoefficients(regrCoefficientFilterPanel.getSelectedParitionId());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            RegrCoefViewer.this.setupTable();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(RegrCoefViewer.this.mainPanel.getEditor().getContext(), throwable, ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            RegrCoefViewer.this.setLoading(false);
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(RegrCoefViewer.this, RegrCoefViewer.this.overlayPanel, RegrCoefViewer.this.dataMinerTablePanel.getTable());
        }

        @Override
        protected void beforeExecute() {
            RegrCoefViewer.this.setLoading(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            RegrCoefficientFilterPanel regrCoefficientFilterPanel = (RegrCoefficientFilterPanel)RegrCoefViewer.this.mainPanel.getViewerFilterPanel();
            RegrCoefViewer.this.mainPanel.getViewerFilterPanel().getPartitionToolbar().load(RegrCoefViewer.this.mainPanel.getEditor());
            RegrCoefViewer.this.state.load(regrCoefficientFilterPanel.getPartitionVO());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            RegrCoefViewer.this.setupTable();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(RegrCoefViewer.this.mainPanel.getEditor().getContext(), throwable, ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            RegrCoefViewer.this.setLoading(false);
        }
    }
}

