/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import ilog.views.sdm.IlvSDMException;
import ilog.views.sdm.IlvSDMModel;
import java.net.URL;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractDiagramModelNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.DecisionTree;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;

public class DTModelNode
extends AbstractDiagramModelNode {
    private static final Logger theLogger = Logger.getLogger(DTModelNode.class.getName());
    private boolean modelPartitioned = false;
    private boolean reloading = false;
    private PartitionVO partitionVO;

    public void setReloading(boolean bl) {
        this.reloading = bl;
    }

    public void setPartitionVO(PartitionVO partitionVO) {
        this.partitionVO = partitionVO;
    }

    public boolean isModelPartitioned() {
        return this.modelPartitioned;
    }

    public DecisionTree getModelLoader() {
        return (DecisionTree)this._odmModel;
    }

    @Override
    protected void loadEngine() {
        try {
            String[] stringArray = new String[1];
            URL uRL = this.getClass().getResource("/oracle/dmt/dataminer/navigator/css/dt.css");
            stringArray[0] = uRL.toString();
            this.getEngine().setStyleSheets(stringArray);
        }
        catch (IlvSDMException ilvSDMException) {
            theLogger.log(Level.SEVERE, ilvSDMException.getMessage(), ilvSDMException);
        }
    }

    @Override
    protected IlvSDMModel createModel() {
        if (this._model == null) {
            this._model = new DecisionTreeSDMModel();
        }
        return this._model;
    }

    @Override
    protected void loadImpl() {
        try {
            ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class, true);
            Object object = this.getRepositoryData();
            String string = null;
            if (object instanceof DecisionTreeModelType) {
                string = ((DecisionTreeModelType)object).getName();
            } else if (object instanceof TestModelType.Model) {
                string = ((TestModelType.Model)object).getName();
            } else if (object instanceof ModelNodeType.Models.Model) {
                string = ((ModelNodeType.Models.Model)object).getName();
            }
            this._odmModel = new DecisionTree(connectionFolder, this.getSchema(), string);
            if (!this.reloading) {
                String string2 = this._odmModel.getUserName();
                String string3 = this._odmModel.getModelName();
                PartitionVO partitionVO = new PartitionVO("", "");
                this.modelPartitioned = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string2, string3, partitionVO);
                if (this.modelPartitioned) {
                    this.setPartitionId(partitionVO.getPartitionID());
                    this.setPartitionName(partitionVO.getPartitionName());
                    this._odmModel.setPartitionId(partitionVO.getPartitionID());
                }
            } else {
                this.setPartitionId(this.partitionVO.getPartitionID());
                this.setPartitionName(this.partitionVO.getPartitionName());
                this._odmModel.setPartitionId(this.partitionVO.getPartitionID());
            }
            this._odmModel.load();
            this._exists = false == this._odmModel.getModelGeneralDescription().equals(ModelGeneralDescription._NONE);
        }
        catch (ODMrDAOException oDMrDAOException) {
            if (oDMrDAOException.getCause() instanceof SQLException) {
                SQLException sQLException = (SQLException)oDMrDAOException.getCause();
                if (sQLException.getErrorCode() == 1403) {
                    this._exists = false;
                }
            }
            theLogger.log(Level.SEVERE, oDMrDAOException.getMessage(), oDMrDAOException);
        }
    }
}

