/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ClusteringFilterSetting {
    public static final double MAX_CONFIDENCE = 100.0;
    public static final double MIN_CONFIDENCE = 0.0;
    public static final double CONFIDENCE_STEP = 1.0;
    private Double _minConfidence;
    private Double _maxConfidence;
    private int _fetchSize;
    private List<SortSpec> _sortSpecs;
    private Integer _clusterId;
    private boolean bUseFilterSpec = false;
    private List<AttributeBiCoefficient> _itemFilters;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    public ClusteringFilterSetting() {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeClusteringModel();
        this._minConfidence = 0.0;
        this._maxConfidence = 100.0;
        this._sortSpecs = new Vector<SortSpec>();
        this._sortSpecs.add(new SortSpec("attribute_confidence", SortDirection.DESCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_support", SortDirection.DESCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
    }

    public ClusteringFilterSetting(int n, Double d, Double d2, Vector<SortSpec> vector) throws Exception {
        this._fetchSize = n;
        this._minConfidence = d;
        this._maxConfidence = d2;
        this._sortSpecs = vector;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public List<SortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(List<SortSpec> list) {
        this._sortSpecs = list;
    }

    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }

    public void setItemFilters(Vector<AttributeBiCoefficient> vector) {
        this._itemFilters = vector;
    }

    public List<AttributeBiCoefficient> getItemFilters() {
        return this._itemFilters;
    }

    public void setMinConfidence(Double d) {
        this._minConfidence = d;
    }

    public Double getMinConfidence() {
        return this._minConfidence;
    }

    public void setMaxConfidence(Double d) {
        this._maxConfidence = d;
    }

    public Double getMaxConfidence() {
        return this._maxConfidence;
    }

    public void setClusterId(Integer n) {
        this._clusterId = n;
    }

    public Integer getClusterId() {
        return this._clusterId;
    }
}

