/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.applyText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.models.AttributeItem;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextTokenPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.applyText.ApplyTextNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextPIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.ApplyTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class ApplyTextPanel
extends DialogDisplayer<ApplyTextNode>
implements SearchListener {
    private WorkflowApplyTextNodePropertyProxyModel _propertyModel;
    private TextNodeType _textNodeType;
    private AttributeType _caseAttribute;
    private TextTransformationOutputAttributeType _selectedTextTransformationOutputAttribute = null;
    private TransformedAttributesType _transformedAttributes;
    private List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private AttrsTableModel _models;
    private GenericTable _attributeTable = new DataMinerTable();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private transient RowFilter<AttrsTableModel, Integer> _nodeFilter;
    private boolean _bShowAllRows;
    private boolean _isAdjusting;
    private boolean _dirty;
    private JButton _editBtn;
    private JButton _outputTrueBtn;
    private JButton _outputFalseBtn;
    private AttributeItem SELECT_CASEID_NONE;
    private BuildTextTokenPanel _tokensPanel = null;
    private BuildTextOutputPanel _outputPanel = null;
    private static final String THEMES_TAB = DialogsLrb.get("BUILDTEXT_THEMES_TAB");
    private static final String TOKENS_TAB = DialogsLrb.get("BUILDTEXT_TOKENS_TAB");
    private static final String OUTPUT_TAB = DialogsLrb.get("BUILDTEXT_OUTPUT_TAB");
    private static final String[] _columnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"), DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"), DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"), DialogsLrb.get("BUILDTEXT_COLUMN_OUTPUT")};
    private static final int[] _columnWidths = new int[]{220, 140, 220, 83, 60};
    private static final int[] _columnWidthsForPI = new int[]{170, 140, 160, 65, 50};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int SOURCE = 2;
    private static final int TRANSFORM = 3;
    private static final int OUTPUT = 4;
    private static final int ATTR_STATUS = 99;
    private ComponentWithTitlebar<JScrollPane> columnComponentWithTitlebar;
    private JPanel jBottomPanel;
    private DataMinerCombBox<AttributeItem> jCaseIdComboBox;
    private JLabel jCaseIdLabel;
    private JButton jEditStoplistsButton;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPane;
    private JPanel jTopPanel;
    private JComboBox<String> jColumnTypeComboBox;

    public ApplyTextPanel(Context context, ApplyTextNode applyTextNode) {
        super(context, applyTextNode);
        this.init((ApplyTextNode)this._data, null);
    }

    public ApplyTextPanel(PropertyModel propertyModel) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for BuildText node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((ApplyTextNode)this._data, propertyModel);
    }

    private void init(ApplyTextNode applyTextNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this.initSettings(applyTextNode);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jCaseIdLabel, this.jCaseIdComboBox, (String)DialogsLrb.get("BUILDTEXT_CASEID"));
        ResourceUtils.resButton((AbstractButton)this.jEditStoplistsButton, (String)DialogsLrb.get("BUILDTEXT_VIEW_STOPLIST"));
    }

    @Override
    public void initUI() {
        this._isAdjusting = true;
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.initCaseAttribute();
        this.buildAttrList();
        Collections.sort(this._combinedAttrList, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel();
        JScrollPane jScrollPane = new JScrollPane((Component)this._attributeTable);
        this.columnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.columnComponentWithTitlebar.setControlBar(controlBar);
        this.installItemFilterActions(controlBar);
        this._attributeTable.setModel((TableModel)((Object)this._models));
        this._attributeTable.setResizeColumnOnDoubleClick(true);
        this._attributeTable.getSelectionModel().setSelectionMode(1);
        this._attributeTable.setAutoResizeMode(0);
        this._attributeTable.setSelectionMode(1);
        this._attributeTable.setColumnSelectorAvailable(true);
        this._attributeTable.setShowToolTips(true);
        this._attributeTable.setUpdateSelectionOnSort(true);
        this._attributeTable.setRowSelectionAllowed(true);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2;
                int n3 = ApplyTextPanel.this._attributeTable.convertRowIndexToModel(n);
                GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)ApplyTextPanel.this._attributeTable.getModel();
                AttributeStatus attributeStatus = AttributeStatus.VALID;
                if (genericBaseTableModel instanceof AttrsTableModel && (object2 = genericBaseTableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                    attributeStatus = (AttributeStatus)object2;
                }
                if (attributeStatus.equals((Object)AttributeStatus.VALID)) {
                    return OracleIcons.getIcon((String)"attribute.png");
                }
                return OracleIcons.getIcon((String)"warning.png");
            }
        });
        TableColumn tableColumn = this._attributeTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this._attributeTable.getColumnModel().getColumn(4);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        this._nodeFilter = new RowFilter<AttrsTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends AttrsTableModel, ? extends Integer> entry) {
                String string;
                String string2;
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = ApplyTextPanel.this._searchText != null && ApplyTextPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                AttrsTableModel attrsTableModel = entry.getModel();
                if (!ApplyTextPanel.this._bShowAllRows) {
                    bl2 = false;
                    string2 = (String)attrsTableModel.getValueAt(n, 1);
                    if (DatabaseMetadataUtils.isTypeSupportedAsText(string2)) {
                        bl2 = true;
                    }
                    if (!bl2 && (string = (String)attrsTableModel.getValueAt(n, 2)) != null) {
                        bl2 = true;
                    }
                }
                String string3 = string2 = ApplyTextPanel.this._searchText != null ? ApplyTextPanel.this._searchText.toLowerCase() : null;
                if (bl2 && bl3 && ApplyTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 0);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && ApplyTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 1);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && ApplyTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"))) {
                    String string4 = string = (String)attrsTableModel.getValueAt(n, 2) != null ? ((String)attrsTableModel.getValueAt(n, 2)).toLowerCase() : "";
                    if (string.startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && ApplyTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))) {
                    string = (String)attrsTableModel.getValueAt(n, 3);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2) {
                    bl = true;
                }
                return bl;
            }
        };
        this.configureSorting();
        int n = 0;
        int[] nArray = this.isPIMode() ? _columnWidthsForPI : _columnWidths;
        for (int n2 : nArray) {
            this._attributeTable.getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._attributeTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(this));
        if (this.isPIMode()) {
            this.jSplitPane.setRightComponent(null);
            this.jSplitPane.setDividerSize(0);
        } else {
            ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)((ApplyTextNode)this.getData()).getData();
            this._outputPanel = new BuildTextOutputPanel(this._context, (AbstractTextNode)this._data, this._textNodeType);
            int n3 = 0;
            if (!applyTextNodeType.getTransformedAttributes().getMapTextTransformedSource().isEmpty()) {
                n3 = ((MapTextTransformedSourceType)applyTextNodeType.getTransformedAttributes().getMapTextTransformedSource().get(0)).getKey().getTransformationElement().getTheme() != null ? 1 : 0;
            }
            this.jTabbedPane.add(n3 != 0 ? THEMES_TAB : TOKENS_TAB, this._outputPanel);
            if (applyTextNodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || applyTextNodeType.getStatus().equals((Object)NodeStatusType.WARNING)) {
                this._tokensPanel = new BuildTextTokenPanel(this._context, (AbstractTextNode)this._data);
                this.jTabbedPane.add(OUTPUT_TAB, this._tokensPanel);
            }
        }
        this._isAdjusting = false;
        this.enableControls();
    }

    private void installItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        this.jColumnTypeComboBox = new JComboBox();
        this.jColumnTypeComboBox.removeAllItems();
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_TEXT_AND_TRANSFORMED"));
        this.jColumnTypeComboBox.setSelectedItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this._bShowAllRows = true;
        this.jColumnTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ApplyTextPanel.this.jColumnTypeComboBox.getSelectedItem();
                ApplyTextPanel.this._bShowAllRows = string.equals(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
                ApplyTextPanel.this.configureSorting();
            }
        });
        controlBar.add(this.jColumnTypeComboBox);
        this._editBtn = new JButton(OracleIcons.getIcon((String)"viewObject.png"));
        this._editBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_TEXT_XFORM_TOOLTIP"));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTextPanel.this.processAddOrEdit();
            }
        });
        controlBar.add((Component)this._editBtn);
        this._outputTrueBtn = new JButton(OracleIcons.getIcon((String)"messageAsync.png"));
        this._outputTrueBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_INCLUDE_COLUMN_TOOLTIP"));
        this._outputTrueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTextPanel.this.setOutputState(true);
            }
        });
        controlBar.add((Component)this._outputTrueBtn);
        this._outputFalseBtn = new JButton(DataMinerIcons.get(Icons.ATTR_IGNORE));
        this._outputFalseBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_EXCLUDE_COLUMN_TOOLTIP"));
        this._outputFalseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTextPanel.this.setOutputState(false);
            }
        });
        controlBar.add((Component)this._outputFalseBtn);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))}) {
            this._searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    public void configureSorting() {
        TableRowSorter<AttrsTableModel> tableRowSorter = (TableRowSorter<AttrsTableModel>)this._attributeTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<AttrsTableModel>(this._models);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(1);
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._nodeFilter);
        this._attributeTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void initSettings(ApplyTextNode applyTextNode) {
        ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)applyTextNode.getData();
        this._textNodeType = (TextNodeType)MetaDataHelper.copyMetadataObject(applyTextNodeType);
        this._caseAttribute = applyTextNodeType.getCaseAttributes().getAttribute().size() > 0 ? (AttributeType)applyTextNodeType.getCaseAttributes().getAttribute().get(0) : null;
    }

    private void buildAttrList() {
        List list;
        this._combinedAttrList.clear();
        List list2 = this._textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        if (list2 != null && !list2.isEmpty()) {
            this._combinedAttrList.addAll(list2);
        }
        if (this._textNodeType.getTransformedAttributes() != null && (list = this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTextTransformedSourceType.getKey());
            }
        }
    }

    private void processAddOrEdit() {
        ApplyTextNode applyTextNode = (ApplyTextNode)this.getData();
        if (this.isPIMode()) {
            TextTransColumnSettingPanel textTransColumnSettingPanel = new TextTransColumnSettingPanel((PropertyModel)this._propertyModel, this._textNodeType.getTransformationSourceAttributes(), this._textNodeType.getTransformedAttributes(), this.getSelectedAttributes());
            textTransColumnSettingPanel.showAsDialog(this);
        } else {
            TextTransColumnSettingPanel textTransColumnSettingPanel = new TextTransColumnSettingPanel(this.getContext(), applyTextNode, this._textNodeType.getTransformationSourceAttributes(), this._textNodeType.getTransformedAttributes(), this.getSelectedAttributes());
            if (textTransColumnSettingPanel.showAsDialog(this)) {
                this._transformedAttributes = textTransColumnSettingPanel.getTransformedAttributes();
                this.refreshUI();
            }
        }
    }

    private void enableControls() {
        this.jCaseIdComboBox.setEnabled(false);
        boolean bl = false;
        int n = this._attributeTable.getSelectedRowCount();
        AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getSelectedItem();
        if (!attributeItem.equals(this.SELECT_CASEID_NONE) && !attributeItem.getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
            this.jCaseIdLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this.jCaseIdLabel.setIcon(null);
        }
        if (n == 0) {
            bl = false;
        } else {
            int[] nArray;
            bl = true;
            for (int n2 : nArray = this._attributeTable.getSelectedRowsInModel()) {
                TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(n2);
                if (transformationSourceAttribute.getStatus() == AttributeStatus.VALID && transformationSourceAttribute instanceof TextTransformationOutputAttributeType) continue;
                bl = false;
            }
        }
        this._outputTrueBtn.setEnabled(this.isWritable());
        this._outputFalseBtn.setEnabled(this.isWritable());
        this.jEditStoplistsButton.setEnabled(this.isWritable());
        this.jColumnTypeComboBox.setEnabled(this.isWritable());
        this._editBtn.setEnabled(this.isWritable() && bl);
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ApplyTextNode applyTextNode = (ApplyTextNode)workflowNodeInspectorElement.getNode();
        if (applyTextNode == null) {
            return;
        }
        this._propertyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = applyTextNode;
        this._dirty = false;
        this.initSettings(applyTextNode);
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyTextNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ApplyTextNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ApplyTextNodeType) {
            return (ApplyTextNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initCaseAttribute() {
        Object object;
        if (this.SELECT_CASEID_NONE == null) {
            object = new AttributeType();
            object.setName(DialogsLrb.get("BUILDTEXT_SELECT_CASEID_NONE"));
            object.setDataType("String");
            this.SELECT_CASEID_NONE = new AttributeItem((AttributeType)object);
        }
        object = (ApplyTextNode)this.getData();
        List<AttributeType> list = ((ApplyTextNode)object).getCaseAttributes();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.jCaseIdComboBox.removeAllItems();
        this.jCaseIdComboBox.addItem(this.SELECT_CASEID_NONE);
        for (AttributeType attributeType : list) {
            this.jCaseIdComboBox.addItem(new AttributeItem(attributeType));
        }
        this.jCaseIdComboBox.setSelectedItem(this.SELECT_CASEID_NONE);
        if (this._caseAttribute != null) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseIdComboBox.getItemCount(); ++i) {
                AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getItemAt(i);
                if (!this._caseAttribute.getName().equals(attributeItem.getAttribute().getName())) continue;
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
                bl = true;
                break;
            }
            if (!bl) {
                AttributeItem attributeItem = new AttributeItem(this._caseAttribute);
                this.jCaseIdComboBox.addItem(attributeItem);
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
            }
        }
        this.jCaseIdComboBox.setRenderer(new ToolTipComboBoxRenderer());
    }

    public void refreshUI() {
        this._isAdjusting = true;
        this.initCaseAttribute();
        this.buildAttrList();
        Collections.sort(this._combinedAttrList, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel();
        this._attributeTable.clearSelection();
        this.configureSorting();
        this._isAdjusting = false;
        this.enableControls();
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (this._dirty && !this.isPIMode()) {
            this.updateNode();
        }
        return bl;
    }

    private void setOutputState(boolean bl) {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        if (nArray != null && nArray.length > 0) {
            Object object;
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(nArray.length);
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>(nArray.length);
            boolean bl2 = true;
            for (int i = 0; i < nArray.length; ++i) {
                object = this._models.getAttribute(nArray[i]);
                if (bl2 && object.isIsOutput() != bl) {
                    bl2 = false;
                }
                if (bl2) continue;
                if (this.isPIMode()) {
                    hashMap.put(object.getName(), object.isIsOutput());
                    hashMap2.put(object.getName(), bl);
                    continue;
                }
                object.setIsOutput(bl);
                this._dirty = true;
            }
            if (bl2) {
                return;
            }
            if (this.isPIMode()) {
                ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
                complexProperty.setOldData(hashMap);
                object = new ArrayList(1);
                object.add(new Property(String.valueOf(ApplyTextNodePropertyModel.OUTPUT_STATE.index), null, complexProperty, null, null));
                this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), (AbstractNode)this.getData(), (List<Property>)object);
            } else {
                this._models.fireTableDataChanged();
            }
            this._attributeTable.setSelectedRowsInModel(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        ApplyTextNode applyTextNode = (ApplyTextNode)this.getData();
        CommandProcessor.getInstance().beginTrans(DialogsLrb.get("BUILDTEXT_NODE_EDIT_TRANSACTION_NAME"));
        try {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(this._textNodeType.getTransformedAttributes(), this._textNodeType.getTransformationSourceAttributes()), null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)applyTextNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(applyTextNode, this._context, arrayList);
            applyTextNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new DataMinerCombBox();
        this.jEditStoplistsButton = new JButton();
        this.columnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.setOpaque(false);
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerLocation(240);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setOpaque(false);
        this.jTopPanel.setOpaque(false);
        this.jCaseIdLabel.setText("CaseId:");
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTextPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistsButton.setText("Edit Stoplist...");
        this.jEditStoplistsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyTextPanel.this.jEditStoplistsButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.columnComponentWithTitlebar, GroupLayout.Alignment.LEADING, -1, 622, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseIdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCaseIdComboBox, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 257, Short.MAX_VALUE).addComponent(this.jEditStoplistsButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2).addComponent(this.jEditStoplistsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.columnComponentWithTitlebar, -1, 189, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jTopPanel);
        this.jBottomPanel.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 622, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 242, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jEditStoplistsButtonActionPerformed(ActionEvent actionEvent) {
        AbstractTextNode abstractTextNode = (AbstractTextNode)this.getData();
        StoplistPanel stoplistPanel = null;
        if (this.isPIMode()) {
            stoplistPanel = new StoplistPanel((PropertyModel)this._propertyModel, this);
            stoplistPanel.showAsDialog(this);
        } else {
            stoplistPanel = new StoplistPanel(this.getContext(), abstractTextNode, this._textNodeType, this);
            if (stoplistPanel.showAsDialog(this)) {
                this.refreshUI();
            }
        }
    }

    private List<TransformationSourceAttribute> getSelectedAttributes() {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        for (int i = 0; i < nArray.length; ++i) {
            TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(nArray[i]);
            arrayList.add(transformationSourceAttribute);
        }
        return arrayList;
    }

    public TextTransformationOutputAttributeType getSelectedTextTransformationOutputAttribute() {
        return this._selectedTextTransformationOutputAttribute;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("APPLY_TEXT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "applytext";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMaximumInitialSize(new Dimension(800, 700));
        jEWTDialog.setMinimumSize(new Dimension(800, 700));
    }

    private class AttrsTableModel
    extends SimpleBaseTableModel {
        AttrsTableModel() {
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            return ApplyTextPanel.this._combinedAttrList.size();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                if (n == 4) {
                    return ImageIcon.class;
                }
                return object.getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                return ApplyTextPanel.this.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (ApplyTextPanel.this._combinedAttrList.isEmpty()) {
                return "Loading...";
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)ApplyTextPanel.this._combinedAttrList.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = transformationSourceAttribute.getName();
                    break;
                }
                case 1: {
                    object = DatabaseMetadataUtils.getJSONDataType(transformationSourceAttribute.getDataType(), transformationSourceAttribute.getDataTypeQualifier());
                    break;
                }
                case 2: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getSource();
                    }
                    object = string;
                    break;
                }
                case 3: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getTransformationElement().getToken() != null ? DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN") : DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
                    }
                    object = string;
                    break;
                }
                case 4: {
                    object = transformationSourceAttribute.isIsOutput();
                    break;
                }
                case 99: {
                    object = transformationSourceAttribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)ApplyTextPanel.this._combinedAttrList.get(n);
            switch (n2) {
                case 4: {
                    ApplyTextPanel.this._dirty = true;
                    if (ApplyTextPanel.this.isPIMode()) {
                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
                        hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute.isIsOutput());
                        ArrayList<Property> arrayList = new ArrayList<Property>(1);
                        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>(1);
                        hashMap2.put(transformationSourceAttribute.getName(), (Boolean)object);
                        ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
                        complexProperty.setOldData(hashMap);
                        arrayList.add(new Property(String.valueOf(ApplyTextNodePropertyModel.OUTPUT_STATE.index), null, complexProperty, null, null));
                        ApplyTextPanel.this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), (AbstractNode)ApplyTextPanel.this.getData(), (List<Property>)arrayList);
                        break;
                    }
                    transformationSourceAttribute.setIsOutput(((Boolean)object).booleanValue());
                    break;
                }
                default: {
                    assert (false) : "Invalid option";
                    break;
                }
            }
        }

        public TransformationSourceAttribute getAttribute(int n) {
            return (TransformationSourceAttribute)ApplyTextPanel.this._combinedAttrList.get(n);
        }
    }

    private class SelectedItemSelectionHandler
    implements ListSelectionListener {
        ApplyTextPanel _parent;

        SelectedItemSelectionHandler(ApplyTextPanel applyTextPanel2) {
            this._parent = applyTextPanel2;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TransformationSourceAttribute transformationSourceAttribute;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                return;
            }
            ApplyTextPanel.this.enableControls();
            int[] nArray = ApplyTextPanel.this._attributeTable.getSelectedRowsInModel();
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = null;
            if (nArray.length == 1 && (transformationSourceAttribute = ApplyTextPanel.this._models.getAttribute(nArray[0])) instanceof TextTransformationOutputAttributeType) {
                textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
            }
            if (ApplyTextPanel.this._selectedTextTransformationOutputAttribute != null && textTransformationOutputAttributeType != null && textTransformationOutputAttributeType.getName().compareTo(ApplyTextPanel.this._selectedTextTransformationOutputAttribute.getName()) == 0) {
                return;
            }
            ApplyTextPanel.this._selectedTextTransformationOutputAttribute = textTransformationOutputAttributeType;
            if (ApplyTextPanel.this._outputPanel != null) {
                boolean bl = false;
                if (textTransformationOutputAttributeType != null) {
                    bl = textTransformationOutputAttributeType.getTransformationElement().getTheme() != null;
                }
                ApplyTextPanel.this.jTabbedPane.setTitleAt(0, bl ? THEMES_TAB : TOKENS_TAB);
                ApplyTextPanel.this._outputPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
            if (ApplyTextPanel.this._tokensPanel != null) {
                ApplyTextPanel.this._tokensPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
        }
    }
}

