/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.NumberCellEditor;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.clas.common.PerformanceInfo;
import oracle.dmt.dataminer.core.model.clas.common.PriorsInfo;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;

public class PerformancePriorsPanel
extends AbstractPropertiesPanel
implements ActionListener {
    private static final Logger theLogger = Logger.getLogger(PerformancePriorsPanel.class.getName());
    private DataMinerTable coefficienstTable;
    private JButton jBtnBalanced;
    private JButton jBtnNatural;
    private JCheckBox jChkBoxUsePriors;
    private JPanel jContent;
    private JLabel jLblGenerate;
    private JRadioButton jRadioBtnBalanced;
    private JRadioButton jRadioBtnCustom;
    private JRadioButton jRadioBtnMaxOverall;
    private JScrollPane jScrollPaneCoeffis;
    private String _displayAlgorithm;
    private static final int PERFORMANCE_COLUMN_COUNT = 2;
    private static final int PERFORMANCE_TARGET_VALUE = 0;
    private static final int PERFORMANCE_DISTRIBUTION = 1;
    private static String[] _performance_columnNames = new String[]{AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE"), AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_WEIGHT_VALUE")};
    private static final int WEIGHT_COLUMN_COUNT = 2;
    private static final int WEIGHT_TARGET_VALUE = 0;
    private static final int WEIGHT_VALUE = 1;
    private static String[] _weight_columnNames = new String[]{AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE"), AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_WEIGHT_VALUE")};

    public PerformancePriorsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioBtnBalanced = new JRadioButton();
        this.jRadioBtnMaxOverall = new JRadioButton();
        this.jRadioBtnCustom = new JRadioButton();
        this.jContent = new JPanel();
        this.jChkBoxUsePriors = new JCheckBox();
        this.jScrollPaneCoeffis = new JScrollPane();
        this.coefficienstTable = new DataMinerTable();
        this.jLblGenerate = new JLabel();
        this.jBtnBalanced = new JButton();
        this.jBtnNatural = new JButton();
        buttonGroup.add(this.jRadioBtnBalanced);
        buttonGroup.add(this.jRadioBtnMaxOverall);
        buttonGroup.add(this.jRadioBtnCustom);
        this.jRadioBtnBalanced.setText("Balanced");
        this.jRadioBtnBalanced.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioBtnBalanced.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioBtnMaxOverall.setText("Natural");
        this.jRadioBtnMaxOverall.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioBtnMaxOverall.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioBtnCustom.setText("Custom");
        this.jRadioBtnCustom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioBtnCustom.setMargin(new Insets(0, 0, 0, 0));
        this.jContent.setBorder(BorderFactory.createTitledBorder("Weights"));
        this.jChkBoxUsePriors.setText("Use Priors");
        this.jChkBoxUsePriors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkBoxUsePriors.setMargin(new Insets(0, 0, 0, 0));
        this.coefficienstTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneCoeffis.setViewportView((Component)((Object)this.coefficienstTable));
        this.jLblGenerate.setText("Generate");
        this.jBtnBalanced.setText("jButton1");
        this.jBtnBalanced.setActionCommand("Balanced");
        this.jBtnNatural.setText("Natural");
        GroupLayout groupLayout = new GroupLayout(this.jContent);
        this.jContent.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jScrollPaneCoeffis, -1, 399, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChkBoxUsePriors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 57, Short.MAX_VALUE).addComponent(this.jLblGenerate, -2, 92, -2).addGap(19, 19, 19).addComponent(this.jBtnBalanced).addGap(17, 17, 17).addComponent(this.jBtnNatural))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jChkBoxUsePriors)).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnNatural).addComponent(this.jBtnBalanced).addComponent(this.jLblGenerate)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneCoeffis, -1, 216, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioBtnBalanced, -2, 171, -2).addComponent(this.jRadioBtnMaxOverall, -2, 171, -2).addComponent(this.jRadioBtnCustom, -2, 171, -2).addComponent(this.jContent, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.linkSize(0, this.jRadioBtnBalanced, this.jRadioBtnCustom, this.jRadioBtnMaxOverall);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jRadioBtnBalanced).addGap(16, 16, 16).addComponent(this.jRadioBtnMaxOverall).addGap(14, 14, 14).addComponent(this.jRadioBtnCustom).addGap(14, 14, 14).addComponent(this.jContent, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.linkSize(1, this.jRadioBtnBalanced, this.jRadioBtnCustom, this.jRadioBtnMaxOverall);
    }

    private void initUI() {
        this._displayAlgorithm = this.getPanelState().getAlgorithm();
        String string = this.getPanelState().getOriginalPerformanceOption();
        this.jRadioBtnBalanced.setText(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_BALANCED"));
        this.jRadioBtnMaxOverall.setText(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_NATURAL"));
        this.jRadioBtnCustom.setText(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_CUSTOM"));
        this.jRadioBtnBalanced.addActionListener(this);
        if (this.getPanelState().isDataSourcePresent() && this.getPanelState().isTargetSelected()) {
            this.jRadioBtnCustom.addActionListener(this);
        } else {
            this.jRadioBtnCustom.setEnabled(false);
        }
        this.jRadioBtnMaxOverall.addActionListener(this);
        this.jLblGenerate.setText(AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_GENERATE_BUTTON"));
        this.jBtnBalanced.setText(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_BALANCED"));
        this.jBtnBalanced.addActionListener(this);
        this.jBtnNatural.setText(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_NATURAL"));
        this.jBtnNatural.addActionListener(this);
        this.jChkBoxUsePriors.setText(AlgSettingsLrb.get("PRIORS_PANEL_USE_PRIORS_FOR_MODEL_BUILD"));
        this.jChkBoxUsePriors.addActionListener(this);
        if (ServerConstants.BuildSettingPerformanceOption.isBalanced((String)string)) {
            this.jRadioBtnBalanced.setSelected(true);
            this.balancedOptionSelected();
        } else if (ServerConstants.BuildSettingPerformanceOption.isNatural((String)string)) {
            this.jRadioBtnMaxOverall.setSelected(true);
            if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm)) {
                this.jLblGenerate.setVisible(false);
                this.jBtnBalanced.setVisible(false);
                this.jBtnNatural.setVisible(false);
                this.jContent.setBorder(BorderFactory.createTitledBorder(AlgSettingsLrb.get("PERFORMANCE_PRIORS_BORDER_TITLE")));
                if (this.getPanelState().hasPriors()) {
                    this.jChkBoxUsePriors.setSelected(true);
                    this.loadPriorsTable();
                    this.coefficienstTable.setEnabled(true);
                } else {
                    this.jChkBoxUsePriors.setSelected(false);
                    this.loadPriorsTable();
                    this.coefficienstTable.setEnabled(false);
                }
            } else {
                this.balancedOptionSelected();
            }
        } else if (ServerConstants.BuildSettingPerformanceOption.isCustom((String)string)) {
            this.jRadioBtnCustom.setSelected(true);
            this.jLblGenerate.setVisible(true);
            this.jBtnBalanced.setVisible(true);
            this.jBtnNatural.setVisible(true);
            this.jBtnBalanced.setEnabled(this.getPanelState().isDataSourcePresent());
            this.jBtnNatural.setEnabled(this.getPanelState().isDataSourcePresent());
            this.loadWeightTable();
            this.jChkBoxUsePriors.setVisible(false);
            this.jContent.setBorder(BorderFactory.createTitledBorder(AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_BORDER_TITLE")));
        }
        this.getPanelState().setBackupValue("BUILD_SETTING_PERFORM_OPTION", string);
    }

    private void loadPriorsTable() {
        this.coefficienstTable.setModel((TableModel)((Object)new PriorsStatisticsModel(this.getPanelState().getResultPriorsInfo())));
        this.coefficienstTable.setSorted(false);
        this.coefficienstTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.coefficienstTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NumberCellEditor());
    }

    private void loadWeightTable() {
        this.coefficienstTable.setModel((TableModel)((Object)new WeightSettingsModel(this.getPanelState().getResultPerformanceInfo())));
        this.coefficienstTable.setSorted(false);
        this.coefficienstTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.coefficienstTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NumberCellEditor());
    }

    private void loadEmptyWeightTable() {
        this.coefficienstTable.setModel((TableModel)((Object)new WeightSettingsModel(null)));
        this.coefficienstTable.setSorted(false);
        this.coefficienstTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.coefficienstTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NumberCellEditor());
    }

    @Override
    public void processInput() {
        PerformanceInfo performanceInfo;
        if (this.jRadioBtnBalanced.isSelected()) {
            this.getPanelState().setBalancedPerformanceInfo();
        } else if (this.jRadioBtnMaxOverall.isSelected()) {
            this.getPanelState().setNaturalPerformanceInfo();
        } else {
            performanceInfo = this.getPanelState().getResultPerformanceInfo();
            if (null == performanceInfo.getValues() || performanceInfo.getValues().isEmpty()) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_EMPTY"));
                return;
            }
            this.getPanelState().setCustomPerformanceInfo();
        }
        performanceInfo = this.getPanelState().getResultPerformanceInfo();
        this.setObjectValue("BUILD_SETTING_PERFORM_OPTION", performanceInfo.getPerformanceOption());
    }

    public boolean isNewDataInput(boolean bl) throws ValidationException {
        String string = this.getPanelState().getOriginalPerformanceOption();
        String string2 = null;
        AbstractTableModel abstractTableModel = null;
        if (this.jRadioBtnBalanced.isSelected()) {
            string2 = "BUILD_SETTING_PERFORM_OP_AVG";
        } else if (this.jRadioBtnMaxOverall.isSelected()) {
            string2 = "BUILD_SETTING_PERFORM_OP_OVRL";
            if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm) && (abstractTableModel = (AbstractTableModel)this.coefficienstTable.getModel()).getRowCount() < 1) {
                throw new ValidationException(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_EMPTY"));
            }
        } else {
            string2 = "BUILD_SETTING_PERFORM_OP_CUST";
            abstractTableModel = (AbstractTableModel)this.coefficienstTable.getModel();
            if (abstractTableModel.getRowCount() < 1) {
                throw new ValidationException(AlgSettingsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_EMPTY"));
            }
        }
        if (!bl) {
            return bl;
        }
        if (0 != string.compareTo(string2)) {
            return true;
        }
        PerformanceInfo performanceInfo = null;
        if (ServerConstants.BuildSettingPerformanceOption.isNatural((String)string)) {
            if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm)) {
                performanceInfo = this.getPanelState().getOriginalPriorsInfo();
            }
        } else if (ServerConstants.BuildSettingPerformanceOption.isCustom((String)string)) {
            performanceInfo = this.getPanelState().getOriginalPerformanceInfo();
        }
        if (performanceInfo == null) {
            return false;
        }
        List list = null;
        list = performanceInfo.getValues();
        if (list == null) {
            return false;
        }
        for (int i = 0; i < abstractTableModel.getRowCount(); ++i) {
            BigDecimal bigDecimal;
            String string3;
            NameValuePair nameValuePair = (NameValuePair)list.get(i);
            String string4 = (String)abstractTableModel.getValueAt(i, 0);
            if (0 != string4.compareTo(nameValuePair.getName())) {
                return true;
            }
            string4 = (String)abstractTableModel.getValueAt(i, 1);
            if (0 == string4.compareTo(string3 = NumericFormat.format((double)(bigDecimal = (BigDecimal)nameValuePair.getValue()).doubleValue(), (boolean)true, (int)8))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block26: {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                JRadioButton jRadioButton = (JRadioButton)object;
                this.getPanelState().clearValidationError();
                if (jRadioButton.equals(this.jRadioBtnBalanced)) {
                    this.balancedOptionSelected();
                } else if (jRadioButton.equals(this.jRadioBtnMaxOverall)) {
                    this.naturalOptionSelected();
                } else if (jRadioButton.equals(this.jRadioBtnCustom)) {
                    this.customOptionSelected();
                }
            } else if (object instanceof JCheckBox) {
                if (object.equals(this.jChkBoxUsePriors)) {
                    if (this.jChkBoxUsePriors.isSelected()) {
                        this.getPanelState().createCustomPriorsInfo();
                        this.loadPriorsTable();
                        this.coefficienstTable.setEnabled(true);
                    } else if (this.getPanelState().hasPriors()) {
                        if (MessageDialog.confirm((Component)this, (Object)AlgSettingsLrb.get("PRIORS_PANEL_VALUE_REGENERATE"), (String)AlgSettingsLrb.get("PRIORS_PANEL_VALUE_REGENERATE_CONFIRM"), null)) {
                            this.getPanelState().clearPriors();
                            this.loadPriorsTable();
                            this.coefficienstTable.setEnabled(false);
                        } else {
                            this.jChkBoxUsePriors.setSelected(true);
                            this.coefficienstTable.setEnabled(true);
                        }
                    }
                }
            } else if (object instanceof JButton) {
                try {
                    JButton jButton = (JButton)object;
                    Boolean bl = null;
                    if (jButton.equals(this.jBtnBalanced)) {
                        bl = Boolean.TRUE;
                    } else if (jButton.equals(this.jBtnNatural)) {
                        bl = Boolean.FALSE;
                    }
                    if (bl == null) break block26;
                    boolean bl2 = true;
                    if (this.getPanelState().hasWeights()) {
                        bl2 = MessageDialog.confirm((Component)this, (Object)AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE_REGENERATE"), (String)AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE_REGENERATE_CONFIRM"), null);
                    }
                    Object var6_8 = null;
                    if (bl2) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        class Worker
                        extends ProgressRunnable {
                            private boolean balanced;
                            private String error = null;

                            public Worker(boolean bl) {
                                this.balanced = bl;
                            }

                            protected Object doWork() throws Exception {
                                this.error = PerformancePriorsPanel.this.getPanelState().createCustomPerformanceInfo(this.balanced);
                                return this.error;
                            }

                            protected void finish(Object object) {
                                if (this.error == null) {
                                    PerformancePriorsPanel.this.loadWeightTable();
                                    PerformancePriorsPanel.this.coefficienstTable.setEnabled(true);
                                }
                            }
                        }
                        Worker worker = new Worker(bl);
                        worker.setTitle(AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_TITLE"));
                        worker.setMessage(AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_MESSAGE"));
                        worker.setCancelable(true);
                        try {
                            worker.start(true);
                        }
                        catch (ProgressException progressException) {
                            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (var6_8 != null) {
                        MessageDialog.error((Component)this, (Object)AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE_GENERATE_FAILURE"), (String)AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_FAILURE_TITLE"), null);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    private void balancedOptionSelected() {
        this.loadEmptyWeightTable();
        this.coefficienstTable.setEnabled(false);
        this.jLblGenerate.setVisible(true);
        this.jBtnBalanced.setVisible(true);
        this.jBtnNatural.setVisible(true);
        this.jBtnBalanced.setEnabled(false);
        this.jBtnNatural.setEnabled(false);
        this.jChkBoxUsePriors.setVisible(false);
        this.jContent.setBorder(BorderFactory.createTitledBorder(AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_BORDER_TITLE")));
    }

    private void naturalOptionSelected() {
        if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm)) {
            this.jLblGenerate.setVisible(false);
            this.jBtnBalanced.setVisible(false);
            this.jBtnNatural.setVisible(false);
            this.jChkBoxUsePriors.setVisible(true);
            this.jContent.setBorder(BorderFactory.createTitledBorder(AlgSettingsLrb.get("PERFORMANCE_PRIORS_BORDER_TITLE")));
            if (this.getPanelState().hasPriors()) {
                this.jChkBoxUsePriors.setSelected(true);
                this.loadPriorsTable();
                this.coefficienstTable.setEnabled(true);
            } else {
                this.jChkBoxUsePriors.setSelected(false);
                this.loadPriorsTable();
                this.coefficienstTable.setEnabled(false);
            }
        } else {
            this.balancedOptionSelected();
        }
    }

    private void customOptionSelected() {
        this.coefficienstTable.setEnabled(true);
        this.jLblGenerate.setVisible(true);
        this.jBtnBalanced.setVisible(true);
        this.jBtnNatural.setVisible(true);
        this.jBtnBalanced.setEnabled(this.getPanelState().isDataSourcePresent());
        this.jBtnNatural.setEnabled(this.getPanelState().isDataSourcePresent());
        this.loadWeightTable();
        this.jChkBoxUsePriors.setVisible(false);
        this.jContent.setBorder(BorderFactory.createTitledBorder(AlgSettingsLrb.get("PERFORMANCE_WEIGHTS_BORDER_TITLE")));
    }

    class WeightSettingsModel
    extends SimpleBaseTableModel {
        public WeightSettingsModel(PerformanceInfo performanceInfo) {
            this.setColumnIdentifiers(_weight_columnNames);
            this.setRowCount(performanceInfo != null ? performanceInfo.getRowCount() : 0);
            this.setColumnCount(2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            PerformanceInfo performanceInfo = PerformancePriorsPanel.this.getPanelState().getResultPerformanceInfo();
            if (performanceInfo == null) {
                return null;
            }
            String string = null;
            List list = performanceInfo.getValues();
            if (list == null) {
                return string;
            }
            switch (n2) {
                case 0: {
                    NameValuePair nameValuePair = (NameValuePair)list.get(n);
                    if (null != nameValuePair.getKey()) {
                        string = NumericFormat.format((double)nameValuePair.getKey().doubleValue(), (boolean)true, (int)8) + "";
                        break;
                    }
                    string = ((NameValuePair)list.get(n)).getName();
                    break;
                }
                case 1: {
                    string = NumericFormat.format((double)((BigDecimal)((NameValuePair)list.get(n)).getValue()).doubleValue(), (boolean)true, (int)8) + "";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            PerformanceInfo performanceInfo = PerformancePriorsPanel.this.getPanelState().getResultPerformanceInfo();
            List list = performanceInfo.getValues();
            if (list == null) {
                return;
            }
            NameValuePair nameValuePair = (NameValuePair)list.get(n);
            nameValuePair.setValue(object);
        }
    }

    class PriorsStatisticsModel
    extends SimpleBaseTableModel {
        public PriorsStatisticsModel(PriorsInfo priorsInfo) {
            this.setColumnIdentifiers(_performance_columnNames);
            this.setRowCount(priorsInfo != null ? priorsInfo.getRowCount() : 0);
            this.setColumnCount(2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            PriorsInfo priorsInfo = PerformancePriorsPanel.this.getPanelState().getResultPriorsInfo();
            if (priorsInfo == null) {
                return null;
            }
            String string = null;
            List list = priorsInfo.getValues();
            if (list == null) {
                return string;
            }
            switch (n2) {
                case 0: {
                    NameValuePair nameValuePair = (NameValuePair)list.get(n);
                    if (null != nameValuePair.getKey()) {
                        string = NumericFormat.format((double)nameValuePair.getKey().doubleValue(), (boolean)true, (int)8) + "";
                        break;
                    }
                    string = ((NameValuePair)list.get(n)).getName();
                    break;
                }
                case 1: {
                    string = NumericFormat.format((double)((BigDecimal)((NameValuePair)list.get(n)).getValue()).doubleValue(), (boolean)true, (int)8) + "";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            PriorsInfo priorsInfo = PerformancePriorsPanel.this.getPanelState().getResultPriorsInfo();
            List list = priorsInfo.getValues();
            if (list == null) {
                return;
            }
            NameValuePair nameValuePair = (NameValuePair)list.get(n);
            nameValuePair.setValue(object);
        }
    }
}

