/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.IlvGraphic;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvMutableSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.GenerateSQLScript;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.inmemoryparallelquery.InMemoryParallelPreferences;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataMinerNodeGraphic;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.NodeTypeMappingUtils;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.model.WorkflowRunStateAdapter;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.Icon;
import oracle.dmt.dataminer.workflow.xmlschema.InMemoryColumnarType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;
import oracle.dmt.dataminer.workflow.xmlschema.Messages;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ParallelismType;
import oracle.dmt.dataminer.workflow.xmlschema.ParameterDataType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Version;

public abstract class AbstractNode
extends AbstractObject
implements IlvMutableSDMNode,
Node,
PropertyChangeListener,
GenerateSQLScript {
    public static final String DOP = "<DOP>";
    public static final String NOPARALLEL_NOLOGGING = "NOPARALLEL NOLOGGING";
    public static final String NO_PARALLEL = "NO_PARALLEL";
    public static final String PARALLEL_NOLOGGING = "PARALLEL NOLOGGING";
    public static final String PARALLEL_AUTO = "PARALLEL (AUTO)";
    public static final String NOAPPEND_PARALLEL_AUTO = "NOAPPEND PARALLEL (AUTO)";
    public static final String PARALLEL_DOP_NOLOGGING = "PARALLEL <DOP> NOLOGGING";
    public static final String PARALLEL_DOP = "PARALLEL (<DOP>)";
    public static final String NOAPPEND_PARALLEL_DOP = "NOAPPEND PARALLEL (<DOP>)";
    public static final String CODEGEN_INDENTATION = "        ";
    public static final String SQL_PREFIX_FOR_WITH_NAME = "N$";
    public static final String SYSTEM_DETERMINED = "System Determined";
    public static final int MAX_NODE_NAME_LEN = 30;
    private static final Logger theLogger = Logger.getLogger(AbstractNode.class.getName());
    private ParallelQueryPreferences performancePreferences;
    protected NodeType metaData;
    protected String schemaName;
    private transient String oldId;
    protected transient int refactorInvokeCount = 0;
    private boolean navigatorRefreshPending = false;

    public AbstractNode(String string, NodeType nodeType, Context context) {
        super(string, context);
        this.metaData = nodeType;
        this.schemaName = ConnectionFolder.getUserAccountName(this.getContext());
    }

    @Override
    public WorkflowModel getModel() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
        return workflowModel;
    }

    public IlvSDMEngine getEngine() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        IlvSDMEngine ilvSDMEngine = null;
        ilvSDMEngine = workflowNode.getEngine();
        return ilvSDMEngine;
    }

    public SDMUndoFilter getUndoFilter() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        IlvSDMEngine ilvSDMEngine = null;
        ilvSDMEngine = workflowNode.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    @Override
    public boolean validate(boolean bl) {
        this.clearMessages();
        return true;
    }

    @Override
    public void fireNodeNameChanged(String string) {
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            abstractNode.parentNodeNameChanged(this, string);
        }
    }

    public boolean allowMoreThanOneInputNode() {
        return false;
    }

    public void parentNodeNameChanged(Node node, String string) {
    }

    @Override
    public void validateChildren() {
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            abstractNode.validate(true);
        }
    }

    @Override
    public boolean validateChildrenRunChain(boolean bl) {
        boolean bl2 = true;
        WorkflowModel workflowModel = this.getModel();
        if (workflowModel == null) {
            return false;
        }
        bl2 = this.validateChildrenRunChain(workflowModel);
        if (bl2 && bl && !this.setChildrenRunChainReady(workflowModel)) {
            Exception exception = new Exception("Unable to set nodes to ready state after validating that they were valid.");
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
            bl2 = false;
        }
        return bl2;
    }

    private boolean setChildrenRunChainReady(WorkflowModel workflowModel) {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() != NodeStatusType.INVALID;
        if (!bl) {
            return false;
        }
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            boolean bl3 = bl = abstractNode.getData().getStatus() != NodeStatusType.INVALID;
            if (!bl) {
                return false;
            }
            abstractNode.setNodeReady();
            bl = abstractNode.setChildrenRunChainReady(workflowModel);
        }
        return bl;
    }

    private boolean validateChildrenRunChain(WorkflowModel workflowModel) {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() != NodeStatusType.INVALID;
        if (!bl) {
            return false;
        }
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            boolean bl3 = bl = abstractNode.getData().getStatus() != NodeStatusType.INVALID;
            if (!bl) {
                return false;
            }
            bl = abstractNode.validateChildrenRunChain(workflowModel);
        }
        return bl;
    }

    public boolean validateCompleteChain(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            boolean bl3 = bl2 = this.getData().getStatus() == NodeStatusType.COMPLETE;
        }
        if (bl2) {
            bl2 = this.validateCompleteChain();
        }
        return bl2;
    }

    private boolean validateCompleteChain() {
        boolean bl = true;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            boolean bl2 = bl = abstractNode.getData().getStatus() == NodeStatusType.COMPLETE;
            if (!bl) {
                return false;
            }
            bl = abstractNode.validateCompleteChain();
        }
        return bl;
    }

    @Override
    public boolean validateLineageChain() {
        boolean bl = true;
        WorkflowModel workflowModel = this.getModel();
        if (workflowModel == null) {
            return false;
        }
        bl = this.validateLineageChain(workflowModel);
        return bl;
    }

    private boolean validateLineageChain(WorkflowModel workflowModel) {
        boolean bl = this.canGenerateLineageSQL();
        if (!bl) {
            return false;
        }
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            bl = abstractNode.canGenerateLineageSQL();
            if (!bl) {
                return false;
            }
            bl = abstractNode.validateLineageChain(workflowModel);
        }
        return bl;
    }

    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() != NodeStatusType.INVALID;
        return bl;
    }

    @Override
    public boolean validateRunChain(boolean bl) {
        boolean bl2 = true;
        WorkflowModel workflowModel = this.getModel();
        if (workflowModel == null) {
            return false;
        }
        bl2 = this.validateRunChain(workflowModel);
        if (bl2 && bl) {
            this.setNodeReady();
            if (!this.setRunChainReady(workflowModel)) {
                Exception exception = new Exception("Unable to set nodes to ready state after validating that they were valid.");
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean setRunChainReady(WorkflowModel workflowModel) {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() != NodeStatusType.INVALID;
        if (!bl) {
            return false;
        }
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            boolean bl3 = bl = abstractNode.getData().getStatus() != NodeStatusType.INVALID;
            if (!bl) {
                return false;
            }
            abstractNode.setNodeReady();
            bl = abstractNode.setRunChainReady(workflowModel);
        }
        return bl;
    }

    private boolean validateRunChain(WorkflowModel workflowModel) {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() != NodeStatusType.INVALID;
        if (!bl) {
            return false;
        }
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            boolean bl3 = bl = abstractNode.getData().getStatus() != NodeStatusType.INVALID;
            if (!bl) {
                return false;
            }
            bl = abstractNode.validateRunChain(workflowModel);
        }
        return bl;
    }

    protected void clearMessages() {
        Messages messages = this.getData().getMessages();
        if (messages == null) {
            return;
        }
        List list = messages.getMessage();
        if (list == null || list.isEmpty()) {
            return;
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        Messages messages2 = new Messages();
        messages2.getMessage();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "messages", messages2);
    }

    public void addMessage(String string, MessageEnumType messageEnumType, String ... stringArray) {
        this.addMessage(string, messageEnumType, true, stringArray);
    }

    public void addMessage(String string, MessageEnumType messageEnumType, boolean bl, String ... stringArray) {
        Object object;
        Messages messages = this.getData().getMessages();
        List list = messages.getMessage();
        MessageType messageType = new MessageType();
        MessageType.Resource resource = new MessageType.Resource();
        messageType.setResource(resource);
        messageType.setType(messageEnumType);
        resource.setId(string);
        resource.setParameters(new MessageType.Resource.Parameters());
        List list2 = resource.getParameters().getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            object = new MessageType.Resource.Parameters.Value();
            object.setType(ParameterDataType.STRING);
            object.setValue(stringArray[i]);
            list2.add(object);
        }
        Messages messages2 = new Messages();
        object = messages2.getMessage();
        object.add(messageType);
        for (MessageType messageType2 : list) {
            MessageType messageType3 = (MessageType)MetaDataHelper.copyMetadataObject(messageType2);
            object.add(messageType3);
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "messages", messages2);
        } else {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "messages", messages2, 1);
        }
    }

    public String getFormattedMessages() {
        StringBuilder stringBuilder = new StringBuilder();
        Messages messages = this.getData().getMessages();
        List list = messages.getMessage();
        for (MessageType messageType : list) {
            Object object;
            MessageType.Resource resource = messageType.getResource();
            String string = "";
            try {
                string = NodeMessagesLrb.get(resource.getId());
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            if (resource.getParameters() != null && resource.getParameters().getValue().size() > 0) {
                object = resource.getParameters().getValue();
                Object[] objectArray = new String[object.size()];
                for (int i = 0; i < object.size(); ++i) {
                    MessageType.Resource.Parameters.Value value = (MessageType.Resource.Parameters.Value)object.get(i);
                    objectArray[i] = value.getValue();
                }
                string = MessageFormat.format(string, objectArray);
            }
            object = this.getTooltipImageName(messageType.getType());
            stringBuilder.append("<img src=");
            stringBuilder.append((String)object);
            stringBuilder.append("> &#xA0; ");
            stringBuilder.append(string);
            stringBuilder.append("<br>");
        }
        if (list.size() == 0) {
            if (this.getData().getStatus().equals((Object)NodeStatusType.READY)) {
                stringBuilder = new StringBuilder(NodeMessagesLrb.get("NODE_READY"));
            } else if (this.getData().getStatus().equals((Object)NodeStatusType.COMPLETE)) {
                stringBuilder = new StringBuilder(NodeMessagesLrb.get("NODE_COMPLETE"));
            } else if (this.getData().getStatus().equals((Object)NodeStatusType.FAILURE)) {
                stringBuilder = new StringBuilder(NodeMessagesLrb.get("NODE_FAILURE"));
            } else if (this.getData().getStatus().equals((Object)NodeStatusType.WARNING)) {
                stringBuilder = new StringBuilder(NodeMessagesLrb.get("NODE_WARNING"));
            }
        }
        stringBuilder.insert(0, "<html>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private String getTooltipImageName(MessageEnumType messageEnumType) {
        URL uRL = null;
        uRL = messageEnumType.equals((Object)MessageEnumType.ERROR) ? this.getClass().getClassLoader().getResource(Icons.ERROR_STATUS.getFilePath()) : this.getClass().getClassLoader().getResource(Icons.WARNING_STATUS.getFilePath());
        return uRL.toString();
    }

    @Override
    public void setMetadataId(String string) {
        this.getData().setId(string);
    }

    @Override
    public String getMetadataId() {
        return this.getData().getId();
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{"metadata"};
        return stringArray;
    }

    public String[] getDependentProperties(String string) {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("status")) {
            arrayList.add("show_status");
            arrayList.add("show_warning_status");
            arrayList.add("tooltip");
            stringArray = arrayList.toArray(stringArray);
        } else if (string.equals("show_status")) {
            arrayList.add("status");
            arrayList.add("status_file");
            stringArray = arrayList.toArray(stringArray);
        } else if (string.equals("show_warning_status")) {
            arrayList.add("warning_file");
            stringArray = arrayList.toArray(stringArray);
        } else if (string.equals("status_file")) {
            arrayList.add("status");
            arrayList.add("show_status");
            stringArray = arrayList.toArray(stringArray);
        } else if (string.equals("border_width")) {
            arrayList.add("status");
            arrayList.add("border_color");
            stringArray = arrayList.toArray(stringArray);
        } else if (string.equals("messages")) {
            arrayList.add("status");
            arrayList.add("tooltip");
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public abstract URL getNodeIcon();

    private String getBorderColor() {
        String string = "#555555";
        String string2 = (String)this.getProperty("status");
        string = string2.equals("RUNNING") ? "#00FF00" : (string2.equals("NotRunning") ? "#006600" : (string2.equals(NodeStatusType.INVALID.value()) ? "#FFA800" : (string2.equals(NodeStatusType.FAILURE.value()) ? "#FF0000" : (string2.equals(NodeStatusType.WARNING.value()) ? "#EEEE00" : "#AAAAAA"))));
        return string;
    }

    private String getBorderWidth() {
        String string = "1";
        return string;
    }

    private Boolean isShowStateIcon() {
        String string = (String)this.getProperty("status");
        if (string.equals("NotRunning")) {
            return Boolean.FALSE;
        }
        if (string.equals("RUNNING")) {
            return Boolean.TRUE;
        }
        if (this.getState() == NodeStatusType.READY) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private URL getStatusIconResource() {
        URL uRL = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string = (String)this.getProperty("status");
        if (string.equals("RUNNING")) {
            uRL = classLoader.getResource(Icons.RUNNING_NODE.getFilePath());
        } else if (string.equals("NotRunning")) {
            uRL = classLoader.getResource(Icons.NOT_RUNNING_NODE.getFilePath());
        } else if (this.getState() == NodeStatusType.FAILURE) {
            uRL = classLoader.getResource(Icons.ERROR_STATUS.getFilePath());
        } else if (this.getState() == NodeStatusType.COMPLETE) {
            uRL = classLoader.getResource(Icons.PI_BUILD_GROUP_MODEL_BUILT.getFilePath());
        } else if (this.getState() == NodeStatusType.INVALID) {
            uRL = classLoader.getResource(Icons.WARNING_STATUS.getFilePath());
        } else if (this.getState() == NodeStatusType.WARNING) {
            uRL = classLoader.getResource(Icons.COMPLETE_WITH_WARNING.getFilePath());
        }
        return uRL;
    }

    public abstract Object getProperty(ComplexProperty var1);

    public Object getProperty(String string) {
        if ("userObject".equals(string) || "CSSclass".equals(string)) {
            return this.getData().getName();
        }
        Object object = null;
        try {
            if (string.equals("x") || string.equals("sdm:x")) {
                object = Float.valueOf(this.getData().getIcon().getXCOORD().longValue());
            } else if (string.equals("y") || string.equals("sdm:y")) {
                object = Float.valueOf(this.getData().getIcon().getYCOORD().longValue());
            } else if (string.equals("name")) {
                object = this.getData().getName();
            } else if (string.equals("status")) {
                WorkflowModel workflowModel = this.getModel();
                WorkflowRunStateAdapter workflowRunStateAdapter = workflowModel.getRunStateAdapter();
                if (workflowRunStateAdapter != null) {
                    object = workflowRunStateAdapter.getNodeState(this.getMetadataId());
                    if (object == null || ((String)object).equalsIgnoreCase("NotRunning")) {
                        object = this.getData().getStatus().value();
                    }
                } else {
                    object = this.getData().getStatus().value();
                }
            } else if (string.equals("comment")) {
                object = this.getData().getAnnotation();
                object = object == null ? "" : object;
            } else if (string.equals("metadata")) {
                object = this.metadataToXML();
            } else if (string.equals("tooltip")) {
                object = this.getFormattedMessages();
            } else if (string.equals("messages")) {
                object = this.getData().getMessages();
            } else if (string.equals("nodetype")) {
                object = this.getData();
            } else if (string.equals("border_color")) {
                object = this.getBorderColor();
            } else if (string.equals("border_width")) {
                object = this.getBorderWidth();
            } else if (string.equals("iconfile")) {
                object = this.getNodeIcon();
            } else if (string.equals("warning_file")) {
                object = this.getClass().getClassLoader().getResource(Icons.WARNING_STATUS.getFilePath());
            } else if (string.equals("status_file")) {
                object = this.getStatusIconResource();
                if (object == null) {
                    object = "";
                }
            } else if (string.equals("show_status")) {
                object = this.isShowStateIcon();
            } else if (string.equals("show_warning_status")) {
                object = Boolean.FALSE;
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            return;
        }
        try {
            if (string.equals("x")) {
                Icon icon = this.getData().getIcon();
                if (icon != null) {
                    icon.setXCOORD(this.convertToCoordinateValue(object));
                }
            } else if (string.equals("y")) {
                Icon icon = this.getData().getIcon();
                if (icon != null) {
                    icon.setYCOORD(this.convertToCoordinateValue(object));
                }
            } else if (string.equals("name")) {
                this.getData().setName((String)object);
                this.setNavigatorRefreshPending();
            } else if (string.equals("status")) {
                NodeStatusType nodeStatusType = null;
                if (object instanceof NodeStatusType) {
                    nodeStatusType = (NodeStatusType)object;
                } else if (object instanceof String) {
                    nodeStatusType = NodeStatusType.fromValue((String)((String)object));
                }
                this.getData().setStatus(nodeStatusType);
            } else if (string.equals("comment")) {
                this.getData().setAnnotation((String)object);
            } else if (string.equals("metadata")) {
                this.setMetadata(object);
                this.setNavigatorRefreshPending();
            } else if (string.equals("messages")) {
                NodeType nodeType = this.getData();
                nodeType.setMessages((Messages)object);
            } else if (string.equals("nodetype")) {
                this.setData((NodeType)object, this.getData());
                this.setNavigatorRefreshPending();
            }
            this.applyPendingNavigatorRefresh();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, "Property name: " + string + " Value: " + object + "\n");
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setOldId(String string) {
        this.oldId = string;
    }

    public String getOldId() {
        return this.oldId;
    }

    private void setMetadata(Object object) {
        List<Object> list;
        Object object2;
        ModelProvider modelProvider;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this instanceof ModelProvider) {
            modelProvider = (ModelProvider)((Object)this);
            object2 = modelProvider.getOutputModels();
            list = object2.iterator();
            while (list.hasNext()) {
                RefModelType refModelType = list.next();
                hashMap.put(refModelType.getName(), refModelType.getModelId());
            }
        }
        modelProvider = this.metadataFromXML((String)object);
        this.setOldId(modelProvider.getId());
        modelProvider.setId(this.getData().getId());
        object2 = this.getModel().generateNextDistinctName(modelProvider.getName());
        modelProvider.setName((String)object2);
        if (hashMap.size() != 0) {
            if (this instanceof AbstractBuildNode) {
                list = MetaDataHelper.getModelsCollection((BuildNodeType)this.getData());
                for (Object object3 : list) {
                    object3.setId((String)hashMap.get(object3.getName()));
                }
            } else if (this instanceof ModelProvider) {
                list = ((ModelProvider)((Object)this)).getOutputModels();
                for (Object object3 : list) {
                    object3.setModelId((String)hashMap.get(object3.getName()));
                }
            }
        }
        modelProvider.setStatus(NodeStatusType.READY);
        this.setData((NodeType)modelProvider, this.getData());
        list = this.getModel().findLinksFromNode((IlvSDMNode)this);
        for (Object object3 : list) {
            ((GeneralLink)object3).getData().setFrom(modelProvider.getId());
        }
        list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (Object object3 : list) {
            ((GeneralLink)object3).getData().setTo(modelProvider.getId());
        }
    }

    public void setParent(IlvMutableSDMNode ilvMutableSDMNode) {
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            String string = ((AbstractNode)generalLink.getFrom()).getData().getName();
            String string2 = this.getData().getName();
            String string3 = GeneralLink.generateLinkName(string, string2);
            odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", string3);
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            String string = GeneralLink.generateLinkName(generalLink.getFrom(), generalLink.getTo());
            odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", string);
        }
    }

    public void addChild(IlvMutableSDMNode ilvMutableSDMNode, IlvMutableSDMNode ilvMutableSDMNode2) {
    }

    public void removeChild(IlvMutableSDMNode ilvMutableSDMNode) {
    }

    public Enumeration getChildren() {
        return null;
    }

    public IlvSDMNode getParent() {
        return null;
    }

    @Override
    public final NodeType getData() {
        return this.metaData;
    }

    private static AbstractNode createNode(String string, Context context, NodeType nodeType) throws Exception {
        AbstractNode abstractNode = null;
        Class<?> clazz = Class.forName(AbstractNode.class.getPackage().getName() + "." + string);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length && (constructor = constructorArray[i]).getGenericParameterTypes().length != 3; ++i) {
        }
        abstractNode = (AbstractNode)constructor.newInstance(string, nodeType, context);
        WorkflowModel workflowModel = abstractNode.getModel();
        if (nodeType == null) {
            abstractNode.createMetadataInstance();
            if (!workflowModel.isInPaste()) {
                abstractNode.initNewInstance(context);
                abstractNode.validate(false);
            }
        }
        return abstractNode;
    }

    public static AbstractNode createNode(NodeType nodeType, Context context) throws Exception {
        AbstractNode abstractNode = null;
        Class clazz = NodeTypeMappingUtils.getNodeClassForDataClass(nodeType.getClass());
        if (clazz == null) {
            throw new Exception("Node class could not be obtained.  Check if mapping is defined");
        }
        abstractNode = AbstractNode.createNode(clazz.getSimpleName(), context, nodeType);
        return abstractNode;
    }

    public static AbstractNode createNode(String string, Context context) throws Exception {
        AbstractNode abstractNode = null;
        abstractNode = AbstractNode.createNode(string, context, null);
        return abstractNode;
    }

    public abstract String getHelpTopic();

    protected void createMetadataInstance() {
        try {
            Class<?> clazz = Class.forName(NodeType.class.getPackage().getName() + "." + this.getTag() + "Type");
            this.setData((NodeType)clazz.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new DataMinerException(reflectiveOperationException);
        }
    }

    protected void initNewInstance(Context context) {
        InMemoryColumnarType inMemoryColumnarType;
        Object object;
        Version version = ConfigUtils.getDatabaseVersion(context);
        boolean bl = DbVersionHelper.isDB12102Up((Version)version);
        if (bl) {
            if (this.performancePreferences == null) {
                this.performancePreferences = InMemoryParallelPreferences.getInstance();
            }
        } else if (this.performancePreferences == null) {
            this.performancePreferences = ParallelQueryPreferences.getInstance();
        }
        NodeType nodeType = this.getData();
        String string = nodeType.getClass().getName();
        String string2 = this.performancePreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        String string3 = this.performancePreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.VALUE);
        boolean bl2 = false;
        if (string3 == null || SYSTEM_DETERMINED.equals(string3)) {
            bl2 = true;
        }
        ParallelismType parallelismType = new ParallelismType();
        if (string2 == null) {
            parallelismType.setEnable(false);
            parallelismType.setSystemDetermined(new ParallelismType.SystemDetermined());
        } else {
            if (Boolean.parseBoolean(string2)) {
                parallelismType.setEnable(true);
            } else {
                parallelismType.setEnable(false);
            }
            if (bl2) {
                parallelismType.setSystemDetermined(new ParallelismType.SystemDetermined());
            } else {
                object = new ParallelismType.Custom();
                object.setDegree(Long.parseLong(string3));
                parallelismType.setCustom((ParallelismType.Custom)object);
            }
        }
        nodeType.setParallelism(parallelismType);
        if (bl) {
            object = (InMemoryParallelPreferences)this.performancePreferences;
            inMemoryColumnarType = new InMemoryColumnarType();
            String string4 = ((InMemoryParallelPreferences)((Object)object)).getProperty(string, InMemoryParallelPreferences.PROPERTY_INMEMORY.IS_IN_MEMORY);
            if (string4 == null) {
                inMemoryColumnarType.setEnable(false);
                inMemoryColumnarType.setCompressionMethod("");
                inMemoryColumnarType.setPriorityLevel("");
            } else {
                inMemoryColumnarType.setEnable(Boolean.parseBoolean(string4));
                String string5 = ((InMemoryParallelPreferences)((Object)object)).getProperty(string, InMemoryParallelPreferences.PROPERTY_INMEMORY.COMPRESSION);
                inMemoryColumnarType.setCompressionMethod(MetaDataHelper.inMmemoryCompressionCovertToMachine(string5));
                String string6 = ((InMemoryParallelPreferences)((Object)object)).getProperty(string, InMemoryParallelPreferences.PROPERTY_INMEMORY.PRIORITY);
                inMemoryColumnarType.setPriorityLevel(MetaDataHelper.inMemoryPriorityCovertToMachine(string6));
                nodeType.setInMemoryColumnar(inMemoryColumnarType);
            }
        }
        nodeType.setStatus(NodeStatusType.INVALID);
        object = new Messages();
        object.getMessage();
        nodeType.setMessages((Messages)object);
        inMemoryColumnarType = new Icon();
        inMemoryColumnarType.setXCOORD(BigInteger.valueOf(0L));
        inMemoryColumnarType.setYCOORD(BigInteger.valueOf(0L));
        this.getData().setIcon((Icon)inMemoryColumnarType);
    }

    private void setData(NodeType nodeType) {
        this.setData(nodeType, null);
    }

    private void setData(NodeType nodeType, NodeType nodeType2) {
        if (nodeType2 != null) {
            WorkflowModel workflowModel = this.getModel();
            workflowModel.replacedMetaData(nodeType, nodeType2);
        }
        this.metaData = nodeType;
    }

    @Override
    public void setState(NodeStatusType nodeStatusType) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "status", nodeStatusType);
    }

    protected void setState(boolean bl) {
        NodeStatusType nodeStatusType = bl ? NodeStatusType.READY : NodeStatusType.INVALID;
        this.setState(nodeStatusType);
    }

    public NodeStatusType getState() {
        return this.getData().getStatus();
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = true;
        List<AbstractNode> list = this.findParentNodes();
        Object object = list.iterator();
        while (object.hasNext()) {
            AbstractNode abstractNode = object.next();
            if (abstractNode != node) continue;
            bl = false;
            break;
        }
        if (bl && (object = this.findAllChildNodes()).contains(node)) {
            bl = false;
        }
        return bl;
    }

    public boolean isInRunChain() {
        String string = (String)this.getProperty("status");
        return string.equalsIgnoreCase("NotRunning") || string.equalsIgnoreCase("RUNNING");
    }

    @Override
    public abstract String getDefaultName();

    public String getAliasName() {
        String string = this.getMetadataId();
        String string2 = this.getData().getName();
        int n = 30 - (SQL_PREFIX_FOR_WITH_NAME.length() + string.length()) - 1;
        n = string2.length() > n ? n : string2.length();
        String string3 = string2.substring(0, n);
        String string4 = string3 + "_" + SQL_PREFIX_FOR_WITH_NAME + string;
        return string4;
    }

    public String getParentNodeNameForSQLExpression(boolean bl) {
        List<AbstractNode> list = this.findParentNodes();
        String string = "";
        int n = 0;
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            ++n;
            string = abstractNode.getMetadataId();
        }
        if (n == 0) {
            return null;
        }
        return this.getNodeNameForSQLExpressionInternal(bl, string);
    }

    public String getNodeNameForSQLExpression(boolean bl) {
        return this.getNodeNameForSQLExpressionInternal(bl, this.getMetadataId());
    }

    protected String getNodeNameForSQLExpressionInternal(boolean bl, String string) {
        String string2 = SQL_PREFIX_FOR_WITH_NAME + string;
        if (bl) {
            string2 = "\"" + string2 + "\"";
        }
        return string2;
    }

    protected AttributeType findCompatibleAttribute(AttributeType attributeType, List<? extends AttributeType> list) {
        AttributeType attributeType2 = null;
        for (AttributeType attributeType3 : list) {
            String string = attributeType3.getAlias();
            boolean bl = attributeType3.getName().equals(attributeType.getName()) ? true : string != null && string.equals(attributeType.getName());
            if (!bl || !attributeType3.getDataType().equals(attributeType.getDataType())) continue;
            attributeType2 = attributeType3;
            break;
        }
        return attributeType2;
    }

    @Override
    public AbstractNode findParentNode() {
        AbstractNode abstractNode = null;
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractNode abstractNode2 = (AbstractNode)generalLink.getTo();
            if (!abstractNode2.getID().equals(this.getID())) continue;
            abstractNode = (AbstractNode)generalLink.getFrom();
            break;
        }
        return abstractNode;
    }

    @Override
    public List<AbstractNode> findParentNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        WorkflowModel workflowModel = this.getModel();
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            arrayList.add((AbstractNode)generalLink.getFrom());
        }
        return arrayList;
    }

    public List<AbstractNode> findAllIncompleteParentNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findAllParentNodes();
        for (AbstractNode abstractNode : list) {
            NodeStatusType nodeStatusType = abstractNode.getState();
            if (nodeStatusType == NodeStatusType.COMPLETE) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    @Override
    public List<AbstractNode> findAllParentNodes() {
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        if (list.isEmpty()) {
            return list;
        }
        for (AbstractNode abstractNode : list) {
            arrayList.addAll(abstractNode.findAllParentNodes());
        }
        list.addAll(arrayList);
        return list;
    }

    public List<AbstractNode> findRootNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findAllParentNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode.hasParentNodes() || arrayList.contains(abstractNode)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public static List<AbstractNode> findAllRootNodes(Collection<AbstractNode> collection) {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        for (AbstractNode abstractNode : collection) {
            List<AbstractNode> list = abstractNode.findRootNodes();
            for (AbstractNode abstractNode2 : list) {
                if (arrayList.contains(abstractNode2)) continue;
                arrayList.add(abstractNode2);
            }
        }
        return arrayList;
    }

    @Override
    public List<AbstractNode> findChildNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        WorkflowModel workflowModel = this.getModel();
        List<GeneralLink> list = workflowModel.findLinksFromNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            arrayList.add((AbstractNode)generalLink.getTo());
        }
        return arrayList;
    }

    public List<AbstractNode> findAllChildNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        WorkflowModel workflowModel = this.getModel();
        List<GeneralLink> list = workflowModel.findLinksFromNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractNode abstractNode = (AbstractNode)generalLink.getTo();
            arrayList.add(abstractNode);
            List<AbstractNode> list2 = abstractNode.findAllChildNodes();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public boolean hasParentNodes() {
        WorkflowModel workflowModel = this.getModel();
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        return list.size() > 0;
    }

    public boolean hasChildrenNodes() {
        WorkflowModel workflowModel = this.getModel();
        List<GeneralLink> list = workflowModel.findLinksFromNode((IlvSDMNode)this);
        return list.size() > 0;
    }

    public String metadataToXML() {
        String string = null;
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = Workflow.createMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("", "local"), NodeType.class, (Object)this.metaData), (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string;
    }

    public NodeType metadataFromXML(String string) {
        StringReader stringReader = new StringReader(string);
        JAXBElement jAXBElement = null;
        try {
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            jAXBElement = (JAXBElement)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return (NodeType)jAXBElement.getValue();
    }

    private BigInteger convertToCoordinateValue(Object object) {
        Long l = object instanceof String ? Long.valueOf(Float.valueOf((String)object).longValue()) : Long.valueOf(((Float)object).longValue());
        BigInteger bigInteger = BigInteger.valueOf(l);
        return bigInteger;
    }

    @Override
    public void setNodeReady() {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "status", NodeStatusType.READY);
    }

    public void setNavigatorRefreshPending() {
        this.navigatorRefreshPending = true;
    }

    private void applyPendingNavigatorRefresh() {
        if (this.navigatorRefreshPending) {
            UpdateMessage.fireStructureChanged((Subject)this.getContext().getNode());
            this.navigatorRefreshPending = false;
        }
    }

    public void addPropertyChangeListener(IlvSDMEngine ilvSDMEngine) {
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, true);
        if (ilvGraphic == null || !(ilvGraphic instanceof DataMinerNodeGraphic)) {
            throw new RuntimeException("not an instance of DataMinerNodeSymbol");
        }
        DataMinerNodeGraphic dataMinerNodeGraphic = (DataMinerNodeGraphic)ilvGraphic;
        dataMinerNodeGraphic.addParameterChangeListener(this);
    }

    public void removePropertyChangeListener(IlvSDMEngine ilvSDMEngine) {
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, true);
        if (ilvGraphic == null || !(ilvGraphic instanceof DataMinerNodeGraphic)) {
            throw new RuntimeException("not an instance of DataMinerNodeSymbol");
        }
        DataMinerNodeGraphic dataMinerNodeGraphic = (DataMinerNodeGraphic)ilvGraphic;
        dataMinerNodeGraphic.removeParameterChangeListener(this);
    }

    protected void refactorChildrenAttributes(Node node, Map<String, AttributeType> map) {
        if (!map.isEmpty()) {
            List<AbstractNode> list = this.findChildNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof DataConsumer)) continue;
                ((DataConsumer)((Object)abstractNode)).refactorAttributes(node, map);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        this.getUndoFilter().setObjectProperty((Object)this, string, object);
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        return string;
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        return true;
    }

    public Map<String, String> getInMemorySettings(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("IN_MEMORY_ON", "");
        hashMap.put("COMPRESSION_METHOD", "");
        hashMap.put("PRIORITY_LEVEL", "");
        try {
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            if (DbVersionHelper.isDB12102Up((Version)version)) {
                Object object = context.getProperty("IN_MEMORY_ALLOWED");
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                } else if (object == null || 0 == object.toString().compareToIgnoreCase("true")) {
                    bl = true;
                }
                if (bl) {
                    InMemoryColumnarType inMemoryColumnarType = this.getData().getInMemoryColumnar();
                    boolean bl2 = inMemoryColumnarType != null && inMemoryColumnarType.isEnable();
                    hashMap.put("IN_MEMORY_ON", String.valueOf(bl2));
                    if (bl2) {
                        String string = inMemoryColumnarType.getCompressionMethod();
                        string = string != null && !string.isEmpty() ? string : MetaDataHelper.defaultInMmemoryCompressionMachine();
                        hashMap.put("COMPRESSION_METHOD", string);
                        String string2 = inMemoryColumnarType.getPriorityLevel();
                        string2 = string2 != null && !string2.isEmpty() ? string2 : MetaDataHelper.defaultInMmemoryPriorityMachine();
                        hashMap.put("PRIORITY_LEVEL", string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return hashMap;
    }

    public String getParallelHint(Context context, HintType hintType, boolean bl) {
        String string = "";
        try {
            boolean bl2;
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            if (version == null) {
                version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
            }
            Boolean bl3 = (Boolean)context.getProperty("PARALLEL_QUERY_ON_ALLOWED");
            Boolean bl4 = (Boolean)context.getProperty("PARALLEL_QUERY_OFF_ALLOWED");
            ParallelismType parallelismType = this.getData().getParallelism();
            boolean bl5 = bl2 = parallelismType != null && parallelismType.isEnable();
            if (!bl2) {
                if (DbVersionHelper.isDB11203Up((Version)version)) {
                    string = hintType.equals((Object)HintType.HINT_TYPE_TABLE) ? NOPARALLEL_NOLOGGING : NO_PARALLEL;
                }
            } else {
                ParallelismType.SystemDetermined systemDetermined = parallelismType.getSystemDetermined();
                if (systemDetermined != null) {
                    if (hintType.equals((Object)HintType.HINT_TYPE_TABLE)) {
                        string = PARALLEL_NOLOGGING;
                    } else if (hintType.equals((Object)HintType.HINT_TYPE_QUERY)) {
                        string = PARALLEL_AUTO;
                    } else if (hintType.equals((Object)HintType.HINT_TYPE_INSERT)) {
                        string = NOAPPEND_PARALLEL_AUTO;
                    }
                } else {
                    ParallelismType.Custom custom = parallelismType.getCustom();
                    if (custom == null) {
                        throw new Exception("DOP is not available");
                    }
                    long l = custom.getDegree();
                    String string2 = String.valueOf(l);
                    if (hintType.equals((Object)HintType.HINT_TYPE_TABLE)) {
                        string = StringUtils.getReplacedString(PARALLEL_DOP_NOLOGGING, DOP, string2);
                    } else if (hintType.equals((Object)HintType.HINT_TYPE_QUERY)) {
                        string = StringUtils.getReplacedString(PARALLEL_DOP, DOP, string2);
                    } else if (hintType.equals((Object)HintType.HINT_TYPE_INSERT)) {
                        string = StringUtils.getReplacedString(NOAPPEND_PARALLEL_DOP, DOP, string2);
                    }
                }
            }
            if (bl3 != null && !bl3.booleanValue() && bl2) {
                string = "";
            }
            if (bl4 != null && !bl4.booleanValue() && !bl2) {
                string = "";
            }
            if (!hintType.equals((Object)HintType.HINT_TYPE_TABLE) && bl && string.length() > 0) {
                string = "/*+ " + string + " */";
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string;
    }

    public static enum HintType {
        HINT_TYPE_TABLE,
        HINT_TYPE_QUERY,
        HINT_TYPE_INSERT;

    }
}

