/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PerformanceType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class ClassificationBuildNode
extends SupervisedBuildNode
implements RowDiagnosticsProvider {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildNode.class.getName());
    public static final String PERFORMANCE = "BUILD_SETTING_PERFORM_OPTION";
    public static final String NBSETTINGS = "naiveBayesSettings";
    public static final String PAIRWISETHRESHOLD = "PAIRWISETHRESHOLD";
    public static final String SINGLETONTHRESHOLD = "SINGLETONTHRESHOLD";
    public static final String DTSETTINGS = "decisionTreeSettings";
    public static final String TREE_IMPURITY_METRIC = "TREE_IMPURITY_METRIC";
    public static final String TREE_TERM_MAX_DEPTH = "TREE_TERM_MAX_DEPTH";
    public static final String TREE_TERM_MINREC_NODE = "TREE_TERM_MINREC_NODE";
    public static final String TREE_TERM_MINPCT_NODE = "TREE_TERM_MINPCT_NODE";
    public static final String TREE_TERM_MINREC_SPLIT = "TREE_TERM_MINREC_SPLIT";
    public static final String TREE_TERM_MINPCT_SPLIT = "TREE_TERM_MINPCT_SPLIT";
    public static final String CLAS_MAX_SUP_BINS = "CLAS_MAX_SUP_BINS";
    public static final String SVMSETTINGS = "svmSettings";
    public static final String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
    public static final String SVMS_CONV_TOLERANCE = "SVMS_CONV_TOLERANCE";
    public static final String SVMS_COMPLEXITY_FACTOR = "SVMS_COMPLEXITY_FACTOR";
    public static final String SVMS_ACTIVE_LEARNING = "SVMS_ACTIVE_LEARNING";
    public static final String SVMS_STD_DEV = "SVMS_STD_DEV";
    public static final String SVMS_KERNEL_CACHE_SIZE = "SVMS_KERNEL_CACHE_SIZE";
    public static final String SVMS_REGULARIZER = "SVMS_REGULARIZER";
    public static final String SVMS_BATCH_ROWS = "SVMS_BATCH_ROWS";
    public static final String SVMS_SOLVER = "SVMS_SOLVER";
    public static final String SVMS_NUM_ITERATIONS = "SVMS_NUM_ITERATIONS";
    public static final String SVMS_NUM_PIVOTS = "SVMS_NUM_PIVOTS";
    public static final String GLMSETTINGS = "glmSettings";
    public static final String GLMS_CONF_LEVEL = "GLMS_CONF_LEVEL";
    public static final String GLMS_CONV_TOLERANCE = "GLMS_CONV_TOLERANCE";
    public static final String GLMS_NUM_ITERATIONS = "GLMS_NUM_ITERATIONS";
    public static final String GLMS_BATCH_ROWS = "GLMS_BATCH_ROWS";
    public static final String GLMS_DIAGNOSTICS_TABLE_NAME = "GLMS_DIAGNOSTICS_TABLE_NAME";
    public static final String GLMS_ROW_DIAGNOSTICS = "GLMS_ROW_DIAGNOSTICS";
    public static final String GLMS_REFERENCE_CLASS_NAME = "GLMS_REFERENCE_CLASS_NAME";
    public static final String GLMS_RIDGE_REGRESSION = "GLMS_RIDGE_REGRESSION";
    public static final String GLMS_RIDGE_VALUE = "GLMS_RIDGE_VALUE";
    public static final String GLMS_VIF_FOR_RIDGE = "GLMS_VIF_FOR_RIDGE";
    public static final String GLMS_MISSING_VALUE_TREATMENT = "GLMS_MISSING_VALUE_TREATMENT";
    public static final String GLMS_ROW_WEIGHT_COLUMN_NAME = "GLMS_ROW_WEIGHT_COLUMN_NAME";
    public static final String GLMS_SOLVER = "GLMS_SOLVER";
    public static final String GLMS_SPARSE_SOLVER = "GLMS_SPARSE_SOLVER";
    public static final String COST_BENEFIT = "costBenefit";
    public static final String TUNING_CHANGED = "tuningChanged";
    public static final String GEN_FOR_TUNING = "genTuning";
    public static final String ALL_WEIGHT_TABLES_REMOVED = "allweightsRemoved";
    public static final String ALL_WEIGHT_TABLES_RESTORED = "allweightsRestored";
    private ClassificationModelBuildPreferencesPanelSettings classBuildPref = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    public ClassificationBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        String string;
        TestDataSource.SplitData splitData;
        Object object;
        super.initNewInstance(context);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        Preferences preferences = Preferences.getPreferences();
        ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        if (classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_ALL")) {
            object = new TestDataSource.BuildData();
            classificationBuildNodeType.getTestDataSource().setBuildData((TestDataSource.BuildData)object);
        } else if (classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_SPLIT")) {
            object = (double)classificationModelBuildPreferencesPanelSettings.getTestSplitPercent();
            splitData = new TestDataSource.SplitData();
            splitData.setTestPercent(((Double)object).doubleValue());
            string = classificationModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
            splitData.setDataFormat(string);
            classificationBuildNodeType.getTestDataSource().setSplitData(splitData);
        } else {
            object = new TestDataSource.TestData();
            classificationBuildNodeType.getTestDataSource().setTestData((TestDataSource.TestData)object);
        }
        object = new ClassificationTestSettingsType();
        if (classificationModelBuildPreferencesPanelSettings.isTOPN()) {
            splitData = new ClassificationTestSettingsType.TopNTargets();
            splitData.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            object.setTopNTargets((ClassificationTestSettingsType.TopNTargets)splitData);
        } else {
            splitData = new ClassificationTestSettingsType.BottomNTargets();
            splitData.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            object.setBottomNTargets((ClassificationTestSettingsType.BottomNTargets)splitData);
        }
        classificationBuildNodeType.setTestSettings((ClassificationTestSettingsType)object);
        splitData = new ClassificationBuildNodeType.Models();
        string = new ClassificationBuildNodeType.Results();
        classificationBuildNodeType.setModels((ClassificationBuildNodeType.Models)splitData);
        string.setGenAccuracyMetrics(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isAccuracyMetrics()));
        string.setGenConfusionMatrix(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isConfusionMatrix()));
        string.setGenROC(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isROC()));
        string.setGenLift(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isLift()));
        string.setGenTuning(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isTune()));
        classificationBuildNodeType.setResults((ClassificationBuildNodeType.Results)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.classBuildPref.isNb()) {
            arrayList.add("ALGO_NAIVE_BAYES");
        }
        if (this.classBuildPref.isDt()) {
            arrayList.add("ALGO_DECISION_TREE");
        }
        if (this.classBuildPref.isSvm()) {
            arrayList.add("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (this.classBuildPref.isGlm()) {
            arrayList.add("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "CLASSIFICATION", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.classBuildPref.isNb()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewNaiveBayesModel((NaiveBayesModelType)modelType);
        }
        if (this.classBuildPref.isDt()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewDecisionTreeModel((DecisionTreeModelType)modelType);
        }
        if (this.classBuildPref.isSvm()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewSVMModel((CSupportVectorMachineModelType)modelType);
        }
        if (this.classBuildPref.isGlm()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n));
            modelType.setUseForOutput(true);
            this.addNewGLMModel((CGeneralizedLinearModelType)modelType);
        }
        classificationBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addNewNaiveBayesModel(NaiveBayesModelType naiveBayesModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getNaiveBayesModel();
        list.add(naiveBayesModelType);
    }

    public void addNewDecisionTreeModel(DecisionTreeModelType decisionTreeModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getDecisionTreeModel();
        list.add(decisionTreeModelType);
    }

    public void addNewSVMModel(CSupportVectorMachineModelType cSupportVectorMachineModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getCSupportVectorMachineModel();
        list.add(cSupportVectorMachineModelType);
    }

    public void addNewGLMModel(CGeneralizedLinearModelType cGeneralizedLinearModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getCGeneralizedLinearModel();
        list.add(cGeneralizedLinearModelType);
    }

    public ModelType createNewClassificationModel(String string, String string2, String string3) {
        return this.createNewModel(string, string2, "CLASSIFICATION", string3);
    }

    @Override
    public ModelType createNewModel(String string, String string2, String string3, String string4) {
        ClassificationModelType classificationModelType = (ClassificationModelType)super.createNewModel(string, string2, string3, string4);
        PerformanceType performanceType = new PerformanceType();
        PerformanceType.Balanced balanced = new PerformanceType.Balanced();
        performanceType.setBalanced(balanced);
        TuningType tuningType = new TuningType();
        tuningType.setNone(new TuningType.None());
        classificationModelType.setPerformance(performanceType);
        classificationModelType.setTuning(tuningType);
        return classificationModelType;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void refactor(Node node, boolean bl) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (!classificationBuildNodeType.getResults().getClassificationResult().isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            ClassificationBuildNodeType.Results results = new ClassificationBuildNodeType.Results();
            results.setGenAccuracyMetrics(classificationBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenConfusionMatrix(classificationBuildNodeType.getResults().isGenConfusionMatrix());
            results.setGenLift(classificationBuildNodeType.getResults().isGenLift());
            results.setGenROC(classificationBuildNodeType.getResults().isGenROC());
            results.setGenTuning(classificationBuildNodeType.getResults().isGenTuning());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "classTestResults", results);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), new ComplexProperty(ALL_WEIGHT_TABLES_REMOVED, ALL_WEIGHT_TABLES_RESTORED, MetaDataHelper.getWeightTablesCollection((BuildNodeType)classificationBuildNodeType)));
        }
        super.refactor(node, bl);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        if (models.getNaiveBayesModel().isEmpty() && models.getDecisionTreeModel().isEmpty() && models.getCSupportVectorMachineModel().isEmpty() && models.getCGeneralizedLinearModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            boolean bl4;
            Object object;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getNaiveBayesModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getDecisionTreeModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getCSupportVectorMachineModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getCGeneralizedLinearModel())) {
                bl3 = false;
            }
            HashMap<String, NaiveBayesModelType> hashMap = new HashMap<String, NaiveBayesModelType>();
            for (Object object2 : models.getNaiveBayesModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getDecisionTreeModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getCSupportVectorMachineModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getCGeneralizedLinearModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            ClassificationBuildNodeType.Results results = new ClassificationBuildNodeType.Results();
            results.setGenAccuracyMetrics(classificationBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenConfusionMatrix(classificationBuildNodeType.getResults().isGenConfusionMatrix());
            results.setGenLift(classificationBuildNodeType.getResults().isGenLift());
            results.setGenROC(classificationBuildNodeType.getResults().isGenROC());
            results.setGenTuning(classificationBuildNodeType.getResults().isGenTuning());
            for (Object object3 : classificationBuildNodeType.getResults().getClassificationResult()) {
                if (!hashMap.containsKey(object3.getModelId())) continue;
                object = (ClassificationResultType)MetaDataHelper.copyMetadataObject(object3);
                results.getClassificationResult().add(object);
            }
            boolean bl5 = bl4 = results.getClassificationResult().size() != classificationBuildNodeType.getResults().getClassificationResult().size();
            if (bl4) {
                Object object3;
                object3 = new ArrayList();
                object = (OdmrSDMUndoFilter)this.getUndoFilter();
                ComplexProperty complexProperty = new ComplexProperty("classTestResults", results);
                complexProperty.setOldData(classificationBuildNodeType.getResults());
                object3.add(complexProperty);
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (string.equals(NBSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getNaiveBayesModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (NaiveBayesModelType naiveBayesModelType : list) {
                if (!naiveBayesModelType.getId().equals(string2)) continue;
                NaiveBayesAlgoType naiveBayesAlgoType = naiveBayesModelType.getNaiveBayesAlgo();
                for (Property property : list2) {
                    if (property.getDescription().equals(PAIRWISETHRESHOLD)) {
                        naiveBayesAlgoType.setNABSPAIRWISETHRESHOLD(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SINGLETONTHRESHOLD)) {
                        naiveBayesAlgoType.setNABSSINGLETONTHRESHOLD(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    naiveBayesModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(DTSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getDecisionTreeModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list3 = (List)object;
            if (list3.isEmpty()) {
                return;
            }
            String string3 = ((Property)list3.get(0)).getId();
            for (DecisionTreeModelType decisionTreeModelType : list) {
                if (!decisionTreeModelType.getId().equals(string3)) continue;
                for (Property property : list3) {
                    Number number;
                    DecisionTreeAlgoType decisionTreeAlgoType = decisionTreeModelType.getDecisionTreeAlgo();
                    if (decisionTreeAlgoType == null) continue;
                    if (property.getDescription().equals(TREE_IMPURITY_METRIC)) {
                        decisionTreeAlgoType.setTREEIMPURITYMETRIC((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MAX_DEPTH)) {
                        decisionTreeAlgoType.setTREETERMMAXDEPTH(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINREC_NODE)) {
                        number = new BigInteger(property.getValue().toString());
                        decisionTreeAlgoType.setTREETERMMINRECNODE((BigInteger)number);
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINPCT_NODE)) {
                        decisionTreeAlgoType.setTREETERMMINPCTNODE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINREC_SPLIT)) {
                        number = new BigInteger(property.getValue().toString());
                        decisionTreeAlgoType.setTREETERMMINRECSPLIT((BigInteger)number);
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINPCT_SPLIT)) {
                        decisionTreeAlgoType.setTREETERMMINPCTSPLIT((double)((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals(PERFORMANCE)) {
                        decisionTreeModelType.setPerformance((PerformanceType)property.getValue());
                        continue;
                    }
                    if (!property.getDescription().equals(CLAS_MAX_SUP_BINS)) continue;
                    number = (Integer)property.getValue();
                    decisionTreeAlgoType.setCLASMAXSUPBINS(BigInteger.valueOf(((Integer)number).intValue()));
                }
                break;
            }
        } else if (string.equals(SVMSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getCSupportVectorMachineModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list4 = (List)object;
            if (list4.isEmpty()) {
                return;
            }
            String string4 = ((Property)list4.get(0)).getId();
            for (CSupportVectorMachineModelType cSupportVectorMachineModelType : list) {
                if (!cSupportVectorMachineModelType.getId().equals(string4)) continue;
                for (Property property : list4) {
                    CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = cSupportVectorMachineModelType.getCSupportVectorMachineAlgo();
                    if (property.getDescription().equals(SVMS_KERNEL_FUNCTION)) {
                        cSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_CONV_TOLERANCE)) {
                        cSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_COMPLEXITY_FACTOR)) {
                        cSupportVectorMachineAlgoType.setSVMSCOMPLEXITYFACTOR((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_ACTIVE_LEARNING)) {
                        cSupportVectorMachineAlgoType.setSVMSACTIVELEARNING((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_STD_DEV)) {
                        cSupportVectorMachineAlgoType.setSVMSSTDDEV((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_KERNEL_CACHE_SIZE)) {
                        Object object2 = property.getValue();
                        if (object2 == null) {
                            cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
                            continue;
                        }
                        BigInteger bigInteger = new BigInteger(object2.toString());
                        cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(bigInteger);
                        continue;
                    }
                    if (property.getDescription().equals(PERFORMANCE)) {
                        cSupportVectorMachineModelType.setPerformance((PerformanceType)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_REGULARIZER)) {
                        cSupportVectorMachineAlgoType.setSVMSREGULARIZER(property.getValue().toString());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_BATCH_ROWS)) {
                        cSupportVectorMachineAlgoType.setSVMSBATCHROWS((BigInteger)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_SOLVER)) {
                        cSupportVectorMachineAlgoType.setSVMSSOLVER(property.getValue().toString());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_NUM_ITERATIONS)) {
                        cSupportVectorMachineAlgoType.setSVMSNUMITERATIONS((BigInteger)property.getValue());
                        continue;
                    }
                    if (!property.getDescription().equals(SVMS_NUM_PIVOTS)) continue;
                    cSupportVectorMachineAlgoType.setSVMSNUMPIVOTS((BigInteger)property.getValue());
                }
                break;
            }
        } else if (string.equals(GLMSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getCGeneralizedLinearModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list5 = (List)object;
            if (list5.isEmpty()) {
                return;
            }
            String string5 = ((Property)list5.get(0)).getId();
            for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
                if (!cGeneralizedLinearModelType.getId().equals(string5)) continue;
                for (Property property : list5) {
                    CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo();
                    if (GLMS_CONF_LEVEL.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSCONFLEVEL(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (GLMS_DIAGNOSTICS_TABLE_NAME.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSDIAGNOSTICSTABLENAME((String)property.getValue());
                        continue;
                    }
                    if (GLMS_REFERENCE_CLASS_NAME.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSREFERENCECLASSNAME((String)property.getValue());
                        continue;
                    }
                    if (GLMS_RIDGE_REGRESSION.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSRIDGEREGRESSION((String)property.getValue());
                        continue;
                    }
                    if (GLMS_RIDGE_VALUE.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSRIDGEVALUE((Double)property.getValue());
                        continue;
                    }
                    if (GLMS_VIF_FOR_RIDGE.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSVIFFORRIDGE((String)property.getValue());
                        continue;
                    }
                    if (GLMS_MISSING_VALUE_TREATMENT.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setODMSMISSINGVALUETREATMENT((String)property.getValue());
                        continue;
                    }
                    if (GLMS_ROW_WEIGHT_COLUMN_NAME.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setODMSROWWEIGHTCOLUMNNAME((String)property.getValue());
                        continue;
                    }
                    if (PERFORMANCE.equals(property.getDescription())) {
                        cGeneralizedLinearModelType.setPerformance((PerformanceType)property.getValue());
                        continue;
                    }
                    if (GLMS_CONV_TOLERANCE.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSCONVTOLERANCE((Double)property.getValue());
                        continue;
                    }
                    if (GLMS_NUM_ITERATIONS.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSNUMITERATIONS((Double)property.getValue());
                        continue;
                    }
                    if (GLMS_BATCH_ROWS.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSBATCHROWS((Double)property.getValue());
                        continue;
                    }
                    if (GLMS_ROW_DIAGNOSTICS.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSROWDIAGNOSTICS(property.getValue().toString());
                        continue;
                    }
                    if (GLMS_SOLVER.equals(property.getDescription())) {
                        cGeneralizedLinearAlgoType.setGLMSSOLVER(property.getValue().toString());
                        continue;
                    }
                    if (!GLMS_SPARSE_SOLVER.equals(property.getDescription())) continue;
                    cGeneralizedLinearAlgoType.setGLMSSPARSESOLVER(property.getValue().toString());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list6 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)classificationBuildNodeType, modelType);
                if (list6.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)classificationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list7 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)classificationBuildNodeType, modelType);
                if (!list7.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)classificationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("splitValueChanged")) {
            if (object == null || !(object instanceof Double)) {
                return;
            }
            Double d = (Double)object;
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            if (testDataSource.getSplitData().getTestPercent() != d.doubleValue()) {
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
            }
        } else if (string.equals("splitDataFormat")) {
            String string6 = (String)object;
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            if (string6 == null || testDataSource.getSplitData().getDataFormat() == null || !testDataSource.getSplitData().getDataFormat().equals(string6)) {
                testDataSource.getSplitData().setDataFormat(string6);
            }
        } else if (string.equals("testOptionsChanged")) {
            if (object == null || !(object instanceof TestDataSource)) {
                return;
            }
            TestDataSource testDataSource = (TestDataSource)object;
            classificationBuildNodeType.setTestDataSource(testDataSource);
        } else if (string.equals("alltestsForTuningRemoved")) {
            ClassificationBuildNodeType classificationBuildNodeType2 = (ClassificationBuildNodeType)this.getData();
            if (classificationBuildNodeType2.getResults() != null && !classificationBuildNodeType2.getResults().getClassificationResultForTuning().isEmpty()) {
                classificationBuildNodeType2.getResults().getClassificationResultForTuning().clear();
            }
        } else if (string.equals("testsForTuningRemoved")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType3 = (ClassificationBuildNodeType)this.getData();
            List list8 = classificationBuildNodeType3.getResults().getClassificationResultForTuning();
            block10: for (MiningResultType miningResultType : list) {
                for (ClassificationResultType classificationResultType : list8) {
                    if (!classificationResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list8.remove(classificationResultType);
                    continue block10;
                }
            }
        } else if (string.equals("alltestsForTuningRestored")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType4 = (ClassificationBuildNodeType)this.getData();
            classificationBuildNodeType4.getResults().getClassificationResultForTuning().clear();
            classificationBuildNodeType4.getResults().getClassificationResultForTuning().addAll(list);
        } else if (string.equals("testsForTuningRestored")) {
            Object object32;
            ClassificationBuildNodeType classificationBuildNodeType5 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType5.getResults().getClassificationResultForTuning();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object32 : list) {
                hashMap.put(object32.getModelId(), object32);
            }
            List list9 = (List)object;
            object32 = list9.iterator();
            while (object32.hasNext()) {
                ClassificationResultType classificationResultType = (ClassificationResultType)object32.next();
                if (null != hashMap.get(classificationResultType.getModelId())) continue;
                list.add(classificationResultType);
            }
        } else if (string.equals("alltestsRemoved")) {
            ClassificationBuildNodeType classificationBuildNodeType6 = (ClassificationBuildNodeType)this.getData();
            if (classificationBuildNodeType6.getResults() != null && !classificationBuildNodeType6.getResults().getClassificationResult().isEmpty()) {
                classificationBuildNodeType6.getResults().getClassificationResult().clear();
            }
        } else if (string.equals("testsRemoved")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType7 = (ClassificationBuildNodeType)this.getData();
            List list10 = classificationBuildNodeType7.getResults().getClassificationResult();
            block14: for (MiningResultType miningResultType : list) {
                for (ClassificationResultType classificationResultType : list10) {
                    if (!classificationResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list10.remove(classificationResultType);
                    continue block14;
                }
            }
        } else if (string.equals("alltestsRestored")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType8 = (ClassificationBuildNodeType)this.getData();
            classificationBuildNodeType8.getResults().getClassificationResult().clear();
            classificationBuildNodeType8.getResults().getClassificationResult().addAll(list);
        } else if (string.equals("testsRestored")) {
            Object object42;
            ClassificationBuildNodeType classificationBuildNodeType9 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType9.getResults().getClassificationResult();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object42 : list) {
                hashMap.put(object42.getModelId(), object42);
            }
            List list11 = (List)object;
            object42 = list11.iterator();
            while (object42.hasNext()) {
                ClassificationResultType classificationResultType = (ClassificationResultType)object42.next();
                if (null != hashMap.get(classificationResultType.getModelId())) continue;
                list.add(classificationResultType);
            }
        } else if (string.equals(ALL_WEIGHT_TABLES_REMOVED)) {
            PerformanceType.Balanced balanced;
            Object object5;
            Object object6;
            Object object72;
            ClassificationBuildNodeType classificationBuildNodeType10 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType10.getModels().getCGeneralizedLinearModel();
            for (Object object72 : list) {
                object6 = object72.getPerformance().getBalanced();
                if (object6 == null) continue;
                object6.setWeightsTable(null);
            }
            List list12 = classificationBuildNodeType10.getModels().getCSupportVectorMachineModel();
            object72 = list12.iterator();
            while (object72.hasNext()) {
                object6 = (CSupportVectorMachineModelType)object72.next();
                object5 = object6.getPerformance().getBalanced();
                if (object5 == null) continue;
                object5.setWeightsTable(null);
            }
            object72 = classificationBuildNodeType10.getModels().getDecisionTreeModel();
            object6 = object72.iterator();
            while (object6.hasNext()) {
                object5 = (DecisionTreeModelType)object6.next();
                balanced = object5.getPerformance().getBalanced();
                if (balanced == null) continue;
                balanced.setWeightsTable(null);
            }
            object6 = classificationBuildNodeType10.getModels().getNaiveBayesModel();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                balanced = (NaiveBayesModelType)object5.next();
                PerformanceType.Balanced balanced2 = balanced.getPerformance().getBalanced();
                if (balanced2 == null) continue;
                balanced2.setWeightsTable(null);
            }
        } else if (string.equals(ALL_WEIGHT_TABLES_RESTORED)) {
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object122;
            HashMap hashMap = (HashMap)object;
            ClassificationBuildNodeType classificationBuildNodeType11 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType11.getModels().getCGeneralizedLinearModel();
            for (Object object122 : list) {
                object11 = (String)hashMap.get(object122.getId());
                if (object11 == null || (object10 = object122.getPerformance().getBalanced()) == null) continue;
                object10.setWeightsTable((String)object11);
            }
            List list13 = classificationBuildNodeType11.getModels().getCSupportVectorMachineModel();
            object122 = list13.iterator();
            while (object122.hasNext()) {
                object11 = (CSupportVectorMachineModelType)object122.next();
                object10 = (String)hashMap.get(object11.getId());
                if (object10 == null || (object9 = object11.getPerformance().getBalanced()) == null) continue;
                object9.setWeightsTable((String)object10);
            }
            object122 = classificationBuildNodeType11.getModels().getDecisionTreeModel();
            object11 = object122.iterator();
            while (object11.hasNext()) {
                object10 = (DecisionTreeModelType)object11.next();
                object9 = (String)hashMap.get(object10.getId());
                if (object9 == null || (object8 = object10.getPerformance().getBalanced()) == null) continue;
                object8.setWeightsTable((String)object9);
            }
            object11 = classificationBuildNodeType11.getModels().getNaiveBayesModel();
            object10 = object11.iterator();
            while (object10.hasNext()) {
                PerformanceType.Balanced balanced;
                object9 = (NaiveBayesModelType)object10.next();
                object8 = (String)hashMap.get(object9.getId());
                if (object8 == null || (balanced = object9.getPerformance().getBalanced()) == null) continue;
                balanced.setWeightsTable((String)object8);
            }
        } else if (string.equals("genAccuracyMetrics")) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenAccuracyMetrics())) {
                results.setGenAccuracyMetrics(bl);
            }
        } else if (string.equals("genConfusionMatrix")) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenConfusionMatrix())) {
                results.setGenConfusionMatrix(bl);
            }
        } else if (string.equals("genROC")) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenROC())) {
                results.setGenROC(bl);
            }
        } else if (string.equals("genLiftProfit")) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenLift())) {
                results.setGenLift(bl);
            }
        } else if (string.equals(GEN_FOR_TUNING)) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenTuning())) {
                results.setGenTuning(bl);
            }
        } else if (string.equals("testSettingsChanged")) {
            if (object == null || !(object instanceof ClassificationTestSettingsType)) {
                return;
            }
            ClassificationTestSettingsType classificationTestSettingsType = (ClassificationTestSettingsType)object;
            classificationBuildNodeType.setTestSettings(classificationTestSettingsType);
        } else if (string.equals(TUNING_CHANGED)) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            ClassificationBuildNodeType classificationBuildNodeType12 = (ClassificationBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string7 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType12, string7);
                ((ClassificationModelType)modelType).setTuning((TuningType)entry.getValue());
            }
        } else if (string.equals("testsRerun")) {
            List<ClassificationResultType> list = MetaDataHelper.getClassificationResultsCollection(this);
            Map map = (Map)object;
            for (ClassificationResultType classificationResultType : list) {
                ModelStatusType modelStatusType = (ModelStatusType)map.get(classificationResultType.getModelId());
                if (null == modelStatusType) continue;
                classificationResultType.setStatus(modelStatusType);
            }
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            ClassificationBuildNodeType classificationBuildNodeType13 = (ClassificationBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string8 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType13, string8);
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType14 = (ClassificationBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType14, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals("classTestResults")) {
            classificationBuildNodeType.setResults((ClassificationBuildNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SVMSETTINGS) || complexProperty.getPropertyName().equals(NBSETTINGS) || complexProperty.getPropertyName().equals(GLMSETTINGS) || complexProperty.getPropertyName().equals(DTSETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals(TUNING_CHANGED)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, TuningType> hashMap = new HashMap<String, TuningType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                hashMap.put(string, ((ClassificationModelType)modelType).getTuning());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("testsRerun")) {
            List<ClassificationResultType> list = MetaDataHelper.getClassificationResultsCollection(this);
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            for (ClassificationResultType classificationResultType : list) {
                if (null == map.get(classificationResultType.getModelId())) continue;
                hashMap.put(classificationResultType.getModelId(), classificationResultType.getStatus());
            }
            return hashMap;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        Version version = (Version)this.getContext().getProperty("TARGET_DATABASE_VERSION");
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = ((CSupportVectorMachineModelType)modelType).getCSupportVectorMachineAlgo();
            if (SVMS_KERNEL_FUNCTION.equals(string2)) {
                return cSupportVectorMachineAlgoType.getSVMSKERNELFUNCTION();
            }
            if (SVMS_CONV_TOLERANCE.equals(string2)) {
                return cSupportVectorMachineAlgoType.getSVMSCONVTOLERANCE();
            }
            if (SVMS_COMPLEXITY_FACTOR.equals(string2)) {
                return cSupportVectorMachineAlgoType.getSVMSCOMPLEXITYFACTOR();
            }
            if (SVMS_ACTIVE_LEARNING.equals(string2)) {
                return cSupportVectorMachineAlgoType.getSVMSACTIVELEARNING();
            }
            if (SVMS_STD_DEV.equals(string2)) {
                return cSupportVectorMachineAlgoType.getSVMSSTDDEV();
            }
            if (SVMS_KERNEL_CACHE_SIZE.equals(string2)) {
                return cSupportVectorMachineAlgoType.getSVMSKERNELCACHESIZE();
            }
            if (PERFORMANCE.equals(string2)) {
                return ((CSupportVectorMachineModelType)modelType).getPerformance();
            }
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (SVMS_REGULARIZER.equals(string2)) {
                    return cSupportVectorMachineAlgoType.getSVMSREGULARIZER();
                }
                if (SVMS_BATCH_ROWS.equals(string2)) {
                    return cSupportVectorMachineAlgoType.getSVMSBATCHROWS();
                }
                if (SVMS_SOLVER.equals(string2)) {
                    return cSupportVectorMachineAlgoType.getSVMSSOLVER();
                }
                if (SVMS_NUM_ITERATIONS.equals(string2)) {
                    return cSupportVectorMachineAlgoType.getSVMSNUMITERATIONS();
                }
                if (SVMS_NUM_PIVOTS.equals(string2)) {
                    return cSupportVectorMachineAlgoType.getSVMSNUMPIVOTS();
                }
            }
        } else if (modelType instanceof NaiveBayesModelType) {
            NaiveBayesAlgoType naiveBayesAlgoType = ((NaiveBayesModelType)modelType).getNaiveBayesAlgo();
            if ("NABS_PAIRWISE_THRESHOLD".equals(string2)) {
                return naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD();
            }
            if ("NABS_SINGLETON_THRESHOLD".equals(string2)) {
                return naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD();
            }
            if (PERFORMANCE.equals(string2)) {
                return ((NaiveBayesModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof DecisionTreeModelType) {
            DecisionTreeAlgoType decisionTreeAlgoType = ((DecisionTreeModelType)modelType).getDecisionTreeAlgo();
            if (TREE_IMPURITY_METRIC.equals(string2)) {
                return decisionTreeAlgoType.getTREEIMPURITYMETRIC();
            }
            if (TREE_TERM_MAX_DEPTH.equals(string2)) {
                return decisionTreeAlgoType.getTREETERMMAXDEPTH();
            }
            if (TREE_TERM_MINREC_NODE.equals(string2)) {
                return decisionTreeAlgoType.getTREETERMMINRECNODE();
            }
            if (TREE_TERM_MINPCT_NODE.equals(string2)) {
                return decisionTreeAlgoType.getTREETERMMINPCTNODE();
            }
            if (TREE_TERM_MINREC_SPLIT.equals(string2)) {
                return decisionTreeAlgoType.getTREETERMMINRECSPLIT();
            }
            if (TREE_TERM_MINPCT_SPLIT.equals(string2)) {
                return decisionTreeAlgoType.getTREETERMMINPCTSPLIT();
            }
            if (CLAS_MAX_SUP_BINS.equals(string2)) {
                return decisionTreeAlgoType.getCLASMAXSUPBINS();
            }
            if (PERFORMANCE.equals(string2)) {
                return ((DecisionTreeModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof CGeneralizedLinearModelType) {
            CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = ((CGeneralizedLinearModelType)modelType).getCGeneralizedLinearAlgo();
            if (GLMS_DIAGNOSTICS_TABLE_NAME.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME();
            }
            if (GLMS_CONF_LEVEL.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSCONFLEVEL();
            }
            if (GLMS_CONV_TOLERANCE.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSCONVTOLERANCE();
            }
            if (GLMS_NUM_ITERATIONS.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSNUMITERATIONS();
            }
            if (GLMS_BATCH_ROWS.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSBATCHROWS();
            }
            if (GLMS_RIDGE_REGRESSION.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION();
            }
            if (GLMS_REFERENCE_CLASS_NAME.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME();
            }
            if (GLMS_RIDGE_VALUE.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE();
            }
            if (GLMS_VIF_FOR_RIDGE.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE();
            }
            if (PERFORMANCE.equals(string2)) {
                return ((CGeneralizedLinearModelType)modelType).getPerformance();
            }
            if (GLMS_ROW_DIAGNOSTICS.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSROWDIAGNOSTICS();
            }
            if (GLMS_SOLVER.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSSOLVER();
            }
            if (GLMS_SPARSE_SOLVER.equals(string2)) {
                return cGeneralizedLinearAlgoType.getGLMSSPARSESOLVER();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (string.equals("splitValueChanged")) {
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            double d = testDataSource.getSplitData().getTestPercent();
            return d;
        }
        if (string.equals("splitDataFormat")) {
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            String string2 = testDataSource.getSplitData().getDataFormat();
            return string2;
        }
        if (string.equals("testOptionsChanged")) {
            return classificationBuildNodeType.getTestDataSource();
        }
        if (string.equals("genAccuracyMetrics")) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenAccuracyMetrics();
        }
        if (string.equals("genConfusionMatrix")) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenConfusionMatrix();
        }
        if (string.equals("genROC")) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenROC();
        }
        if (string.equals("genLiftProfit")) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenLift();
        }
        if (string.equals(GEN_FOR_TUNING)) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenTuning();
        }
        if (string.equals("testSettingsChanged")) {
            return classificationBuildNodeType.getTestSettings();
        }
        if (string.equals("classTestResults")) {
            return classificationBuildNodeType.getResults();
        }
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.CLASSIFICATION;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        String string2 = ConnectionFolder.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
            String string3 = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string3 == null || string3.length() <= 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(cGeneralizedLinearModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        String string2 = ConnectionFolder.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (CSupportVectorMachineModelType cSupportVectorMachineModelType : list) {
            String string3 = cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(cSupportVectorMachineModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        RefModelType refModelType;
        Object object;
        Object object2;
        Object object32;
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getDecisionTreeModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        String string2 = ConnectionFolder.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        for (Object object32 : list) {
            if (object32.getPerformance().getBalanced() != null || object32.getPerformance().getCustom() != null) {
                object2 = MetaDataHelper.createRefModelType((ModelType)object32, miningFunctionType, string2, string);
                arrayList.add((RefModelType)object2);
                continue;
            }
            if (object32.getTuning().getBenefit() == null && object32.getTuning().getCost() == null && object32.getTuning().getCustom() == null) continue;
            object2 = MetaDataHelper.createRefModelType((ModelType)object32, miningFunctionType, string2, string);
            arrayList.add((RefModelType)object2);
        }
        List list2 = classificationBuildNodeType.getModels().getNaiveBayesModel();
        object32 = list2.iterator();
        while (object32.hasNext()) {
            object2 = (NaiveBayesModelType)object32.next();
            if (object2.getTuning().getBenefit() == null && object2.getTuning().getCost() == null && object2.getTuning().getCustom() == null) continue;
            object = MetaDataHelper.createRefModelType((ModelType)object2, miningFunctionType, string2, string);
            arrayList.add((RefModelType)object);
        }
        object32 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (CSupportVectorMachineModelType)object2.next();
            if (object.getTuning().getBenefit() == null && object.getTuning().getCost() == null && object.getTuning().getCustom() == null) continue;
            refModelType = MetaDataHelper.createRefModelType((ModelType)object, miningFunctionType, string2, string);
            arrayList.add(refModelType);
        }
        object2 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        object = object2.iterator();
        while (object.hasNext()) {
            refModelType = (CGeneralizedLinearModelType)object.next();
            if (refModelType.getTuning().getBenefit() == null && refModelType.getTuning().getCost() == null && refModelType.getTuning().getCustom() == null) continue;
            RefModelType refModelType2 = MetaDataHelper.createRefModelType((ModelType)refModelType, miningFunctionType, string2, string);
            arrayList.add(refModelType2);
        }
        return arrayList;
    }

    @Override
    public Map<String, RowDiagnosticTableDetails> getRowDiagnosticTables() {
        HashMap<String, RowDiagnosticTableDetails> hashMap = new HashMap<String, RowDiagnosticTableDetails>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
            String string = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string == null) continue;
            RowDiagnosticTableDetails rowDiagnosticTableDetails = new RowDiagnosticTableDetails(this.getMetadataId(), string);
            hashMap.put(cGeneralizedLinearModelType.getId(), rowDiagnosticTableDetails);
        }
        return hashMap;
    }

    public TuningType getModelTuning(String string) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        try {
            if (classificationBuildNodeType != null) {
                Object object;
                Object object2;
                Object object32;
                List list = classificationBuildNodeType.getModels().getNaiveBayesModel();
                for (Object object32 : list) {
                    if (!object32.getId().equals(string)) continue;
                    return object32.getTuning();
                }
                List list2 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                object32 = list2.iterator();
                while (object32.hasNext()) {
                    object2 = (DecisionTreeModelType)object32.next();
                    if (!object2.getId().equals(string)) continue;
                    return object2.getTuning();
                }
                object32 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = (CSupportVectorMachineModelType)object2.next();
                    if (!object.getId().equals(string)) continue;
                    return object.getTuning();
                }
                object2 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                object = object2.iterator();
                while (object.hasNext()) {
                    CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object.next();
                    if (!cGeneralizedLinearModelType.getId().equals(string)) continue;
                    return cGeneralizedLinearModelType.getTuning();
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.CLASSIFICATION;
    }

    @Override
    public String getHelpTopic() {
        return "classification_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_CLASSIFICATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_ICON"));
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            boolean bl = true;
            if (!DbVersionHelper.isDB121Up((Version)version)) {
                for (CGeneralizedLinearModelType cGeneralizedLinearModelType : classificationBuildNodeType.getModels().getCGeneralizedLinearModel()) {
                    if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELECTION() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELCRIT() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSMAXFEATURES() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSSELECTBLOCK() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSAPPROXIMATECOMPUTATION() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSPRUNEMODEL() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRACCEPTANCE() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENERATION() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENMETHOD() == null) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_GLM_BUILD_SETTING_NOT_SUPPORTED"));
                    bl = false;
                    break;
                }
            }
            return bl;
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public List<? extends ModelType> getModels() {
        ArrayList arrayList = new ArrayList();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getNaiveBayesModel());
            arrayList.addAll(models.getCGeneralizedLinearModel());
            arrayList.addAll(models.getCSupportVectorMachineModel());
            arrayList.addAll(models.getDecisionTreeModel());
        }
        return arrayList;
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        NaiveBayesModelType naiveBayesModelType;
        boolean bl = this.modelUsesWeights(modelType, version);
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof NaiveBayesModelType) {
            naiveBayesModelType = (NaiveBayesModelType)modelType;
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NABS_PAIRWISE_THRESHOLD||''', " + naiveBayesModelType.getNaiveBayesAlgo().getNABSPAIRWISETHRESHOLD() + ")'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NABS_SINGLETON_THRESHOLD||''', " + naiveBayesModelType.getNaiveBayesAlgo().getNABSSINGLETONTHRESHOLD() + ")'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_NAIVE_BAYES||''')'); \n");
            if (bl) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_PRIORS_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
        } else if (modelType instanceof DecisionTreeModelType) {
            naiveBayesModelType = (DecisionTreeModelType)modelType;
            if (naiveBayesModelType.getDecisionTreeAlgo().getTREEIMPURITYMETRIC() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_IMPURITY_METRIC||''', ''" + naiveBayesModelType.getDecisionTreeAlgo().getTREEIMPURITYMETRIC() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MAX_DEPTH||''', " + naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMAXDEPTH() + ")'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINPCT_NODE||''', " + naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMINPCTNODE() + ")'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINPCT_SPLIT||''', " + naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMINPCTSPLIT() + ")'); \n");
            if (naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMINRECNODE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINREC_NODE||''', " + naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMINRECNODE() + ")'); \n");
            }
            if (naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMINRECSPLIT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINREC_SPLIT||''', " + naiveBayesModelType.getDecisionTreeAlgo().getTREETERMMINRECSPLIT() + ")'); \n");
            }
            if (naiveBayesModelType.getDecisionTreeAlgo().getCLASMAXSUPBINS() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_MAX_SUP_BINS||''', " + naiveBayesModelType.getDecisionTreeAlgo().getCLASMAXSUPBINS() + ")'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_DECISION_TREE||''')'); \n");
            if (bl) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_COST_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
        } else if (modelType instanceof CSupportVectorMachineModelType) {
            naiveBayesModelType = (CSupportVectorMachineModelType)modelType;
            if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSACTIVELEARNING() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_ACTIVE_LEARNING||''', ''" + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSACTIVELEARNING() + "'')'); \n");
            }
            if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_COMPLEXITY_FACTOR||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() + ")'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_CONV_TOLERANCE||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSCONVTOLERANCE() + ")'); \n");
            if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_CACHE_SIZE||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() + ")'); \n");
            }
            if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_FUNCTION||''', ''" + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() + "'')'); \n");
            }
            if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSSTDDEV() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_STD_DEV||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSSTDDEV() + ")'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SUPPORT_VECTOR_MACHINES||''')'); \n");
            if (bl) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_WEIGHTS_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSREGULARIZER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_REGULARIZER||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSREGULARIZER() + ")'); \n");
                }
                if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSBATCHROWS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_BATCH_ROWS||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSBATCHROWS() + ")'); \n");
                }
                if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSSOLVER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_SOLVER||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSSOLVER() + ")'); \n");
                }
                if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSNUMITERATIONS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_NUM_ITERATIONS||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSNUMITERATIONS() + ")'); \n");
                }
                if (naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSNUMPIVOTS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_NUM_PIVOTS||''', " + naiveBayesModelType.getCSupportVectorMachineAlgo().getSVMSNUMPIVOTS() + ")'); \n");
                }
            }
        } else if (modelType instanceof CGeneralizedLinearModelType) {
            naiveBayesModelType = (CGeneralizedLinearModelType)modelType;
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_CONF_LEVEL||''', " + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSCONFLEVEL() + ")'); \n");
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME() != null) {
                stringBuilder.append("  v_row_diag_table := generateUniqueName; \n");
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_DIAGNOSTICS_TABLE_NAME||''', '''||v_row_diag_table||''')'); \n");
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_row_diag_table, 'TABLE', NULL,'GLM Diagnostics Table'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSREFERENCECLASSNAME() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_REFERENCE_CLASS_NAME||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSREFERENCECLASSNAME() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEREGRESSION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_REGRESSION||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEREGRESSION() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEVALUE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_VALUE||''', " + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEVALUE() + ")'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getODMSMISSINGVALUETREATMENT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_MISSING_VALUE_TREATMENT||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getODMSMISSINGVALUETREATMENT() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getODMSROWWEIGHTCOLUMNNAME() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ROW_WEIGHT_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(naiveBayesModelType.getCGeneralizedLinearAlgo().getODMSROWWEIGHTCOLUMNNAME())) + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELCRIT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SEL_CRIT||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELCRIT() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSMAXFEATURES() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_MAX_FEATURES||''', " + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSMAXFEATURES() + ")'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSSELECTBLOCK() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_SELECT_BLOCK||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSSELECTBLOCK() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSPRUNEMODEL() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_PRUNE_MODEL||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSPRUNEMODEL() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRACCEPTANCE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_ACCEPTANCE||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRACCEPTANCE() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELECTION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SELECTION||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELECTION() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENERATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GENERATION||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENERATION() + "'')'); \n");
            }
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENMETHOD() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GEN_METHOD||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENMETHOD() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_GENERALIZED_LINEAR_MODEL||''')'); \n");
            if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRIDENTIFICATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_IDENTIFICATION||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSFTRIDENTIFICATION() + "'')'); \n");
            }
            if (bl) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_WEIGHTS_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSCONVTOLERANCE() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_CONV_TOLERANCE||''', " + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSCONVTOLERANCE() + ")'); \n");
                }
                if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSNUMITERATIONS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_NUM_ITERATIONS||''', " + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSNUMITERATIONS() + ")'); \n");
                }
                if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSBATCHROWS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_BATCH_ROWS||''', " + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSBATCHROWS() + ")'); \n");
                }
                if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSROWDIAGNOSTICS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_ROW_DIAGNOSTICS||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSROWDIAGNOSTICS() + "'')'); \n");
                }
                if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSSOLVER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_SOLVER||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSSOLVER() + "'')'); \n");
                }
                if (naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSSPARSESOLVER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_SPARSE_SOLVER||''', ''" + naiveBayesModelType.getCGeneralizedLinearAlgo().getGLMSSPARSESOLVER() + "'')'); \n");
                }
            }
        }
        if (modelType instanceof ClassificationModelType) {
            naiveBayesModelType = (ClassificationModelType)modelType;
            boolean bl2 = DbVersionHelper.isDB122Up((Version)version);
            if (!bl && naiveBayesModelType.getPerformance().getBalanced() != null && bl2) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_WEIGHTS_BALANCED||''', ''ON'')'); \n");
            }
        }
        return stringBuilder.toString();
    }

    private boolean modelUsesWeights(ModelType modelType, Version version) {
        boolean bl = false;
        if (modelType instanceof ClassificationModelType) {
            boolean bl2 = DbVersionHelper.isDB122Up((Version)version);
            PerformanceType performanceType = ((ClassificationModelType)modelType).getPerformance();
            bl = performanceType.getBalanced() != null && !bl2 || performanceType.getCustom() != null;
        }
        return bl;
    }

    @Override
    protected String getModelTemplatePath() {
        return "workflow_class_build_model.sql";
    }

    @Override
    public Map<String, String> getAdditionalModelCodeTemplateReplacements(Context context, ModelType modelType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.generateClassificationModelCommentCode(modelType);
        hashMap.put("<COMMENT_MODEL>", string);
        String string2 = this.generateTestModelCode(context, modelType);
        hashMap.put("<TEST_MODELS>", string2);
        String string3 = "";
        try {
            string3 = this.generateWeightsCode(context, modelType);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        hashMap.put("<WEIGHTS_SETTING>", string3);
        return hashMap;
    }

    private String generateClassificationModelCommentCode(ModelType modelType) {
        String string = "";
        if (modelType instanceof ClassificationModelType) {
            PerformanceType performanceType = ((ClassificationModelType)modelType).getPerformance();
            string = performanceType.getBalanced() != null ? "  execSQL('COMMENT ON MINING MODEL <MODEL_NAME_PARAM> IS ''BALANCED'''); \n" : (performanceType.getCustom() != null ? "  execSQL('COMMENT ON MINING MODEL <MODEL_NAME_PARAM> IS ''CUSTOM'''); \n" : "  execSQL('COMMENT ON MINING MODEL <MODEL_NAME_PARAM> IS ''NATURAL'''); \n");
        }
        return string;
    }

    @Override
    protected String generateTestModelCode(Context context, ModelType modelType) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        TestDataSource testDataSource = this.getTestDataSource();
        String string2 = "";
        if (testDataSource.getNone() == null) {
            String string3;
            Object object;
            Object object2;
            String string4;
            Object object3;
            Object object4;
            boolean bl = DbVersionHelper.isDB122Up((Version)version) && buildNodeType.getPartitionExpressions() != null && !buildNodeType.getPartitionExpressions().getPartitionExpression().isEmpty();
            string2 = bl ? CodeTemplate.getInstance().getTemplate("workflow_class_test_part_model.sql") : CodeTemplate.getInstance().getTemplate("workflow_class_test_model.sql");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.generateCostMatrixCode(modelType));
            boolean bl2 = false;
            boolean bl3 = false;
            String string5 = null;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("  BEGIN \n");
                stringBuilder.append("    DBMS_DATA_MINING.REMOVE_COST_MATRIX('<MODEL_NAME_PARAM>'); \n");
                stringBuilder.append("  EXCEPTION WHEN OTHERS THEN \n");
                stringBuilder.append("    NULL; -- ignore if no existing cost matrix to drop \n");
                stringBuilder.append("  END; \n");
                stringBuilder.append("  DBMS_DATA_MINING.ADD_COST_MATRIX('<MODEL_NAME_PARAM>', v_cost_setting); \n");
                stringBuilder.append("  execSQL('COMMENT ON MINING MODEL <MODEL_NAME_PARAM> IS ''TUNED'''); \n");
                bl2 = true;
                bl3 = true;
            } else if (modelType instanceof DecisionTreeModelType && ((object4 = (object3 = (DecisionTreeModelType)modelType).getPerformance()).getBalanced() != null || object4.getCustom() != null)) {
                bl2 = true;
                bl3 = true;
            }
            if (bl2) {
                object3 = "COST MODEL AUTO USING *";
                string5 = "COST";
            } else {
                object3 = "USING *";
                string5 = "PROBABILITY";
            }
            object4 = new StringBuilder();
            if (bl2 && bl3) {
                string4 = bl ? "  v_sql := \n    'SELECT DISTINCT PARTITION_NAME FROM '||v_confusion_matrix_part||' WHERE PARTITION_NAME IS NOT NULL'; \n  EXECUTE IMMEDIATE v_sql BULK COLLECT INTO v_partitions; \n  FOR i IN 1..v_partitions.COUNT LOOP \n    v_sql := \n      'INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE) \n      WITH \n      tr_cost AS \n        ( \n          select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n          from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(model_name => :1, partition_name => :2)) \n        ), \n      c_m AS \n        ( \n          select * from '||v_confusion_matrix_part||' where partition_name = :3 \n        ), \n      total_actuals AS \n        ( \n          SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n            SUM(a.VALUE * b.cost) actuals_cost, \n            SUM(a.VALUE) total_actuals \n          FROM c_m a, tr_cost b \n          WHERE a.actual_target_value(+) = b.actual_target_value \n          AND a.predicted_target_value(+) = b.predicted_target_value \n          GROUP BY nvl(a.actual_target_value, b.actual_target_value) \n        ), \n      total_predicted AS \n        ( \n          SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n            SUM(a.VALUE * b.cost) predicted_cost, \n            SUM(a.VALUE) total_predicted \n          FROM c_m a, tr_cost b \n          WHERE a.actual_target_value(+) = b.actual_target_value \n          AND a.predicted_target_value(+) = b.predicted_target_value \n          GROUP BY nvl(a.predicted_target_value, b.predicted_target_value) \n        ), \n      right_predictions AS \n        ( \n          SELECT actual_target_value, \n            VALUE AS correct \n          FROM c_m a \n          WHERE actual_target_value = predicted_target_value \n        ), \n      actuals_total_cost as \n        ( \n          SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n          FROM c_m a, tr_cost b \n          WHERE a.actual_target_value = b.actual_target_value \n          AND a.predicted_target_value = b.predicted_target_value \n        ) \n      SELECT ''COST'', '''||v_partitions(i)||''', NVL(SUM(actuals_cost), 0) \n      FROM total_actuals a, total_predicted p, right_predictions c, actuals_total_cost tc \n      WHERE a.actual_target_value(+) = p.predicted_target_value \n      AND p.predicted_target_value = c.actual_target_value(+)'; \n    EXECUTE IMMEDIATE v_sql USING '<MODEL_NAME_PARAM>', '\"'||v_partitions(i)||'\"', v_partitions(i); \n  END LOOP; \n  v_sql := \n    'INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE) \n    SELECT ''COST'', NULL, SUM(METRIC_NUM_VALUE) FROM '||v_test_metric||' \n    WHERE METRIC_NAME = ''COST'' AND PARTITION_NAME IS NOT NULL'; \n  execSQL(v_sql); \n" : "  v_sql := \n    'INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) \n    WITH \n    tr_cost AS \n      ( \n        select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n        from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(:1)) \n      ), \n    total_actuals AS \n      (SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n         SUM(a.VALUE * b.cost) actuals_cost, \n         SUM(a.VALUE) total_actuals \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value(+) = b.actual_target_value \n       AND a.predicted_target_value(+) = b.predicted_target_value \n       GROUP BY nvl(a.actual_target_value, b.actual_target_value)), \n    total_predicted AS \n      (SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n         SUM(a.VALUE * b.cost) predicted_cost, \n         SUM(a.VALUE) total_predicted \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value(+) = b.actual_target_value \n       AND a.predicted_target_value(+) = b.predicted_target_value \n       GROUP BY nvl(a.predicted_target_value, b.predicted_target_value)), \n    right_predictions AS \n      (SELECT actual_target_value, \n         VALUE AS correct \n       FROM '||v_confusion_matrix||' \n       WHERE actual_target_value = predicted_target_value), \n    actuals_total_cost as \n      (SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value = b.actual_target_value \n       AND a.predicted_target_value = b.predicted_target_value) \n    SELECT ''COST'', NVL(SUM(actuals_cost), 0) \n    FROM total_actuals a, \n      total_predicted p, \n      right_predictions c, \n      actuals_total_cost tc \n    WHERE a.actual_target_value(+) = p.predicted_target_value \n      AND p.predicted_target_value = c.actual_target_value(+)'; \n  EXECUTE IMMEDIATE v_sql USING '<MODEL_NAME_PARAM>'; \n";
                ((StringBuilder)object4).append(string4);
            }
            boolean bl4 = this.isGeneratingLift();
            boolean bl5 = this.isGeneratingROC();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = new StringBuilder();
            if (bl4 || bl5) {
                object2 = this.getTestSettingsMetaData();
                object = object2.getTopNTargets();
                ClassificationTestSettingsType.BottomNTargets bottomNTargets = object2.getBottomNTargets();
                string3 = "DESC";
                int n = 5;
                if (object != null || bottomNTargets != null) {
                    if (bottomNTargets != null) {
                        string3 = "ASC";
                        n = bottomNTargets.getValue().intValue();
                    } else {
                        n = object.getValue().intValue();
                    }
                    string4 = "  -- targets for test results \n  v_sql := \n    'SELECT <PARALLEL_HINT> \"'||v_target||'\" as prediction FROM \n    ( \n      SELECT \"'||v_target||'\", \n      RANK() OVER (ORDER BY count(\"'||v_target||'\") " + string3 + ") \"Rank\" \n      FROM '||v_test_data||'  \n      GROUP BY \"'||v_target||'\" \n    ) \n    WHERE rownum <= " + n + "'; \n  EXECUTE IMMEDIATE v_sql BULK COLLECT INTO v_targets; \n";
                } else {
                    StringBuilder stringBuilder5 = new StringBuilder();
                    int n2 = 0;
                    for (ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue : object2.getSpecificTargets().getTargetValue()) {
                        if (n2 > 0) {
                            stringBuilder5.append(", ");
                        }
                        stringBuilder5.append("'" + StringUtils.escapeSingleQuotesForSQL(targetValue.getValue()) + "'");
                        ++n2;
                    }
                    string4 = "  -- targets for test results \n  v_targets := ODMR_OBJECT_VALUES(" + stringBuilder5.toString() + "); \n";
                }
                stringBuilder4.append(string4);
                if (bl4) {
                    string4 = "  FOR i IN 1..v_targets.COUNT LOOP \n    -- lift for each target \n    v_lift := generateUniqueName; \n    DBMS_DATA_MINING.COMPUTE_LIFT ( \n      apply_result_table_name   => v_apply_data, \n      target_table_name         => v_test_data, \n      case_id_column_name       => v_caseid, \n      target_column_name        => '\"'||v_target||'\"', \n      lift_table_name           => v_lift, \n      positive_target_value     => v_targets(i), \n      score_column_name         => 'PREDICTION', \n      score_criterion_column_name => '<SCORE_CRITERION>', \n      num_quantiles             => 100, \n      score_criterion_type      => '<SCORE_CRITERION>'); \n";
                    if (bl) {
                        string4 = string4 + "    -- partition lift for each target \n    v_lift_part := generateUniqueName; \n    DBMS_DATA_MINING.COMPUTE_LIFT_PART ( \n      apply_result_table_name     => v_apply_data, \n      target_table_name           => v_test_data, \n      case_id_column_name         => v_caseid, \n      target_column_name          => '\"'||v_target||'\"', \n      lift_table_name             => v_lift_part, \n      positive_target_value       => v_targets(i), \n      score_column_name           => 'PREDICTION', \n      score_criterion_column_name => '<SCORE_CRITERION>', \n      num_quantiles               => 100, \n      score_criterion_type        => '<SCORE_CRITERION>', \n      score_partition_column_name => 'PARTITION_NAME'); \n    execSQL('ALTER TABLE '||v_lift_part||' <TABLE_PARALLEL_HINT>'); \n";
                        string4 = bl2 ? string4 + "    execSQL('INSERT INTO '||v_lift_part||' (QUANTILE_NUMBER, COST_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, PARTITION_NAME) \n            SELECT QUANTILE_NUMBER, COST_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, NULL FROM '||v_lift); \n" : string4 + "    execSQL('INSERT INTO '||v_lift_part||' (QUANTILE_NUMBER, PROBABILITY_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, PARTITION_NAME) \n            SELECT QUANTILE_NUMBER, PROBABILITY_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, NULL FROM '||v_lift); \n";
                        string4 = string4 + "    execSQL('DROP TABLE '||v_lift||' PURGE'); \n    recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_lift_part, 'TABLE', v_target||'='||v_targets(i), 'Lift Result'); \n";
                    } else {
                        string4 = string4 + "    recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_lift, 'TABLE', v_target||'='||v_targets(i), 'Lift Result'); \n";
                    }
                    string4 = string4 + "  END LOOP; \n";
                    stringBuilder2.append(string4);
                }
                if (bl5) {
                    string4 = "  -- roc for each target (only binary target support) \n  IF (v_targets.COUNT <= 2) THEN \n    FOR i IN 1..v_targets.COUNT LOOP \n      v_roc := generateUniqueName; \n      DBMS_DATA_MINING.COMPUTE_ROC ( \n        roc_area_under_curve        => v_area_under_curve, \n        apply_result_table_name     => v_apply_data, \n        target_table_name           => v_test_data, \n        case_id_column_name         => v_caseid, \n        target_column_name          => '\"'||v_target||'\"', \n        roc_table_name              => v_roc, \n        positive_target_value       => v_targets(i), \n        score_column_name           => 'PREDICTION', \n        score_criterion_column_name => 'PROBABILITY'); \n";
                    string4 = bl ? string4 + "    -- partition lift for each target \n      v_roc_part := generateUniqueName; \n      DBMS_DATA_MINING.COMPUTE_ROC_PART ( \n        roc_area_under_curve        => v_area_under_curve_nested, \n        apply_result_table_name     => v_apply_data, \n        target_table_name           => v_test_data, \n        case_id_column_name         => v_caseid, \n        target_column_name          => '\"'||v_target||'\"', \n        roc_table_name              => v_roc_part, \n        positive_target_value       => v_targets(i), \n        score_column_name           => 'PREDICTION', \n        score_criterion_column_name => 'PROBABILITY', \n        score_partition_column_name => 'PARTITION_NAME'); \n      execSQL('ALTER TABLE '||v_lift_part||' <TABLE_PARALLEL_HINT>'); \n      execSQL('INSERT INTO '||v_roc_part||' (PROBABILITY, TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES, TRUE_POSITIVE_FRACTION, FALSE_POSITIVE_FRACTION, PARTITION_NAME) \n              SELECT PROBABILITY, TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES, TRUE_POSITIVE_FRACTION, FALSE_POSITIVE_FRACTION, NULL FROM '||v_roc); \n      execSQL('DROP TABLE '||v_roc||' PURGE'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_roc_part, 'TABLE', v_target||'='||v_targets(i), 'ROC Result'); \n      v_area_under_curve_result := generateUniqueName; \n      execSQL('CREATE TABLE '||v_area_under_curve_result||' (PARTITION_NAME VARCHAR2(128), AREA NUMBER) <TABLE_PARALLEL_HINT>'); \n      EXECUTE IMMEDIATE 'INSERT INTO '||v_area_under_curve_result||' (PARTITION_NAME, AREA) \n                        SELECT t.attribute_name, NVL(t.value, 0) FROM TABLE(:1) t' USING v_area_under_curve_nested; \n      EXECUTE IMMEDIATE 'INSERT INTO '||v_area_under_curve_result||' (PARTITION_NAME, AREA) \n                        SELECT NULL, NVL(:1, 0) FROM DUAL' USING v_area_under_curve; \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_area_under_curve_result, 'TABLE', v_target||'='||v_targets(i), 'ROC Area Under Curve'); \n" : string4 + "      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_roc, 'TABLE', v_target||'='||v_targets(i), 'ROC Result'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_area_under_curve, 'SCALAR', v_target||'='||v_targets(i), 'ROC Area Under Curve'); \n";
                    string4 = string4 + "    END LOOP; \n  END IF; \n";
                    stringBuilder3.append(string4);
                }
            }
            object2 = this.getInMemorySettings(context);
            object = (String)object2.get("IN_MEMORY_ON");
            boolean bl6 = false;
            bl6 = object == null || ((String)object).isEmpty() ? false : Boolean.parseBoolean((String)object);
            string3 = (String)object2.get("COMPRESSION_METHOD");
            String string6 = (String)object2.get("PRIORITY_LEVEL");
            if (bl6) {
                string2 = CodeTemplate.updateBodyTemplate(string2, "<COMPRESSION_METHOD>", string3);
                string2 = CodeTemplate.updateBodyTemplate(string2, "<PRIORITY_LEVEL>", string6);
            } else {
                string2 = CodeTemplate.updateBodyTemplate(string2, "<COMPRESSION_METHOD>", "");
                string2 = CodeTemplate.updateBodyTemplate(string2, "<PRIORITY_LEVEL>", "");
            }
            string2 = CodeTemplate.updateBodyTemplate(string2, "<TEST_APPLY_COST_OPTION>", (String)object3);
            string2 = CodeTemplate.updateBodyTemplate(string2, "<COST_SETTING>", stringBuilder.toString());
            string2 = CodeTemplate.updateBodyTemplate(string2, "<COMPUTE_TOTAL_COST>", ((StringBuilder)object4).toString());
            string2 = CodeTemplate.updateBodyTemplate(string2, "<TEST_TARGET_VALUES>", stringBuilder4.toString());
            string2 = CodeTemplate.updateBodyTemplate(string2, "<GEN_LIFT_RESULT>", stringBuilder2.toString());
            string2 = CodeTemplate.updateBodyTemplate(string2, "<GEN_ROC_RESULT>", stringBuilder3.toString());
            string2 = CodeTemplate.updateBodyTemplate(string2, "<SCORE_CRITERION>", string5);
            string2 = CodeTemplate.updateBodyTemplate(string2, "<TABLE_PARALLEL_HINT>", string);
        }
        return string2;
    }

    private String generateCostMatrixCode(ModelType modelType) {
        String string = this.getTargetAttribute().getDataType();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (modelType instanceof ClassificationModelType) {
            TuningType tuningType = ((ClassificationModelType)modelType).getTuning();
            boolean bl2 = bl = tuningType.getBenefit() != null || tuningType.getCost() != null || tuningType.getCustom() != null;
            if (bl) {
                tuningType = ((ClassificationModelType)modelType).getTuning();
                stringBuilder.append("  v_cost_setting := generateUniqueName; \n");
                if (string.indexOf("CHAR") > -1) {
                    stringBuilder.append("  execSQL('CREATE TABLE '||v_cost_setting||' (actual_target_value VARCHAR2(4000), predicted_target_value VARCHAR2(4000), cost NUMBER)'); \n");
                } else {
                    stringBuilder.append("  execSQL('CREATE TABLE '||v_cost_setting||' (actual_target_value NUMBER, predicted_target_value NUMBER, cost NUMBER)'); \n");
                }
                if (tuningType.getCost() != null) {
                    for (CostMatrixType.Item item : tuningType.getCost().getCostMatrix().getItem()) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuilder.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (''" + item.getActual() + "'', ''" + item.getPredict() + "'', " + item.getCost() + ")'); \n");
                            continue;
                        }
                        stringBuilder.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (" + item.getActual() + ", " + item.getPredict() + ", " + item.getCost() + ")'); \n");
                    }
                } else if (tuningType.getCustom() != null) {
                    for (CostMatrixType.Item item : tuningType.getCustom().getCostMatrix().getItem()) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuilder.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (''" + item.getActual() + "'', ''" + item.getPredict() + "'', " + item.getCost() + ")'); \n");
                            continue;
                        }
                        stringBuilder.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (" + item.getActual() + ", " + item.getPredict() + ", " + item.getCost() + ")'); \n");
                    }
                } else if (tuningType.getBenefit() != null) {
                    List list = tuningType.getBenefit().getBenefitWeights().getItem();
                    for (int i = 0; i < list.size(); ++i) {
                        for (int j = 0; j < list.size(); ++j) {
                            double d = i == j ? -1.0 * ((WeightsType.Item)list.get(i)).getWeight() : 0.0;
                            if (string.indexOf("CHAR") > -1) {
                                stringBuilder.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (''" + ((WeightsType.Item)list.get(i)).getTargetValue() + "'', ''" + ((WeightsType.Item)list.get(j)).getTargetValue() + "'', " + d + ")'); \n");
                                continue;
                            }
                            stringBuilder.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (" + ((WeightsType.Item)list.get(i)).getTargetValue() + ", " + ((WeightsType.Item)list.get(j)).getTargetValue() + ", " + d + ")'); \n");
                        }
                    }
                }
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_cost_setting, 'TABLE', NULL, 'Cost Setting'); \n");
            }
        }
        return stringBuilder.toString();
    }

    private boolean isGeneratingROC() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        Boolean bl = null;
        boolean bl2 = true;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            bl = ((ClassificationBuildNodeType)buildNodeType).getResults().isGenROC();
        } else if (buildNodeType instanceof ExtensibleBuildNodeType) {
            bl = ((ExtensibleBuildNodeType)buildNodeType).getResults().isGenROC();
        } else assert (false) : "Non Compatible Meta Data";
        bl2 = bl == null ? true : bl;
        return bl2;
    }

    private boolean isGeneratingLift() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        Boolean bl = null;
        boolean bl2 = true;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            bl = ((ClassificationBuildNodeType)buildNodeType).getResults().isGenLift();
        } else if (buildNodeType instanceof ExtensibleBuildNodeType) {
            bl = ((ExtensibleBuildNodeType)buildNodeType).getResults().isGenLift();
        } else assert (false) : "Non Compatible Meta Data";
        bl2 = bl == null ? true : bl;
        return bl2;
    }

    private ClassificationTestSettingsType getTestSettingsMetaData() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        ClassificationTestSettingsType classificationTestSettingsType = null;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            classificationTestSettingsType = ((ClassificationBuildNodeType)buildNodeType).getTestSettings();
        } else if (buildNodeType instanceof ExtensibleBuildNodeType) {
            classificationTestSettingsType = ((ExtensibleBuildNodeType)buildNodeType).getTestSettings();
        } else assert (false) : "Non Compatible Meta Data";
        return classificationTestSettingsType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateWeightsCode(Context context, ModelType modelType) throws SQLException {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof ClassificationModelType) {
            ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
            PerformanceType performanceType = classificationModelType.getPerformance();
            String string = this.getTargetAttribute().getDataType();
            if (performanceType.getBalanced() != null || performanceType.getCustom() != null) {
                boolean bl = DbVersionHelper.isDB122Up((Version)version);
                if (classificationModelType instanceof NaiveBayesModelType) {
                    if (performanceType.getBalanced() != null && !bl || performanceType.getCustom() != null) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuilder.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE VARCHAR2(4000), PRIOR_PROBABILITY NUMBER)'); \n");
                        } else {
                            stringBuilder.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE NUMBER, PRIOR_PROBABILITY NUMBER)'); \n");
                        }
                    }
                    if (performanceType.getBalanced() != null) {
                        if (!bl) {
                            String string2 = performanceType.getBalanced().getWeightsTable();
                            String string3 = "SELECT TARGET_VALUE, PRIOR_PROBABILITY FROM " + string2;
                            try (SQLHelper sQLHelper = new SQLHelper();){
                                sQLHelper.conn = ConnectionFolder.getConnection(context);
                                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
                                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                                while (sQLHelper.rs.next()) {
                                    Object object;
                                    Double d = sQLHelper.rs.getDouble("PRIOR_PROBABILITY");
                                    if (string.indexOf("CHAR") > -1) {
                                        object = sQLHelper.rs.getString("TARGET_VALUE");
                                        stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + (String)object + "'', " + d + ")'); \n");
                                        continue;
                                    }
                                    object = sQLHelper.rs.getBigDecimal("TARGET_VALUE");
                                    stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + object + ", " + d + ")'); \n");
                                }
                            }
                        }
                    } else if (performanceType.getCustom() != null) {
                        for (WeightsType.Item item : performanceType.getCustom().getWeights().getItem()) {
                            if (string.indexOf("CHAR") > -1) {
                                stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + item.getTargetValue() + "'', " + item.getWeight() + ")'); \n");
                                continue;
                            }
                            stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + item.getTargetValue() + ", " + item.getWeight() + ")'); \n");
                        }
                    }
                } else if (classificationModelType instanceof DecisionTreeModelType) {
                    if (performanceType.getBalanced() != null && !bl || performanceType.getCustom() != null) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuilder.append("  execSQL('CREATE TABLE '||v_weights_setting||' (ACTUAL_TARGET_VALUE VARCHAR2(4000), PREDICTED_TARGET_VALUE VARCHAR2(4000), COST NUMBER)'); \n");
                        } else {
                            stringBuilder.append("  execSQL('CREATE TABLE '||v_weights_setting||' (ACTUAL_TARGET_VALUE NUMBER, PREDICTED_TARGET_VALUE NUMBER, COST NUMBER)'); \n");
                        }
                    }
                    if (performanceType.getBalanced() != null) {
                        if (!bl) {
                            String string4 = performanceType.getBalanced().getWeightsTable();
                            String string5 = "SELECT actual_target_value, predicted_target_value, cost FROM " + string4;
                            try (SQLHelper sQLHelper = new SQLHelper();){
                                sQLHelper.conn = ConnectionFolder.getConnection(context);
                                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
                                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                                while (sQLHelper.rs.next()) {
                                    Object object;
                                    Object object2;
                                    Double d = sQLHelper.rs.getDouble("COST");
                                    if (string.indexOf("CHAR") > -1) {
                                        object2 = sQLHelper.rs.getString("ACTUAL_TARGET_VALUE");
                                        object = sQLHelper.rs.getString("PREDICTED_TARGET_VALUE");
                                        stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + (String)object2 + "'', ''" + (String)object + "'', " + d + ")'); \n");
                                        continue;
                                    }
                                    object2 = sQLHelper.rs.getBigDecimal("ACTUAL_TARGET_VALUE");
                                    object = sQLHelper.rs.getBigDecimal("PREDICTED_TARGET_VALUE");
                                    stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + object2 + ", " + object + ", " + d + ")'); \n");
                                }
                            }
                        }
                    } else if (performanceType.getCustom() != null) {
                        List list = performanceType.getCustom().getWeights().getItem();
                        for (int i = 0; i < list.size(); ++i) {
                            for (int j = 0; j < list.size(); ++j) {
                                double d = i == j ? 0.0 : ((WeightsType.Item)list.get(i)).getWeight();
                                if (string.indexOf("CHAR") > -1) {
                                    stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + ((WeightsType.Item)list.get(i)).getTargetValue() + "'', ''" + ((WeightsType.Item)list.get(j)).getTargetValue() + "'', " + d + ")'); \n");
                                    continue;
                                }
                                stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + ((WeightsType.Item)list.get(i)).getTargetValue() + ", " + ((WeightsType.Item)list.get(j)).getTargetValue() + ", " + d + ")'); \n");
                            }
                        }
                    }
                } else if (classificationModelType instanceof CSupportVectorMachineModelType || classificationModelType instanceof CGeneralizedLinearModelType) {
                    if (performanceType.getBalanced() != null && !bl || performanceType.getCustom() != null) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuilder.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE VARCHAR2(4000), CLASS_WEIGHT NUMBER)'); \n");
                        } else {
                            stringBuilder.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE NUMBER, CLASS_WEIGHT NUMBER)'); \n");
                        }
                    }
                    if (performanceType.getBalanced() != null) {
                        if (!bl) {
                            String string6 = performanceType.getBalanced().getWeightsTable();
                            String string7 = "SELECT TARGET_VALUE, CLASS_WEIGHT FROM " + string6;
                            try (SQLHelper sQLHelper = new SQLHelper();){
                                sQLHelper.conn = ConnectionFolder.getConnection(context);
                                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string7);
                                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                                while (sQLHelper.rs.next()) {
                                    Object object;
                                    Double d = sQLHelper.rs.getDouble("CLASS_WEIGHT");
                                    if (string.indexOf("CHAR") > -1) {
                                        object = sQLHelper.rs.getString("TARGET_VALUE");
                                        stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + (String)object + "'', " + d + ")'); \n");
                                        continue;
                                    }
                                    object = sQLHelper.rs.getBigDecimal("TARGET_VALUE");
                                    stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + object + ", " + d + ")'); \n");
                                }
                            }
                        }
                    } else if (performanceType.getCustom() != null) {
                        for (WeightsType.Item item : performanceType.getCustom().getWeights().getItem()) {
                            if (string.indexOf("CHAR") > -1) {
                                stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + item.getTargetValue() + "'', " + item.getWeight() + ")'); \n");
                                continue;
                            }
                            stringBuilder.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + item.getTargetValue() + ", " + item.getWeight() + ")'); \n");
                        }
                    }
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, "  v_weights_setting := generateUniqueName; \n");
                    stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_weights_setting, 'TABLE', NULL, 'Weights Setting'); \n");
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateBuildTestDataCode(Context context) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        String string = null;
        if (buildNodeType.getCaseAttributes() != null && !buildNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            string = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
        }
        String string2 = null;
        String string3 = null;
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        Map<String, String> map = this.getInMemorySettings(context);
        String string6 = map.get("IN_MEMORY_ON");
        boolean bl = false;
        bl = string6 == null || string6.isEmpty() ? false : Boolean.parseBoolean(string6);
        String string7 = map.get("COMPRESSION_METHOD");
        String string8 = map.get("PRIORITY_LEVEL");
        String string9 = null;
        boolean bl2 = false;
        TestDataSource testDataSource = this.getTestDataSource();
        if (testDataSource.getSplitData() != null) {
            double d = 100.0 - testDataSource.getSplitData().getTestPercent();
            String string10 = "    ( \n      SELECT \"'||v_caseid||'\", \n        <ATTR_LIST> \n        FROM ( \n          WITH  \n          \"A\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " * FROM '||v_input_data||'), \n          \"B.1\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " row_number() OVER(partition by \"'||v_target||'\" ORDER BY ORA_HASH(\"'||v_caseid||'\")) '||v_caseid_alias||', \"'||v_caseid||'\" FROM \"A\" t), \n          \"B.2\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " t.*, p.'||v_caseid_alias||' FROM \"A\" t, \"B.1\" p WHERE t.\"'||v_caseid||'\" = p.\"'||v_caseid||'\"), \n          \"B.3\" as (SELECT \"'||v_target||'\", COUNT(*) '||v_num_row_alias||' FROM \"A\" GROUP BY \"'||v_target||'\"), \n          \"B\" as ( \n            SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " v1.* FROM \"B.2\" v1 ,\"B.3\" v2 \n            WHERE v1.\"'||v_target||'\" = v2.\"'||v_target||'\" \n            AND ORA_HASH(v1.'||v_caseid_alias||', v2.'||v_num_row_alias||'-1, 0) <= (v2.'||v_num_row_alias||' * " + d + " / 100) \n          ) \n          SELECT * from \"B\" \n        ) \n    )'; \n";
            String string11 = "    ( \n      SELECT \"'||v_caseid||'\", \n        <ATTR_LIST> \n        FROM ( \n          WITH \n          \"A\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " * FROM '||v_input_data||'), \n          \"B.1\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " row_number() OVER(partition by \"'||v_target||'\" ORDER BY ORA_HASH(\"'||v_caseid||'\")) '||v_caseid_alias||', \"'||v_caseid||'\" FROM \"A\" t), \n          \"B.2\" as (SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " t.*, p.'||v_caseid_alias||' FROM \"A\" t, \"B.1\" p WHERE t.\"'||v_caseid||'\" = p.\"'||v_caseid||'\"),  \n          \"B.3\" as (SELECT \"'||v_target||'\", COUNT(*) '||v_num_row_alias||' FROM \"A\" GROUP BY \"'||v_target||'\"),  \n          \"B\" as ( \n            SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + " v1.* FROM \"B.2\" v1 ,\"B.3\" v2 \n            WHERE v1.\"'||v_target||'\" = v2.\"'||v_target||'\" \n            AND ORA_HASH(v1.'||v_caseid_alias||', v2.'||v_num_row_alias||'-1, 0) > (v2.'||v_num_row_alias||' * " + d + " / 100) \n          ) \n          SELECT * from \"B\" \n        ) \n    )'; \n";
            string9 = "\n";
            string9 = string9 + "  v_caseid_alias := generateUniqueName; \n";
            string9 = string9 + "  v_num_row_alias := generateUniqueName; \n";
            boolean bl3 = true;
            StringBuilder stringBuilder = new StringBuilder();
            if (bl3) {
                string2 = "TABLE";
                string3 = "TABLE";
                try {
                    for (Object object : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (object.getInput().compareToIgnoreCase("Yes") != 0 || string != null && object.getName().compareTo(string) == 0) continue;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",\n        ");
                        }
                        stringBuilder.append(StringUtils.addDoubleQuotes(object.getName()));
                    }
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (MiningAttributeType miningAttributeType : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (miningAttributeType.getInput().compareToIgnoreCase("Yes") != 0 && miningAttributeType.getInput().compareToIgnoreCase("Maybe") != 0) continue;
                        if (miningAttributeType.getDataType().compareToIgnoreCase("CLOB") == 0 || miningAttributeType.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                            if (stringBuilder2.length() > 0) {
                                stringBuilder2.append(",\n        ");
                            }
                            stringBuilder2.append("LOB(" + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (miningAttributeType.getDataType().contains("NESTED")) {
                            if (stringBuilder2.length() > 0) {
                                stringBuilder2.append(",\n        ");
                            }
                            stringBuilder2.append("NESTED TABLE " + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (miningAttributeType.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(",\n        ");
                        }
                        stringBuilder2.append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + " STORE AS BASICFILE CLOB");
                    }
                    string9 = string9 + "  v_build_data := generateUniqueName; \n";
                    string9 = string9 + "  v_test_data := generateUniqueName; \n";
                    string9 = string9 + "\n";
                    string9 = string9 + "  _START_CHECK_SQL_SIZE_ \n";
                    string9 = string9 + "  v_sql := \n";
                    string9 = string9 + "    'CREATE TABLE '||v_build_data||' \n";
                    string9 = string9 + "        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n";
                    string9 = string9 + "    AS SELECT <PARALLEL_HINT> * FROM \n" + string10;
                    string9 = string9 + "  execSQL(v_sql); \n";
                    string9 = string9 + "  _END_CHECK_SQL_SIZE_ \n";
                    string9 = StringUtils.getReplacedString(string9, "<STORAGE_CLAUSE>", stringBuilder2.toString());
                    string9 = StringUtils.getReplacedString(string9, "<TABLE_PARALLEL_HINT>", string5);
                    string9 = StringUtils.getReplacedString(string9, "<PARALLEL_HINT>", string4);
                    string9 = StringUtils.getReplacedString(string9, "<ATTR_LIST>", stringBuilder.toString());
                    string9 = string9 + "\n";
                    if (bl) {
                        string9 = string9 + "\n";
                        string9 = string9 + "  v_sql := \n";
                        string9 = string9 + "    'ALTER TABLE '||v_build_data||' \n";
                        string9 = string9 + "        <COMPRESSION_CLAUSE> <PRIORITY_CLAUSE>';\n";
                        string9 = string9 + "\n";
                        string9 = string9 + "  execSQL(v_sql); ";
                        string9 = string9 + "\n";
                        string9 = StringUtils.getReplacedString(string9, "<COMPRESSION_CLAUSE>", string7);
                        string9 = StringUtils.getReplacedString(string9, "<PRIORITY_CLAUSE>", string8);
                    }
                    string9 = string9 + "  _START_CHECK_SQL_SIZE_ \n";
                    string9 = string9 + "  v_sql := \n";
                    string9 = string9 + "    'CREATE TABLE '||v_test_data||' \n";
                    string9 = string9 + "        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n";
                    string9 = string9 + "    AS SELECT <PARALLEL_HINT> * FROM \n" + string11;
                    string9 = string9 + "  execSQL(v_sql); \n";
                    string9 = string9 + "  _END_CHECK_SQL_SIZE_ \n";
                    string9 = StringUtils.getReplacedString(string9, "<STORAGE_CLAUSE>", stringBuilder2.toString());
                    string9 = StringUtils.getReplacedString(string9, "<TABLE_PARALLEL_HINT>", string5);
                    string9 = StringUtils.getReplacedString(string9, "<PARALLEL_HINT>", string4);
                    string9 = StringUtils.getReplacedString(string9, "<ATTR_LIST>", stringBuilder.toString());
                    if (bl) {
                        string9 = string9 + "\n";
                        string9 = string9 + "  v_sql := \n";
                        string9 = string9 + "    'ALTER TABLE '||v_test_data||' \n";
                        string9 = string9 + "        <COMPRESSION_CLAUSE> <PRIORITY_CLAUSE>';\n";
                        string9 = string9 + "\n";
                        string9 = string9 + "  execSQL(v_sql); ";
                        string9 = string9 + "\n";
                        string9 = StringUtils.getReplacedString(string9, "<COMPRESSION_CLAUSE>", string7);
                        string9 = StringUtils.getReplacedString(string9, "<PRIORITY_CLAUSE>", string8);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else {
                for (MiningAttributeType miningAttributeType : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                    if (miningAttributeType.getInput().compareToIgnoreCase("Yes") != 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",\n        ");
                    }
                    stringBuilder.append(StringUtils.addDoubleQuotes(miningAttributeType.getName()));
                }
                Object object = StringUtils.getReplacedString(string10, "<ATTR_LIST>", stringBuilder.toString());
                string9 = string9 + "  v_build_data := generateUniqueName; \n";
                string9 = string9 + "  v_test_data := generateUniqueName; \n";
                string9 = string9 + "\n";
                string9 = string9 + "  _START_CHECK_SQL_SIZE_ \n";
                string9 = string9 + "  v_sql := \n";
                string9 = string9 + "    'CREATE VIEW '||v_build_data||' AS SELECT <PARALLEL_HINT> * FROM \n" + (String)object;
                string9 = string9 + "  execSQL(v_sql); \n";
                string9 = string9 + "  _END_CHECK_SQL_SIZE_ \n";
                object = StringUtils.getReplacedString(string11, "<ATTR_LIST>", stringBuilder.toString());
                string9 = string9 + "\n";
                string9 = string9 + "  _START_CHECK_SQL_SIZE_ \n";
                string9 = string9 + "  v_sql := \n";
                string9 = string9 + "    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n" + (String)object;
                string9 = string9 + "  execSQL(v_sql); \n";
                string9 = string9 + "  _END_CHECK_SQL_SIZE_ \n";
                string9 = StringUtils.getReplacedString(string9, "<PARALLEL_HINT>", string4);
            }
            bl2 = true;
        } else if (testDataSource.getTestData() != null) {
            String string12 = testDataSource.getTestData().getSourceId();
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
                string9 = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT t.*  \n      FROM '||getInputSource('" + string12 + "')||' t \n    )'; \n  execSQL(v_sql); \n";
                string9 = StringUtils.getReplacedString(string9, "<PARALLEL_HINT>", string4);
            } else {
                Object object;
                Object object2;
                Object object32;
                String string13 = null;
                List<Object> list = new ArrayList();
                list = this.getModel().findLinksToNode((IlvSDMNode)this);
                for (Object object32 : list) {
                    object2 = (AbstractNode)((GeneralLink)object32).getFrom();
                    if (!((AbstractNode)object2).getMetadataId().equals(string12)) continue;
                    object = (AbstractDataNode)object2;
                    string13 = ((AbstractDataNode)object).getInputSQL();
                    break;
                }
                Object object4 = null;
                object32 = null;
                object2 = new StringBuilder();
                object = ConnectionFolder.getConnectionFolder(context);
                try {
                    object4 = ConnectionFolder.getUserAccountName(context);
                    object32 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", (ConnectionManager)object);
                    string13 = "SELECT * FROM (" + string13 + ")";
                    DatabaseMetadataUtils.createViewAs((ConnectionManager)object, string13, (String)object4, (String)object32);
                    Map<String, DatabaseMetadataUtils.ColumnInfo> map2 = DatabaseMetadataUtils.getColumnInfo(context, (String)object32);
                    for (DatabaseMetadataUtils.ColumnInfo columnInfo : map2.values()) {
                        if (columnInfo.getDataType().compareToIgnoreCase("CLOB") == 0 || columnInfo.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                            if (((StringBuilder)object2).length() > 0) {
                                ((StringBuilder)object2).append(",\n        ");
                            }
                            ((StringBuilder)object2).append("LOB(" + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (columnInfo.getDataType().contains("NESTED")) {
                            if (((StringBuilder)object2).length() > 0) {
                                ((StringBuilder)object2).append(",\n        ");
                            }
                            ((StringBuilder)object2).append("NESTED TABLE " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (columnInfo.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                        if (((StringBuilder)object2).length() > 0) {
                            ((StringBuilder)object2).append(",\n        ");
                        }
                        ((StringBuilder)object2).append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS BASICFILE CLOB");
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                finally {
                    try {
                        DatabaseMetadataUtils.dropView((ConnectionManager)object, (String)object4, (String)object32);
                    }
                    catch (SQLException sQLException) {
                        theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    }
                }
                string2 = "TABLE";
                string3 = "TABLE";
                string9 = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE TABLE '||v_test_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM '||v_caseid||', t.*  \n      FROM '||getInputSource('" + string12 + "')||' t \n    )'; \n  execSQL(v_sql); \n";
                string9 = StringUtils.getReplacedString(string9, "<STORAGE_CLAUSE>", ((StringBuilder)object2).toString());
                string9 = StringUtils.getReplacedString(string9, "<TABLE_PARALLEL_HINT>", string5);
                string9 = StringUtils.getReplacedString(string9, "<PARALLEL_HINT>", string4);
                if (bl) {
                    string9 = string9 + "\n";
                    string9 = string9 + "    'ALTER TABLE '||v_test_data||' \n";
                    string9 = string9 + "        <COMPRESSION_CLAUSE> <PRIORITY_CLAUSE>';\n";
                    string9 = string9 + "\n";
                    string9 = string9 + "  execSQL(v_sql); ";
                    string9 = string9 + "\n";
                    string9 = StringUtils.getReplacedString(string9, "<COMPRESSION_CLAUSE>", string7);
                    string9 = StringUtils.getReplacedString(string9, "<PRIORITY_CLAUSE>", string8);
                }
            }
            bl2 = true;
        } else if (testDataSource.getBuildData() != null) {
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
            } else {
                string2 = "TABLE";
                string3 = "TABLE";
            }
            string9 = "  \n  v_build_data := v_input_data; \n  v_test_data := v_build_data; \n";
            bl2 = true;
        } else {
            string2 = string != null ? "VIEW" : "TABLE";
            string9 = "  \n  v_build_data := v_input_data; \n";
            bl2 = false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string9);
        stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_build_data, '" + string2 + "', NULL, 'Build Data');\n");
        if (bl2) {
            stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_test_data, '" + string3 + "', NULL, 'Test Data');\n");
        }
        return stringBuilder.toString();
    }
}

