/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.inspect.columnFilterDetails.FilterDetailsPreferenceSettings;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.ExtractQueryFactory;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Version;

public final class FilterDetailsDataNode
extends AbstractTransformNode
implements DataConsumer {
    public static final String FILTER_DETAILS_SPECIFICATION = "FilterDetailsSpecification";
    public static final String SQL_EXPRESSION = "SQL_EXPRESSION";
    public static final String SQL_EXPRESSION_GENERATE = "SQL_EXPRESSION_GENERATE";
    private static Preferences _p = Preferences.getPreferences();
    private FilterDetailsPreferenceSettings _filterDetailsPreferenceSettings = FilterDetailsPreferenceSettings.getInstance((PropertyStorage)_p);

    public FilterDetailsDataNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        FilterDetailsOutputType filterDetailsOutputType = new FilterDetailsOutputType();
        Attributes attributes = new Attributes();
        filterDetailsOutputType.setAttributes(attributes);
        filterDetailsOutputType.setType(null);
        filterDetailsDataNodeType.setFilterDetailsOutput(filterDetailsOutputType);
        if (this._filterDetailsPreferenceSettings.getAutomaticSetting()) {
            filterDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
        } else {
            filterDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"No"));
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_COLUMN_FILTER_DETAILS_NODE_NAME");
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SQL_EXPRESSION)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        if (string.equals(FILTER_DETAILS_SPECIFICATION)) {
            FilterDetailsOutputType filterDetailsOutputType = filterDetailsDataNodeType.getFilterDetailsOutput();
            return filterDetailsOutputType;
        }
        if (string.equals(SQL_EXPRESSION)) {
            String string2 = filterDetailsDataNodeType.getSQLExpression();
            return string2;
        }
        return super.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        if (string.equals(FILTER_DETAILS_SPECIFICATION)) {
            FilterDetailsOutputType filterDetailsOutputType = (FilterDetailsOutputType)object;
            filterDetailsDataNodeType.setFilterDetailsOutput(filterDetailsOutputType);
        } else if (string.equals(SQL_EXPRESSION)) {
            if (SQL_EXPRESSION_GENERATE.equals(object)) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    public ColumnFilterNode getSourceNode() {
        ColumnFilterNode columnFilterNode = null;
        List<AbstractNode> list = this.findParentNodes();
        columnFilterNode = list.size() == 0 ? null : (list.get(0) instanceof ColumnFilterNode ? (ColumnFilterNode)list.get(0) : null);
        return columnFilterNode;
    }

    @Override
    public boolean validate(boolean bl) {
        String string;
        boolean bl2 = true;
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        FilterDetailsOutputType filterDetailsOutputType = filterDetailsDataNodeType.getFilterDetailsOutput();
        boolean bl3 = this.isNodeUndefined();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ColumnFilterNode columnFilterNode = this.getSourceNode();
        bl2 = super.validate(bl);
        if (columnFilterNode == null) {
            this.addMessage("COLUMN_FILTER_DETAIL_NO_COLUMN_FILTER", MessageEnumType.INCOMPLETE, new String[0]);
            bl2 = false;
        }
        if (bl2 && bl3) {
            bl = true;
            if (filterDetailsDataNodeType.getFilterDetailsOutput().getAutoSpec().value().compareTo("Yes") == 0) {
                filterDetailsOutputType = this.getDefaultFilterDetailOutputType(columnFilterNode);
            }
            if (filterDetailsOutputType != null) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), FILTER_DETAILS_SPECIFICATION, filterDetailsOutputType);
            }
        } else if (bl2 && !bl3 && !this.validateAIIsSpecified(columnFilterNode, filterDetailsOutputType)) {
            string = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
            if (DbVersionHelper.isDB122Up((Version)string)) {
                this.addMessage("COLUMN_FILTER_DETAIL_NO_OUTPUT_TYPE", MessageEnumType.INCOMPLETE, new String[0]);
            } else {
                this.addMessage("COLUMN_FILTER_DETAIL_OUTPUT_TYPE_NOT_AVAILABLE", MessageEnumType.INCOMPLETE, new String[0]);
                if (filterDetailsDataNodeType.getFilterDetailsOutput().getAutoSpec().value().compareTo("Yes") == 0 && (filterDetailsOutputType = this.getDefaultFilterDetailOutputType(columnFilterNode)) != null) {
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), FILTER_DETAILS_SPECIFICATION, filterDetailsOutputType);
                }
            }
            bl2 = false;
        }
        if (bl2 && (filterDetailsOutputType == null || filterDetailsOutputType.getType() == null)) {
            this.addMessage("COLUMN_FILTER_DETAIL_NO_OUTPUT_TYPE", MessageEnumType.INCOMPLETE, new String[0]);
            bl2 = false;
        }
        if (bl2 && filterDetailsOutputType.getAttributes().getAttribute().size() == 0) {
            this.addMessage("COLUMN_FILTER_DETAIL_NO_OUTPUT_COLUMNS", MessageEnumType.INCOMPLETE, new String[0]);
            bl2 = false;
        }
        if (bl2 && !this.areColumnsValid(filterDetailsOutputType.getAttributes().getAttribute())) {
            this.addMessage("COLUMN_FILTER_DETAIL_INVALID_OUTPUT_COLUMNS", MessageEnumType.INCOMPLETE, new String[0]);
            bl2 = false;
        }
        if (bl2 && bl) {
            this.validateChildren();
        }
        string = "";
        if (bl2) {
            filterDetailsDataNodeType.setSQLExpression(this.generateSQLExpression());
            string = this.getSQLExpression();
        } else {
            filterDetailsDataNodeType.setSQLExpression(string);
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SQL_EXPRESSION, string);
        this.setState(bl2);
        return bl2;
    }

    private boolean validateAIIsSpecified(Node node, FilterDetailsOutputType filterDetailsOutputType) {
        boolean bl = false;
        if (node == null) {
            return bl;
        }
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)node;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        Version version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        if (DbVersionHelper.isDB122Up((Version)version)) {
            if (columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput()) {
                bl = true;
            }
        } else if (columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute() != null && columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput()) {
            bl = true;
        }
        return bl;
    }

    private boolean areColumnsValid(List<AttributeType> list) {
        boolean bl = true;
        for (AttributeType attributeType : list) {
            if (attributeType.getStatus().compareTo((Enum)AttributeStatus.INVALID) != 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        for (AttributeType attributeType : filterDetailsDataNodeType.getFilterDetailsOutput().getAttributes().getAttribute()) {
            AttributeType attributeType2 = new AttributeType();
            String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
            attributeType2.setName(string);
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setStatus(attributeType.getStatus());
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        boolean bl = this.isNodeUndefined();
        FilterDetailsOutputType filterDetailsOutputType = null;
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        if (filterDetailsDataNodeType.getFilterDetailsOutput().getAutoSpec().value().equals("Yes") && (filterDetailsOutputType = this.automaticHandleNewConnectionFrom(node, bl)) != null) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), FILTER_DETAILS_SPECIFICATION, filterDetailsOutputType);
        }
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        FilterDetailsOutputType filterDetailsOutputType = filterDetailsDataNodeType.getFilterDetailsOutput();
        if (filterDetailsOutputType != null && filterDetailsDataNodeType.getFilterDetailsOutput().getAutoSpec().value().equals("Yes")) {
            filterDetailsOutputType.setType(null);
            filterDetailsOutputType.getAttributes().getAttribute().clear();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), FILTER_DETAILS_SPECIFICATION, filterDetailsOutputType);
        }
        this.validate(false);
    }

    private FilterDetailsOutputType automaticHandleNewConnectionFrom(Node node, boolean bl) {
        FilterDetailsOutputType filterDetailsOutputType = null;
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        filterDetailsOutputType = bl ? this.getDefaultFilterDetailOutputType(node) : filterDetailsDataNodeType.getFilterDetailsOutput();
        return filterDetailsOutputType;
    }

    private FilterDetailsOutputType getDefaultFilterDetailOutputType(Node node) {
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        FilterDetailsOutputType filterDetailsOutputType = new FilterDetailsOutputType();
        Attributes attributes = new Attributes();
        filterDetailsOutputType.setAttributes(attributes);
        FilterDetailType filterDetailType = null;
        if (node == null) {
            return filterDetailsOutputType;
        }
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)node;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        List<Object> list = new ArrayList();
        Version version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        if (DbVersionHelper.isDB122Up((Version)version)) {
            if (columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput()) {
                filterDetailType = FilterDetailType.ATTRIBUTE_IMPORTANCE;
            }
            list = ExtractQueryFactory.getFilterColumnList(filterDetailType, filterDetailsDataNodeType.getFilterDetailsOutput().getAttributes().getAttribute(), columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput(), null);
        } else if (columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute() != null && columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput() && columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput() != null && columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput().length() > 0) {
            filterDetailType = FilterDetailType.ATTRIBUTE_IMPORTANCE;
        }
        filterDetailsOutputType.setType(filterDetailType);
        filterDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(list));
        filterDetailsOutputType.setAutoSpec(filterDetailsDataNodeType.getFilterDetailsOutput().getAutoSpec());
        return filterDetailsOutputType;
    }

    private boolean isNodeUndefined() {
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        Attributes attributes = filterDetailsDataNodeType.getFilterDetailsOutput().getAttributes();
        FilterDetailType filterDetailType = filterDetailsDataNodeType.getFilterDetailsOutput().getType();
        return attributes.getAttribute().size() == 0 || filterDetailType == null;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        List<AbstractNode> list = this.findParentNodes();
        if (list.size() > 0) {
            return false;
        }
        bl = node instanceof ColumnFilterNode;
        return bl;
    }

    @Override
    public void refactor(Node node, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SQL_EXPRESSION, SQL_EXPRESSION_GENERATE);
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        FilterDetailsOutputType filterDetailsOutputType = filterDetailsDataNodeType.getFilterDetailsOutput();
        FilterDetailsOutputType filterDetailsOutputType2 = (FilterDetailsOutputType)MetaDataHelper.copyMetadataObject(filterDetailsOutputType);
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        List list = filterDetailsOutputType2.getAttributes().getAttribute();
        if (!hashMap.isEmpty()) {
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
                AttributeType attributeType3 = map.get(attributeType.getName());
                if (attributeType.getName().equals(attributeType3.getName()) && attributeType.getDataType().equals(attributeType3.getDataType())) continue;
                String string = attributeType.getName();
                attributeType2.setName(attributeType3.getName());
                attributeType2.setDataType(attributeType3.getDataType());
                hashMap.put(string, attributeType2);
                attributeType.setName(attributeType3.getName());
                attributeType.setDataType(attributeType3.getDataType());
            }
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), FILTER_DETAILS_SPECIFICATION, filterDetailsOutputType2);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public String generateSQLExpression() {
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        if (filterDetailsDataNodeType.getFilterDetailsOutput().getType() != null) {
            String string = "";
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof ColumnFilterNode)) continue;
                if (filterDetailsDataNodeType.getFilterDetailsOutput().getType().equals((Object)FilterDetailType.ATTRIBUTE_IMPORTANCE)) {
                    string = ((ColumnFilterNodeType)abstractNode.getData()).getColumnFilterResults().getAttrImportanceOutput();
                    break;
                }
                if (!filterDetailsDataNodeType.getFilterDetailsOutput().getType().equals((Object)FilterDetailType.ATTRIBUTE_DEPENDENCIES)) break;
                string = ((ColumnFilterNodeType)abstractNode.getData()).getColumnFilterResults().getAttrDependencyOutput();
                break;
            }
            return this.wrapExpressionInWithClause(ExtractQueryFactory.createColumnQuery(filterDetailsDataNodeType.getFilterDetailsOutput().getType(), filterDetailsDataNodeType.getFilterDetailsOutput().getAttributes().getAttribute(), string, null));
        }
        return null;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) {
        Object object;
        Object object2;
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)this.getData();
        String string2 = "";
        if (filterDetailsDataNodeType.getFilterDetailsOutput().getType().equals((Object)FilterDetailType.ATTRIBUTE_IMPORTANCE) || filterDetailsDataNodeType.getFilterDetailsOutput().getType().equals((Object)FilterDetailType.ATTRIBUTE_DEPENDENCIES)) {
            object2 = this.findParentNodes();
            object = object2.iterator();
            while (object.hasNext()) {
                AbstractNode abstractNode = object.next();
                if (!(abstractNode instanceof ColumnFilterNode)) continue;
                string2 = "'||getInputSource('" + abstractNode.getMetadataId() + "')||'";
                break;
            }
        }
        object2 = ExtractQueryFactory.createColumnQuery(filterDetailsDataNodeType.getFilterDetailsOutput().getType(), filterDetailsDataNodeType.getFilterDetailsOutput().getAttributes().getAttribute(), string2, null);
        object = CodeTemplate.updateBodyTemplate(string, "<SQL_EXPRESSION>", (String)object2);
        return object;
    }

    protected void getInternalStackedSQL(AbstractDataNode abstractDataNode, StringBuffer stringBuffer) {
    }

    @Override
    public String getHelpTopic() {
        return "columnfilterdetails_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_COLUMN_FILTER_DETAILS_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_DETAILS_ICON"));
    }

    public boolean getIsADselected() {
        ColumnFilterNode columnFilterNode = this.getSourceNode();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        boolean bl = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().isAttributeDependency() != null && columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().isAttributeDependency() != false;
        return bl;
    }
}

