/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvMutableSDMLink;
import ilog.views.sdm.model.IlvMutableSDMNode;
import ilog.views.sdm.model.IlvSDMLink;
import ilog.views.sdm.model.IlvSDMNode;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.Link;
import oracle.dmt.dataminer.workflow.model.LinkLrb;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeTypeMappingUtils;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ConnectorGraphicsInfo;
import oracle.dmt.dataminer.workflow.xmlschema.Coordinates;
import oracle.dmt.dataminer.workflow.xmlschema.LinkType;
import oracle.ide.Context;

public final class GeneralLink
extends AbstractObject
implements IlvSDMLink,
IlvMutableSDMLink,
Link {
    private static final Logger theLogger = Logger.getLogger(GeneralLink.class.getName());
    private LinkType _jaxbData;
    private AbstractNode _from;
    private AbstractNode _to;
    public static final String LINK_TO = LinkLrb.get("LINK_TO");
    public static final String LINK_FROM = LinkLrb.get("LINK_FROM");
    public static final String EMPTY_LABEL = " ";
    public static final String SPACE = " ";
    public static final String QUOTE = "\"";

    public GeneralLink(String string, LinkType linkType, Context context) {
        super(string, context);
        this._jaxbData = linkType;
    }

    private static GeneralLink createLink(String string, LinkType linkType, Context context) throws Exception {
        GeneralLink generalLink = null;
        generalLink = new GeneralLink(string, linkType, context);
        if (linkType == null) {
            generalLink.initInstance();
        }
        return generalLink;
    }

    public static GeneralLink createLink(LinkType linkType, AbstractNode abstractNode, AbstractNode abstractNode2, Context context) throws Exception {
        GeneralLink generalLink = null;
        Class clazz = NodeTypeMappingUtils.getNodeClassForDataClass(linkType.getClass());
        generalLink = GeneralLink.createLink(clazz.getSimpleName(), linkType, context);
        generalLink.setTo((IlvSDMNode)abstractNode);
        generalLink.setFrom((IlvSDMNode)abstractNode2);
        linkType.setLabel(GeneralLink.generateLinkName(abstractNode2.getData().getName(), abstractNode.getData().getName()));
        return generalLink;
    }

    public static GeneralLink createLink(String string, Context context) throws Exception {
        return GeneralLink.createLink(string, null, context);
    }

    protected void initInstance() {
        Object object;
        try {
            object = Class.forName(LinkType.class.getPackage().getName() + "." + this.getTag() + "Type");
            this._jaxbData = (LinkType)((Class)object).newInstance();
            this._jaxbData.setLabel(EMPTY_LABEL);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        object = new ConnectorGraphicsInfo();
        Coordinates coordinates = new Coordinates();
        coordinates.setXCoordinate(0.0);
        coordinates.setYCoordinate(0.0);
        object.getCoordinates().add(coordinates);
        this._jaxbData.setConnectorGraphicsInfo((ConnectorGraphicsInfo)object);
    }

    public static String generateLinkName(String string, String string2) {
        return LINK_FROM + SPACE + QUOTE + string + QUOTE + SPACE + LINK_TO + SPACE + QUOTE + string2 + QUOTE;
    }

    public static String generateLinkName(IlvSDMNode ilvSDMNode, IlvSDMNode ilvSDMNode2) {
        assert (ilvSDMNode instanceof Node);
        assert (ilvSDMNode2 instanceof Node);
        Node node = (Node)ilvSDMNode;
        Node node2 = (Node)ilvSDMNode2;
        return GeneralLink.generateLinkName(node.getData().getName(), node2.getData().getName());
    }

    @Override
    public IlvSDMNode getFrom() {
        return this._from;
    }

    public void setFrom(IlvSDMNode ilvSDMNode) {
        this._from = (AbstractNode)ilvSDMNode;
        this._jaxbData.setFrom(this._from.getMetadataId());
    }

    public void setTo(IlvSDMNode ilvSDMNode) {
        this._to = (AbstractNode)ilvSDMNode;
        this._jaxbData.setTo(this._to.getMetadataId());
    }

    @Override
    public IlvSDMNode getTo() {
        return this._to;
    }

    public WorkflowModel getModel() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
        return workflowModel;
    }

    public String getProperty(String string) {
        try {
            if (string.equals("status")) {
                AbstractNode abstractNode = (AbstractNode)this.getTo();
                AbstractNode abstractNode2 = (AbstractNode)this.getFrom();
                if (this.isInRunChain(abstractNode2, abstractNode)) {
                    return "NotRunning";
                }
                return "Idle";
            }
            if (string.equals("label")) {
                String string2 = this.getData().getLabel();
                return string2;
            }
            if (string.equals("tooltip")) {
                return this.getProperty("label");
            }
            if (string.equals("metadata")) {
                return this.metadataToXML();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    public void setProperty(String string, Object object) {
        try {
            if (string.equals("label")) {
                this.getData().setLabel((String)object);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public String[] getDependentProperties(String string) {
        String[] stringArray = new String[]{};
        if (string.equals("tooltip")) {
            stringArray = new String[]{"label"};
        }
        return stringArray;
    }

    private boolean isInRunChain(AbstractNode abstractNode, AbstractNode abstractNode2) {
        return abstractNode.isInRunChain() && abstractNode2.isInRunChain();
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{"metadata"};
        return stringArray;
    }

    public Enumeration getChildren() {
        return null;
    }

    public void addChild(IlvMutableSDMNode ilvMutableSDMNode, IlvMutableSDMNode ilvMutableSDMNode2) {
    }

    public void removeChild(IlvMutableSDMNode ilvMutableSDMNode) {
    }

    public IlvSDMNode getParent() {
        return null;
    }

    public void setParent(IlvMutableSDMNode ilvMutableSDMNode) {
    }

    @Override
    public LinkType getData() {
        return this._jaxbData;
    }

    @Override
    public void setMetadataId(String string) {
        this.getData().setId(string);
    }

    @Override
    public String getMetadataId() {
        return this.getData().getId();
    }

    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_LINK_NAME");
    }

    public String metadataToXML() {
        String string = null;
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = Workflow.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)new JAXBElement(new QName("", "local"), LinkType.class, (Object)this._jaxbData), (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string;
    }

    public LinkType metadataFromXML(String string) {
        StringReader stringReader = new StringReader(string);
        JAXBElement jAXBElement = null;
        try {
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            jAXBElement = (JAXBElement)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return (LinkType)jAXBElement.getValue();
    }
}

