/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Array;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.WithClauseNoInputException;
import oracle.dmt.dataminer.expressionbuilder2.WithClauseViewOutputException;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryOutputColumnsType;
import oracle.ide.Context;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;

public final class SQLQueryNode
extends AbstractTransformNode
implements DataConsumer,
ApplyChainNode {
    private static final Logger theLogger = Logger.getLogger(SQLQueryNode.class.getName());
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;
    public static final String SQLQUERY_EXPRESSION = "SQLQueryExpression";
    public static final String SQLQUERY_OUTPUT_COLUMNS = "SQLQueryOutputColumns";
    public static final String HAS_WITH_CLAUSE = "HasWithClause";
    public static final String GENERATE_VIEW = "GenerateView";
    public static final String VIEW_NAME = "viewName";

    public SQLQueryNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        SQLQueryOutputColumnsType sQLQueryOutputColumnsType = new SQLQueryOutputColumnsType();
        sQLQueryNodeType.setSQLQueryOutputColumns(sQLQueryOutputColumnsType);
        sQLQueryNodeType.setHasWithClause(false);
        sQLQueryNodeType.setGenerateView(false);
        sQLQueryNodeType.setStatus(NodeStatusType.INVALID);
        String string = "";
        try {
            string = WorkflowUtils.getNewOutputTableNameWfid(context);
            sQLQueryNodeType.setViewName(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_SQL_QUERY_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        for (AttributeType attributeType : sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute()) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            attributeType2.setAlias(null);
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setStatus(attributeType.getStatus());
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    public List<AbstractNode> findSourceNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider) && !(abstractNode instanceof ModelProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public boolean validateOLD(boolean bl) {
        Object object;
        boolean bl2 = super.validate(bl);
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        Vector<ColumnDataRow> vector = new Vector<ColumnDataRow>();
        boolean bl3 = false;
        boolean bl4 = false;
        SQLQueryOutputColumnsType sQLQueryOutputColumnsType = new SQLQueryOutputColumnsType();
        if (sQLQueryNodeType.getSQLQueryExpression() != null && sQLQueryNodeType.getSQLQueryExpression().length() > 0) {
            try {
                this.validateSQLExpression(sQLQueryNodeType.getSQLQueryExpression(), vector);
                for (ColumnDataRow object22 : vector) {
                    object = object22.getName();
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName((String)object);
                    attributeType.setDataType(object22.getDataType());
                    attributeType.setStatus(AttributeStatus.VALID);
                    sQLQueryOutputColumnsType.getAttribute().add(attributeType);
                }
                bl3 = true;
            }
            catch (WithClauseNoInputException withClauseNoInputException) {
                this.addMessage("SQL_QUERY_WITH_CLAUSE_NO_INPUT", MessageEnumType.WARNING, new String[0]);
                bl3 = true;
                bl2 = false;
            }
            catch (WithClauseViewOutputException withClauseViewOutputException) {
                this.addMessage("SQL_QUERY_WITH_CLAUSE_NO_VIEW", MessageEnumType.WARNING, new String[0]);
                bl3 = true;
                bl2 = false;
            }
            catch (Exception exception) {
                this.addMessage("SQL_QUERY_INVAL_SQL", MessageEnumType.WARNING, new String[0]);
                bl3 = true;
                bl2 = false;
            }
            bl4 = true;
        } else if (sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute().size() > 0) {
            bl3 = true;
        }
        ArrayList arrayList = new ArrayList();
        if (bl4) {
            ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty.setOldData(this.getSQLExpression());
            arrayList.add(complexProperty);
        }
        if (bl3) {
            SQLQueryOutputColumnsType sQLQueryOutputColumnsType2 = (SQLQueryOutputColumnsType)MetaDataHelper.copyMetadataObject(sQLQueryNodeType.getSQLQueryOutputColumns());
            object = new ComplexProperty(SQLQUERY_OUTPUT_COLUMNS, sQLQueryOutputColumnsType);
            ((ComplexProperty)object).setOldData(sQLQueryOutputColumnsType2);
            arrayList.add(object);
        }
        if (bl4 || bl3) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
        }
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        if (sQLQueryNodeType.getSQLQueryExpression() == null || sQLQueryNodeType.getSQLQueryExpression().trim().isEmpty()) {
            this.addMessage("SQL_QUERY_NO_SQL", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute().size() == 0) {
            this.addMessage("SQL_QUERY_NO_OUTPUT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (sQLQueryNodeType.isGenerateView()) {
            boolean bl2;
            String string = sQLQueryNodeType.getViewName();
            if (!StringUtils.isDoubleQuotedString(string) && !StringUtils.containsNoDot(string)) {
                bl = false;
                this.addMessage("SQL_QUERY_INVALID_OUPUT_VIEW_NAME", MessageEnumType.INCOMPLETE, new String[0]);
            }
            if (bl2 = SQLHelper.isExpandedObjNameEnabled(this.getContext())) {
                if (string.length() > 128) {
                    bl = false;
                    this.addMessage("SQL_QUERY_VIEW_NAME_TOO_LONG_EX", MessageEnumType.INCOMPLETE, new String[0]);
                }
            } else if (string.length() > 30) {
                bl = false;
                this.addMessage("SQL_QUERY_VIEW_NAME_TOO_LONG", MessageEnumType.INCOMPLETE, new String[0]);
            }
        }
        return bl;
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl;
        boolean bl2 = bl = node instanceof DataProvider || node instanceof ModelProvider;
        if (!bl) {
            return false;
        }
        return super.isAllowedConnectionFrom(node);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        String string = sQLQueryNodeType.getSQLQueryExpression();
        if (string != null && string.length() > 0) {
            if (sQLQueryNodeType.isHasWithClause() && sQLQueryNodeType.isGenerateView()) {
                stringBuffer.append(string + "\n");
            } else {
                List<AbstractNode> list = this.findSourceNodes();
                for (AbstractNode abstractNode : list) {
                    if (!(abstractNode instanceof AbstractDataNode) || !string.contains(abstractNode.getAliasName())) continue;
                    String string2 = "\"RefNodeName\" as (SELECT * FROM {INPUT_SOURCE:RefNodeId})";
                    string2 = StringUtils.getReplacedString(string2, "RefNodeName", abstractNode.getAliasName());
                    string2 = StringUtils.getReplacedString(string2, "RefNodeId", abstractNode.getMetadataId());
                    stringBuffer2.append(string2 + ",\n");
                }
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(this.getNodeNameForSQLExpression(true) + " as (" + string + ")\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void setProperty(String string, Object object) {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        if (string.equals(SQLQUERY_EXPRESSION)) {
            String string2 = (String)object;
            sQLQueryNodeType.setSQLQueryExpression(string2);
        } else if (string.equals(SQLQUERY_OUTPUT_COLUMNS)) {
            SQLQueryOutputColumnsType sQLQueryOutputColumnsType = (SQLQueryOutputColumnsType)object;
            sQLQueryNodeType.setSQLQueryOutputColumns(sQLQueryOutputColumnsType);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                sQLQueryNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                sQLQueryNodeType.setSQLExpression((String)object);
            }
        } else if (string.equals(HAS_WITH_CLAUSE)) {
            Boolean bl = (Boolean)object;
            sQLQueryNodeType.setHasWithClause(bl.booleanValue());
        } else if (string.equals(GENERATE_VIEW)) {
            Boolean bl = (Boolean)object;
            sQLQueryNodeType.setGenerateView(bl.booleanValue());
        } else if (string.equals(VIEW_NAME)) {
            String string3 = (String)object;
            sQLQueryNodeType.setViewName(string3);
        } else if ("INCLUDE_ALL_COLUMNS".equals(string)) {
            Boolean bl = (Boolean)object;
            sQLQueryNodeType.setIncludeAllAvailableAttributes(bl);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SQLQUERY_EXPRESSION)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SQLQUERY_OUTPUT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(HAS_WITH_CLAUSE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(GENERATE_VIEW)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(VIEW_NAME)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("INCLUDE_ALL_COLUMNS")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        if (string.equals(SQLQUERY_EXPRESSION)) {
            return sQLQueryNodeType.getSQLQueryExpression();
        }
        if (string.equals(SQLQUERY_OUTPUT_COLUMNS)) {
            return sQLQueryNodeType.getSQLQueryOutputColumns();
        }
        if (string.equals("SQL_EXPRESSION")) {
            return sQLQueryNodeType.getSQLExpression();
        }
        if (string.equals(HAS_WITH_CLAUSE)) {
            return sQLQueryNodeType.isHasWithClause();
        }
        if (string.equals(GENERATE_VIEW)) {
            return sQLQueryNodeType.isGenerateView();
        }
        if (string.equals(VIEW_NAME)) {
            return sQLQueryNodeType.getViewName();
        }
        return super.getProperty(string);
    }

    public List<ColumnDataRow> getMetaData() throws SQLException {
        Object object;
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        Vector<ColumnDataRow> vector = new Vector<ColumnDataRow>();
        boolean bl = false;
        boolean bl2 = false;
        SQLQueryOutputColumnsType sQLQueryOutputColumnsType = new SQLQueryOutputColumnsType();
        if (sQLQueryNodeType.getSQLQueryExpression() != null && sQLQueryNodeType.getSQLQueryExpression().length() > 0) {
            try {
                this.validateSQLExpression(sQLQueryNodeType.getSQLQueryExpression(), vector);
                for (ColumnDataRow object22 : vector) {
                    object = object22.getName();
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName((String)object);
                    attributeType.setDataType(object22.getDataType());
                    attributeType.setStatus(AttributeStatus.VALID);
                    attributeType.setAlias(null);
                    sQLQueryOutputColumnsType.getAttribute().add(attributeType);
                }
                bl = true;
            }
            catch (WithClauseNoInputException withClauseNoInputException) {
                this.addMessage("SQL_QUERY_WITH_CLAUSE_NO_INPUT", MessageEnumType.WARNING, new String[0]);
                bl = true;
            }
            catch (WithClauseViewOutputException withClauseViewOutputException) {
                this.addMessage("SQL_QUERY_WITH_CLAUSE_NO_VIEW", MessageEnumType.WARNING, new String[0]);
                bl = true;
            }
            catch (Exception exception) {
                this.addMessage("SQL_QUERY_INVAL_SQL", MessageEnumType.WARNING, new String[0]);
                bl = true;
            }
            bl2 = true;
        } else if (sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute().size() > 0) {
            bl = true;
        }
        ArrayList arrayList = new ArrayList();
        if (bl2) {
            ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty.setOldData(this.getSQLExpression());
            arrayList.add(complexProperty);
        }
        if (bl) {
            SQLQueryOutputColumnsType sQLQueryOutputColumnsType2 = (SQLQueryOutputColumnsType)MetaDataHelper.copyMetadataObject(sQLQueryNodeType.getSQLQueryOutputColumns());
            object = new ComplexProperty(SQLQUERY_OUTPUT_COLUMNS, sQLQueryOutputColumnsType);
            ((ComplexProperty)object).setOldData(sQLQueryOutputColumnsType2);
            arrayList.add(object);
        }
        if (bl2 || bl) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
        }
        return vector;
    }

    @Override
    public String getHelpTopic() {
        return "sqlquery_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_SQL_QUERY_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_SQL_QUERY_ICON"));
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public void refactor(Node node, boolean bl) {
        Object object;
        Object object2;
        String string;
        String string2;
        if (!bl) {
            string2 = ((SQLQueryNodeType)this.getData()).getViewName();
            if (string2 != null && !string2.equals(string = this.getRefactorTableName(string2, this.getContext()))) {
                object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), VIEW_NAME, string);
                this.getModel().addRefactoredTableName(string2, string);
            }
            if (node instanceof DataProvider) {
                Object object3;
                String string3;
                Object object4;
                String string4;
                Object object5;
                string = node.getData().getName();
                if (node instanceof CreateTableNode) {
                    object2 = node.getData().getName();
                    Map<String, String> map = this.getModel().getRefactoredTableNames();
                    object = null;
                    object5 = map.entrySet().iterator();
                    while (object5.hasNext() && !(string4 = map.get(object = (object4 = object5.next()).getKey())).equals(object2)) {
                    }
                    string = object;
                }
                object2 = ((AbstractNode)node).getOldId();
                int n = 30 - ("N$".length() + ((String)object2).length()) - 1;
                n = string.length() > n ? n : string.length();
                object = string.substring(0, n);
                object5 = (String)object + "_" + "N$" + (String)object2;
                if (((String)object5).compareTo((String)(object4 = ((AbstractNode)node).getAliasName())) != 0) {
                    string4 = (SQLQueryNodeType)this.getData();
                    string3 = string4.getSQLQueryExpression();
                    string3 = StringUtils.getReplacedString(string3, (String)object5, (String)object4);
                    object3 = (OdmrSDMUndoFilter)this.getUndoFilter();
                    object3.prepareUndo(this, this.getContext(), SQLQUERY_EXPRESSION, string3);
                }
                if (!((String)object2).equals(string4 = node.getMetadataId())) {
                    string3 = "N$" + (String)object2;
                    object3 = "N$" + string4;
                    String string5 = StringUtils.getReplacedString(this.getSQLExpression(), string3, (String)object3);
                    String string6 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", (CharSequence)object2);
                    String string7 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", string4);
                    string5 = StringUtils.getReplacedString(string5, string6, string7);
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "SQL_EXPRESSION", string5);
                }
            }
        }
        string2 = this.getOldId();
        if (!this.getMetadataId().equals(string2)) {
            string = "N$" + string2;
            object2 = "N$" + this.getMetadataId();
            String string8 = StringUtils.getReplacedString(this.getSQLExpression(), string, (String)object2);
            object = (OdmrSDMUndoFilter)this.getUndoFilter();
            object.prepareUndo(this, this.getContext(), "SQL_EXPRESSION", string8);
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        SQLQueryOutputColumnsType sQLQueryOutputColumnsType = sQLQueryNodeType.getSQLQueryOutputColumns();
        SQLQueryOutputColumnsType sQLQueryOutputColumnsType2 = (SQLQueryOutputColumnsType)MetaDataHelper.copyMetadataObject(sQLQueryOutputColumnsType);
        List list = sQLQueryOutputColumnsType2.getAttribute();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (attributeType2 == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType())) continue;
            String string = attributeType.getName();
            AttributeType attributeType3 = null;
            if (attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty()) {
                attributeType3 = new AttributeType();
                attributeType3.setName(attributeType.getAlias());
                attributeType3.setAlias(null);
                attributeType3.setDataType(attributeType2.getDataType());
                attributeType3.setStatus(AttributeStatus.VALID);
                string = attributeType.getAlias();
            } else {
                attributeType3 = attributeType;
            }
            attributeType.setName(attributeType2.getName());
            attributeType.setDataType(attributeType2.getDataType());
            hashMap.put(string, attributeType3);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SQLQUERY_OUTPUT_COLUMNS, sQLQueryOutputColumnsType2);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    public String getStackSQLExpression(SQLContext sQLContext, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        List<AbstractNode> list = this.findSourceNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof AbstractDataNode) || !string.contains(abstractNode.getAliasName())) continue;
            AbstractDataNode abstractDataNode = (AbstractDataNode)abstractNode;
            String string2 = "\"RefNodeName\" as (SELECT * FROM \"N$RefNodeId\")";
            string2 = StringUtils.getReplacedString(string2, "RefNodeName", abstractNode.getAliasName());
            string2 = StringUtils.getReplacedString(string2, "RefNodeId", abstractNode.getMetadataId());
            stringBuffer2.append(string2 + ",\n");
            String string3 = abstractDataNode.getInputSQL(true, false);
            stringBuffer.append(string3 + ",\n");
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(this.getNodeNameForSQLExpression(true) + " as (" + string + ")\n");
        stringBuffer.append("SELECT * FROM " + this.getNodeNameForSQLExpression(true));
        stringBuffer.insert(0, "WITH ");
        return stringBuffer.toString();
    }

    public void validateSQLExpression(String string, Vector<ColumnDataRow> vector) throws Exception {
        String string2 = null;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        try {
            string2 = this.getStackSQLExpression(null, string);
            this.getMetaData(connectionFolder, string2, vector);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 32034) {
                List<AbstractNode> list = this.findSourceNodes();
                for (AbstractNode abstractNode : list) {
                    if (!(abstractNode instanceof AbstractDataNode) || !string.contains(abstractNode.getAliasName())) continue;
                    throw new WithClauseNoInputException();
                }
                this.getMetaData(connectionFolder, string, vector);
                SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
                if (!sQLQueryNodeType.isGenerateView()) {
                    throw new WithClauseViewOutputException();
                }
            }
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private void getMetaData(ConnectionManager connectionManager, String string, Vector<ColumnDataRow> vector) throws Exception {
        if (string == null) {
            return;
        }
        if (vector == null) {
            return;
        }
        vector.clear();
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ( ");
        stringBuilder.append(string);
        stringBuilder.append(")");
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2;
            sQLHelper.conn = connectionManager.getConnection(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            Array array = oracleConnection.createOracleArray("ODMR_OBJECT_VALUES", (Object)new String[0]);
            Array array2 = oracleConnection.createOracleArray("ODMR_OBJECT_NAMES", (Object)new String[0]);
            Array array3 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", null);
            Array array4 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", null);
            Array array5 = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", null);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.DESCRIBE_SQL_EXPRESSION(?,?,?,?,?,?)}");
            sQLHelper.cstmt.setCharacterStream(1, (Reader)new StringReader(stringBuilder.toString()), stringBuilder.length());
            sQLHelper.cstmt.setArray(2, array);
            sQLHelper.cstmt.setArray(3, array2);
            sQLHelper.cstmt.setArray(4, array3);
            sQLHelper.cstmt.setArray(5, array4);
            sQLHelper.cstmt.setArray(6, array5);
            sQLHelper.cstmt.registerOutParameter(2, 2003, "ODMR_OBJECT_VALUES");
            sQLHelper.cstmt.registerOutParameter(3, 2003, "ODMR_OBJECT_NAMES");
            sQLHelper.cstmt.registerOutParameter(4, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.registerOutParameter(5, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.registerOutParameter(6, 2003, "ODMR_OBJECT_IDS");
            sQLHelper.cstmt.execute();
            Array array6 = sQLHelper.cstmt.getArray(2);
            String[] stringArray = (String[])array6.getArray();
            Array array7 = sQLHelper.cstmt.getArray(3);
            String[] stringArray2 = (String[])array7.getArray();
            sQLHelper.close();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                String string3 = stringArray2[i];
                ColumnDataRow columnDataRow = new ColumnDataRow(string2, string3, null, null, null, null);
                vector.add(columnDataRow);
            }
            if (stringBuilder2.length() > 0) {
                String string4 = NodeMessagesLrb.get("SQL_QUERY_COL_INVALID");
                string2 = MessageFormat.format(string4, stringBuilder2.toString());
                throw new Exception(string2);
            }
        }
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this.getData();
        boolean bl = sQLQueryNodeType.isHasWithClause();
        boolean bl2 = sQLQueryNodeType.isGenerateView();
        String string2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string3 = CodeTemplate.updateBodyTemplate(string, "<PARALLEL_HINT>", string2);
        String string4 = null;
        if (bl && bl2) {
            String string5 = sQLQueryNodeType.getViewName();
            String string6 = ConnectionFolder.getUserAccountName(context);
            DatabaseObjectType databaseObjectType = DatabaseObjectType.CREATE_VIEW;
            parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string6, string5, databaseObjectType);
            String string7 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string6, string5, databaseObjectType);
            StringBuffer stringBuffer = new StringBuffer();
            for (AttributeType attributeType : sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",\n        ");
                }
                stringBuffer.append(StringUtils.addDoubleQuotes(attributeType.getName()));
            }
            string4 = "SELECT " + stringBuffer.toString() + "\n      FROM \n      ( \n        " + StringUtils.escapeSingleQuotesForSQL(sQLQueryNodeType.getSQLQueryExpression()) + "\n      )";
            String string8 = "\n  IF (v_drop = 'TRUE') THEN -- delete existing view created for the WITH clause? \n    BEGIN \n      v_sql := 'DROP VIEW '||v_view_name; \n      execSQL(v_sql); \n    EXCEPTION WHEN OTHERS THEN \n      NULL; \n    END; \n  END IF; \n\n";
            string3 = CodeTemplate.updateBodyTemplate(string3, "<CREATE_VIEW_NAME>", StringUtils.addSingleQuotes(string7));
            string3 = CodeTemplate.updateBodyTemplate(string3, "<OPTIONAL_CODE>", string8);
        } else {
            string4 = "SELECT * \n      FROM \n      ( \n        " + this.getCodeGenSQL() + "\n      )";
            string3 = CodeTemplate.updateBodyTemplate(string3, "<CREATE_VIEW_NAME>", "generateUniqueName");
            string3 = CodeTemplate.updateBodyTemplate(string3, "<OPTIONAL_CODE>", null);
        }
        return CodeTemplate.updateBodyTemplate(string3, "<SQL_EXPRESSION>", StringUtils.removeBlankLines(string4));
    }
}

