/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.snippet.Messages;
import oracle.dbtools.raptor.snippet.Resources;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.raptor.snippet.SnippetController;
import oracle.dbtools.raptor.snippet.SnippetDialog;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;

public class SaveSnippetActionProvider
implements ActionProvider<Object> {
    public static final String SAVE_SNIPPET = "save_snippet_from_worksheet";
    private static final IdeAction SAVE_SNIPPET_ACTION;
    private List<WorksheetAction> m_actions;

    public SaveSnippetActionProvider() {
        WorksheetAction worksheetAction = WorksheetAction.createWorksheetAction((String)SAVE_SNIPPET, (WorksheetAction.ActionType)WorksheetAction.ActionType.CONTEXT_MENU_ONLY, (int)0, (double)0.0);
        this.m_actions = Collections.singletonList(worksheetAction);
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        return worksheetContext.getEditor().getSelectedText() != null;
    }

    public WorksheetTaskWrapper<Object> doAction(String string, WorksheetContext worksheetContext) {
        SnippetDialog.saveSnippet(worksheetContext.getEditor().getSelectedText(), SnippetController.snippetFile);
        SnippetAddin snippetAddin = (SnippetAddin)AddinManager.getAddinManager().getAddin(SnippetAddin.class);
        snippetAddin.load(true);
        return null;
    }

    public WorksheetAction getActionAt(int n) {
        return this.m_actions.get(n);
    }

    public int getActionsCount() {
        return this.m_actions.size();
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public int getPanelCount() {
        return 0;
    }

    static {
        String string = Messages.getString("SaveSnippetActionProvider.1");
        SAVE_SNIPPET_ACTION = IdeAction.get((int)Ide.findOrCreateCmdID((String)SAVE_SNIPPET), null, (String)StringUtils.stripMnemonic((String)string), (String)"Worksheet", (Integer)StringUtils.getMnemonicKeyCode((String)string), (Icon)Resources.getIcon("SNIPPET_ICON"), null, (boolean)true);
    }
}

