/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.contextlogger;

import java.util.logging.LogRecord;
import oracle.nosql.common.contextlogger.ContextLogManager;
import oracle.nosql.common.contextlogger.LogContext;
import oracle.nosql.common.contextlogger.LogFormatter;

public class ContextFormatter
extends LogFormatter {
    private static final String contextLabel = "CTX";

    public ContextFormatter(String label) {
        super(label);
    }

    public ContextFormatter() {
        this(null);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String dateVal = this.getDate(record.getMillis());
        LogContext lc = ContextLogManager.WithLogContext.get();
        String level = record.getLevel().getLocalizedName();
        String correlationId = "0";
        if (lc != null) {
            correlationId = lc.getId();
            if (!lc.isLogged()) {
                lc.setLogged();
                this.addContextLine(sb, lc, level, dateVal);
            }
        }
        sb.append(dateVal);
        sb.append(" ");
        sb.append(level);
        sb.append(this.label);
        if (lc != null) {
            sb.append(correlationId);
            sb.append(" ");
        }
        sb.append(this.formatMessage(record));
        sb.append(LINE_SEPARATOR);
        this.getThrown(record, sb);
        return sb.toString();
    }

    private void addContextLine(StringBuilder sb, LogContext lc, String level, String date) {
        sb.append(date);
        sb.append(" ");
        sb.append(level);
        sb.append(this.label);
        sb.append(contextLabel);
        sb.append(" ");
        sb.append(lc.toJsonString());
        sb.append(LINE_SEPARATOR);
    }
}

