/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.contextlogger;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import oracle.nosql.common.JsonUtils;
import oracle.nosql.common.contextlogger.CorrelationId;

public class LogContext
extends JsonUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String entry;
    protected String origin;
    protected int logLevel;
    protected boolean logged;

    public LogContext() {
    }

    public LogContext(CorrelationId id, String entry, String origin, Level logLevel) {
        this(id, entry, origin, logLevel, false);
    }

    protected LogContext(CorrelationId id, String entry, String origin, Level logLevel, boolean logged) {
        if (id == null) {
            throw new IllegalStateException("CorrelationId cannot be null.");
        }
        this.id = id.toString();
        this.entry = entry;
        this.origin = origin;
        this.logLevel = logLevel.intValue();
        this.logged = logged;
    }

    public LogContext(String id, String entry, String origin, int logLevel, boolean logged) {
        this.id = id;
        this.entry = entry;
        this.origin = origin;
        this.logLevel = logLevel;
        this.logged = logged;
    }

    public String getId() {
        return this.id;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void putOrigin(String newOrigin) {
        this.origin = newOrigin;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void putLogLevel(Level newLevel) {
        this.logLevel = newLevel.intValue();
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged() {
        this.logged = true;
    }

    public String toJsonString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return this.toJsonString();
    }

    public static LogContext fromJsonString(String js) {
        if (js == null) {
            return null;
        }
        try {
            return (LogContext)mapper.readValue(js, LogContext.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + this.logLevel;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogContext other = (LogContext)obj;
        if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.logLevel != other.logLevel) {
            return false;
        }
        return !(this.origin == null ? other.origin != null : !this.origin.equals(other.origin));
    }
}

