/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.contextlogger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.nosql.common.contextlogger.FormatUtils;

public class LogFormatter
extends Formatter {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Date date = new Date();
    private final DateFormat formatter = FormatUtils.getDateTimeAndTimeZoneFormatter();
    protected final String label;

    public LogFormatter(String label) {
        if (label != null) {
            label = label.replaceAll("\\s", "");
            this.label = " [" + label + "] ";
        } else {
            this.label = " - ";
        }
    }

    public LogFormatter() {
        this(null);
    }

    protected synchronized String getDate(long millis) {
        this.date.setTime(millis);
        return this.formatter.format(this.date);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String dateVal = this.getDate(record.getMillis());
        sb.append(dateVal);
        sb.append(" ");
        sb.append(record.getLevel().getLocalizedName());
        sb.append(this.label);
        sb.append(this.formatMessage(record));
        sb.append(LINE_SEPARATOR);
        this.getThrown(record, sb);
        return sb.toString();
    }

    protected void getThrown(LogRecord record, StringBuilder sb) {
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

