/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.sklogger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import oracle.nosql.common.sklogger.MetricFamilySamples;
import oracle.nosql.common.sklogger.RateMetric;
import oracle.nosql.common.sklogger.StatsData;

public class Histogram
extends RateMetric<RateResult, Element> {
    private final long[] upperBounds;

    public Histogram(String name, long[] upperBounds, String ... labelNames) {
        super(name, labelNames);
        if (upperBounds == null || upperBounds.length == 0) {
            throw new IllegalArgumentException("upperBounds cannot be empty");
        }
        if (upperBounds[upperBounds.length - 1] != Long.MAX_VALUE) {
            long[] tmp = new long[upperBounds.length + 1];
            System.arraycopy(upperBounds, 0, tmp, 0, upperBounds.length);
            tmp[upperBounds.length] = Long.MAX_VALUE;
            this.upperBounds = tmp;
        } else {
            this.upperBounds = upperBounds;
        }
        this.initializeNoLabelsElement();
    }

    @Override
    protected Element newElement() {
        return new Element(this.upperBounds);
    }

    public void observe(long v) {
        ((Element)this.noLabelsElement).observe(v);
    }

    public void observe(long v, int times) {
        ((Element)this.noLabelsElement).observe(v, times);
    }

    public static long[] linearBuckets(long start, long width, int count) {
        long[] buckets = new long[count];
        int i = 0;
        while (i < count) {
            buckets[i] = start + (long)i * width;
            ++i;
        }
        return buckets;
    }

    public static long[] exponentialBuckets(long start, long factor, int count) {
        long[] buckets = new long[count];
        int i = 0;
        while (i < count) {
            buckets[i] = start * (long)Math.pow(factor, i);
            ++i;
        }
        return buckets;
    }

    @Override
    public MetricFamilySamples<RateResult> collect() {
        return this.collect(StatsData.Type.HISTOGRAM);
    }

    @Override
    public MetricFamilySamples<RateResult> collectSinceLastTime(String watcherName) {
        return this.collectSinceLastTime(StatsData.Type.HISTOGRAM, watcherName);
    }

    public static final class Element
    extends RateMetric.Element<RateResult> {
        private final long[] upperBounds;
        private final AtomicLongArray cumulativeCounts;
        private final ConcurrentHashMap<String, HistoryItem> watchers;

        private Element(long ... bounds) {
            this.upperBounds = bounds;
            this.cumulativeCounts = new AtomicLongArray(this.upperBounds.length);
            this.watchers = new ConcurrentHashMap();
        }

        public void observe(long v) {
            this.observe(v, 1);
        }

        public void observe(long v, int times) {
            int i = 0;
            while (i < this.upperBounds.length) {
                if (v <= this.upperBounds[i]) {
                    this.cumulativeCounts.addAndGet(i, times);
                    break;
                }
                ++i;
            }
        }

        @Override
        public RateResult rate() {
            long[] intervalCounts = new long[this.upperBounds.length];
            long intervalTotalCount = 0L;
            int i = 0;
            while (i < this.upperBounds.length) {
                intervalCounts[i] = this.cumulativeCounts.get(i);
                intervalTotalCount += intervalCounts[i];
                ++i;
            }
            return new RateResult(System.nanoTime() - this.initialTime, intervalTotalCount, this.upperBounds, intervalCounts);
        }

        @Override
        public RateResult rateSinceLastTime(String watcherName) {
            long[] lastHistogramCounts;
            long currentTime = System.nanoTime();
            long lastTime = this.initialTime;
            HistoryItem historyItem = this.watchers.get(watcherName);
            if (historyItem != null) {
                lastTime = historyItem.lastTime;
                lastHistogramCounts = historyItem.lastHistogramCounts;
                historyItem.lastTime = currentTime;
            } else {
                lastHistogramCounts = new long[this.upperBounds.length];
                this.watchers.put(watcherName, new HistoryItem(currentTime, lastHistogramCounts));
            }
            long[] intervalCounts = new long[this.upperBounds.length];
            long cumulativeICount = 0L;
            long intervalTotalCount = 0L;
            int i = 0;
            while (i < this.upperBounds.length) {
                cumulativeICount = this.cumulativeCounts.get(i);
                intervalCounts[i] = cumulativeICount - lastHistogramCounts[i];
                lastHistogramCounts[i] = cumulativeICount;
                intervalTotalCount += intervalCounts[i];
                ++i;
            }
            return new RateResult(currentTime - lastTime, intervalTotalCount, this.upperBounds, intervalCounts);
        }

        private static final class HistoryItem {
            private long lastTime;
            private long[] lastHistogramCounts;

            private HistoryItem(long time, long[] histogramCounts) {
                this.lastTime = time;
                this.lastHistogramCounts = histogramCounts;
            }
        }
    }

    public static class RateResult
    extends RateMetric.RateResult {
        private static final long serialVersionUID = 1L;
        private final long totalCount;
        private final long[] upperBounds;
        private final long[] histogramCounts;

        public RateResult(long duration, long totalCount, long[] upperBounds, long[] histogramCounts) {
            super(duration);
            this.totalCount = totalCount;
            this.upperBounds = upperBounds;
            this.histogramCounts = histogramCounts;
        }

        public long[] getHistogramCounts() {
            return this.histogramCounts;
        }

        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = super.toMap();
            int i = 0;
            while (i < this.upperBounds.length) {
                String key = "histogram_" + this.upperBounds[i];
                map.put(key, this.histogramCounts[i]);
                ++i;
            }
            return map;
        }
    }
}

