/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.sklogger;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.nosql.common.sklogger.MetricFamilySamples;
import oracle.nosql.common.sklogger.MetricRegistry;
import oracle.nosql.common.sklogger.StatsData;

public abstract class Metric<E extends Element>
extends StatsData {
    protected final List<String> labelNames;
    protected TreeMap<String[], E> elements;
    protected E noLabelsElement;

    public Metric(String name, String ... labelNames) {
        super(name);
        String[] stringArray = labelNames;
        int n = labelNames.length;
        int n2 = 0;
        while (n2 < n) {
            String labelName = stringArray[n2];
            this.checkMetricLabelName(labelName);
            ++n2;
        }
        this.labelNames = Arrays.asList(labelNames);
        this.elements = new TreeMap(new StringArrayComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E labels(String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        String[] stringArray = labelValues;
        int n = labelValues.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (label == null) {
                throw new IllegalArgumentException("Label cannot be null.");
            }
            ++n2;
        }
        Element e = (Element)this.elements.get(labelValues);
        if (e != null) {
            return (E)e;
        }
        Metric metric = this;
        synchronized (metric) {
            e = (Element)this.elements.get(labelValues);
            if (e != null) {
                return (E)e;
            }
            e = this.newElement();
            TreeMap<String[], E> newElements = new TreeMap<String[], E>(this.elements);
            newElements.put(labelValues, e);
            this.elements = newElements;
            return (E)e;
        }
    }

    protected void initializeNoLabelsElement() {
        if (this.labelNames.size() == 0) {
            this.noLabelsElement = this.labels(new String[0]);
        }
    }

    private void checkMetricLabelName(String name) {
        if (name == null || name.contains(".")) {
            throw new IllegalArgumentException("Invalid metric label name: " + name);
        }
    }

    protected abstract E newElement();

    public abstract MetricFamilySamples<?> collect();

    public Metric<?> registerTo(MetricRegistry registry) {
        registry.addMetricData(this);
        return this;
    }

    public static interface Element {
    }

    public static abstract class Result
    implements Serializable {
        public static final long serialVersionUID = 1L;

        public abstract Map<String, Object> toMap();
    }

    private static class StringArrayComparator
    implements Comparator<String[]> {
        private StringArrayComparator() {
        }

        @Override
        public int compare(String[] s1, String[] s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            int i = 0;
            while (i < s1.length) {
                int result = s1[i].compareTo(s2[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }
    }
}

