/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.sklogger;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import oracle.nosql.common.sklogger.Counter;
import oracle.nosql.common.sklogger.CustomGauge;
import oracle.nosql.common.sklogger.Histogram;
import oracle.nosql.common.sklogger.LongGauge;
import oracle.nosql.common.sklogger.Metric;
import oracle.nosql.common.sklogger.MetricFamilySamples;
import oracle.nosql.common.sklogger.MetricProcessor;
import oracle.nosql.common.sklogger.RateMetric;
import oracle.nosql.common.sklogger.ScheduleStart;
import oracle.nosql.common.sklogger.SizeQuantile;

public class MetricRegistry {
    public static final MetricRegistry defaultRegistry = new MetricRegistry();
    private final ScheduledExecutorService executor;
    private Future<?> collectorFuture;
    private final ConcurrentHashMap<String, Metric<?>> registeredMetrics = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetricProcessor> metricProcessors = new ConcurrentHashMap();

    public MetricRegistry() {
        this.executor = new ScheduledThreadPoolExecutor(1, new MetricThreadFactory());
    }

    public static LongGauge getLongGauge(String name, String ... labelNames) {
        return defaultRegistry.register(new LongGauge(name, labelNames));
    }

    public static CustomGauge getCustomGauge(String name, CustomGauge.GaugeCalculator gaugeCalculator) {
        return defaultRegistry.register(new CustomGauge(name, gaugeCalculator));
    }

    public static Counter getCounter(String name, String ... labelNames) {
        return defaultRegistry.register(new Counter(name, labelNames));
    }

    public static SizeQuantile getSizeQuantile(String name, String ... labelNames) {
        return defaultRegistry.register(new SizeQuantile(name, labelNames));
    }

    public static SizeQuantile getSizeQuantile(String name, double[] quantiles, String ... labelNames) {
        return defaultRegistry.register(new SizeQuantile(name, quantiles, labelNames));
    }

    public static Histogram getHistogram(String name, long[] upperBounds, String ... labelNames) {
        return defaultRegistry.register(new Histogram(name, upperBounds, labelNames));
    }

    public LongGauge register(LongGauge metric) {
        this.addMetricData(metric);
        return metric;
    }

    public Counter register(Counter metric) {
        this.addMetricData(metric);
        return metric;
    }

    public Histogram register(Histogram metric) {
        this.addMetricData(metric);
        return metric;
    }

    public SizeQuantile register(SizeQuantile metric) {
        this.addMetricData(metric);
        return metric;
    }

    public CustomGauge register(CustomGauge metric) {
        this.addMetricData(metric);
        return metric;
    }

    public void addMetricData(Metric<?> metric) {
        String statsName = metric.getStatsName();
        Metric<?> data = this.registeredMetrics.putIfAbsent(statsName, metric);
        if (data != null) {
            throw new IllegalArgumentException("Already registered name: " + statsName);
        }
    }

    public void unregister(String statsName) {
        this.registeredMetrics.remove(statsName);
    }

    public void addMetricProcessor(MetricProcessor processor) {
        this.metricProcessors.put(processor.getName(), processor);
    }

    public synchronized void startProcessors(long configuredIntervalMs) {
        if (this.collectorFuture != null) {
            this.collectorFuture.cancel(true);
        }
        long nowMs = System.currentTimeMillis();
        long delayMs = ScheduleStart.calculateDelay(configuredIntervalMs, nowMs);
        this.collectorFuture = this.executor.scheduleAtFixedRate(new ProcessMetricTask(), delayMs, configuredIntervalMs, TimeUnit.MILLISECONDS);
    }

    public synchronized void stopProcessors() {
        if (this.collectorFuture != null) {
            this.collectorFuture.cancel(true);
        }
    }

    public List<MetricFamilySamples<?>> getAllMetricFactory(String watcherName) {
        ArrayList metricFamilys = new ArrayList();
        for (Metric<?> data : this.registeredMetrics.values()) {
            MetricFamilySamples<Object> sample = data instanceof RateMetric ? ((RateMetric)data).collectSinceLastTime(watcherName) : data.collect();
            metricFamilys.add(sample);
        }
        return metricFamilys;
    }

    private class MetricThreadFactory
    implements ThreadFactory {
        private MetricThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "MetricThread");
            t.setDaemon(true);
            return t;
        }
    }

    private class ProcessMetricTask
    implements Runnable {
        private ProcessMetricTask() {
        }

        @Override
        public void run() {
            try {
                for (MetricProcessor processor : MetricRegistry.this.metricProcessors.values()) {
                    for (Metric data : MetricRegistry.this.registeredMetrics.values()) {
                        MetricFamilySamples<Object> sample = data instanceof RateMetric ? ((RateMetric)data).collectSinceLastTime(processor.getName()) : data.collect();
                        processor.process(sample);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

