/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.sklogger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.nosql.common.sklogger.Metric;
import oracle.nosql.common.sklogger.MetricFamilySamples;
import oracle.nosql.common.sklogger.StatsData;

public abstract class RateMetric<T extends RateResult, E extends Element<T>>
extends Metric<E> {
    public static final String DEFAULT_WATCHER = "defaultWatcher";

    public RateMetric(String name, String ... labelNames) {
        super(name, labelNames);
    }

    public T rate() {
        return (T)((RateResult)((Element)this.noLabelsElement).rate());
    }

    public T rateSinceLastTime(String watcherName) {
        return (T)((RateResult)((Element)this.noLabelsElement).rateSinceLastTime(watcherName));
    }

    public abstract MetricFamilySamples<T> collectSinceLastTime(String var1);

    protected MetricFamilySamples<T> collect(StatsData.Type type) {
        ArrayList samples = new ArrayList(this.elements.size());
        for (Map.Entry e : this.elements.entrySet()) {
            samples.add(new MetricFamilySamples.Sample<RateResult>(Arrays.asList((String[])e.getKey()), (RateResult)((Element)e.getValue()).rate()));
        }
        return new MetricFamilySamples(this.statsName, type, this.labelNames, samples);
    }

    protected MetricFamilySamples<T> collectSinceLastTime(StatsData.Type type, String watcherName) {
        ArrayList samples = new ArrayList(this.elements.size());
        for (Map.Entry e : this.elements.entrySet()) {
            samples.add(new MetricFamilySamples.Sample<RateResult>(Arrays.asList((String[])e.getKey()), (RateResult)((Element)e.getValue()).rateSinceLastTime(watcherName)));
        }
        return new MetricFamilySamples(this.statsName, type, this.labelNames, samples);
    }

    public static abstract class Element<T>
    implements Metric.Element {
        protected long initialTime = System.nanoTime();

        protected Element() {
        }

        public abstract T rate();

        public abstract T rateSinceLastTime(String var1);
    }

    public static abstract class RateResult
    extends Metric.Result {
        private static final long serialVersionUID = 1L;
        protected final long duration;

        public RateResult(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("duration", this.duration);
            return map;
        }
    }
}

