/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.common.sklogger;

import java.util.regex.Pattern;

public abstract class StatsData {
    public static final double NANOSECONDS_PER_SECOND = 1.0E9;
    public static final double MILLISECONDS_PER_SECOND = 1000.0;
    public static final String SHARD = "shard";
    public static final String RESOURCE = "resource";
    public static final String COMPONENT_ID = "componentId";
    public static final String DURATION_NAME = "duration";
    public static final String COUNT_NAME = "count";
    public static final String THROUGHPUT_NAME = "throughputPerSecond";
    public static final String GAUGE_NAME = "value";
    public static final String QUANTILE_NAME = "quantile";
    public static final String SUM_NAME = "sum";
    public static final String OPERATION_COUNT_NAME = "operationCount";
    public static final String REQUEST_COUNT_NAME = "requestCount";
    public static final String OVERFLOW_COUNT_NAME = "overflowCount";
    public static final String OPERATION_MIN_NAME = "operationMin";
    public static final String OPERATION_MAX_NAME = "operationMax";
    public static final String OPERATION_AVG_NAME = "operationAvg";
    public static final String HISTOGRAM_NAME = "histogram";
    public static final String DELIMITER = "_";
    protected final String statsName;
    private static final Pattern METRIC_NAME_RE = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    StatsData(String statsName) {
        this.checkStatsName(statsName);
        this.statsName = statsName;
    }

    public String getStatsName() {
        return this.statsName;
    }

    private void checkStatsName(String name) {
        if (name == null || !METRIC_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid stats name: " + name);
        }
    }

    public static enum Type {
        COUNTER,
        LONG_GAUGE,
        CUSTOM_GAUGE,
        SIZE_QUANTILE,
        PERF_QUANTILE,
        HISTOGRAM,
        EVENT,
        UNTYPED;

    }
}

