/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;

final class DTreeExpandedEnumeration
implements Enumeration {
    private DTree _tree;
    private DTreeItem _current;
    private DTreeItem _next;
    private boolean _done;

    DTreeExpandedEnumeration(DTree tree) {
        this._tree = tree;
        this._next = tree.getRoot();
    }

    @Override
    public final boolean hasMoreElements() {
        DTreeItem next = this._getNext();
        if (next == null) {
            this._done = true;
            return false;
        }
        return true;
    }

    public final Object nextElement() {
        DTreeItem next = this._getNext();
        if (next == null) {
            this._done = true;
            throw new NoSuchElementException();
        }
        this._current = next;
        this._next = null;
        return next;
    }

    private final DTreeItem _getNext() {
        if (this._next != null) {
            return this._next;
        }
        DTreeItem next = null;
        next = this._current.getNextExpandedChild(null);
        if (next == null) {
            DTreeItem current = this._current;
            for (DTreeItem parent = this._current.getParent(); parent != null && (next = parent.getNextExpandedChild(current)) == null; parent = parent.getParent()) {
                current = parent;
            }
        }
        this._next = next;
        return next;
    }
}

